<?php
/**
 * Utility script to refresh wms servers cache
 *
 * @project     CWC2
 * @revision    $Id: refresh_server.php,v 1.2 2003/06/25 18:19:39 assefa Exp $
 * @purpose     Base Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


/************************************************************************/
/*                   Utility script to refersh servers :                */
/*        - look for server.dbf and refersh the capabilities for        */
/*      servers included in this file.                                  */
/*                                                                      */
/************************************************************************/
if (!extension_loaded("dbase"))
{
  if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
    dl("php_dbase.dll");
}

define( "CONFIG_PATH", "../config/" );
define( "COMMON", "../htdocs/common/" );
// include the xml parsing class
include_once( COMMON."appcontext/appcontext.php" );

include_once(COMMON."phpwms/xpath.class.php");
include_once(COMMON."phpwms/server_data_manager.php");
include_once(COMMON."phpwms/dbf.php");


// define a new AppContext object
$gContext = new AppContext( CONFIG_PATH."cwc2.xml" );
$szServerDataPath = $gContext->getContextValue("server_data_path");

if ($szServerDataPath[strlen($szServerDataPath) -1] != '/' &&
    $szServerDataPath[strlen($szServerDataPath) -1] != '\\')
     $szServerDataPath .= "/";
$szWMSParseFile = $gContext->getContextValue("wms_parse_file");


$oServerDataManager = 
  new ServerDataManager(new WMSDatabase($szServerDataPath));

$szServerdbfFile = $szServerDataPath . DB_SERVER;
if (file_exists($szServerdbfFile))
{
    $db = dbase_open($szServerdbfFile, 0);
    if ($db)
    {
        $nRecords = dbase_numrecords($db);
        for ($i=1; $i<=$nRecords; $i++)
        {
            $aRec = dbase_get_record_with_names($db, $i);
            $nId = $aRec['server_id'];
            $szTitle = $aRec['svc_title'];
            $aServers[$i][0] = $nId;
            $aServers[$i][1] = $szTitle;
        }
        dbase_close($db);
        //seperate in 2 loops so there won't be any conflict with the dbase
        // file
        for ($i=1; $i<=$nRecords; $i++)
        {
            echo "refreshing server " . $aServers[$i][0]  . "  : " . $aServers[$i][1] . "\n";
            @$oServerDataManager->refreshServer($aServers[$i][0] , $szServerDataPath, 
                                               $szWMSParseFile);
        }
    }
    
}
else
  echo "Could not locate file ". $szServerdbfFile;

?>
