<?php
/**
 * MapLab Information page
 *
 * @project     MapLab
 * @revision    $Id: info.php,v 1.8 2003/10/31 16:06:51 pspencer Exp $
 * @purpose     This is the information page.
 * @author      William A. Bronsema C.E.T. (bronsema@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2001, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: info.php,v $
 * Revision 1.8  2003/10/31 16:06:51  pspencer
 * merge from 1.1 branch
 *
 * Revision 1.6.2.1  2003/05/02 18:16:31  sacha
 * Added some change from main branch
 *
 * Revision 1.6  2003/01/06 11:07:00  bronsema
 * added check for php_gd.so module loaded.
 *
 * Revision 1.5  2002/12/20 03:23:56  bronsema
 * fixed bug for reading display_errors
 *
 * Revision 1.4  2002/12/11 16:37:06  bronsema
 * Removed dependancy on Mapscript constants MS_GIF etc.
 *
 * Revision 1.3  2002/12/11 15:57:32  bronsema
 * Fixed minor bugs & added index page.
 *
 * Revision 1.2  2002/12/11 04:39:20  bronsema
 * Completed construction
 *
 * Revision 1.1  2002/12/10 18:25:35  bronsema
 * added
 *
 * Revision 1.9  2002/09/18 19:44:59  sacha
 * Make sure all module are loaded.
 *
 * Revision 1.8  2002/09/06 15:34:10  bronsema
 * Checks for and loads GD module.
 *
 * Revision 1.6  2002/08/12 12:57:50  sacha
 * Moved all common lib into htdocs. Not yet completed with Mapbrowser and gmapfactory.
 *
 * Revision 1.5  2002/07/17 14:42:53  sacha
 * When php mapscript module is loaded in php.ini, set the bMapscript to
 * true.
 *
 * Revision 1.4  2002/06/30 17:42:34  pspencer
 * remove notice about register_globals
 *
 * Revision 1.3  2002/06/13 22:01:59  jmckenna
 * - fix by Paul (JM)
 *
 * Revision 1.2  2002/06/13 17:59:07  pspencer
 * added additional checks for php configuration
 *
 * Revision 1.1  2002/06/09 04:11:05  bronsema
 * Moved info to new dialog
 *
 *****************************************************************************/

// ensure that the gd module is loaded
if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
{
    if (!extension_loaded("gd")) dl("php_gd2.dll");
    if (!extension_loaded("dbase")) dl("php_dbase.dll");
}
else
{
    if (!extension_loaded("gd")) dl("php_gd2.so");
    if (!extension_loaded("dbase")) dl("php_dbase.so");
}

// define path to the common utils
define( "COMMON", "../htdocs/common/" );
include_once("../htdocs/common/appcontext/appcontext.php");

/* ============================================================================
 * Build an array with the HTTP GET or POST parameters.
 * ========================================================================= */
// check for POST vars
$http_form_vars =  (count($_POST) > 0) ?
                   $_POST : ((count($_GET) > 0) ? $_GET : array());

/* ============================================================================
 * Open XML
 * ========================================================================= */
// get info from xml
$oAppContext = new AppContext( $http_form_vars["szConfigFile"] );

/* ============================================================================
 * Mapscript Info
 * ========================================================================= */
// ensure mapscript module is loaded
if (!extension_loaded("MapScript"))
    $bMapscriptValid = @dl($oAppContext->getContextValue("mapscript_module"));
else
    $bMapscriptValid = true;

// initialize array
$gaMSImageTypes = array();

if ( $bMapscriptValid )
{
    // check each
    if (strpos( ms_GetVersion(), "OUTPUT=GIF") > 0 )
        array_push( $gaMSImageTypes, "MS_GIF" );
    if (strpos( ms_GetVersion(), "OUTPUT=PNG") > 0 )
        array_push( $gaMSImageTypes, "MS_PNG" );
    if (strpos( ms_GetVersion(), "OUTPUT=JPEG") > 0 )
        array_push( $gaMSImageTypes, "MS_JPEG" );
    if (strpos( ms_GetVersion(), "OUTPUT=WBMP") > 0 )
        array_push( $gaMSImageTypes, "MS_WBMP" );
    if (strpos( ms_GetVersion(), "OUTPUT=PDF") > 0 )
        array_push( $gaMSImageTypes, "MS_PDF" );
    if (strpos( ms_GetVersion(), "OUTPUT=SWF") > 0 )
        array_push( $gaMSImageTypes, "MS_SWF" );
}

/* ============================================================================
 * Php Image Types
 * ========================================================================= */
// initialize array
$gaPhpImageTypes = array();

// check each
if ( ImageTypes() & IMG_GIF )
   array_push( $gaPhpImageTypes, "GIF" );
if ( ImageTypes() & IMG_PNG )
   array_push( $gaPhpImageTypes, "PNG" );
if ( ImageTypes() & IMG_JPG )
   array_push( $gaPhpImageTypes, "JPEG" );
if ( ImageTypes() & IMG_WBMP )
   array_push( $gaPhpImageTypes, "WBMP" );

/* ============================================================================
 * Php Configuration File Settings
 *
 * the array has the configuration value as the key and the value is an array
 * of three elements.  The first is the required value.  The second is
 * read from PHP using ini_get.  The third is the message to display about the
 * setting.  The same structure is used for both Mandatory and Recommended
 * settings.
 * ========================================================================= */
$gaszMandatorySettings = array(
    "enable_dl" => array( "1", "1", "this value must be set to on or 1 in php.ini" ),
    "file_uploads" => array( "1", "1", "this value must be set to on or 1 in php.ini" ),
    "allow_url_fopen" => array( "1", "1", "this value must be set to on or 1 in php.ini" )
                              );

foreach( array_keys($gaszMandatorySettings) as $szIniKey)
{
    $gaszMandatorySettings[$szIniKey][1] = ini_get( $szIniKey );
}

$gaszRecommendedSettings = array(
    "register_globals" => array( "0", "0", "this value should be set to off or 0 in php.ini" ),
    "display_errors" => array( "0", "0", "this value should be set to off or 0 in php.ini" ),
    "log_errors" => array( "1", "1", "this value should be set to on or 1 in php.ini" ),
    "error_reporting" => array( "0", "0", "this value should be E_ALL in php.ini" )
                                );

foreach( array_keys($gaszRecommendedSettings) as $szIniKey )
{
    if ($szIniKey == "error_reporting")
    {
        $anErrorLevels = array( "E_ERROR" => 1,
                                "E_WARNING" => 2,
                                "E_PARSE" => 4,
                                "E_NOTICE" => 8,
                                "E_CORE_ERROR" => 16,
                                "E_CORE_WARNING" => 32,
                                "E_COMPILE_ERROR" => 64,
                                "E_COMPILE_WARNING" => 128,
                                "E_USER_ERROR" => 256,
                                "E_USER_WARNING" => 512,
                                "E_USER_NOTICE" => 1024
                              );
        //calculate the output string for the current value
        //and set it in index 1
        $nErrorLevel = error_reporting();
        $szValue = "<font size=1>";
        $szSep = "";
        foreach( $anErrorLevels as $szLevel => $nLevel )
        {
            if ($nErrorLevel & $nLevel)
            {
                $szValue .= $szSep.$szLevel;
                $szSep = "<BR>";
            }
        }
        $szValue .= "</font>";
        $gaszRecommendedSettings[$szIniKey][1] = $szValue;

        //calculate the output string if E_NOTICE is not included
        //and set it as the required value (index 0)
        $nErrorLevel = E_ALL;
        $szValue = "<font size=1>";
        $szSep = "";
        foreach( $anErrorLevels as $szLevel => $nLevel )
        {
            if ($nErrorLevel & $nLevel)
            {
                $szValue .= $szSep.$szLevel;
                $szSep = "<BR>";
            }
        }
        $szValue .= "</font>";
        $gaszRecommendedSettings[$szIniKey][0] = $szValue;
    }
    elseif ( $szIniKey == "register_globals" )
    {
        // NOTE: there seems to be a bug in PHP that returns "" when false
        $szTmpString = ini_get( "register_globals" );
        if ( $szTmpString == "" )
            $gaszRecommendedSettings[$szIniKey][1] = 0;
        else
            $gaszRecommendedSettings[$szIniKey][1] = 1;

    }
    elseif ( $szIniKey == "display_errors" )
    {
        // NOTE: there seems to be a bug in PHP that returns "" when false
        $szTmpString = ini_get( "display_errors" );
        if ( $szTmpString == "" )
            $gaszRecommendedSettings[$szIniKey][1] = 0;
        else
            $gaszRecommendedSettings[$szIniKey][1] = 1;

    }
    else
    {
        $gaszRecommendedSettings[$szIniKey][1] = ini_get( $szIniKey );
    }
}



/* ============================================================================
 * Php Required Modules (in enable_dl is off)
 * ========================================================================= */
$gaszModuleNames = array( "MapScript" => "",
                          "dbase" => "",
                          "gd" => "" );
foreach( array_keys($gaszModuleNames) as $szModuleName )
{
    $gaszModuleNames[$szModuleName] = extension_loaded( $szModuleName );
}


/**
 * Postcondition:   This function takes the given string and adds "<br>" tags at
 *                  the requested character interval.
 * @param $szString string - The string to break.
 * @param $nInterval integer - The character interval.
 * @return string - The string with <br> tags.
 **/
function breakString( $szString, $nInterval )
{
    // init vars
    $szNewString = "";
    $nCount = 0;

    // loop through and break at every "$nInterval" chars
    for ( $i = 0; $i < strlen( $szString ); $i++ )
    {
        // increment counter
        $nCount++;

        // add next character
        $szNewString .= substr( $szString, $i, 1 );

        // if the count is "$nInterval" then add break
        if ( $nCount == $nInterval )
        {
            $szNewString .= "<br>";
            $nCount = 0;
        }
    }

    // return the new string
    return $szNewString;
}
?>
