<?php
/**
 * MapLab XML configuration Tool
 *
 * @project     MapLab
 * @revision    $Id: edit_xml_default.php,v 1.3 2003/06/11 19:58:35 sacha Exp $
 * @purpose     This is the XML configuration page.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: edit_xml_default.php,v $
 * Revision 1.3  2003/06/11 19:58:35  sacha
 * removed some <? php tag
 *
 * Revision 1.2  2003/01/23 16:02:50  sacha
 * Moved all params about text button into configuration file
 *
 * Revision 1.1  2002/12/10 18:25:35  bronsema
 * added
 *
 * Revision 1.1  2002/11/21 04:38:30  pspencer
 * new file.
 *
 * Revision 1.1  2002/08/12 12:57:50  sacha
 * Moved all common lib into htdocs. Not yet completed with Mapbrowser and gmapfactory.
 *
 * Revision 1.2  2002/06/30 17:29:03  pspencer
 * modified for register_globals = off
 *
 * Revision 1.1  2002/06/18 19:48:03  sacha
 * Fixed some bug when using config tool in Netscape also added a new
 * file that puts default values in configuration file BEFORE opening
 * configuration tool.
 *
 ****************************************************************************/

// define the common directory
if (!defined( "COMMON" ) )
    define("COMMON", "./common/");


// include appcontext definition
include_once(COMMON."appcontext/appcontext.php");

// Scan all configuration files and change "MUST_CHANGE"
// parameters to something more realist.
define("CONFIG_DIR", "../config/");
$hDir = opendir(CONFIG_DIR);

// check if $_SERVER["DOCUMENT_ROOT"] is set to determine an APACHE configuration
if ( isset( $_SERVER["DOCUMENT_ROOT"] ) )
{
    $bApache = true;
}
else
    $bApache = false;

while (false !== ($szFile = readdir($hDir)))
{
    if (strtolower(substr($szFile, -3)) != "xml")
        continue;

    $oAppContext = new AppContext( CONFIG_DIR.$szFile );

    // check if the file is read-only
    if ( !is_writable( CONFIG_DIR.$szFile ) )
        $bWritable = false;
    else
        $bWritable = true;

    $bDefaulted = false;

    // loop and list all include file paramters
    if (isset( $oAppContext->aoContext))
    {
        foreach (array_keys($oAppContext->aoContext) as $szKey)
        {
            // only use textbox if writable
            if ( $bWritable )
            {
                // check for initial values
                if ( $oAppContext->aoContext[$szKey]->szContextFile == "MUST_CHANGE" )
                {
                    if ( $bApache )
                    {
                        $oAppContext->aoContext[$szKey]->szContextFile = str_replace("\\", "/", realpath( dirname( $_SERVER['PATH_TRANSLATED'] ) ."/../config/maplab.xml" ));
                        $bDefaulted = true;
                    }
                }
            }
        }
    }
    // Loop through each parameter and add
    foreach (array_keys($oAppContext->aContext) as $szKey)
    {
        //$szValue = $aValue["param-value"];
        //$szDesc  = $aValue["description"];

        // only use textbox if writable
        if ( $bWritable && $oAppContext->aContext[$szKey]["param-value"] == "MUST_CHANGE")
        {
            $bDefaulted = true;

            // check for initial values
            if ($szKey == "app_path" )
            {
                if ( $bApache )
                    $oAppContext->aContext[$szKey]["param-value"] = str_replace("\\", "/", realpath( dirname( $HTTP_SERVER_VARS['PATH_TRANSLATED'] ) ."/../" )."/" );
            }
            elseif ($szKey == "file_browser_root" )
            {
                if ( $bApache )
                    $oAppContext->aContext[$szKey]["param-value"] = str_replace("\\", "/", realpath( dirname( $HTTP_SERVER_VARS['PATH_TRANSLATED'] ) ."/../" )."/" );
            }
            elseif ( ( $szKey == "log_path" || $szKey == "tmp_map_path" || $szKey == "tmp_img_path" ) )
            {
                // set based on OS
                if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
                {
                    // check for possible temp directories
                    if ( is_dir( "c:/temp/" ) )
                        $oAppContext->aContext[$szKey]["param-value"] = "c:/temp/";
                    elseif ( is_dir( "c:/windows/temp/" ) )
                        $oAppContext->aContext[$szKey]["param-value"] = "c:/windows/temp/";
                    elseif ( is_dir( "c:/winnt/temp/" ) )
                        $oAppContext->aContext[$szKey]["param-value"] = "c:/winnt/temp/";
                }
                else
                {
                    // set for unix
                    $oAppContext->aContext[$szKey]["param-value"] = "/tmp/";
                }
            }
            elseif ( $szKey == "mapscript_module" )
            {
                // set according to OS
                if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
                    $oAppContext->aContext[$szKey]["param-value"] = "php_mapscript_36.dll";
                else
                    $oAppContext->aContext[$szKey]["param-value"] = "php_mapscript.so";
            }
            elseif ( $szKey == "new_app_url" )
            {
                // get the directory
                $szTmpDir = trim( dirname( $HTTP_SERVER_VARS['PHP_SELF'] ) );

                // remove "config/"
                $szTmpDir = substr( $szTmpDir, 0, strlen( $szTmpDir ) - 6 );

                $oAppContext->aContext[$szKey]["param-value"] = str_replace("\\", "/", $szTmpDir )."projects/";
            }
            elseif ( $szKey == "new_app_path" )
            {
                if ( $bApache )
                {
                    // get the directory
                    $szTmpDir = trim( dirname( $HTTP_SERVER_VARS['PATH_TRANSLATED'] ) );

                    // remove "config/"
                    $szTmpDir = substr( $szTmpDir, 0, strlen( $szTmpDir ) - 6 );

                    $oAppContext->aContext[$szKey]["param-value"] = str_replace("\\", "/", realpath( $szTmpDir ) )."/projects/";
                }
            }
            elseif ($szKey == "gd_version" )
            {
                // start the output buffer, this means nothing will be displayed until the buffer is closed
                ob_start();
     
                // call the phpinfo function to display the php info
                phpinfo(INFO_MODULES);
     
                // get contents of output buffer, which is everything 
                // that would have been printed from phpinfo();
                $val_phpinfo .= ob_get_contents();
             
                // flush the output buffer and delete the contents
                ob_end_clean();
   
                // replace the </td>'s with tabs and the $nbsp;'s with spaces
                $val_phpinfo = str_replace( '</td>', '|', $val_phpinfo );
                $val_phpinfo = str_replace( '&nbsp;', ' ', $val_phpinfo );

                // strip the tags
                $val_phpinfo = strip_tags($val_phpinfo);

                $aInfo = explode("\n", $val_phpinfo);

                $bGDSupport = "false";
                $szGDVersion = "";

                foreach($aInfo as $szInfo)
                {
                    $aszInfo = explode("|", $szInfo);
                    if (is_array($aszInfo))
                    {
                        switch($aszInfo[0])
                        {
                            case "GD Support" : $szGDSupport = $aszInfo[1]; 
                            break; 
                            case "GD Version" : $szGDVersion = $aszInfo[1]; 
                            break; 
                        }
                    }
                }

                if ($bGDSupport)
                {
                    $aGDVersion = explode(" ", $szGDVersion);
                    if (is_array($aGDVersion))
                        $szGDVersion = $aGDVersion[0];
                }

                if (strstr($szGDVersion, "2") !== false)
                    $oAppContext->aContext[$szKey]["param-value"] = "php_gd2";
                else
                    $oAppContext->aContext[$szKey]["param-value"] = "php_gd";
            }
            elseif ($szKey == "freetype_version" )
            {
                // start the output buffer, this means nothing will 
                // be displayed until the buffer is closed
                ob_start();
     
                // call the phpinfo function to display the php info
                phpinfo(INFO_MODULES);
     
                // get contents of output buffer, which is everything 
                // that would have been printed from phpinfo();
                $val_phpinfo .= ob_get_contents();
             
                // flush the output buffer and delete the contents
                ob_end_clean();
   
                // replace the </td>'s with tabs and the $nbsp;'s with spaces
                $val_phpinfo = str_replace( '</td>', '|', $val_phpinfo );
                $val_phpinfo = str_replace( '&nbsp;', ' ', $val_phpinfo );

                // strip the tags
                $val_phpinfo = strip_tags($val_phpinfo);

                $aInfo = explode("\n", $val_phpinfo);

                $bFreeTypeSupport = "false";
                $szFreeTypeLinkage = "";

                foreach($aInfo as $szInfo)
                {
                    $aszInfo = explode("|", $szInfo);
                    if (is_array($aszInfo))
                    {
                        switch($aszInfo[0])
                        {
                            case "FreeType Support" : $szFreeTypeSupport = $aszInfo[1]; break; 
                            case "FreeType Linkage" : $szFreeTypeLinkage = $aszInfo[1]; break; 
                        }
                    }
                }
                if (strstr($szFreeTypeSupport, "enable") !== false)
                    $bFreeTypeSupport = true;
                else
                    $bFreeTypeSupport = false;

                if ($bFreeTypeSupport)
                {
                    if (stristr($szFreeTypeLinkage, "TTF") !== false)
                        $szFreeTypeLinkage = "TTF";
                    else
                        $szFreeTypeLinkage = "FreeType 2";
                }
                $oAppContext->aContext[$szKey]["param-value"] = $szFreeTypeLinkage;
            }
            elseif ( $oAppContext->aContext[$szKey]["param-value"] == "" && $szKey == "configuration_file" )
                $oAppContext->aContext[$szKey]["param-value"] = "mapserv_36.xml";
        }
    }

    // check if value was defaulted
    if ( $bDefaulted && $bWritable)
        $oAppContext->saveAppContext();
}
?>
