<?php
// define the path to the components folder
//%DMPEAR_COMMON%
//%DMPEAR_WEBCOMMON%
if(!defined("COMMON"))
define( "COMMON",  str_replace("\\","/",dirname(__FILE__))."/../common/" );
if(!defined("WEBCOMMON"))
define( "WEBCOMMON", dirname($_SERVER['PHP_SELF'])."/../common/" );

if (!defined("CONFIG_PATH"))
define("CONFIG_PATH", "../../config/");

include_once(COMMON."logger/logfile.php");
include_once(COMMON."logger/logger.php");
include_once(COMMON."logger/error_manager.php");

if (defined("LOAD_MAPSESSION"))
{
    // include wrapper file(s)
    include_once(COMMON."wrapper/map_session.php" );
}

include_once(COMMON."session/session.php");

installSessionDirectoryHandler();
$GLOBALS['bSessionOK'] = initializeSession("sid");
if ($GLOBALS['bSessionOK'])
{
    
    // convert the global session reference if necessary
    if ( PHP_OS == "WINNT" || PHP_OS == "WIN32" )
    {
        if ( version_compare( phpversion(), "4.2.1" ) < 0 )
        {
            $_SESSION = &$HTTP_SESSION_VARS;
        }
    }
    
    /* ============================================================================
    * Setup logging objects
    * ========================================================================= */
    $aszLog = explode(".", basename($_SERVER["PHP_SELF"]));
    $gLogFile = new LogFile( $_SESSION["gszLogPath"].$aszLog[0]."_session.inc.log",
    LOG_TO_FILE, true );
    // set the max log level
    $gLogFile->setMaxLogLevel( $_SESSION["gnLogLevel"] );
    
    //starting the session resumes everything where we left off at the end of the
    //last script
    if (!isset($_SESSION["gErrorManager"]))
    {
        $_SESSION['gErrorManager'] = new ErrorManager($_SESSION['gbLogError']);
    }
    
    if (defined("LOAD_MAPSESSION"))
    {
        // ensure that the mapscript module is loaded
        if (!extension_loaded("MapScript")) dl($_SESSION['gszMapscriptModule']);
        
        // create a new map session object
        if ($_SESSION['gnMapSessionMode'] == "1")
        {
            $oMapSession = new MapSession_RW;
        }
        else
        {
            $oMapSession = new MapSession_R;
        }
        
        // set the global log file and error manager
        $oMapSession->setLogFile( $gLogFile );
        $oMapSession->setErrorManager( $_SESSION["gErrorManager"] );
        
        // set the temp directory for the map session
        $oMapSession->setTempDir( $_SESSION['gszTmpPath'] );
        
        
        /* ============================================================================
        * Re-instate the previous map state
        * ========================================================================= */
        $oMapSession->restoreState( $_SESSION["gszCurrentState"], $_SESSION['gszMapName'],dirname( $_SESSION['gszMapName'] ) );
    }
    
    $http_form_vars = (count($_POST) > 0) ?
    $_POST : ((count($_GET) > 0) ? $_GET : array() );
    
    /* ============================================================================
    * Setup the translation object(s)
    * ========================================================================= */
    // suppress the error constant (not defined when this page is called because
    // error object was passed through the session)
    if ( !defined("ERROR_CRITICAL") )
    {
        // define
        define("ERROR_CRITICAL", 2);
    }
    
    // include the mlt file
    include_once( COMMON."mlt/mlt.php" );
    
    // create a new MLT object
    $oMLT = new MLTdBase( $_SESSION['gszCurrentLanguage'] );
    $oMLT->setLogFile( $gLogFile );
    $oMLT->setErrorManager( $_SESSION["gErrorManager"] );
    
    // create a new common MLT object
    $oCommonMLT = new MLTdBase( $_SESSION['gszCurrentLanguage'] );
    
    $oCommonMLT->setLogFile( $gLogFile );
    $oCommonMLT->setErrorManager( $_SESSION["gErrorManager"] );
    
    // load the resourcre file into memory
    if (isset( $GLOBALS["szLanguageResource"] ))
    {
        $oMLT->loadResource( $szLanguageResource, $_SESSION['aszLang'] );
    }
    
    // load common resources
    $oCommonMLT->loadResource( str_replace("\\", "/", $_SESSION['gszCorePath']).
                               "/common.dbf", $_SESSION['aszLang'] );
    
    if (isset($_SESSION['gszCSSFile']))
    {
        $szCSSFile = $_SESSION['gszCSSFile'];
    }
    else
    {
        $szCSSFile = $_SESSION['gszCoreWebPath']."/skins/default/css/popup.css";
    }
}
else if (!isset($GLOBALS['bInvalidSessionDontFail']))
{
    ?>
<html><head>
<title>Invalid Session</title>
</head>
<body>Your session is invalid or has expired.</body>
</html>
    <?php
    exit;
}
?>
