//
//This script was contributed by TYDAC AG : http://www.tydac.ch/
//
/**
 *
 * @project     CWC2
 * @revision    $Id: toolsobj.js,v 1.8 2003/11/24 20:44:01 wbronsema Exp $
 * @purpose     Used with Ruler widget
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
function distancetool(dtmap,ptmax,Ox, Oy){
	this.theMap = dtmap
	this.dtOrigX = Ox
	this.dtOrigY = Oy
	this.dtPtMax = ptmax
	this.dtDistance = 0
	this.dtOffX = 0
	this.dtOffY =0
	this.dtInitDist = dtInitDist
	this.dtCalcDist = dtCalcDist
	this.dtDrawDist = dtDrawDist
	this.dtDrawClose = dtDrawClose
	this.dtSetInflection = dtSetInflection
	this.dtFinishDist = dtFinishDist
	this.aaPointTrace = new Array();   // array of points
	var currPix = 0
	var startPix = 0
	var snapDist = 10
	var dD
	var Vx
	var Vy
	var espace 
          var intervalmin = gRulerSpaceBetweenPoints;
	var intervalmax = gRulerSpaceBetweenPoints+1;
	var ODist
	var nbInf = 0
	var nodeX = new Array()
	var nodeY = new Array()
	
	function dtInitDist(e, spacebetweenpoints){
          //alert("dtInitDist");	
          //alert(spacebetweenpoints);
		espace = 20 		//pixels - interval between pixels during the drag phase
		intervalmin =spacebetweenpoints 	//pixels - interval between pixels once definitivly paint
		intervalmax = spacebetweenpoints+1; 	//pixels - idem
		ODist = 0
		
		if (isNav4) {
			this.dtOffX = e.pageX - this.theMap.left
			this.dtOffY = e.pageY - this.theMap.top
		} else if (isNav6) {
			this.dtOffX = e.pageX - this.dtOrigX
			this.dtOffY = e.pageY - this.dtOrigY
		} else {
			this.dtOffX = (window.event.clientX + document.body.scrollLeft) - this.dtOrigX
			this.dtOffY = (window.event.clientY + document.body.scrollTop) - this.dtOrigY
		}
		
		if (gRulerareaMode)
		{
			if (isNav4 || isNav6)
			{
				gRulerareaString = gRulerareaString + '|' + e.pageX + ',' + e.pageY
				startPtX = e.pageX;
				startPtY = e.pageY;
			} else {
				
				gRulerareaString = gRulerareaString + '|' + window.event.clientX + ',' + window.event.clientY
				startPtX = window.event.clientX;
				startPtY = window.event.clientY;					
			}
		}
			
		for(var i=1; i<=gRulerNbPoints; i++)
		{
			hide("pix" + i)
		}
		
		shiftTo("pix1", this.dtOrigX + this.dtOffX, this.dtOrigY + this.dtOffY)
		show("pix1")

		for(var i=1; i<=nbInf; i++)
		{
			hide("pInf" + i)
		}
		nbInf = 1
		if (gRulerg_digitTool){
			shiftTo("pInf"+nbInf,this.dtOrigX + this.dtOffX, this.dtOrigY + this.dtOffY)
			show("pInf"+nbInf)
		}
		
		currPix = 1
		startPix = currPix
	}
	function dtFinishDist(){
		for(var i=1; i<=gRulerNbPoints; i++){hide("pix" + i)}
		for(var i=1; i<=nbInf; i++){hide("pInf" + i)}
	}
	function dtCalcDist(e){
		var dDistX
		var dDistY
		var nbPix
		var i = 0
		var alpha
		var PixUp = 0
		var startPtX = this.dtOrigX + this.dtOffX
		var startPtY = this.dtOrigY + this.dtOffY
		if (isNav4 || isNav6) {
			dDistX = (e.pageX - startPtX)
			dDistY = (e.pageY - startPtY)
		} else {
			dDistX = (window.event.clientX + document.body.scrollLeft - startPtX)
			dDistY = (window.event.clientY + document.body.scrollTop - startPtY)
		}
		
		if (isNav4){
			dD = Math.sqrt((dDistX*dDistX)+(dDistY*dDistY))
			nbPix = Math.round(dD/espace) 
			if (dD != 0)
			{
				Vx = dDistX/dD
				Vy = dDistY/dD
			} else {
				Vx = 0;
				Vy = 0;
			}
			PixUp = startPix - 1 + nbPix
			if (PixUp > this.dtPtMax){PixUp = this.dtPtMax} 
			for (i=startPix + 1; i<=  PixUp ; i++){
				shiftTo("pix"+i,this.dtOrigX + this.dtOffX + (i - startPix)*Vx*espace,this.dtOrigY + this.dtOffY +(i - startPix)*Vy*espace)
				show("pix"+i)
			}
		} else {
			dD = Math.sqrt((dDistX*dDistX)+(dDistY*dDistY))
			nbPix = 5
			if (dD != 0)
			{
				Vx = dDistX/dD
				Vy = dDistY/dD
			} else {
				Vx = 0;
				Vy = 0;
			}
			
			PixUp = startPix - 1 + nbPix
			
			if (PixUp > this.dtPtMax){PixUp = this.dtPtMax}
			
			for (i=startPix + 1; i<= PixUp ; i++){
				shiftTo("pix"+i,this.dtOrigX + this.dtOffX + (i-startPix)*Vx*dD/4,this.dtOrigY + this.dtOffY +(i-startPix)*Vy*dD/4)
				show("pix"+i)
			}
				
		}
		if ( startPix - 1 + nbPix < currPix && nbPix>0){
			for (i = startPix - 1 +nbPix;i <= gRulerNbPoints; i++){hide("pix"+i)}
		}
		currPix = PixUp
		this.dtDistance = ODist + dD
	}
	function dtDrawDist(e){
        //alert("dtDrawDist");
		var nbPic = 1 
		var flag = false
		var intervalle
		var dDistX
		var dDistY
		var startPtX = this.dtOrigX + this.dtOffX
		var startPtY = this.dtOrigY + this.dtOffY
		if (isNav4 || isNav6) {
			dDistX = (e.pageX - startPtX)
			dDistY = (e.pageY - startPtY)
		} else {
			dDistX = (window.event.clientX + document.body.scrollLeft - startPtX)
			dDistY = (window.event.clientY + document.body.scrollTop - startPtY)
		}
		var dDist = Math.sqrt((dDistX*dDistX)+(dDistY*dDistY))
		do {
			intervalle = dDist/nbPic
			if (intervalle <= intervalmin){flag = true}
			if (intervalle > intervalmax){
				nbPic += 1
			} else {
				flag = true
			}
		} while (flag == false)
		if (startPix  + nbPic <= this.dtPtMax){
			for (i = startPix + 1; i<= startPix  + nbPic; i++){
				shiftTo("pix"+i,this.dtOrigX + this.dtOffX + (i-startPix)*Vx*intervalle,this.dtOrigY + this.dtOffY +(i-startPix)*Vy*intervalle)
				show("pix"+i)
			}
			if (gRulerg_digitTool){
				nbInf +=1
				shiftTo("pInf"+nbInf,this.dtOrigX + this.dtOffX + (i-startPix-1)*Vx*intervalle,this.dtOrigY + this.dtOffY +(i-startPix-1)*Vy*intervalle)
				show("pInf"+nbInf)
			}
			currPix = startPix - 1 +nbPic
		}

	}
	
    function dtDrawClose(e){
    
        // check to see if there are points to use for closing
        if ( this.aaPointTrace.length <= 0 )
            return null;
    
        //alert("dtDrawClose");
		var nbPic = 1 
		var flag = false
		var intervalle
		var dDistX
		var dDistY
		var startPtX = this.dtOrigX + this.dtOffX
		var startPtY = this.dtOrigY + this.dtOffY
		
        // set the x and y distance from the first point of the polygon
        dDistX = ( this.aaPointTrace[0][0] - startPtX );
		dDistY = ( this.aaPointTrace[0][1] - startPtY );

		var dDist = Math.sqrt((dDistX*dDistX)+(dDistY*dDistY))

		// update the direction variables
		if (dDist != 0)
		{
			Vx = dDistX/dDist
			Vy = dDistY/dDist
		} else {
			Vx = 0;
			Vy = 0;
		}		
		
		// loop and get interval
		do {
			intervalle = dDist/nbPic
			if (intervalle <= intervalmin){flag = true}
			if (intervalle > intervalmax){
				nbPic += 1
			} else {
				flag = true
			}
		} while (flag == false)
		if (startPix  + nbPic <= this.dtPtMax){
			for (i = startPix + 1; i<= startPix  + nbPic; i++){
				shiftTo("pix"+i,this.dtOrigX + this.dtOffX + (i-startPix)*Vx*intervalle,this.dtOrigY + this.dtOffY +(i-startPix)*Vy*intervalle)
				show("pix"+i)
			}
			if (gRulerg_digitTool){
				nbInf +=1
				shiftTo("pInf"+nbInf,this.dtOrigX + this.dtOffX + (i-startPix-1)*Vx*intervalle,this.dtOrigY + this.dtOffY +(i-startPix-1)*Vy*intervalle)
				show("pInf"+nbInf)
			}
			currPix = startPix - 1 +nbPic
		}

	}
	
	function dtSetInflection(e){
		var nbPic = Math.round(dD/espace)
		if (startPix - 1 + nbPic <= this.dtPtMax){
			this.dtDrawDist(e)		
			if (isNav4) {
				this.dtOffX = e.pageX - this.theMap.left
				this.dtOffY = e.pageY - this.theMap.top
			} else if (isNav6) {
				this.dtOffX = e.pageX - this.dtOrigX
				this.dtOffY = e.pageY - this.dtOrigY
			} else {
				this.dtOffX = window.event.clientX + document.body.scrollLeft - this.dtOrigX
				this.dtOffY = window.event.clientY + document.body.scrollTop - this.dtOrigY
			}
			startPix = currPix
			parent.gStartPix = currPix
			currPix += 1
			startPix = currPix
			parent.gStartPix = currPix
			ODist = this.dtDistance
			
			if (parent.gRulerareaMode)
			{
				if (isNav4 || isNav6)
				{
					parent.gRulerareaString = parent.gRulerareaString + '|' + e.pageX + ',' + e.pageY
					parent.lastPtX = e.pageX;
					parent.lastPtY = e.pageY;
				} else {
					
					parent.gRulerareaString = parent.gRulerareaString + '|' + window.event.clientX + ',' + window.event.clientY
					parent.lastPtX = window.event.clientX;
					parent.lastPtY = window.event.clientY;					
				}
			}
		}
	}
}
