// define global vars
var aoExpressions = new Array();
var szBrowser ="";
var nVersion = 0;

/* ============================================================================
 * Determine browser and version.
 * ========================================================================= */
if ( navigator.appName == "Netscape" )
{
    szBrowser = "netscape";
    if ( navigator.appVersion[0] <= 4)
      nVersion = 4;
    else
      nVersion = 5;
}
else
{
    szBrowser = "ie";
}

/**
 * setLayerVis()
 *
 * Postcondition:  This function sets the given layer's visibility.
 *
 * @param szLayerName string - Layer name.
 * @param bVisible boolean - Flag to indicate visibility.
 * @return boolean - True if successful, false if not
 **/
function setLayerVis( szLayerName, bVisible )
{
    // init vars
    var oLayer = getLayerObj( szLayerName );
    
    // set according to browser
    if ( szBrowser == "netscape" && nVersion == 4 )
    {
        if ( bVisible )
            oLayer.visibility = "show";
        else
            oLayer.visibility = "hide";
    }
    else
    {
        if ( bVisible )
            oLayer.visibility = "visible";
        else            
            oLayer.visibility = "hidden";
    }
    
    // return
    return true;
}

/**
 * toggleLayerVis()
 *
 * Postcondition:  This function toggles the given layer's visibility.
 *
 * @param szLayerName string - Layer name.
 * @return boolean - True if successful, false if not
 **/
function toggleLayerVis( szLayerName )
{
    // init vars
    var oLayer = getLayerObj( szLayerName );
    
    // set according to browser
    if ( szBrowser == "netscape" && nVersion == 4 )
    {
        if ( oLayer.visibility == "show" )
            oLayer.visibility = "hide";
        else
            oLayer.visibility = "show";
    }
    else
    {
        if ( oLayer.visibility == "visible" )
            oLayer.visibility = "hidden";
        else            
            oLayer.visibility = "visible";
    }
    
    // return
    return true;
}

/**
 * getLayerObj()
 *
 * Postcondition:  This function gets an object handle on the requested layer.
 *
 * @param szLayerName string - Layer name.
 * @return object - Handle for layer object.
 **/
function getLayerObj( szLayerName )
{
    // init var
    var oLayer;
    
    if ( szBrowser == "netscape" )
    {
        if ( nVersion == "4" )
          return document.layers[szLayerName];
        else
        {
            if ( eval( 'document.getElementById("' + szLayerName + '")' ) != null )
            {
                oLayer = eval( 'document.getElementById("' + szLayerName + '").style' );
                return oLayer;
            }
            else
            {
                return null;
            }
        }
    }
    else if ( szBrowser == "ie" )
    {
        if ( eval( 'document.all.' + szLayerName ) != null )
        {
            oLayer = eval( 'document.all.' + szLayerName + '.style' );
            return oLayer;
        } else
        {
            return null;
        }
    }
}

/**
 * getImageObj()
 *
 * Postcondition:  This function gets an object handle on the requested image.
 *
 * @param szImageName string - Image name.
 * @return object - Handle for image object.
 **/
function getImageObj( szImageName )
{
    var oImage;
    if ( szBrowser == "netscape" )
    {
        if ( arguments.length == 2 )
        {
            oImage = document.layers[arguments[1]].document.images[szImageName];
        }
        else
        {
            oImage = document.images[szImageName];
        }
    }
    else  //IE
    {
        oImage = document.getElementById(szImageName);
    }
    return oImage;
}

/**
 * setLayerPos()
 *
 * Postcondition:  This function dynamically positions a layer in the page.
 *
 * @param szLayerName string - Layer name.
 * @param nX integer - X position.
 * @param nY integer - Y position.
 * @return object - Handle for layer object.
 **/
function setLayerPos( szLayerName, nX, nY )
{
    if ( szBrowser == "netscape" )
    {
        if ( nVersion == "4" )
        {
            document.layers[szLayerName].left=nX;
            document.layers[szLayerName].top=nY;
        }
        else if ( nVersion == "5" )
        {
            document.getElementById(szLayerName).style.left=nX;
            document.getElementById(szLayerName).style.top=nY;
        }
    }
    else if ( szBrowser == "ie" )
    {
        document.all[szLayerName].style.left=nX;
        document.all[szLayerName].style.top=nY;
    }
}

/**
 * findObjectPosX()
 *
 * Postcondition:  This returns the x position of the given object.
 *
 * @param obj object - Object to process.
 * @return integer - X position.
 **/
function findObjectPosX( obj )
{
    var curleft = 0;
    if ( document.getElementById || document.all )  //Netscape 5+, IE
    {
        while ( obj.offsetParent )
        {
            curleft += obj.offsetLeft;
            obj = obj.offsetParent;
        }
    }
    else if ( document.layers )  //Netscape 4.x
    curleft += obj.x;
    return curleft;
}

/**
 * findObjectPosY()
 *
 * Postcondition:  This returns the y position of the given object.
 *
 * @param obj object - Object to process.
 * @return integer - Y position.
 **/
function findObjectPosY(obj)
{
    var curtop = 0;
    if ( document.getElementById || document.all )  //Netscape 5+, IE
    {
        while ( obj.offsetParent )
        {
            curtop += obj.offsetTop;
            obj = obj.offsetParent;
        }
    }
    else if ( document.layers )  //Netscape 4.x
    curtop += obj.y;
    return curtop;
}

/**
 * QueryExpression()
 *
 * Postcondition:  This function is the constructor to define a class of the same
 *                 name.  The class object is used to store expression attributes.
 **/
function QueryExpression()
{
    this.query_type = 0;    // 0 for simple, 1 for complex
    this.attribute = "";    // simple - attribute to use
    this.operator = "";     // both - operator to use
    this.not = "";          // complex - operator to use
    this.value1 = "";       // both - value 1 for simple - expression 1 for complex
    this.value2 = "";       // both - value 1 for simple - expression 1 for complex
    
}

/**
 * addExpression()
 *
 * Postcondition:  This function adds the given expression to the global 
 *                 javascript array and list box.
 *
 * @return boolean - True if successful, false if not
 **/
function addExpression( nType, szAttribute, szOperator, szSimple1, szSimple2, 
                                         szAndOr, szNot, szComplex1, szComplex2 )
{
    var nType = nType;
    var szNOT = "";
    var szExprToStore = "";
    
    // set flag to indicate save is required
    bSaveRequired = true;
    
    // check to see if a " was used
    szCheckText = document.forms[0].txtValue1.value;
    szCheckText2 = document.forms[0].txtValue2.value;
    if ( szCheckText.indexOf("\"") != -1 ||
         szCheckText2.indexOf("\"") != -1 )
    {
        alert( szLang15 );
        return;
    }
        
    // get array length
    var nCount = aoExpressions.length;
    
    // add according to type
    if ( nType == 0 )
    {
        // create new simple object in array
        aoExpressions[nCount] = new QueryExpression();
        aoExpressions[nCount].type = nType;
        aoExpressions[nCount].attribute = szAttribute;
        aoExpressions[nCount].operator = szOperator;
        aoExpressions[nCount].value1 = szSimple1;
        aoExpressions[nCount].value2 = szSimple2;
        
        // concat the expression to store
        szExprToStore = szAttribute + " " + szOperator + " " +  szSimple1;
               
        // add extra box for "between" if necessary
        if ( szOperator == "BETWEEN" )
            szExprToStore += " and " + szSimple2;
            
        // add the expression to the list of availble expressions
        document.forms[0].selExpressions.options.length = nCount + 1;
        document.forms[0].selExpressions.options[nCount].value = nCount;
        document.forms[0].selExpressions.options[nCount].text = 
               "[Expr" + (nCount + 1) + "]: " +  szExprToStore;
    }
    else
    {
        // check that the two value boxes have different values
        if ( szComplex1 == szComplex2 )
        {
            // give message
            alert( szLang16 );
            return;
        }
        
        // create new complex object in array
        aoExpressions[nCount] = new QueryExpression();
        aoExpressions[nCount].type = nType;
        aoExpressions[nCount].operator = szAndOr;
        aoExpressions[nCount].not = szNot;
        aoExpressions[nCount].value1 = szComplex1;
        aoExpressions[nCount].value2 = szComplex2;
        
        // concat expression
        szExprToStore = szComplex1 + " " + szAndOr + " " + szNot + " " + szComplex2;
            
        // add to expression list
        document.forms[0].selExpressions.options.length = nCount + 1;
        document.forms[0].selExpressions.options[nCount].value = nCount;
        document.forms[0].selExpressions.options[nCount].text = 
               "[Expr" + (nCount + 1) + "]: " + szExprToStore;
    }   
    
    // add the expression to the hidden textbox
    var szTmpDivider;
    if ( document.forms[0].txtExpressions.value == ""  )
        szTmpDivider = "";
    else
        szTmpDivider = "||";
    document.forms[0].txtExpressions.value += '|@|' +
        aoExpressions[nCount].type + '|' + 
        aoExpressions[nCount].attribute + '|' + 
        aoExpressions[nCount].operator + '|' + 
        aoExpressions[nCount].not + '|' + 
        aoExpressions[nCount].value1 + '|' + 
        aoExpressions[nCount].value2;
    
    // add the expression to the drop downs
    document.forms[0].selCompExpression1.options.length = nCount + 1;
    document.forms[0].selCompExpression1.options[nCount].value = "Expr" + (nCount + 1);
    document.forms[0].selCompExpression1.options[nCount].text = "Expr" + (nCount + 1);
    document.forms[0].selCompExpression2.options.length = nCount + 1;
    document.forms[0].selCompExpression2.options[nCount].value = "Expr" + (nCount + 1);
    document.forms[0].selCompExpression2.options[nCount].text = "Expr" + (nCount + 1);
}

/**
 * updateDetails()
 *
 * Postcondition:  This function updates the details box with the correct info and
 *                 also generates the required XML tags to be returned.
 *
 * @param nType integer - Type of expression, 0 for simple, 1 for complex
 * @return boolean - True if successful, false if not
 **/
function updateDetails()
{
    // init vars
    var nIndex = 0;
    var szNewExpression = "";
    
    // update with the current listbox selection
    nIndex = document.forms[0].selExpressions.selectedIndex;
    
    // evaluate the expression
    szNewExpression = concatExpression( nIndex );

    // evaluate
    document.forms[0].txtExpressionDetails.value = evalExpression( szNewExpression, false );
    
    // return
    return true;
}

/**
 * evalExpression()
 *
 * Postcondition:  This function evaluates the given expression and resolves all
 *                 nested "ExprX" items.
 *
 * @param szExpression string - Expression to evaluate.
 * @param bUseType boolean - Flag to indicate if type is to be considered.
 * @return string - Resolved expression.
 **/
function evalExpression( szExpression, bUseType )
{
    // intialize vars
    var szReturn = "";

    // loop through each char and replace each expression with it's value
    for( var i=0; i<szExpression.length; i++ )
    {
        //  check for Expr
        if ( szExpression.substr( i, 4 ) == "Expr" )
        {
            // int vars
            var szIndex = "";
            var szNewExpression = "";
            
            // advance to the end of the Expr portion
            i = i + 4;
            
            // loop until a non-numeric found or end of the expression
            do 
            {
                // check if the end of the expression has been reached
                if ( i >= szExpression.length )
                    break;
                    
                // check if the value of the current char is numeric
                szChar = szExpression.substr( i, 1 );
                if ( szChar == "0" || szChar == "1" || szChar == "2" ||
                     szChar == "3" || szChar == "4" || szChar == "5" ||
                     szChar == "6" || szChar == "7" || szChar == "8" ||
                     szChar == "9" )
                {
                    // add to index
                    szIndex = szIndex + szChar;
                }
                else
                {
                   // done so exit loop
                   break;
                }
                
                // increment counter
                i++;
            }
            while( 1==1 );
            
            // decrement i
            i--;
            
            // use index to get new expression (based on type if necessary)
            if ( bUseType )
            {
                // get type
                switch ( szWidgetType )
                {
                    case "WFS" :
                        szNewExpression = concatWFSExpression( szIndex - 1 );
                        // resolve any more nested expressions
                        szNewExpression = evalExpression( szNewExpression, true ); 
                        break;
                    default :
                        szNewExpression = concatExpression( szIndex - 1 );
                        // resolve any more nested expressions
                        szNewExpression = evalExpression( szNewExpression, true ); 
                        break;
                }
            }
            else
            {
                // default
                szNewExpression = concatExpression( szIndex - 1 );
                
                // resolve any more nested expressions
                szNewExpression = evalExpression( szNewExpression, false );                
            }   
            
            // add to results
            szReturn = szReturn + szNewExpression;
        }
        else
        {
            // just copy char
            szReturn = szReturn + szExpression.substr( i, 1 );
        }
    }

    // return 
    return szReturn;
}

/**
 * concatExpression()
 *
 * Postcondition:  This function constructs the expression based on index.
 *
 * @param nIndex integer - Expression index.
 * @return string - Expression.
 **/
function concatExpression( nIndex )
{
    // init vars
    var szReturn = "";
    var szNOTOpen = "";
    var szNOTClose = "";
    
    // concat by type
    if ( aoExpressions[nIndex].type == 0 )
    {
        szReturn = aoExpressions[nIndex].attribute + " " + 
                   aoExpressions[nIndex].operator + " " + 
                   aoExpressions[nIndex].value1;
                   
        // add the extra textbox value if operator is "BETWEEN"
        if ( aoExpressions[nIndex].operator == "BETWEEN" )
            szReturn = szReturn + " and " + aoExpressions[nIndex].value2;
    }
    else
    {
        // check if "NOT" isset
        if ( aoExpressions[nIndex].not == "NOT" )
        {
            szNOTOpen = "NOT(";
            szNOTClose = ")";
        }
        else
        {
            szNOTOpen = "";
            szNOTClose = "";
        }

        szReturn = "(" + aoExpressions[nIndex].value1 + " " + 
                   aoExpressions[nIndex].operator + " " + szNOTOpen +
                   aoExpressions[nIndex].value2 + szNOTClose + ")";
    }
    
    // return
    return szReturn;
}

/**
 * showExpressionTab()
 *
 * Postcondition:  This function makes the requested tab visible.
 *
 * @param nType integer - Type to display - 0 for simple, 1 for complex.
 * @return void.
 **/
function showExpressionTab( nType )
{
    // get info on image placeholder
    //var oImage = getImageObj( "imgSpacer" );
    //var xPos = findObjectPosX( oImage );
    //var yPos = findObjectPosY( oImage );
    
    // show tab based on type
    if ( nType == 0 )
    {
        // position the simple expression builder and show it
        //setLayerPos( "simple_expression", xPos, yPos );
        setLayerVis( "complex_expression", false );
        setLayerVis( "simple_expression", true );
        
        // set the type in the hidden var
        document.forms[0].txtExpressionType.value = 0;
        
        // hide the extra textbox for the between if necessary
        checkBetween();
    }
    else
    {
        // position the complex expression builder and show it
        //setLayerPos( "complex_expression", xPos, yPos );
        setLayerVis( "simple_expression", false );
        setLayerVis( "complex_expression", true );
        
        // set the type in the hidden var
        document.forms[0].txtExpressionType.value = 1;
        
        // always hide the extra textbox for the between
        setLayerVis( "extra_between", false );
        
        // hide like and attributes as well
        setLayerVis( "attribute_layer", false );
        //setLayerVis( "like_help", false );
    }
    
    // return void
    return;
}

/**
 * checkBetween()
 *
 * Postcondition:  This function checks and sets the visibility of the extra
 *                 textbox.
 *
 * @return void.
 **/
function checkBetween()
{   
    // show the extra textbox for the between option
    if ( document.forms[0].selOperator.value == "BETWEEN" )
        setLayerVis( "extra_between", true );
    else
        setLayerVis( "extra_between", false );
        
    // return void
    return;
}

/**
 * checkLikeHelp()
 *
 * Postcondition:  This function checks/sets the visibility and position of the
 *                 like help box.
 *
 * @return void.
 **/
function checkLikeHelp()
{
    // get info on image placeholder
    var oImage = getImageObj( "imgSpacer2" );
    var xPos = findObjectPosX( oImage );
    var yPos = findObjectPosY( oImage );
    
    // position
    setLayerPos( "like_help", xPos, yPos );
    
    // show the extra textbox for the between option
    if ( document.forms[0].selOperator.value == "LIKE" )
        setLayerVis( "like_help", true );
    else
        setLayerVis( "like_help", false );
        
    // return void
    return;
}

/**
 * execute()
 *
 * Postcondition:  This function gets run when the execute button has been 
 *                 pressed.
 *
 * @return void.
 **/
function execute()
{
    // give message if the textbox is not set
    if ( document.forms[0].txtExpressionDetails.value == "" &&
         !document.forms[0].chkBBOnly.checked )
    {
        alert( szLang17 );
        return;
    }
    
    // perform different functionality based on widget type
    switch ( szWidgetType )
    {
        case "WFS" :
            // get expression
            var szExpression = '';
            if ( document.forms[0].chkBBOnly.checked )
                szExpression = "BBOXONLY";
            else
                szExpression = buildWFSFilter();

            // determine of the filter is to be applied to the current layer
            var szApplyToMap = 0;
            if ( document.forms[0].chkApplyToMap.checked )
                szApplyToMap = 1;
            
            // check restrictions
            if ( !checkRestrictions( szExpression ) )
            {
                // check failed, restrictions were found
                return;
            }
            
            // get the name of the sld
            var selectedSLD = '';
            if ( document.forms[0].selSLD )
            {
                selectedSLD = document.forms[0].selSLD.value;
            }
            else
            {
                selectedSLD = 'expressionbuilder_default';
            }
            
            // get the layer type if set
            var layerType = '';
            if ( document.forms[0].selLayerType )
            {
                layerType = document.forms[0].selLayerType.value;
            }          

            // execute the opener's function to appply the filter
            window.opener.applyWFSFilter( szExpression, 
                document.forms[0].txtLayerIndex.value, 
                document.forms[0].txtExpressions.value, szApplyToMap,
                selectedSLD, document.forms[0].txtWMSConnection.value, layerType );
            
            // cancel any save flags
            bSaveRequired = false;
            
            // close the window
            //window.close();

            // set focus to main window
            window.opener.focus();
            
            break;
        default :
            break;
    }
    
    // return void
    return;
}

/**
 * buildWFSFilter()
 *
 * Postcondition:  This function builds the WFS filter based on the current 
 *                 selected expression.
 *
 * @return string - expression.
 **/
function buildWFSFilter()
{
    // init vars
    var nIndex = 0;
    var szNewExpression = "";
    
    // update with the current listbox selection
    nIndex = document.forms[0].selExpressions.selectedIndex;
    
    // evaluate the expression
    szNewExpression = concatWFSExpression( nIndex );

    // evaluate
    return evalExpression( szNewExpression, true );
}

/**
 * concatWFSExpression()
 *
 * Postcondition:  This function constructs the expression based on index.
 *
 * @param nIndex integer - Expression index.
 * @return string - Expression.
 **/
function concatWFSExpression( nIndex )
{
    // init vars
    var szReturn = "";
    var szOpenNot = "";
    var szCloseNot = "";
    
    // concat by expression type
    if ( aoExpressions[nIndex].type == 0 )
    {
        // build tags by operator
        switch ( aoExpressions[nIndex].operator )
        {
            case "=" :
                szReturn = "<PropertyIsEqualTo>" + 
                           "<PropertyName>" + 
                           aoExpressions[nIndex].attribute +
                           "</PropertyName>" + 
                           "<Literal>" + 
                           aoExpressions[nIndex].value1 +
                           "</Literal>" + 
                           "</PropertyIsEqualTo>";
                break;
            case "!=" :
                szReturn = "<NOT><PropertyIsEqualTo>" + 
                           "<PropertyName>" + 
                           aoExpressions[nIndex].attribute +
                           "</PropertyName>" + 
                           "<Literal>" + 
                           aoExpressions[nIndex].value1 +
                           "</Literal>" + 
                           "</PropertyIsEqualTo></NOT>";
                break;
            case "<" :
                szReturn = "<PropertyIsLessThan>" + 
                           "<PropertyName>" + 
                           aoExpressions[nIndex].attribute +
                           "</PropertyName>" + 
                           "<Literal>" + 
                           aoExpressions[nIndex].value1 +
                           "</Literal>" + 
                           "</PropertyIsLessThan>";
                break;
            case "<=" :
                szReturn = "<PropertyIsLessThanOrEqualTo>" + 
                           "<PropertyName>" + 
                           aoExpressions[nIndex].attribute +
                           "</PropertyName>" + 
                           "<Literal>" + 
                           aoExpressions[nIndex].value1 +
                           "</Literal>" + 
                           "</PropertyIsLessThanOrEqualTo>";
                break;
            case ">" :
                szReturn = "<PropertyIsGreaterThan>" + 
                           "<PropertyName>" + 
                           aoExpressions[nIndex].attribute +
                           "</PropertyName>" + 
                           "<Literal>" + 
                           aoExpressions[nIndex].value1 +
                           "</Literal>" + 
                           "</PropertyIsGreaterThan>";
                break;
            case ">=" :
                szReturn = "<PropertyIsGreaterThanOrEqualTo>" + 
                           "<PropertyName>" + 
                           aoExpressions[nIndex].attribute +
                           "</PropertyName>" + 
                           "<Literal>" + 
                           aoExpressions[nIndex].value1 +
                           "</Literal>" + 
                           "</PropertyIsGreaterThanOrEqualTo>";
                break;
            case "LIKE" :
                szReturn = "<PropertyIsLike wildcard='" + szWildCard + 
                           "' singleChar='" + szSingleChar + 
                           "' escape='" + szEscapeChar + "'>" +
                           "<PropertyName>" +
                           aoExpressions[nIndex].attribute +
                           "</PropertyName>" +
                           "<Literal>" +
                           aoExpressions[nIndex].value1 +
                           "</Literal>" +
                           "</PropertyIsLike>";
                break;
                
            case "BETWEEN" :
                szReturn = "<PropertyIsBetween>" + 
                           "<PropertyName>" +
                           aoExpressions[nIndex].attribute +
                           "</PropertyName>" +
                           "<LowerBoundary>" +
                           aoExpressions[nIndex].value1 +
                           "</LowerBoundary>" +
                           "<UpperBoundary>" +
                           aoExpressions[nIndex].value2 +
                           "</UpperBoundary>" + 
                           "</PropertyIsBetween>";
                break;
                
            default :
                break;
        }
    }
    else
    {
        // check if "NOT" isset
        if ( aoExpressions[nIndex].not == "NOT" )
        {
            szOpenNot = "<NOT>";
            szCloseNot = "</NOT>";
        }
        else
        {
            szOpenNot = "";
            szCloseNot = "";
        }
    
        szReturn = "<" + aoExpressions[nIndex].operator + ">" + 
                   aoExpressions[nIndex].value1 + 
                   szOpenNot + aoExpressions[nIndex].value2 + szCloseNot + 
                   "</" + aoExpressions[nIndex].operator + ">";
    }
    
    // return
    return szReturn;
}

/**
 * deleteAllExpressions()
 *
 * Postcondition:  This function deletes all expressions.
 *
 * @return void.
 **/
function deleteAllExpressions()
{
    // clear all text boxes
    document.forms[0].selExpressions.length = 0;
    document.forms[0].selCompExpression1.length = 0;
    document.forms[0].selCompExpression2.length = 0;
    document.forms[0].txtExpressionDetails.value = "";
    
    // expression textbox
    document.forms[0].txtExpressions.value = "";
    
    // clear global array
    aoExpressions = new Array();
    
    // return void
    return;
}

/**
 * checkRestrictions()
 *
 * Postcondition:  This function checks the current selected expression for 
 *                 restrictions.
 *
 * @return boolean - True if passed, false if restrictions found.
 **/
function checkRestrictions( szExpression )
{
    // get expression
    var szCheck = szExpression;
    szCheck = szCheck.toUpperCase();
    
    // check expression for "and" & "like"
    if ( szCheck.indexOf( "<AND><PROPERTYISLIKE" ) != -1 ||
         szCheck.indexOf( "<AND><NOT><PROPERTYISLIKE" ) != -1 ||
         szCheck.indexOf( "</PROPERTYISLIKE></AND>" ) != -1 ||
         szCheck.indexOf( "</PROPERTYISLIKE></NOT></AND>" ) != -1 )
    {
        // give error message
        alert( szLang18 );
            
        // return false
        return false;
    }
    
    // check for at least 2 occurrances of "like"
    var nPos = szCheck.indexOf( "<PROPERTYISLIKE" );
    if ( nPos != -1 && nPos != (szCheck.length - 1) )
    {
        // check for a second occurrance
        nPos = szCheck.indexOf( "<PROPERTYISLIKE", nPos + 1 );
        if ( nPos != -1 )
        {
            // give error message
            alert( szLang19 );
                
            // return false
            return false;
        }
    }
    
    // otherwise return true
    return true;
}
