//
//This script was contributed by TYDAC AG : http://www.tydac.ch/
//
// DHTMLapi.js custom API for cross-platform
// object positioning by Danny Goodman (http://www.dannyg.com)
/**
 *
 * @project     CWC2
 * @revision    $Id: dhtmlapi.js,v 1.3 2002/11/25 20:41:16 assefa Exp $
 * @purpose     Used with Ruler widget
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

// Global variables
var isNav4, isIE4, isNav6
var insideWindowWidth
var range = ""
var styleObj = ""

if (navigator.appName.charAt(0) == "N"){
	if(parseFloat(navigator.appVersion.charAt(0)) > 4){
		isNav6 = true
	} else {
		isNav4 = true
		insideWindowWidth = window.innerWidth
	}
} else {
	isIE4 = true
	range = "all."
	styleObj = ".style"
}



// Convert object name string or object reference
// into a valid object reference
function getObject(obj) {
	var theObj
	if (typeof obj == "string") {
        //alert(obj);
		if (isNav4) {
			theObj = eval("document." + range + obj + styleObj)
		} else {
			theObj = document.getElementById(obj).style
		}
	} else {
		theObj = obj
	}
	return theObj
}

// Convert object name string or object reference
// into a valid image object reference
function getImageObject(obj,img) {
	var theObj
	if (typeof obj == "string") {
		if (isNav4) {
			theObj = eval("document."+ obj + ".document." + img) 
		} else {
			theObj = document.getElementsByName(img)[0]
		}
	} else {
		theObj = obj
	}
	
	return theObj
}

// Convert object name string or object reference
// into a valid object reference
function getParObject(obj) {
	var theObj
	if (typeof obj == "string") {
		if (isNav4) {
			theObj = eval("document." + range + obj)
		} else {
			theObj = document.getElementById(obj)
		}
	} else {
		theObj = obj
	}
	return theObj
}

// Positioning an object at a specific pixel coordinate
function shiftTo(obj, x, y) {
	var theObj = getObject(obj)
	if (isNav4) {
		theObj.moveTo(x,y)
	} else {
		theObj.left = x
		theObj.top = y 
	}
}

// Moving an object by x and/or y pixels
function shiftBy(obj, deltaX, deltaY) {
	var theObj = getObject(obj)
	if (isNav4) {
		theObj.moveBy(deltaX, deltaY)
	} else {
		theObj.pixelLeft += deltaX
		theObj.pixelTop += deltaY
	}
}

// Setting the z-order of an object
function setZIndex(obj, zOrder) {
	var theObj = getObject(obj)
	theObj.zIndex = zOrder
}

// Setting the background color of an object
function setBGColor(obj, color) {
	var theObj = getObject(obj)
	if (isNav4) {
		theObj.bgColor = color
	} else {
		theObj.backgroundColor = color
	}
}

// Setting the visibility of an object to visible
function show(obj) {
	var theObj = getObject(obj)

	if (isNav4) {
		theObj.visibility = 'show'
	} else {
		theObj.visibility = "visible"
	}	
}

// Setting the visibility of an object to hidden
function hide(obj) {
	var theObj = getObject(obj)
	if (isNav4) {
		theObj.visibility = 'hide'
	} else {
		theObj.visibility = "hidden"
	}
}

// Retrieving the x coordinate of a positionable object
function getObjectLeft(obj)  {
	var theObj = getObject(obj)
	if (isNav4) {
		return theObj.left
	} else {
		return theObj.pixelLeft
	}
}

// Retrieving the y coordinate of a positionable object
function getObjectTop(obj)  {
	var theObj = getObject(obj)
	if (isNav4) {
		return theObj.top
	} else {
		return theObj.pixelTop
	}
}

function showProps(o, objName) {
	var result = ""
	count = 0
	for (var i in o) {
		result += o + "." + i + "=" + o[i] + "\n"
		count++
		if (count == 25) {
			alert(result)
			result = ""
			count = 0
		}
	}
	alert(result)
}