/**
 *
 * @project     CWC2
 * @revision    $Id: cwc_slide.js,v 1.2 2004/01/22 18:41:49 pspencer Exp $
 * @purpose     JS for SlideLayer Chameleon widget
 * @author      DM Solutions Group (jfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */



/************************************************************************************************/
/*  @function :  CWCDHTML_PositionIntersectLayer                                                */
/*            (anchorType, layerName, anchorName, location, xoffset, yoffset, visible, objMake) */
/*  @purpose  :  Places a layer [top,bottom,left,right] under an anchor (layer|image)           */
/************************************************************************************************/
function CWCDHTML_PositionIntersectLayer( anchorType, anchorName, layerName, location, xoffset, yoffset, visible )
{

    CWCDHTML_SetLayerVis(layerName, visible);
    CWCDHTML_SetLayerZOrder( layerName, 0 );
    
    if( anchorType == 'layer' )
    {
        var oAnchor = CWCDHTML_GetLayer( anchorName );
        var anchorLeft = parseInt(oAnchor.left);
        var anchorTop = parseInt(oAnchor.top);
    }
    else
    {
        var oAnchor = CWCDHTML_GetImage( anchorName );
        var anchorLeft = CWCDHTML_FindObjectPosX( oAnchor );
        var anchorTop = CWCDHTML_FindObjectPosY( oAnchor );
    }
    
    var anchorWidth = parseInt( oAnchor.width );
    var anchorHeight = parseInt( oAnchor.height );

    var oLayer = CWCDHTML_GetLayer( layerName );
    var layerWidth = parseInt( oLayer.width );
    var layerHeight = parseInt( oLayer.height );
    
    var x, y, dir, out, direction;
    
    switch( location )
    {
        /* right */
        case 'RT':
            x = anchorLeft + ((anchorWidth - layerWidth) + xoffset);
            y = anchorTop + yoffset;
            dir = 'x';
            out = 'r'
            break;
            
        case 'RM':
            x = anchorLeft + ((anchorWidth - layerWidth) + xoffset);
            y = anchorTop + ((anchorHeight - layerHeight)/2) + yoffset;
            dir = 'x';
            break;
            
        case 'RB':
            x = anchorLeft + ((anchorWidth - layerWidth) + xoffset);
            y = anchorTop + (anchorHeight - layerHeight) + yoffset;
            dir = 'x';
            break;

        /* left */
        case 'LT':
            x = anchorLeft + xoffset;
            y = anchorTop + yoffset;
            dir = 'x';
            break;
            
        case 'LM':
            x = anchorLeft + xoffset;
            y = anchorTop + ((anchorHeight - layerHeight)/2) + yoffset;
            dir = 'x';
            break;
            
        case 'LB':
            x = anchorLeft + xoffset;
            y = anchorTop + (anchorHeight - layerHeight) + yoffset;
            dir = 'x';
            break;
    
    
        /* top */
        case 'TL':
            x = anchorLeft + xoffset;
            y = anchorTop + yoffset;
            dir = 'y';
            break;
            
        case 'TM':
            x = anchorLeft + (((anchorWidth - layerWidth)/2) + xoffset);
            y = anchorTop + yoffset;
            dir = 'y';
            break;
            
        case 'TR':
            x = anchorLeft + ((anchorWidth - layerWidth) + xoffset);
            y = anchorTop + yoffset;
            dir = 'y';
            break;


        /* bottom */
        case 'BL':
            x = anchorLeft + xoffset;
            y = anchorTop + (anchorHeight - layerHeight) + yoffset;
            dir = 'y';
            break;
            
        case 'BM':
            x = anchorLeft + (((anchorWidth - layerWidth)/2) + xoffset);
            y = anchorTop + (anchorHeight - layerHeight) + yoffset;
            dir = 'y';
            break;
            
        case 'BR':
            x = anchorLeft + ((anchorWidth - layerWidth) + xoffset);
            y = anchorTop + (anchorHeight - layerHeight) + yoffset;
            dir = 'y';
            break;
    }
    
    if( arguments.length > 7 )
    {
        if( location.substring(0,1) == 'R' )
        {
            endx = layerWidth + x;
            endy = y;
            direction = 'r';
        }
        else if( location.substring(0,1) == 'L' )
        {
            endx = x - layerWidth;
            endy = y;
            direction = 'l';
        }
        else if( location.substring(0,1) == 'T' )
        {
            endx = x;
            endy = y - layerHeight;
            direction = 't';
        }
        else
        {
            endx = x;
            endy = layerHeight + y;
            direction = 'b';
        }
        eval(arguments[7] + '= new CWCSlideLayer(layerName, layerWidth, layerHeight, direction, x, y, endx, endy);');
    }

    CWCDHTML_SetLayerPos(layerName, x, y);
    
}

var CWCSlideLayerTemp = new Array();
var CWCSlideLayerIndex = 0;

/*****************************************************************************/
/*  function CWCSlideLayer                                                   */
/*  (layerName, layerWidth, layerHeight, direction, x, y, endx, endy)        */
/*  Constructs a CWCSlideLayer object                                        */
/*****************************************************************************/
function CWCSlideLayer(layerName, layerWidth, layerHeight, direction, x, y, endx, endy)
{

    // layer vars
    this.szLayerName = layerName;               // name of the layer
    this.oLayer = CWCDHTML_GetLayer(layerName); // handle on the slide layer
    this.nLayerWidth = layerWidth;              // slide layer width
    this.nLayerHeight = layerHeight;            // slide layer height
    
    // direction vars
    this.szDirection = direction;               // direction of inital shift (r,l,t,b)
    this.nPosition = '0';                       // in or out?  0|1
    
    // position vars
    this.nStartX = x;                           // calculated start x pos of the slide layer
    this.nStartY = y;                           // calculated start y pos of the slide layer
    this.nEndX = endx;                          // calculated end x pos of the slide layer
    this.nEndY = endy;                          // calculated end y pos of the slide layer
    
    // aesthetic vars
    this.nIncrement = 2;                        // increment of slide in pixels
    this.nSpeed = 25;                           // speed of slide in ms
    
    //globally unique
    this.nIndex = CWCSlideLayerIndex;
    CWCSlideLayerIndex = CWCSlideLayerIndex + 1;
    CWCSlideLayerTemp[this.nIndex] = this;
    
    // prototypes
    this.ShiftXY = ShiftXY;                     // constructs values and tmpThis for Shifts
    this.SetPositionValue = SetPositionValue;   // sets state value to 1|0
    this.SetStaticPosition = SetStaticPosition; // sets position from form submits
    
    // workhorse prototypes
    this.ShiftPlus = ShiftPlus;                 // shift a layer towards positively
    this.ShiftMinus = ShiftMinus;               // shift a layer towards negatively
    
}


/******************************************/
/*  function ShiftXY()                    */
/******************************************/
function ShiftXY()
{

    // tmpThis is a temporary global that contains all of the properties of this.
    // This is required for the settimeout functions.
    tmpThis = null;
    tmpThis = this;

    if( this.nPosition == '0' )
    {
        if( this.szDirection == 'r' )
        {
            this.startPos = this.nStartX;
            this.endPos = this.nEndX;
            this.ShiftPlus();
        }
        else if( this.szDirection == 'l' )
        {
            this.startPos = this.nStartX;
            this.endPos = this.nEndX;
            this.ShiftMinus();
        }
        else if( this.szDirection == 't' )
        {
            this.startPos = this.nStartY;
            this.endPos = this.nEndY;
            this.ShiftMinus();
        }
        else
        {
            this.startPos = this.nStartY;
            this.endPos = this.nEndY;
            this.ShiftPlus();
        }
    }
    else
    {
        if( this.szDirection == 'r' )
        {
            this.startPos = this.nEndX;
            this.endPos = this.nStartX;
            this.ShiftMinus();
        }
        else if( this.szDirection == 'l' )
        {
            this.startPos = this.nEndX;
            this.endPos = this.nStartX;
            this.ShiftPlus();
        }
        else if( this.szDirection == 't' )
        {
            this.startPos = this.nEndY;
            this.endPos = this.nStartY;
            this.ShiftPlus();
        }
        else
        {
            this.startPos = this.nEndY;
            this.endPos = this.nStartY;
            this.ShiftMinus();
        }
    }

}


/******************************************/
/*  method SetPositionValue()             */
/******************************************/
function SetPositionValue()
{
    if( this.nPosition == 0 )
        this.nPosition = 1;
    else
        this.nPosition = 0;
}


/******************************************/
/*  method SetStaticPosition()            */
/******************************************/
function SetStaticPosition()
{
    CWCDHTML_SetLayerPos( this.szLayerName, this.nEndX, this.nEndY );
}


/******************************************/
/*  method ShiftPlus()                    */
/******************************************/
function ShiftPlus()
{
    //if (this.startPos > this.endPos)
    //    this.startPos = this.endPos;
    if ( this.startPos < this.endPos ) 
    {
        this.startPos += this.nIncrement;
            
        if( this.szDirection == 'r' || this.szDirection == 'l' )
            this.oLayer.left = this.startPos;
        else
            this.oLayer.top = this.startPos;
        setTimeout( "var tmp = CWCSlideLayerTemp[" + this.nIndex + "]; tmp.ShiftPlus()", this.nSpeed );
    }
    else
    {
        this.SetPositionValue();
    }
}


/******************************************/
/*  method ShiftMinus()                   */
/******************************************/
function ShiftMinus()
{
    //if (this.startPos > this.endPos)
    //    this.startPos = this.endPos;
    if ( this.startPos > this.endPos ) 
    {
        this.startPos -= this.nIncrement;
        if( this.szDirection == 'l' || this.szDirection == 'r' )
            this.oLayer.left = this.startPos;
        else
            this.oLayer.top = this.startPos;
        setTimeout( "var tmp = CWCSlideLayerTemp[" + this.nIndex + "]; tmp.ShiftMinus()", this.nSpeed );
    }
    else
    {
        this.SetPositionValue();
    }
}