/**
 * @project     Chameleon
 * @revision    $Id: cwc_dhtml.js,v 1.13 2004/05/20 20:45:47 pspencer Exp $
 * @purpose     DHTML utilities for Chameleon widgets
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

//browser detection
var CWCIsNav4 = (document.layers) ? 1:0;
var CWCIsIE = (document.all) ? 1:0;
var CWCIsNav6 = (document.getElementById && !document.all) ? 1:0;


/* ==================================================================== */
/*  CWCDHTML_GetImage( szImage )                                        */
/*  returns a handle on an Image object                                 */
/* ==================================================================== */
function CWCDHTML_GetImage( szImage )
{
    var obj = null;
    if (CWCIsNav4) //Netscape 4.x
    {
        obj = document.images[szImage];
    }
    else
    {
        obj = document.getElementById(szImage);
    }
    return obj;
}


/* ==================================================================== */
/*  CWCDHTML_GetLayer( name )                                           */
/*  returns a handle on a Layer object                                  */
/*  if optional arg (true) is set - layer returned writes to contents   */
/* ==================================================================== */
function CWCDHTML_GetLayer( name )
{
    if (CWCIsNav4) // Netscape
    {                
        return document.layers[name];
    } 
    else if (CWCIsIE) // IE
    {            
        if (eval('document.all.' + name) != null) 
        {
            if( arguments.length > 1 && arguments[1] == true )
            {
                layer = eval('document.all.' + name);
            }
            else
            {
                layer = eval('document.all.' + name + '.style');
            }
            return layer;

        } 
        else 
        {
            return null;
        }
    } 
    else if (CWCIsNav6) 
    {
        if (eval('document.getElementById("' + name + '")') != null)
        {
            if( arguments.length > 1 && arguments[1] == true )
            {
                layer = eval('document.getElementById("' + name + '")');
            }
            else
            {
                layer = eval('document.getElementById("' + name + '").style');
            }
            return layer;
        } 
        else 
        {
            return null;
        }
    } 
    else // Don't know
    {                              
        return null;
    }
}


/* ==================================================================== */
/*  CWCDHTML_SetLayerZOrder( name, nLevel )                             */
/*  sets the z-Index on a layer                                         */
/* ==================================================================== */
function CWCDHTML_SetLayerZOrder( name, nLevel )
{
    var layer = CWCDHTML_GetLayer( name );
    layer.zIndex = nLevel;
    //CWCIsNav4 ? layer.zIndex = nLevel : layer.style.zIndex = nLevel;
}


/* ==================================================================== */
/*  CWCDHTML_ClipLayer(name, clipleft, cliptop, clipright, clipbottom)  */
/*  clips a layer                                                       */
/* ==================================================================== */
function CWCDHTML_ClipLayer(name, clipleft, cliptop, clipright, clipbottom)
{
    var layer = CWCDHTML_GetLayer(name);
    if (layer != null) 
    {
        if (CWCIsNav4) // Netscape
        {                      
            layer.clip.left   = clipleft;
            layer.clip.top    = cliptop;
            layer.clip.right  = clipright;
            layer.clip.bottom = clipbottom;
        } 
        else if (CWCIsIE) // IE
        {                  
            layer.clip = 'rect(' + cliptop + ' ' +  clipright + ' ' +
                         clipbottom + ' ' + clipleft + ')';
        } 
        else if (CWCIsNav6) // Netscape 6
        {       
            layer.clip = 'rect(' + cliptop + 'px,' + clipright + 'px,' +
                          clipbottom + 'px,' + clipleft + 'px)';
        }
    }
}


/* ======================================================================== */
/*  CWCDHTML_CreateLayer(name, left, top, width, height, visible, content)  */
/*  creates a layer                                                         */
/* ======================================================================== */
function CWCDHTML_CreateLayer(name, left, top, width, height, visible, content)
{
    var layer, str;
    if (CWCIsNav4) 
    {                        // Netscape
        str = '<layer id="' + name + '" name="'+name+'" left=' + left + ' top=' + top +
              ' width=' + width + ' height=' + height +
              ' visibility=' + (visible ? '"show"' : '"hide"') + '>';
        document.writeln(str);
        document.writeln(content);
        document.writeln('</layer>');
        layer = CWCDHTML_GetLayer(name);
        layer.width = width;
        layer.height = height;
    } 
    else if (CWCIsIE || CWCIsNav6) 
    {                    // IE
        str = '<div id="' + name +
              '" name="' + name + '" style="position:absolute; overflow:none; left:' + left +
              'px; top:' + top + 'px; width:' + width + 'px; height:' + height +
              'px;' + ' visibility:' + (visible ? 'visible;' : 'hidden;') +  '">';
        document.writeln(str);
        document.writeln(content);
        document.writeln('</div>');
    } 
    else 
    {
        return null;
    }
}


/* ==================================================================== */
/*  CWCDHTML_SetLayerBackgroundColor(name, color)                       */
/*  sets the background color of a layer                                */
/* ==================================================================== */
function CWCDHTML_SetLayerBackgroundColor(name, color)
{
    var layer = CWCDHTML_GetLayer(name);
    if (layer != null) 
    {
        if (CWCIsNav4) // Netscape
        {              
            layer.bgColor = color;
        } 
        else if (CWCIsIE || CWCIsNav6) // IE
        {          
            layer.backgroundColor = color;
        }
    }
}


/* ==================================================================== */
/*  CWCDHTML_SetLayerOpacity(name, opacity)                             */
/*  sets the opacity/alpha of a layer                                   */
/* ==================================================================== */
function CWCDHTML_SetLayerOpacity(name, opacity)
{
    var layer = CWCDHTML_GetLayer( name );
    if (layer != null)
    {
        if (CWCIsNav4)
        {
            //netscape 4 doesn't support transparency
            return;
        }
        else if (CWCIsIE)
        {
            if (opacity <= 1)
                opacity = opacity * 100;
            layer.filter = "Alpha(opacity=" + opacity + ")";
        }
        else if (CWCIsNav6)
        {
            if (opacity > 1)
                opacity = opacity / 100;
            layer.MozOpacity = opacity;
        }
    }
}


/* ==================================================================== */
/*  CWCDHTML_GetLayerOpacity( layer )                                   */
/*  returns the opacity/alpha of a layer                                */
/* ==================================================================== */
function CWCDHTML_GetLayerOpacity( layer )
{
    var opacity = null;
    if (CWCIsNav6)
    {
        opacity = layer.style.MozOpacity;
    }
    else if (CWCIsIE)
    {
        var filter = layer.style.filter;
        var start = filter.indexOf( "=" ) + 1;
        var end = filter.indexOf( ")" );
        opacity = filter.substring( start, end);
    }
    return opacity;
}
  
  
/* ==================================================================== */
/*  CWCDHTML_ShowLayer(name)                                            */
/*  makes a layer visible                                               */
/* ==================================================================== */
function CWCDHTML_ShowLayer(name)
{
    var layer = CWCDHTML_GetLayer(name);
    if (layer != null) 
    {
        if (CWCIsNav4) // Netscape
        {              
            layer.visibility = "show";
        } 
        else if (CWCIsIE || CWCIsNav6) // IE
        {          
            layer.visibility = "visible";
        }
    }
}
         

/* ==================================================================== */
/*  CWCDHTML_HideLayer(name)                                            */
/*  makes a layer hidden                                                */
/* ==================================================================== */
function CWCDHTML_HideLayer(name)
{
    var layer = CWCDHTML_GetLayer(name);
    if (layer != null) 
    {
        if (CWCIsNav4)
        {              // Netscape
            layer.visibility = "hide";
        }
        else if (CWCIsIE || CWCIsNav6)
        {
            layer.visibility = "hidden";
        }
    }
}


/* ==================================================================== */
/*  CWCDHTML_FindObjectPosX(obj)                                        */
/*  returns the X (left) position of an object                          */
/* ==================================================================== */
function CWCDHTML_FindObjectPosX(obj)
{
    var curleft = 0;
    if (document.getElementById || document.all)
    {
        while (obj.offsetParent)
        {
            curleft += obj.offsetLeft;
            obj = obj.offsetParent;
        }
    }
    else if (document.layers)
        curleft += obj.x;
    return curleft;
}


/* ==================================================================== */
/*  CWCDHTML_FindObjectPosY(obj)                                        */
/*  returns the Y (top) position of an object                           */
/* ==================================================================== */
function CWCDHTML_FindObjectPosY(obj)
{
    var curtop = 0;
    if (document.getElementById || document.all)
    {
        while (obj.offsetParent)
        {
            curtop += obj.offsetTop;
            obj = obj.offsetParent;
        }
    }
    else if (document.layers)
        curtop += obj.y;
    return curtop;
}


/* ==================================================================== */
/*  CWCDHTML_FindObjectPos(oElement)                                    */
/*  returns the X & Y positions of an object as an array                */
/* ==================================================================== */
function CWCDHTML_FindObjectPos(oElement)
{
    var aPos = new Array(2);
    aPos[0] = CWCDHTML_FindObjectPosX( oElement );
    aPos[1] = CWCDHTML_FindObjectPosY( oElement );

    if (arguments.length == 2 && CWCIsNav4)
    {
        var oLayer = CWCDHTML_GetLayer( arguments[1] );
        
        aPos[0] = aPos[0] + oLayer.left;
        aPos[1] = aPos[1] + oLayer.top;
    }
    return aPos;
}


/* ==================================================================== */
/*  CWCDHTML_SetLayerPos(layerName, x, y)                               */
/*  sets layer position based on recieved x & y coords                  */
/* ==================================================================== */
function CWCDHTML_SetLayerPos(layerName, x, y)
{
    var oLayer = CWCDHTML_GetLayer(layerName);
    
    if (oLayer != null)
    {
        oLayer.left=x;
        oLayer.top=y;
    }
    else
        alert( "layer " + layerName + " doesn't exist" );
}


/* ==================================================================== */
/*  CWCDHTML_SetLayerVis(layerName, bVisible)                           */
/*  sets layer visibility based on true/false                           */
/* ==================================================================== */
function CWCDHTML_SetLayerVis(layerName, bVisible)
{
    var oLayer = CWCDHTML_GetLayer(layerName);
    if (CWCIsNav4)
    {
        if (bVisible)
            oLayer.visibility = "show";
        else
            oLayer.visibility = "hide";
    }
    else
    {
        if (bVisible)
            oLayer.visibility = "visible";
        else            
            oLayer.visibility = "hidden";
    }
}


/* ==================================================================== */
/*  CWCDHTML_SetLayerVis(layerName, bVisible)                           */
/*  sets layer visibility based on true/false                           */
/* ==================================================================== */
function CWCDHTML_SetLayerSize(layerName, imgWidth, imgHeight)
{

    var oLayer = CWCDHTML_GetLayer( layerName );

    oLayer.width = imgWidth;
    oLayer.height = imgHeight;

}


/* ==================================================================== */
/*  CWCDHTML_PositionLayerByImage( szLayer, szImage )                   */
/*  positions layer based on image (tl,tr,bl,br)                        */
/* ==================================================================== */
function CWCDHTML_PositionLayerByImage( szLayer, szImage )
{
    var oLayer = CWCDHTML_GetLayer( szLayer );
    var oImage = CWCDHTML_GetImage( szImage );
    var szPosition;
    var aPos;
    var x, y;

    //If no position specified then put the layer to the top left
    if (arguments.length > 2)
        szPosition = arguments[2];
    else
        szPosition = "tl";
  
    //Are there offsets set?
    if (arguments.length == 5)
    {
        nXOffset = arguments[3];
        nYOffset = arguments[4];
    }
    else
    {
        nXOffset = 0;
        nYOffset = 0;
    }

    //Get the Image position
    aPos = CWCDHTML_FindObjectPos( oImage );
    x = aPos[0] + nXOffset;;
    y = aPos[1] + nYOffset;
    
    if (szPosition == "tr" )      //top right
    {
        x = x + oImage.width;
    }
    else if (szPosition == "bl" ) //bottom left
    {
        y = y + oImage.height;
    }
    else if (szPosition == "br" ) //bottom right
    {
        x = x + oImage.width;
        y = y + oImage.height;
    }
    
    if (oLayer == null)
        alert( szLayer + " not found?" );
    else
    {
       
        oLayer.left = x;
        oLayer.top = y;
    }
}


/* ==================================================================== */
/*  CWCDHTML_PositionLayerByLayer( szLayer, szImage )                   */
/*  positions layer based on layer (t,b,l,r)                            */
/* ==================================================================== */
function CWCDHTML_PositionLayerByLayer( szTabsetLayer, szContentLayer )
{
    var oTSLayer = CWCDHTML_GetLayer( szTabsetLayer );
    var oCLayer = CWCDHTML_GetLayer( szContentLayer );
    
    var szPosition;
    var deltaX, deltaY;

    var layerCX = parseInt( oCLayer.left );
    var layerCY = parseInt( oCLayer.top );

    //If no position specified then put the layer to the top left
    if (arguments.length > 2)
        szPosition = arguments[2];
    else
        szPosition = "t";
  
    //Are there offsets set?
    if (arguments.length == 5)
    {
        nXOffset = arguments[3];
        nYOffset = arguments[4];
    }
    else
    {
        nXOffset = 0;
        nYOffset = 0;
    }

    if( szPosition == "t" )  /////////////////////////////////TOP
    {
        var layerTSHeight = parseInt( oTSLayer.height );
        deltaX = layerCX + nXOffset;
        deltaY = layerCY - layerTSHeight - nYOffset;
    }
    else if( szPosition == "b" )  ////////////////////////////BOTTOM
    {
        var layerCHeight = parseInt( oCLayer.height );
        deltaX = layerCX + nXOffset;
        deltaY = layerCY + layerCHeight + nYOffset;
    }
    
    else if( szPosition == "l" )  ////////////////////////////LEFT
    {
        var layerCWidth = parseInt( oCLayer.width );
        deltaX = layerCX + layerCWidth + nXOffset;
        deltaY = layerCY + nYOffset;
    }
    else  ////////////////////////////////////////////////////RIGHT
    {
        var layerTSWidth = parseInt( oTSLayer.width );
        deltaX = layerCX - layerTSWidth - nXOffset;
        deltaY = layerCY + nYOffset;
    }

    oTSLayer.left = deltaX;
    oTSLayer.top = deltaY;
    
}


/* ==================================================================== */
/*  CWCDHTML_ShowContents( szLayerName, szContents )                    */
/*  writes content to a layer                                           */
/* ==================================================================== */
function CWCDHTML_ShowContents(szLayerName,szContents)
{

    oLayer = CWCDHTML_GetLayer(szLayerName, true);

    if (CWCIsNav4)
    {       
        oLayer.document.open();
        oLayer.document.write(szContents);
        oLayer.document.close();
    }
    else
    {
        oLayer.innerHTML = szContents;
    }
    
}   


function CWCDHTML_AddEventHandler()
{
}
