<?php
/**
 * ZoomSelectedLayers Widget class
 *
 * @project     CWC2
 * @revision    $Id: ZoomSelectedLayers.widget.php,v 1.3 2004/07/08 15:58:59 pspencer Exp $
 * @purpose     Zoom Selected Layers Widget class
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
 * ZoomSelectedLayersWidget
 *
 * @desc ZoomSelectedLayers widget.
 */
class ZoomSelectedLayers extends CWCWidget
{
    var $moButton;
    var $moMapNavigator;

    /**
     * ZoomSelectedLayersWidget
     *
     * Constructor. Set the default values.
     */
    function ZoomSelectedLayers()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = "No description available.  Please set ".
                        "this description in the constructor of this class.";

        $this->moButton = new CWCButton( $this );
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick( "clickZoomSelectedLayers()" );
    }


    /**
     * SetMap
     *
     * Set the map session and create a navigation tool.
     *
     * @param $oMapSession
     */
    function SetMap($oMapSession)
    {
        $this->moMapObject = $oMapSession;

        $this->moMapNavigator = new MapNavigator( $oMapSession );
    }

    /**
     * GetHTMLHiddenVariables
     *
     * return the NAV_CMD varaiable.
     *
     * @return NAV_CMD variable.
     */
    function GetHTMLHiddenVariables()
    {
        $szCmd="";
        if ($this->isVarSet( "NAV_ZOOM" ))
          $szCmd = $this->getVar( "NAV_ZOOM" );

        $szVariable = "NAV_ZOOM";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * GetJavascriptFunctions
     *
     * Return the Javacriptfunctions needed by the widget.
     *
     * @return Javacriptfunctions needed by the widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = $this->moButton->GetJavascriptFunctions();

        $szJsFunctionName = "clickZoomSelectedLayers";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the user clicks a pan arrow
 */
function {$szJsFunctionName}(sTool)
{
    {$this->mszHTMLForm}.NAV_ZOOM.value=sTool;
    {$this->mszHTMLForm}.submit();
    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }

    /**
     * ParseURL
     *
     * Look for the ZOOM_IN command and if founddo the zooming
     * according to the other NAV paramaters.
     */
    function  ParseURL()
    {
        $szCmd = "";
        if ($this->isVarSet( "NAV_ZOOM" ))
          $szCmd = trim($this->getVar( "NAV_ZOOM" ));

        if ($szCmd == "ZOOMSELECTED")
        {
            //handle ZoomSelectedLayers here.

        }
        
        // return success
        return true;
    }
    
    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }


    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     *
     * @return HTML code
     */
    function DrawPublish()
    {
        return $this->moButton->DrawPublish();
    }

}

if ((function_exists( "RegisterWidget" )))
    RegisterWidget( "ZoomSelectedLayers", "ZoomSelectedLayers" );

?>
