<?php
/**
 * ZoomOut Widget class
 *
 * @project     CWC2
 * @revision    $Id: ZoomOut.widget.php,v 1.2 2004/04/24 22:00:08 pspencer Exp $
 * @purpose     Zoom out Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../NavTool.php");

/**
 * ZoomOut
 *
 * @desc ZoomOut widget.
 */
class ZoomOut extends NavTool
{
    var $mszImagePath = "images/tool_zoomout_off.gif";
    var $mszSelectedImagePath = "images/tool_zoomout_on.gif";
    var $mszHoverImagePath = "/images/tool_zoomout_over.gif";
    var $mszImageTip = "Zoom Out";


    /**
     * ZoomOut
     *
     * Constructor. Set the default values.
     */
    function ZoomOut()
    {
        // invoke constructor of parent
        parent::NavTool();

        $this->NavTool();
        $this->SetNavCommand("ZOOM_OUT");

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ZoomOut widget allows the user to zoom out of the map from a given point
using the current zoom factor.
EOT;

    }

    /**
     * ParseURL
     *
     * Look for the ZOOM_IN command and if founddo the zooming
     * according to the other NAV paramaters.
     */
    function  ParseURL()
    {
        parent::ParseURL();

        $szCmd = "";
        if ($this->isVarSet( "NAV_CMD" ))
          $szCmd = trim($this->getVar( "NAV_CMD" ));

        if ($szCmd == "ZOOM_OUT")
        {

            $szInputCoords = "";
            $szInputCoords = $this->getVar( "NAV_INPUT_COORDINATES" );
            $szInputType = $this->getVar( "NAV_INPUT_TYPE" );

            if(strlen($szInputCoords) <= 0)
            {
          //                $_SESSION['gErrorManager']->setError(ERR_WARNING,
          //           "ERROR: No input coordinates specified in ZoomOut.php.");
        return;
            }
            if(strlen($szInputType) <= 0)
            {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                   trim($this->moMLT->get("0", "ERROR: No input type specified in "))."ZoomOut.php.");
                return;
            }
            //widget can have a default
            $nZoomFactor = $this->GetValue( "DefaultFactor", 2 );

            //a zoomfactor widget could also set it?
            if ($this->isVarSet( "ZOOMFACTOR" ))
                $nZoomFactor = $this->getVar( "ZOOMFACTOR" );

            //final sanity check on Zoom Factor
            if ($nZoomFactor <= 0)
              $nZoomFactor = 2;

            if ($szInputType == "POINT")
            {
                $aPixPos = explode(",", $szInputCoords);
                $this->moMapNavigator->zoomOut($nZoomFactor, $aPixPos[0], $aPixPos[1]);
          /**
             Call the reporjectauto function in case the map projection
             is set to AUTO:XXX. If it is not, the function will do
             nothing.
          */
                $this->ReprojectAuto();
            }
        else
        {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                   trim($this->moMLT->get("1", "ERROR: Invalid input type specified in "))."ZoomOut.php.");
                return false;
        }
        }
        
        // return success
        return true;
    }
}
?>
