<?php
/**
 * ZoomAllLayers Widget class
 *
 * @project     CWC2
 * @revision    $Id: ZoomAllLayers.widget.php,v 1.3 2004/05/23 23:29:06 pspencer Exp $
 * @purpose     Zoom All Layers Widget class
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../NavTool.php");

/**
 * ZoomAllLayers
 *
 * @desc ZoomAllLayers widget.
 */
class ZoomAllLayers extends NavTool
{
   /**
     * ZoomAllLayers
     *
     * Constructor. Set the default values.
     */
    function ZoomAllLayers()
    {
        // invoke constructor of parent
        parent::NavTool();

        $this->NavTool();
        $this->SetNavCommand("ZOOM_FULL");
        $this->mbSubmitOnClick = 1;

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ZoomAllLayers widget is a navigation tool that allows the user to zoom to
the full extents of the original context.
EOT;


    }
    
    function InitDefaults()
    {
        $this->maParams["TOOLSET"] = "";
        parent::InitDefaults();
    }

    /**
     * ParseURL
     *
     * Look for the ZOOM_IN command and if founddo the zooming
     * according to the other NAV paramaters.
     */
    function  ParseURL()
    {
        parent::ParseURL();
        
        $oMap = $this->moMapObject->oMap;

        $szOriginalExtents = trim($oMap->getMetaData( "original_extents" ));
        if ($szOriginalExtents == "")
        {
            $szOriginalExtents = $oMap->extent->minx;
            $szOriginalExtents .= ",".$oMap->extent->miny;
            $szOriginalExtents .= ",".$oMap->extent->maxx;
            $szOriginalExtents .= ",".$oMap->extent->maxy;
            $oMap->setMetaData( "original_extents", $szOriginalExtents );
        }

        $szOriginalProjection = trim( $oMap->getMetaData( "original_projection" ));
        if ($szOriginalProjection == "" && $oMap->getprojection() != "")
        {
            $oMap->setMetaData( "original_projection", $oMap->getprojection() );
        }

        $szCmd = "";
        if ($this->isVarSet( "NAV_CMD" ))
          $szCmd = trim($this->getVar( "NAV_CMD" ));

        if ($szCmd == "ZOOM_FULL")
        {
            // reproject full_extents metadata if different from projection

            if (strlen($szOriginalExtents) > 0)
            {
                $aszExtents = explode(",", $szOriginalExtents);
                if (count($aszExtents) == 4)
                {
                    if ($szOriginalProjection != "" && $szOriginalProjection != $oMap->getprojection())
                    {
                        $aszExtents = $this->moMapNavigator->reprojectExtentFromCenter($aszExtents, $oMap->width, $oMap->height, $szOriginalProjection,$oMap->getProjection());
                    }
                    $oMap->setMetadata("full_extents", $aszExtents[0].",".$aszExtents[1].",".$aszExtents[2].",".$aszExtents[3]);

/* -------------------------------------------------------------------- */
/*      Call the reporjectauto function in case the map projection      */
/*      is set to AUTO:XXX. If it is not, the function will do          */
/*      nothing.                                                        */
/* -------------------------------------------------------------------- */
                    $this->ReprojectAuto();
                }
                else
                {
                    $_SESSION['gErrorManager']->setError(ERR_WARNING,
                         trim($this->moMLT->get("5", "ERROR: Invalid extent specified in"))." ZoomAllLayers.widget.php on line".__LINE__.".");

                }
            }
            else
            {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                    trim($this->moMLT->get("5", "ERROR: Invalid extent specified in"))." ZoomAllLayers.widget.php on line".__LINE__.".");
            }

            $szExtents="";
            $szExtents = $oMap->getMetaData("full_extents");

            if (strlen($szExtents) > 0)
            {
                $aExtents = explode(",", $szExtents);
                if (count($aExtents) == 4)
                {
                    $oMap->setextent($aExtents[0], $aExtents[1],
                                     $aExtents[2], $aExtents[3]);
                }
                else
                {
                    $_SESSION['gErrorManager']->setError(ERR_WARNING,
                            trim($this->moMLT->get("5", "ERROR: Invalid extent specified in"))." ZoomAllLayers.widget.php on line".__LINE__.".");
                }
            }
            else
            {
                    $_SESSION['gErrorManager']->setError(ERR_WARNING,
                        trim($this->moMLT->get("5", "ERROR: Invalid extent specified in"))." ZoomAllLayers.widget.php on line".__LINE__.".");
            }
        }
        
        // return success
        return true;
    }
}
?>
