<?php
/**
 * Z39Query Helper script
 *
 * @project     Chameleon
 * @revision    $Id: Z39Query.php,v 1.2 2004/04/25 04:20:51 pspencer Exp $
 * @purpose     Help build and execute Z39 Queries
 * @author      Jason Fournier (dev@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * set the flag to setup the mapsession
 */
//if ( !defined("LOAD_MAPSESSION") )
//    define("LOAD_MAPSESSION", 1);

/**
 * include the session handling file
 */
include_once("./session.inc.php");
include_once("../CWC2ButtonCache.php");

/**
 * get the form vars
 */
$_FORM = array_merge( $_GET, $_POST );
$szMapFile = "D:/ms4w/apps/scihi/map/testbed11.map";

/**
 * Check for submit
 * Process as required
 */
if( isset($_FORM['formSubmit']) && ($_FORM['formSubmit'] == 1) )
{
    // Construct the URL
    
    // these two vars should have come from the widget declaration
    $szSearchURL = $_POST['SearchServer'];
    //$szSearchURL .= '&responsestylesheet='.$_FORM['responsestylesheet'];
    
    // Comma Delimited Collection
    $szSearchURL .= '&collection='.urlencode($_FORM['collection']);
    
    // Comma Delimited Search String
    $szSearchURL .= '&searchstring='.$_FORM['searchstring'];
    $szSearchURL .= "&searchtype=".$_FORM['searchtype'];
    
    // Dates
    $szSearchURL .= "&begdate=".$_FORM['begdate'];
    $szSearchURL .= "&enddate=".$_FORM['enddate'];
    
    // BBOX - checked for consistency onSubmit through javascript
    $szSearchURL .= "&north=".$_FORM['north'];
    $szSearchURL .= "&east=".$_FORM['east'];
    $szSearchURL .= "&south=".$_FORM['south'];
    $szSearchURL .= "&west=".$_FORM['west'];
    
    // Integer delimiters
    $szSearchURL .= "&searchoffset=".$_FORM['searchoffset'];
    $szSearchURL .= "&searchdisplaycount=".$_FORM['searchdisplaycount'];
    $szSearchURL .= "&outputmethod=GML";
    $szSearchURL .= "&displaytype=BRIEF";
    
    //echo "Searching server with URL: $szSearchURL <BR>";
    $time_start = getmicrotime();
    if( !$szResponse = trim( @file_get_contents( $szSearchURL ) ) )
        echo $szErrMsg = "<b><font color=maroon>Could not contact Server</b></font><br>";
        
    $time_end = getmicrotime();
    $time = $time_end - $time_start;

    // We got something back from the file_get_contents
    if ($szResponse != '')
    {
        // At least one record returned?
        if( stristr($szResponse, 'envirodatMetadataMember') )
        {
            //$szFilePath = getSessionSavePath() . $_FORM['GMLName'];
            $szFilePath = 'D:/ms4w/apps/scihi/data/GML/sampleGML.gml';
            $hOutFile = @fopen( $szFilePath, "w+" );
            if ($hOutFile)
            {
                // Successfully opened the GML document for writing
                // Write the contents to the doc
                fwrite( $hOutFile, $szResponse );
                fclose( $hOutFile );
                $bUpdateMap = 1;
            }
            else
            {
                // Error opening the static GML document for writing
                echo $szErrMsg = "<b><font color=maroon>There was a problem opening the GML document in write mode</b></font><br>";
                $bUpdateMap = 0;
            }
        }
        else
        {
            // Zero records returned from the query
            echo $szErrMsg = "<b><font color=maroon>No Records found in resulting dataset</b></font><br>";
            $bUpdateMap = 0;
        }
    }
    else
    {
        // Error getting the GML from the server
        echo $szErrMsg = "<b><font color=maroon>There was a problem obtaining the GML from the server</b></font><br>";
        $bUpdateMap = 0;
    }
    
    // Assuming there was no problem obtaining the GML let's 
    // write the results to a SharedResource
    
    
    
    
    echo "<br><br>Query for ".$_FORM['searchdisplaycount']." stations took ". round($time, 3) ." seconds<br><br>";
    
    if( $bUpdateMap == 1 )
    {
    
        // Set the file path in the mapfile
        // if (!extension_loaded('MapScript'))
        //     dl( "php_mapscript_40.dll" );
        //$oMap = ms_newMapObj( $szMapFile );
        //$oLayer = $oMap->GetLayerByName( 'envirodatGML' );
        //$oLayer->set( "CONNECTION", $szFilePath );

        // Call the opener function as defined in the widget
        echo "<script>\n";
        echo "opener.location.reload();";
        //
        //echo window.opener.applyZ39BoundingBox($_FORM['west'], $_FORM['south'], $_FORM['east'], $_FORM['north']);
        //
        echo "self.focus();";
        echo "</script>\n";
        
    }
    
}
else // this else populates the bbox
{
    // take coords from FORM is available
    if (isset( $_FORM['north'] ) )
    {
        $nMinX = $_FORM['west'];
        $nMinY = $_FORM['south']; 
        $nMaxX = $_FORM['east']; 
        $nMaxY = $_FORM['north']; 

        $bSetDD = false;
    }

    // Check for the ROIManager inputs and set coords appropriately
    else if ( isset( $_SESSION['ROIRENDERER'] ) && 
              is_array( $_SESSION['ROIRENDERER'] ) &&
              isset( $_SESSION['ROIRENDERER'][0]["aGeoCoords"] ) &&
              is_array( $_SESSION['ROIRENDERER'][0]["aGeoCoords"] )
            )
    {
        // set extents form ROIManager
        // hardcoded for one AOI box only
        $nMinX = $_SESSION['ROIRENDERER'][0]["aGeoCoords"][0];
        $nMinY = $_SESSION['ROIRENDERER'][0]["aGeoCoords"][1];
        $nMaxX = $_SESSION['ROIRENDERER'][0]["aGeoCoords"][2];
        $nMaxY = $_SESSION['ROIRENDERER'][0]["aGeoCoords"][3];
        
        $bSetDD = true;
    }
    elseif( isset( $oMapSession->oMap->extent->minx  ) )
    {
        // default to current extents
        $nMinX = round( $oMapSession->oMap->extent->minx, 4 );
        $nMinY = round( $oMapSession->oMap->extent->miny, 4 );
        $nMaxX = round( $oMapSession->oMap->extent->maxx, 4 );
        $nMaxY = round( $oMapSession->oMap->extent->maxy, 4 );

        $bSetDD = true;
    }
    else
    {
        // default to arbitrary extents
        $nMinX = 0; 
        $nMinY = 0; 
        $nMaxX = 0; 
        $nMaxY = 0; 

        $bSetDD = false;
    }
    
    if( $bSetDD )
    {
    
        // What's the projection?  If it's not 4326 then we convert to DD
        if (!extension_loaded( 'MapScript' ))
            dl( "php_mapscript_40.dll" );
        $oNewMap = ms_newMapObj($szMapFile);
        $szCurrProj = $oNewMap->getProjection();
        if( !stristr( strtolower($szCurrProj), 'init=epsg:4326' ) )
        {
            $oProjIn = ms_newprojectionobj( $szCurrProj );
            $oProjOut = ms_newprojectionobj( "init=epsg:4326" );
            $oRect = ms_newRectObj();
            $oRect->setextent( $nMinX, $nMinY, $nMaxX, $nMaxY );
            $oRect->project( $oProjIn, $oProjOut );

            $nMinX = round( $oRect->minx, 4 );
            $nMinY = round( $oRect->miny, 4 );
            $nMaxX = round( $oRect->maxx, 4 );
            $nMaxY = round( $oRect->maxy, 4 );
        }
    }

}




/**
 * Helper functions
 */
function getmicrotime()
{ 
    list($usec, $sec) = explode(" ",microtime()); 
    return ((float)$usec + (float)$sec); 
} 


?>