<?php
/**
 * XMLRPC Widget class
 *
 * @project     CWC2
 * @revision    $Id: 
 * @purpose     XMLRPC Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
//added this primarily for the documentation generator.
if (!defined("CHAMELEON_FS_CORE"))
{
    define( "CHAMELEON_FS_CORE", realpath(str_replace("\\","/",dirname(__FILE__))."/..") );
}
include_once (CHAMELEON_FS_CORE."/widgets/SharedResource.widget.php");
include_once (CHAMELEON_FS_CORE."/widgets/Widget.php");
include_once ("IXR_Library.inc.php");

/**
 * XMLRPCWidget
 *
 * @desc Widget that build a XMLRPC call.
 */
class XMLRPC extends CWCWidget
{
    var $mszURI    = "";
    var $mszHost   = "";
    var $mszMethod = "";

    var $mszParams = "";
    var $mszSeparator = "|";
    var $mszStructSeparator = "__STRUCT_SEPARATOR__";

    var $mnPort    = 80;

    var $mszResult = "XMLRPCResult";
    var $mbCacheResult = false;

    /**
     * XMLRPCWidget
     *
     * Constructor method for the XMLRPC widget.
     */
    function XMLRPC()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
XMLRPC is a simple widget that simply returns the value from a URL variable.
EOT;
        if ($this->mszURI == "") $this->maAttributes["URI"] = new StringAttribute( "URI", true );
        if ($this->mszHost == "") $this->maAttributes["HOST"] = new StringAttribute( "HOST", true );
        if ($this->mszMethod == "") $this->maAttributes["METHOD"] = new StringAttribute( "METHOD", true );

        $this->maAttributes["PORT"] = new IntegerAttribute( "PORT", false );
        $this->maAttributes["PARAMS"] = new StringAttribute( "PARAMS", false );
        $this->maAttributes["SEPARATOR"] = new StringAttribute( "SEPARATOR", false );
        $this->maAttributes["RESULT"] = new StringAttribute( "RESULT", false );
        $this->maAttributes["CACHERESULT"] = new BooleanAttribute( "CACHERESULT", false );

        $this->mnPriority = PRIORITY_SUPER;
    }

    /**
     * InitDefault
     */
    function InitDefaults()
    {
        parent::InitDefaults();

        if ($this->mszURI    == "") $this->mszURI = $this->maParams["URI"];
        if ($this->mszHost   == "") $this->mszHost = $this->maParams["HOST"];
        if ($this->mszMethod == "") $this->mszMethod = $this->maParams["METHOD"];

        if (substr($this->mszHost, -1) == "/")
            $this->mszHost = substr($this->mszHost, 0, -1);

        if (substr($this->mszURI, 0, 1) != "/")
            $this->mszURI = "/".$this->mszURI;

        if (isset($this->maParams["PORT"]))
            $this->mnPort = $this->maParams["PORT"];

        if (isset($this->maParams["PARAMS"]))
            $this->mszParams = $this->maParams["PARAMS"];

        if (isset($this->maParams["SEPARATOR"]))
            $this->mszSeparator = $this->maParams["SEPARATOR"];
    
        if (isset($this->maParams["STRUCTSEPARATOR"]))
            $this->mszStructSeparator = $this->maParams["STRUCTSEPARATOR"]; 

        if (isset($this->maParams["RESULT"]))
            $this->mszResult = $this->maParams["RESULT"];

        if (isset($this->maParams["CACHERESULT"]))
        {
            $this->mbCacheResult = $this->maParams["CACHERESULT"];

        if (strcasecmp($this->mbCacheResult, "true") == 0)
            $this->mbCacheResult = true;
            else
            $this->mbCacheResult = false;
        }
    }



    /**
     * Parse URL
     */
    function ParseURL()
    {
        $szKey = md5($this->mszMethod.$this->mszParams.$this->mszHost.$this->mszURI.$this->mnPort);

        if ($this->mbCacheResult)
        {
            if (isset($_SESSION["XMLRPCWidgetCachedResult"][$szKey]))
            {
                $result = $_SESSION["XMLRPCWidgetCachedResult"][$szKey];

                // Put result in shared resource.
                $this->maSharedResourceWidgets[$this->mszResult] =& $result;
                return parent::ParseURL();
            }
        }

        $aParams = $this->ProcessParams();

        $result = $this->CallServer($aParams);

        if (is_array($result))
        {
            // Cache result if set.
            if ($this->mbCacheResult)
            {
                $_SESSION["XMLRPCWidgetCachedResult"][$szKey] = $result;
            }
            // Put result in shared resource.
            $this->maSharedResourceWidgets[$this->mszResult] =& $result;
        }
        else
        {
            return false;
    }
        return parent::ParseURL();
     }
    
    function CallServer($aParams)
    {
        $client = new IXR_Client($this->mszHost.$this->mszURI);
        $res = call_user_func_array(array(&$client, "query"), array_merge(array($this->mszMethod), $aParams));

        return $client->getResponse();
    }
    
    function ProcessParams()
    {
        $aParams = array();

        // Parse Parameters
            $aszParams = explode($this->mszStructSeparator, $this->mszParams);    

        $nbParam = count($aszParams);

        for($i=0;$i<$nbParam;$i++)
        {
            $aszParams2 = explode($this->mszSeparator, $aszParams[$i]);

            $nbParam2 = count($aszParams2)+1;

            $aTmp = array();
            for ($j=0;$j<=$nbParam2;$j=$j+2)
            {
                if (isset($aszParams2[$j]) && isset($aszParams2[$j+1]))
                {
                    $aTmp[$aszParams2[$j]] = $aszParams2[$j+1];
                }
            }

                if ($nbParam == 1)
                {
                    $aParams = array_merge($aParams, $aTmp);
                }
                else
                {
                    $aParams = array_merge($aParams, array($aTmp));
                }
        }

        return $aParams;
    }
}
?>
