<?php
/**
 * VarURL Widget class
 *
 * @project     CWC2
 * @revision    $Id: 
 * @purpose     VarURL Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");

/**
 * VarURLWidget
 *
 * @desc Widget That return the value of a URL variable
 */
class VarURL extends CWCWidget
{
    var $mbKeepState = false;

    /**
     * VarURLWidget
     *
     * Constructor method for the VarURL widget.
     */
    function VarURL()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
VarURLWidget is a simple widget that simply return the value from a URL variable.
EOT;
        $this->maAttributes["URLVAR"] = 
                 new StringAttribute( "URLVAR", true );

        $this->maAttributes["PREFIX"] = 
                 new StringAttribute( "PREFIX", false );

        $this->maAttributes["SUFIX"] = 
                 new StringAttribute( "SUFIX", false );

        $this->maAttributes["KEEPSTATE"] = 
                 new BooleanAttribute( "KEEPSTATE", false );
    }

    /**
     * initialize respectable defaults
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        $this->mbKeepState = false;
        $szKeepState = "false";
        if (isset($this->maParams["KEEPSTATE"]))
            $szKeepState = $this->maParams["KEEPSTATE"];
        if (strcasecmp( $szKeepState , "true" ) == 0)
        {
            $this->mbKeepState = true;
        }
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        $szReturn = "";

        if($this->isVarSet( strtoupper($this->maParams["URLVAR"]) ) && 
           $this->getVar( strtoupper($this->maParams["URLVAR"]) ) != "")
        {
            if(isset($this->maParams["PREFIX"]))
                $szReturn .= urldecode($this->maParams["PREFIX"]);

            $szReturn .= stripslashes(urldecode($this->getVar( strtoupper($this->maParams["URLVAR"]) )));

            if(isset($this->maParams["SUFIX"]))
                $szReturn .= urldecode($this->maParams["SUFIX"]);
        }

        return $szReturn;
    }

    /**
     * GetHTMLHiddenVariables
     *
     * Returnrs an empty  string. Should be redefined for Widgets 
     * returning hidden variables
     */
    function GetHTMLHiddenVariables()
    {
        if ($this->mbKeepState)
        {
            $szVariable = strtoupper($this->maParams["URLVAR"]);
            if($this->isVarSet( $this->maParams["URLVAR"] ))
                $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".
                    $this->getVar( $this->maParams["URLVAR"] )."\">";
            else
                $szValue = "";

            return array($szVariable => $szValue);
        }

        return array();
    }
}
?>
