<?php
/**
 * VarSharedResource Widget class
 *
 * @project     CWC2
 * @revision    $Id: 
 * @purpose     VarSharedResource Widget class
 * @author      DM Solutions Group (lacroix@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once("SharedResource.widget.php");

/**
 * VarURLWidget
 *
 * @desc Widget That return the value of a URL variable
 */
class VarSharedResource extends CWCWidget
{
    var $mszVar = "";

    /**
     * VarSharedResourceWidget
     *
     * Constructor method for the VarSharedResource widget.
     */
    function VarSharedResource()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
VarSharedResourceWidget is a simple widget that simply return the value from a SharedResource variable.
EOT;
        $this->maAttributes["SRVAR"] = 
                 new StringAttribute( "SRVAR", true );

        $this->maAttributes["PREFIX"] = 
                 new StringAttribute( "PREFIX", false );

        $this->maAttributes["SUFIX"] = 
                 new StringAttribute( "SUFIX", false );
    }

    function InitDefaults()
    {
        parent::InitDefaults();

        if (isset($this->maParams["SRVAR"]))
            $this->mszVar = $this->maParams["SRVAR"];
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        $szReturn = "";
        $aszSRParams = explode(".", $this->mszVar);
        $numParams = count($aszSRParams);
        $oSR =& $this->maSharedResourceWidgets;
        for($i=0; $i<$numParams; $i++)
        {
            if(isset($oSR[$aszSRParams[$i]]) && $i < $numParams)
            {
                $oSR =& $oSR[$aszSRParams[$i]];
            }
            else
            {
                break;
            }
        }

        $szReturn = "";
        if($i == $numParams && $oSR != "")
        {
            if(isset($this->maParams["PREFIX"]))
                $szReturn .= $this->maParams["PREFIX"];

            $szReturn .= $oSR;

            if(isset($this->maParams["SUFIX"]))
                $szReturn .= $this->maParams["SUFIX"];
        }
        
        return $szReturn;
    }
}
?>
