<?php
/**
 * TimeFilter Widget Class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     Display a time range selector for layers
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");

/**
 * TimeFilter
 *
 * @desc A widget that displays a time range combobox to
 * display specific layers
 */
class TimeFilter extends CWCWidget
{
    var $mszInputClass = "CWCTimeFilterInputClass";
    var $mszLabelClass = "CWCTimeFilterLabelClass";
    var $mszInputStyle = "";
    var $mszLabelStyle = "";

    /**
     * build a new widget
     */
    function TimeFilter()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/TimeFilter.dbf";

        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The TimeFilter widget allows the user to create a filter on the layers in
the current context using a time value or range in accordance with the WMS
specification.
EOT;

        $this->mnPriority = PRIORITY_SUPER;
        $this->maAttributes["INPUTCLASS"] = new StringAttribute( "INPUTCLASS", false );
        $this->maAttributes["INPUTSTYLE"] = new StringAttribute( "INPUTSTYLE", false );
        $this->maAttributes["LABELCLASS"] = new StringAttribute( "LABELCLASS", false );
        $this->maAttributes["LABELSTYLE"] = new StringAttribute( "LABELSTYLE", false );
        $this->maAttributes["EARLIESTYEAR"] = new StringAttribute( "EARLIESTYEAR", false );
        $this->maAttributes["SHOWTIME"] = new BooleanAttribute( "SHOWTIME", false );
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["INPUTCLASS"]))
            $this->mszInputClass = strtoupper($this->maParams["INPUTCLASS"]);
        if (isset($this->maParams["INPUTSTYLE"]))
            $this->mszInputStyle = strtoupper($this->maParams["INPUTSTYLE"]);
        if (isset($this->maParams["LABELCLASS"]))
            $this->mszLabelClass = strtoupper($this->maParams["LABELCLASS"]);
        if (isset($this->maParams["LABELSTYLE"]))
            $this->mszLabelStyle = strtoupper($this->maParams["LABELSTYLE"]);
    }

    function GetJavascriptOnLoadFunctions()
    {
        $bShowTime = $this->getValue("SHOWTIME", "FALSE");
        $aReturn = array();

        if (stristr($bShowTime, "TRUE") !== false)
        {
            $szJsFunctionName = "onloadTimeFilter";
            $szFunction = "$szJsFunctionName();\n";
            $aReturn[$szJsFunctionName] = $szFunction;
        }

        return $aReturn;
    }

    /**
     * get the javascript functions for this widget
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        $szJsFunctionName = "onloadTimeFilter";
        $bSetStartTimezone = (($this->isVarSet( 'start_tz' )) ? "0" : "1");
        $szFunction = <<<EOT
/**
 * Called when page is loaded
 */
function {$szJsFunctionName}()
{
    var curDate = new Date();
    var timezone = curDate.getTimezoneOffset() / 60;
    var start_tz = {$this->mszHTMLForm}.start_tz.options[{$this->mszHTMLForm}.start_tz.selectedIndex].value;
    var end_tz = {$this->mszHTMLForm}.end_tz.options[{$this->mszHTMLForm}.end_tz.selectedIndex].value;
    var setStartTimezone = {$bSetStartTimezone};

    if (setStartTimezone == 1)
        {$this->mszHTMLForm}.start_tz.value = timezone;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "monthClicked";
        $szFunction = <<<EOT
/**
 * Called when month combo is clicked
 */
function {$szJsFunctionName}()
{
    var MINUTE = 60 * 1000;
    var HOUR = MINUTE * 60;
    var DAY = HOUR * 24;
    var WEEK = DAY * 7;

    var start_year = {$this->mszHTMLForm}.start_year.options[{$this->mszHTMLForm}.start_year.selectedIndex].value;
    var end_year = {$this->mszHTMLForm}.end_year.options[{$this->mszHTMLForm}.end_year.selectedIndex].value;
    var start_month = {$this->mszHTMLForm}.start_month.options[{$this->mszHTMLForm}.start_month.selectedIndex].value;
    var end_month = {$this->mszHTMLForm}.end_month.options[{$this->mszHTMLForm}.end_month.selectedIndex].value;

    if (start_month == 12)
    {
        start_month = 1;
        start_year ++;
    }
    else
        start_month ++;

    if (end_month == 12)
    {
        end_month = 1;
        end_year ++;
    }
    else
        end_month ++;

    var startDate = new Date(start_year, start_month-1, 1);
    var startNbDay = startDate.getTime() - DAY;
    startDate = new Date(startNbDay);

    var endDate = new Date(end_year, end_month-1, 1);
    var endNbDay = endDate.getTime() - DAY;
    endDate = new Date(endNbDay);

    var nSelectedStartDay = {$this->mszHTMLForm}.start_day.selectedIndex;
    var nSelectedEndDay = {$this->mszHTMLForm}.end_day.selectedIndex;

    //clear day combo
    var nbEndDay = {$this->mszHTMLForm}.end_day.length;
    var nbStartDay = {$this->mszHTMLForm}.start_day.length;
    for (i=0;i<nbEndDay;i++)
    {
      {$this->mszHTMLForm}.end_day.options[0] = null;
    }
    for (i=0;i<nbStartDay;i++)
    {
      {$this->mszHTMLForm}.start_day.options[0] = null;
    }


    // add day
    nbEndDay = endDate.getDate();
    length = {$this->mszHTMLForm}.end_day.length;
    optionName = new Option("SAME", -1, false, false);
    {$this->mszHTMLForm}.end_day.options[length] = optionName;
    for (i=0;i<nbEndDay;i++)
    {
        if (nSelectedEndDay == i+1)
          optionName = new Option(i+1, i+1, true, true);
        else
          optionName = new Option(i+1, i+1, false, false);

        length = {$this->mszHTMLForm}.end_day.length;
        {$this->mszHTMLForm}.end_day.options[length] = optionName;
    }

    nbStartDay = startDate.getDate();
    for (i=0;i<nbStartDay;i++)
    {
        if (nSelectedStartDay == i)
          optionName = new Option(i+1, i+1, true, true);
        else
          optionName = new Option(i+1, i+1, false, false);

        length = {$this->mszHTMLForm}.start_day.length;
        {$this->mszHTMLForm}.start_day.options[length] = optionName;
    }
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;
        return $aReturn;
    }

    /**
     * process the url looking for quickzoom requests
     */
    function  ParseURL()
    {
        parent::ParseURL();

        if ($this->isVarSet( 'bEnableTimeQuery' ) &&
            $this->getVar( 'bEnableTimeQuery' ) == "on")
        {
            $nStartYear  = (($this->isVarSet( 'start_year' )) ?
                            $this->getVar( 'start_year' ) : "" );
            $nStartMonth = (($this->isVarSet( 'start_month' )) ?
                            $this->getVar( 'start_month' ) : "" );
            $nStartDay   = (($this->isVarSet( 'start_day' )) ?
                            $this->getVar( 'start_day' ) : "" );
            $nStartHour  = (($this->isVarSet( 'start_hour' )) ?
                            $this->getVar( 'start_hour' ) : "" );
            $nStartMinute= (($this->isVarSet( 'start_minute' )) ?
                            $this->getVar( 'start_minute' ) : "" );
            $nStartTz    = (($this->isVarSet( 'start_tz' )) ?
                            $this->getVar( 'start_tz' ) : "" );

            $nEndYear  = (($this->isVarSet( 'end_year' )) ?
                          (($this->getVar( 'end_year' ) == -1) ?
                           $this->getVar( 'start_year' ) :
                           $this->getVar( 'end_year' )) : "");
            $nEndMonth = (($this->isVarSet( 'end_month' )) ?
                          (($this->getVar( 'end_month' ) == -1) ?
                           $this->getVar( 'start_month' ) :
                           $this->getVar( 'end_month' )) : "");
            $nEndDay   = (($this->isVarSet( 'end_day' )) ?
                          (($this->getVar( 'end_day' ) == -1) ?
                           $this->getVar( 'start_day' ) :
                           $this->getVar( 'end_day' )) : "");
            $nEndHour  = (($this->isVarSet( 'end_hour' )) ?
                          (($this->getVar( 'end_hour' ) == -1) ?
                           $this->getVar( 'start_hour' ) :
                           $this->getVar( 'end_hour' )) : "");
            $nEndMinute= (($this->isVarSet( 'end_minute' )) ?
                          (($this->getVar( 'end_minute' ) == -1) ?
                           $this->getVar( 'start_minute' ) :
                           $this->getVar( 'end_minute' )) : "");
            $nEndTz    = (($this->isVarSet( 'end_tz' )) ?
                          (($this->getVar( 'end_tz' ) == -13) ?
                           $this->getVar( 'start_tz' ) :
                           $this->getVar( 'end_tz' )) : "");

            $bShowTime = $this->getValue("SHOWTIME", "FALSE");

            if (stristr($bShowTime, "TRUE")!==false)
            {
                $nStartTime = mktime(($nStartHour+$nStartTz), $nStartMinute,0,
                                     $nStartMonth , $nStartDay, $nStartYear);

                $nEndTime = mktime(($nEndHour+$nEndTz), $nEndMinute, 0,
                                   $nEndMonth , $nEndDay, $nEndYear);

                $szStartTime = date("Y-m-j", $nStartTime)."T".
                  date("H:i", $nStartTime).":0.0Z";
                $szEndTime = date("Y-m-j", $nEndTime)."T".
                  date("H:i", $nEndTime).":0.0Z";
            }
            else
            {
                $szStartTime = $nStartYear."-".$nStartMonth."-".$nStartDay;
                $szEndTime = $nEndYear."-".$nEndMonth."-".$nEndDay;
            }

            $szValue = $szStartTime."/".$szEndTime;
        }
        else
            $szValue = "";


        if ($szValue != "")
        {
            $nLayers = $this->moMapObject->oMap->numlayers;

            for ($i=0;$i<$nLayers;$i++)
            {
                $oLayer = $this->moMapObject->oMap->getLayer($i);
                if ($oLayer->connectiontype == MS_WMS)
                {
                    $oLayer->setMetadata("wms_time", $szValue);
                }
            }
        }
    }

    /**
     * draw this widget
     */
    function DrawPublish()
    {
        $nEarliestYear = $this->getValue("EarliestYear", "1940");


        $nStartYear  = (($this->isVarSet( 'start_year' )) ?
                       $this->getVar( 'start_year' ) : "" );
        $nStartMonth = (($this->isVarSet( 'start_month' )) ?
                       $this->getVar( 'start_month' ) : "" );
        $nStartDay   = (($this->isVarSet( 'start_day' )) ?
                       $this->getVar( 'start_day' ) : "" );
        $nStartHour  = (($this->isVarSet( 'start_hour' )) ?
                       $this->getVar( 'start_hour' ) : "" );
        $nStartMinute= (($this->isVarSet( 'start_minute' )) ?
                       $this->getVar( 'start_minute' ) : "" );
        $nStartTz    = (($this->isVarSet( 'start_tz' )) ?
                       $this->getVar( 'start_tz' ) : "" );

        $nEndYear  = (($this->isVarSet( 'end_year' )) ?
                       $this->getVar( 'end_year' ) : "" );
        $nEndMonth = (($this->isVarSet( 'end_month' )) ?
                       $this->getVar( 'end_month' ) : "" );
        $nEndDay   = (($this->isVarSet( 'end_day' )) ?
                       $this->getVar( 'end_day' ) : "" );
        $nEndHour  = (($this->isVarSet( 'end_hour' )) ?
                       $this->getVar( 'end_hour' ) : "-1" );
        $nEndMinute= (($this->isVarSet( 'end_minute' )) ?
                       $this->getVar( 'end_minute' ) : "-1" );
        $nEndTz    = (($this->isVarSet( 'end_tz' )) ?
                       $this->getVar( 'end_tz' ) : "-13" );

        $nCurrentYear = date("Y");

        $bShowTime = $this->getValue("SHOWTIME", "FALSE");

        if (!$this->mbVisible)
            return "<!-- QuickView is hidden -->";

        if ($this->isVarSet( "START_TIME" ) &&
            $this->isVarSet( "END_TIME" ))
        {
            $szStartTime = $this->getVar( "START_TIME" );
            $szEndTime = $this->getVar( "END_TIME" );
        }
        else
        {
            $szStartTime = "";
            $szEndTime = "";
        }

        //szInputClass and szInputStyle cause problems in NS4
        $szInputClass = "";
        //if ( strlen($this->mszInputClass) > 0 )
        //    $szInputClass = " CLASS=\"$this->mszInputClass\"";
        $szInputStyle = "";
        //if ( strlen($this->mszInputStyle) > 0 )
        //    $szInputStyle = " STYLE=\"$this->mszInputStyle\"";
        $szLabelClass = "";
        if ( strlen($this->mszLabelClass) > 0 )
            $szLabelClass = " CLASS=\"$this->mszLabelClass\"";
        $szLabelStyle = "";
        if ( strlen($this->mszLabelStyle) > 0 )
            $szLabelStyle = " STYLE=\"$this->mszLabelStyle\"";


        $szResult  = "<!-- Star of TimeRangeWidget -->\n";
        $szResult .= "<TABLE>\n";
        $szResult .= "  <TR>\n";
        $szResult .= "    <TD></TD>\n";
        $szResult .= "    <TD><p$szLabelClass$szLabelStyle>".trim($this->moMLT->get("0","Year"))."</p></TD>\n";
        $szResult .= "    <TD><p$szLabelClass$szLabelStyle>".trim($this->moMLT->get("1","Month"))."</p></TD>\n";
        $szResult .= "    <TD><p$szLabelClass$szLabelStyle>".trim($this->moMLT->get("2","Day"))."</p></TD>\n";

        if (stristr($bShowTime, "TRUE")!==false)
        {
            $szResult .= "    <TD><p$szLabelClass$szLabelStyle>".trim($this->moMLT->get("3","Hour"))."</p></TD>\n";
            $szResult .= "    <TD><p$szLabelClass$szLabelStyle>".trim($this->moMLT->get("4","Minute"))."</p></TD>\n";
            $szResult .= "    <TD><p$szLabelClass$szLabelStyle>".trim($this->moMLT->get("5","Time Zone"))."</p></TD>\n";
        }

        $szResult .= "  </TR>\n";
        $szResult .= "  <TR>\n";
        $szResult .= "    <TD><p$szLabelClass$szLabelStyle>".trim($this->moMLT->get("6","From:"))."</p></TD>\n";

        $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='start_year' onChange='monthClicked()'>";
        for ($i=$nEarliestYear;  $i<$nCurrentYear; $i++)
        {
          if ($nStartYear == $i)
            $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>\n";
          else
            $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>\n";
        }
        $szResult .= "        </SELECT></TD>\n";

        $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='start_month' onChange='monthClicked()'>";
        for ($i=1; $i<=12; $i++)
        {
          if ($nStartMonth == $i)
            $szResult .= "<OPTION VALUE=\"$i\" selected>".date("F", mktime (0,0,0,$i,1,1997))."</OPTION>\n";
          else
            $szResult .= "<OPTION VALUE=\"$i\">".date("F", mktime (0,0,0,$i,1,1997))."</OPTION>\n";
        }
        $szResult .= "        </SELECT></TD>\n"
;
        $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='start_day'>\n";
        for ($i=1;$i<=31;$i++)
        {
          if ($nStartDay == $i)
            $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>\n";
          else
            $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>\n";
        }
        $szResult .= "        </SELECT></TD>\n";

        if (stristr($bShowTime, "TRUE")!==false)
        {
          $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='start_hour'>\n";
          for ($i=0;$i<=23;$i++)
          {
            if ($nStartHour == $i)
              $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>\n";
            else
              $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>\n";
          }
          $szResult .=     "    </SELECT></TD>\n";
          $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='start_minute'>\n";
          for ($i=0;$i<=59;$i++)
          {
            if ($nStartMinute == $i)
              $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>\n";
            else
              $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>\n";
          }
          $szResult .= "</SELECT></TD>\n";
          $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='start_tz'>\n";
          for($i=-12;$i<=12;$i++)
          {
            if ($nStartTz == $i)
              $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>";
            else
              $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>";
          }
          $szResult .= "        </SELECT></TD>\n";
        }
        $szResult .= "  </TR>\n";

        $szResult .= "  <TR>\n";
        $szResult .= "    <TD><p class=\"CWCTimeFilterLabelClass\">".trim($this->moMLT->get("7","To:"))."</p></TD>\n";
        $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='end_year' onChange='monthClicked()'>";
        $szResult .= "<OPTION VALUE=-1>SAME</OPTION>\n";
        for ($i=$nEarliestYear; $i<$nCurrentYear; $i++)
        {
          if ($nEndYear == $i)
            $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>\n";
          else
            $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>\n";
        }
        $szResult .= "        </SELECT></TD>\n";

        $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='end_month' onChange='monthClicked()'>";
        $szResult .= "<OPTION VALUE=\"-1\">SAME</OPTION>\n";
        for ($i=1; $i<=12; $i++)
        {
          if ($nEndMonth == $i)
            $szResult .= "<OPTION VALUE=\"$i\" selected>".date("F", mktime (0,0,0,$i,1,1997))."</OPTION>\n";
          else
            $szResult .= "<OPTION VALUE=\"$i\">".date("F", mktime (0,0,0,$i,1,1997))."</OPTION>\n";
        }
        $szResult .= "        </SELECT></TD>\n";
        $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='end_day'>\n";
        $szResult .= "<OPTION VALUE=\"-1\">SAME</OPTION>\n";
        for ($i=1;$i<=31;$i++)
        {
          if ($nEndDay == $i)
            $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>\n";
          else
            $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>\n";
        }
        $szResult .= "        </SELECT></TD>\n";


        if (stristr($bShowTime, "TRUE")!==false)
        {
          $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='end_hour'>\n";
          $szResult .= "<OPTION VALUE=\"-1\">SAME</OPTION>\n";
          for ($i=0;$i<=23;$i++)
          {
            if ($nEndHour == $i)
              $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>\n";
            else
              $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>\n";
          }
          $szResult .=     "    </SELECT></TD>\n";
          $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='end_minute'>\n";
          $szResult .= "<OPTION VALUE=\"-1\">SAME</OPTION>\n";
          for ($i=0;$i<=59;$i++)
          {
            if ($nEndMinute == $i)
              $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>\n";
            else
              $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>\n";
          }
          $szResult .= "</SELECT></TD>\n";
          $szResult .= "    <TD><SELECT$szInputClass$szInputStyle NAME='end_tz'>\n";
          $szResult .= "<OPTION VALUE=\"-13\">SAME</OPTION>\n";
          for($i=-12;$i<=12;$i++)
          {
            if ($nEndTz == $i)
              $szResult .= "<OPTION VALUE=\"$i\" selected>$i</OPTION>";
            else
              $szResult .= "<OPTION VALUE=\"$i\">$i</OPTION>";
          }
          $szResult .= "        </SELECT></TD>\n";
        }
        $szResult .= "  </TR>\n";

        $szResult .= "  <TR>\n";
        $bEnableTimeQuery = (($this->isVarSet( 'bEnableTimeQuery' ) &&
                              $this->getVar( 'bEnableTimeQuery' ) == "on") ?
                             "checked" : "" );

        $szResult .= "    <TD>&nbsp;</TD><TD colspan=6><p$szLabelClass$szLabelStyle><INPUT TYPE='CHECKBOX' $bEnableTimeQuery NAME='bEnableTimeQuery'> Apply time filter</p></TD>\n";

        $szResult .= "</TR></TABLE>\n";

        return $szResult;
    }
}
?>
