<?php
/**
 * Base SharedResource class
 *
 * @project     CWC2
 * @revision    $Id: SharedResource.widget.php,v 1.3 2004/07/08 15:58:59 pspencer Exp $
 * @purpose     Base SharedResourceWidget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");

/**
 *  class  SharedResource
 *
 * @description Base Shared memory widget class
 */
class SharedResource extends CWCWidget
{
    var $mszName = "";
    var $mbEnableJS = false;

    /**
     * ShareResourceWidget
     * 
     * Base CWC Share memory Widget.
     */
    function SharedResource()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
SharedResource is an invisible widget that defines some set of values that
are to be shared among one or more widgets.  This was implemented to share
projection information between the ProjectionSelector and ProjectionLabel
widgets, but could be used for any widgets that might need it.  The format
of subtags is arbitrary and depends on the widgets that are using the
information.
EOT;

        $this->maAttributes["NAME"] = new StringAttribute( "NAME", true );
        $this->maAttributes["ENABLEJS"] = new StringAttribute( "ENABLEJS", false);
    }
    
    /**
     * MakeJSObject
     * utility function to parse object trees
     * and create a javascript object hierarchy to attach to the root object.
     */
    function MakeJSObject($szJSResourceType, $aChildren, $szJSParent)
    {
         $szJSResult = "";

         if (!is_array( $aChildren ))
         {
             return "";
         }
         foreach ($aChildren as $szChild => $aProperties)
         {
            $szJSObjectName = $szJSResourceType. "_"; // . $szChild;
            $szJSResult .= "var " . $szJSObjectName . " = new CWC_JS_SharedResource();\n";
            
            foreach ($aProperties as $key => $val)
            {
                $szJSElement = $key;
                
                if (is_array ($val))
                {
                    foreach ($val as $szChildResource => $aSubChildren)
                    {
                        $szJSResult .= $this->MakeJSObject ($szJSObjectName . "_" /*. $szChildResource*/, $aSubChildren, $szJSObjectName);
                    }
                }
                else
                {
                    $szJSResult .= $szJSObjectName . ".SetProperty(\"" . addslashes(trim($key)) . "\",\"" . addslashes(trim($val)) . "\");\n";
                }
            }
            $szJSResult .= $szJSParent . ".AddChild($szJSObjectName);\n";
            
        }
        return $szJSResult;
    }


    /**
     * InitDefaults
     *
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        $this->mbEnableJS = 0;
        if (isset($this->maParams["ENABLEJS"]))
        {
            $this->mbEnableJS = (strcasecmp($this->maParams["ENABLEJS"], "true") == 0) ? true : false;
        }

        if (isset($this->maParams["NAME"]))
            $this->mszName = $this->maParams["NAME"];

    }

    /**
     * GetJavascriptFunctions
     *
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        
        parent::GetJavascriptFunctions();
        
        //check if there is a resource to build as javascript
        if (!($this->maszContents != "" && $this->mbEnableJS))
        {
            return $aReturn;
        }

        $szJSTree = "var ".$this->mszName." = new CWC_JS_SharedResource();\n";
        foreach ($this->maszContents as $szJSResourceType => $aProperties)
        {
            $szJSTree .= $this->MakeJSObject($szJSResourceType, $aProperties, $this->mszName);
        }
        $szJSTree .= "goJSSR.SetProperty( \"".$this->mszName."\", $this->mszName );\n";
        
        $szJsFunctionName = "JSSharedResourceInit_".$this->mnId;
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to create a client side copy of the shared resource.
 */
function {$szJsFunctionName}()
{    
    //dump javascript that creates js tree for each JSSharedResource.
    {$szJSTree}        
}

{$szJsFunctionName}();
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;        
    
        return $aReturn;
    }

    /**
     * javascript include files
     */
    function GetJavascriptIncludeFunctions()
    {
        $aReturn = array();
        
        $aReturn = parent::GetJavascriptIncludeFunctions();
        if ($this->mbEnableJS)
        {
            $szJsIncludeName = $_SESSION["gszCoreWebPath"]."/widgets/js/cwc_sr.js";
            $szInclude = "<script language=\"JavaScript\" src=\"".$_SESSION["gszCoreWebPath"]."/widgets/js/cwc_sr.js\"></script>";
            $aReturn[$szJsIncludeName] = $szInclude;

        }
        return $aReturn;
    }

    /**
     * GetJavascriptVariables
     *
     * Global var code
     */
    function GetJavascriptVariables()
    {
        $aReturn = array();
        if ($this->mbEnableJS)
        {
            $szVariable = "goJSSR";
            $szValue = " var $szVariable = new CWC_JS_SharedResource();\n";
            $aReturn[$szVariable] = $szValue;

        }
        return $aReturn;
    }

}
?>
