<?php
/**
 * SelectLayers Widget class
 *
 * @project     GeoDan
 * @revision    $Id: SelectLayers.widget.php,v 1.2 2004/04/24 21:59:37 pspencer Exp $
 * @purpose     Select layers so that other widgets can do something to them.
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");

/**
 * SelectLayers
 *
 * @desc SelectLayers widget.
 */
class SelectLayers extends CWCWidget
{
    /**
     * SelectLayers
     *
     * Constructor. Set the default values.
     */
    function SelectLayers()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The purpose of the Select Layers widget is to provide a mechanism via
javascript by which layers can be marked as selected for other widgets. This
could be used for changing layer order, querying or filtering a layer, or
extracting from a specific layer.  The widget is most useful when used with
an appropriate HTML legend and the LegendTemplate widget
EOT;

     }

    /**
     * GetHTMLHiddenVariables
     *
     * return the NAV_CMD varaiable.
     *
     * @return NAV_CMD variable.
     */
    function GetHTMLHiddenVariables()
    {
        $szSelectedLayers = "";
        $szSep = "";
        $oMap = $this->moMapObject->oMap;
        for($i=0; $i<$oMap->numlayers; $i++)
        {
            $oLayer = $oMap->getLayer($i);
            if ($oLayer->getMetaData( "selected" ) == "1")
            {
                $szSelectedLayers .= $szSep.($oLayer->name);
                $szSep = ",";
            }
        }
        //get selected layers here.
        $szVariable = "SELECTED_LAYERS";
        $szValue = " <INPUT TYPE=\"HIDDEN\" NAME=\"$szVariable\" VALUE=\"$szSelectedLayers\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * GetJavascriptFunctions
     *
     * Return the Javacriptfunctions needed by the widget.
     *
     * @return Javacriptfunctions needed by the widget.
     */
    function GetJavascriptFunctions()
    {
        $szJsFunctionName = "CWCSelectLayer";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to set a layer as selected.  If the layer is already selected, then
 * it deselects the layer.  Returns true if the layer was added, false otherwise.
 */
function {$szJsFunctionName}( szLayerName, bSingle )
{
    with({$this->mszHTMLForm})
    {
        var aszLayers;
        if (bSingle)
        {
            aszLayers = new Array();
        }
        else
        {
            aszLayers = SELECTED_LAYERS.value.split( "," );
        }
        var aszNewLayers = new Array();
        var i;
        var bNewLayer = true;
        for (i=0; i < aszLayers.length; i++)
        {
            if (szLayerName == aszLayers[i])
            {
                bNewLayer = false;
            }
            else
            {
                aszNewLayers[aszNewLayers.length] = aszLayers[i];
            }
        }
        if (bNewLayer)
        {
            aszNewLayers[aszNewLayers.length] = szLayerName;
        }
        SELECTED_LAYERS.value = aszNewLayers.toString();
    }
    return bNewLayer;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * ParseURL
     *
     * Look for selected layers and mark them as such.
     */
    function  ParseURL()
    {
        $oMap = $this->moMapObject->oMap;
        if ($this->isVarSet( 'SELECTED_LAYERS' ))
        {
            $aszSelectedLayers = array();
            if (strlen($this->getVar( 'SELECTED_LAYERS' )) > 0)
            {
                $aszSelectedLayers = explode( ",", $this->getVar( 'SELECTED_LAYERS' ) );
            }
            
            for($i=0; $i<$oMap->numlayers; $i++)
            {
                $oLayer = $oMap->getLayer($i);
                if (in_array( $oLayer->name, $aszSelectedLayers ))
                {
                    $oLayer->setMetaData( "selected", "1" );
                }
                else
                {
                    $oLayer->setMetaData( "selected", "0" );
                }
            }
        }
        else 
        {
            $bHasSelection = false;
            for($i=0; $i<$oMap->numlayers; $i++)
            {
                $oLayer = $oMap->getLayer($i);
                $szSelected = $oLayer->getMetaData( "selected" );
                if ($szSelected != "")
                {
                    $bHasSelected = true;
                    break;
                }
            }            
            if (!$bHasSelection && $oMap->numlayers > 0)
            {
                $oLayer = $oMap->getLayer( 0 );
                $oLayer->setMetaData( "selected", "1" );
            }
        }
        // return success
        return true;
    }
}
?>
