<?php
/**
 * Scalebar Widget class
 *
 * @project     CWC2
 * @revision    $Id: Scalebar.widget.php,v 1.2 2004/04/24 21:59:32 pspencer Exp $
 * @purpose     Scalebar Widget class
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */



include_once(dirname(__FILE__)."/../Widget.php");

/**
 * Scalebar
 *
 * @desc Displays a scalebar image for the current map scale
 */
class Scalebar extends CWCWidget
{
    //these are overriden by template or mapfile when available.
    var $mnWidth = 200;
    var $mnHeight = 5;
    var $mnIntervals = 5;
    var $mszUnits = "KILOMETERS";
    var $mnColorRed = 255;
    var $mnColorGreen = 255;
    var $mnColorBlue = 255;
    var $mnBackgroundColorRed = 0;
    var $mnBackgroundColorGreen = 0;
    var $mnBackgroundColorBlue = 0;
    var $mnOutlineColorRed = 0;
    var $mnOutlineColorGreen = 0;
    var $mnOutlineColorBlue = 0;
    var $mnLabelColorRed = 0;
    var $mnLabelColorGreen = 0;
    var $mnLabelColorBlue = 0;
    var $mszLabelSize = "SMALL";
    var $mbTransparent = true;
    var $mszImageType = "PNG";

    /**
     * Scalebar
     *
     * Constructor for the Scalebar
     */
    function Scalebar( )
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
Display a scalebar image for the current extents of the current context.
EOT;

        $this->maAttributes["WIDTH"] = new IntegerAttribute( "WIDTH", false, 0 );
        $this->maAttributes["HEIGHT"] = new IntegerAttribute( "HEIGHT", false, 0 );
        $this->maAttributes["INTERVALS"] = new IntegerAttribute( "INTERVALS", false, 0 );
        $this->maAttributes["UNITS"] = new StringAttribute( "UNITS", false,
            array( "INCHES", "FEET", "MILES", "METERS", "KILOMETERS" ));
        $this->maAttributes["COLOR"] = new RGBColorAttribute( "COLOR", false);
        $this->maAttributes["BACKGROUNDCOLOR"] = new RGBColorAttribute( "BACKGROUNDCOLOR", false);
        $this->maAttributes["OUTLINECOLOR"] = new RGBColorAttribute( "OUTLINECOLOR", false);
        $this->maAttributes["LABELCOLOR"] = new RGBColorAttribute( "LABELCOLOR", false);
        $this->maAttributes["LABELSIZE"] = new StringAttribute( "LABELSIZE", false,
            array( "TINY", "SMALL", "MEDIUM", "LARGE", "GIANT" ));
        $this->maAttributes["TRANSPARENT"] = new BooleanAttribute( "TRANSPARENT", false );

        // initialize array
        $gaMSImageTypes = array();

        if (defined( "ms_GetVersion" ))
        {

            // check each
            if (strpos( ms_GetVersion(), "OUTPUT=GIF") > 0 )
              array_push( $gaMSImageTypes, "GIF" );
            if (strpos( ms_GetVersion(), "OUTPUT=PNG") > 0 )
              array_push( $gaMSImageTypes, "PNG" );
            if (strpos( ms_GetVersion(), "OUTPUT=PNG24") > 0 )
              array_push( $gaMSImageTypes, "PNG" );
            if (strpos( ms_GetVersion(), "OUTPUT=JPEG") > 0 )
              array_push( $gaMSImageTypes, "JPEG" );
            if (strpos( ms_GetVersion(), "OUTPUT=WBMP") > 0 )
              array_push( $gaMSImageTypes, "WBMP" );
            if (strpos( ms_GetVersion(), "OUTPUT=PDF") > 0 )
              array_push( $gaMSImageTypes, "PDF" );
            if (strpos( ms_GetVersion(), "OUTPUT=SWF") > 0 )
              array_push( $gaMSImageTypes, "SWF" );
          }

        $this->maAttributes["IMAGETYPE"] = new StringAttribute( "IMAGETYPE", false, $gaMSImageTypes);
    }


    /**
     * return an array of javascript functions needed by Scalebar widget
     * @return array of name = function values
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $poMap = $this->moMapObject->oMap;

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if ($bCWCJSAPI)
        {
            $url = WEBCOMMON."/wrapper/drawmap.php?map_session_mode=1&run_query=0&REQUEST=SCALEBAR&".SID;
            $url .= "&dummy=".urlencode(microtime());

            $szJsFunctionName = "ScaleBarWRegisterForEvent";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to register and even when the map extents chnages (JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(MAP_EXTENT_CHANGED, "ScaleBarWMapExtentsChanged");
}
EOT;

       $aReturn[$szJsFunctionName] = $szFunction;

       $szJsFunctionName = "ScaleBarWMapExtentsChanged";
       $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mapextents are changed to update the scalebar images(JSAPI)
 */
function {$szJsFunctionName}()
{
     var sImgName = "ScaleBarImg";
     var url = "{$url}";
     var d = new Date();
     var unique = d.getTime() + '' + Math.floor(1000 * Math.random());
     url = url + "&UniqId="+unique;
     document.images[sImgName].src = url;
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;

       $szJsFunctionName = "ScalebarLoaded";
       $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the image is finished loading
 */
function {$szJsFunctionName}()
{
    // Get all errors from ErrorManager on server side.
    //goCWCJSAPI.oErrorManager.GetServerErrors();
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;

       }

       return $aReturn;
    }


    /**
     * return an array of javascript functions needed by Scalebar widget
     * and called when the page is loaded.
     * @return array of name = function values
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();

        $aReturn = parent::GetJavascriptOnLoadFunctions();

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
             $szJsFunctionName = "ScaleBarWRegisterForEvent";
             $szFunction = "$szJsFunctionName();\n";
             $aReturn[$szJsFunctionName] = $szFunction;
        }

        return $aReturn;
    }



    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        $poMap = &$this->moMapObject->oMap;
        $poScaleBar = &$this->moMapObject->oMap->scalebar;

        if (!$this->mbVisible || $poMap->status == MS_OFF)
            return "<!-- Scalebar hidden -->";

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        $aValidUnits = array( "INCHES", "FEET", "MILES",
                              "METERS", "KILOMETERS" );
        $aValidSize = array( "TINY", "SMALL", "MEDIUM", "LARGE", "GIANT" );
        
        // set up the scalebar parameters with template
        // settings if available, otherwise use mapfile.

        $nWidth = $this->mnWidth;
        if (isset($poScaleBar->width))
            $nWidth = $poScaleBar->width;
        if (isset($this->maParams["WIDTH"]))
            $nWidth = $this->maParams["WIDTH"];
        $nHeight = $this->mnHeight;
        if (isset($poScaleBar->height))
            $nHeight = $poScaleBar->height;
        if (isset($this->maParams["HEIGHT"]))
            $nHeight = $this->maParams["HEIGHT"];
        $nIntervals = $this->mnIntervals;
        if (isset($poScaleBar->intervals))
            $nIntervals = $poScaleBar->intervals;
        if (isset($this->maParams["INTERVALS"]))
            $nIntervals = $this->maParams["INTERVALS"];
        $szUnits = $this->mszUnits;
        if (isset($poScaleBar->units))
            $szUnits = $aValidUnits[$poScaleBar->units];
        if (isset($this->maParams["UNITS"]))
            $szUnits = strtoupper($this->maParams["UNITS"]);
        if (!in_array( $szUnits, $aValidUnits))
            $szUnits = $this->mszUnits;
        eval( "\$nUnits = MS_".strtoupper($szUnits).";" );
        $nColorRed = $this->mnColorRed;
        $nColorGreen = $this->mnColorGreen;
        $nColorBlue = $this->mnColorBlue;
        if (isset($poScaleBar->color))
        {
            $nColorRed = $poScaleBar->color->red;
            $nColorBlue = $poScaleBar->color->blue;
            $nColorGreen = $poScaleBar->color->green;
        }
        if (isset($this->maParams["COLOR"]))
        {
            $aszColor = split(" ", $this->maParams["COLOR"]);
            $nColorRed = intval($aszColor[0]);
            $nColorGreen = intval($aszColor[1]);
            $nColorBlue = intval($aszColor[2]);
        }

        $nBackgroundColorRed = $this->mnBackgroundColorRed;
        $nBackgroundColorGreen = $this->mnBackgroundColorGreen;
        $nBackgroundColorBlue = $this->mnBackgroundColorBlue;
        if (isset($poScaleBar->color))
        {
            $nBackgroundColorRed = $poScaleBar->backgroundcolor->red;
            $nBackgroundColorGreen = $poScaleBar->backgroundcolor->green;
            $nBackgroundColorBlue = $poScaleBar->backgroundcolor->blue;
        }

        if (isset($this->maParams["BACKGROUNDCOLOR"]))
        {
            $aszColor = split(" ", $this->maParams["BACKGROUNDCOLOR"]);
            $nBackgroundColorRed = intval($aszColor[0]);
            $nBackgroundColorGreen = intval($aszColor[1]);
            $nBackgroundColorBlue = intval($aszColor[2]);
        }

        $nOutlineColorRed = $this->mnOutlineColorRed;
        $nOutlineColorGreen = $this->mnOutlineColorGreen;
        $nOutlineColorBlue = $this->mnOutlineColorBlue;
        if (isset($poScaleBar->outlinecolor))
        {
            $nOutlineColorRed = $poScaleBar->outlinecolor->red;
            $nOutlineColorGreen = $poScaleBar->outlinecolor->green;
            $nOutlineColorBlue = $poScaleBar->outlinecolor->blue;
        }
        if (isset($this->maParams["OUTLINECOLOR"]))
        {
            $aszColor = split(" ", $this->maParams["OUTLINECOLOR"]);
            $nOutlineColorRed = intval($aszColor[0]);
            $nOutlineColorGreen = intval($aszColor[1]);
            $nOutlineColorBlue = intval($aszColor[2]);
        }

        $nLabelColorRed = $this->mnLabelColorRed;
        $nLabelColorGreen = $this->mnLabelColorGreen;
        $nLabelColorBlue = $this->mnLabelColorBlue;
        if (isset($poScaleBar->label))
        {
            $nLabelColorRed = $poScaleBar->label->color->red;
            $nLabelColorGreen = $poScaleBar->label->color->green;
            $nLabelColorBlue = $poScaleBar->label->color->blue;
        }
        if (isset($this->maParams["LABELCOLOR"]))
        {
            $aszColor = split(" ", $this->maParams["LABELCOLOR"]);
            $nLabelColorRed = intval($aszColor[0]);
            $nLabelColorGreen = intval($aszColor[1]);
            $nLabelColorBlue = intval($aszColor[2]);
        }

        $szLabelSize = $this->mszLabelSize;
        if (isset($poScaleBar->label->size))
        {
            $szLabelSize = $aValidSize[$poScaleBar->label->size];
        }
        if (isset($this->maParams["LABELSIZE"]))
            $szLabelSize = $this->maParams["LABELSIZE"];
        if (!in_array( $szLabelSize, $aValidUnits))
            $szUnits = $this->mszLabelSize;
        eval( "\$nLabelSize = MS_".strtoupper($szLabelSize).";" );

        $bTransparent = $this->mbTransparent;
        if (isset($poScaleBar->transparent))
            $bTransparent = $poScaleBar->transparent;
        if (isset($this->maParams["TRANSPARENT"]))
        {
            if (strcasecmp( $this->maParams["TRANSPARENT"], "FALSE" ) == 0)
                $bTransparent = false;
            else
                $bTransparent = true;
        }

        $poScaleBar->set( "width", $nWidth );
        $poScaleBar->set( "height", $nHeight );
        $poScaleBar->set( "intervals", $nIntervals );
        $poScaleBar->set( "units", $nUnits );
        $poScaleBar->color->setRGB( $nColorRed, $nColorGreen, $nColorBlue );
        $poScaleBar->backgroundcolor->setRGB( $nBackgroundColorRed,
                                              $nBackgroundColorGreen,
                                              $nBackgroundColorBlue );
        $poScaleBar->outlinecolor->setRGB( $nOutlineColorRed,
                                           $nOutlineColorGreen,
                                           $nOutlineColorBlue );
        $poScaleBar->label->color->setRGB( $nLabelColorRed,
                                           $nLabelColorGreen,
                                           $nLabelColorBlue );
        $poScaleBar->label->set( "size", $nLabelSize );

        if ($bTransparent)
            $poScaleBar->set( "transparent", MS_TRUE );
        else
            $poScaleBar->set( "transparent", MS_FALSE );

        $poScaleBar->set( "status", MS_ON );

        $szImageType = $this->mszImageType;
        if (isset($this->maParams["IMAGETYPE"]))
            $szImageType = $this->maParams["IMAGETYPE"];

        $szOldImageType = $this->moMapObject->oMap->outputformat->name."";

        $this->moMapObject->oMap->selectOutputFormat($szImageType);
        $oScalebarImage = $this->moMapObject->oMap->drawScaleBar();
        $this->moMapObject->oMap->selectOutputFormat($szOldImageType);

        $url = $oScalebarImage->saveWebImage( 1, 1, 0, 95 );
        if ($bCWCJSAPI)
            $szOnLoad = " onLoad=\"ScalebarLoaded()\"";
        else
            $szOnLoad = "";
        $szResult = "<img src=\"$url\" name=\"ScaleBarImg\"$szOnLoad width=\"".$oScalebarImage->width.
            "\" height=\"".$oScalebarImage->height."\" border=\"0\">";
        return $szResult;
    }
}
?>
