<?php
/**
 * ScaleZoom Widget class
 *
 * @project     CWC2
 * @revision    $Id: ScaleZoom.widget.php,v 1.4 2004/07/08 15:58:59 pspencer Exp $
 * @purpose     ScaleZoom Widget class
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../NavTool.php");

/**
 * ScaleZoom
 *
 * @desc Display scale bar that the user can zoom to a different.
 * scale using.
 */
class ScaleZoom extends NavTool
{
    var $mszDirection = "horizontal";
    var $mszCurrentImage = "";
    var $mbPutTableTags = true;

    /**
     * ScaleZoom
     *
     * Constructor for the ScaleZoom
     */
    function ScaleZoom( )
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/ScaleZoom.dbf";

        // invoke constructor of parent
        parent::NavTool();

//        $this->NavTool();

        $this->SetNavCommand("SCALE_ZOOM");

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ScaleZoom widget displays a series of preset scale buttons that the user
can use to quickly zoom in or out at predefined intervals.  The intermediate
scales are defined using sub-tags as follows: &lt;ZOOMVALUE SCALE="42000000"
IMAGE="images/zoom_h_1.gif" IMAGEWIDTH="14" IMAGEHEIGHT="22"/&gt;.  Any number
of zoomvalues are allowed, but there is likely a practical limit depending on
the images used.
EOT;

        $this->maAttributes["INCREASEIMAGE"] = new StringAttribute("INCREASEIMAGE", false);
        $this->maAttributes["DECREASEIMAGE"] = new StringAttribute("DECREASEIMAGE", false);
        $this->maAttributes["INCREASETO"] = new IntegerAttribute("INCREASETO", false);
        $this->maAttributes["DECREASETO"] = new IntegerAttribute("DECREASETO", false);
        $this->maAttributes["ORIENTATION"] = new StringAttribute("ORIENTATION", false,
            array( "HORIZONTAL", "VERTICAL" ));
        $this->maAttributes["CURRENTIMAGE"] = new StringAttribute("CURRENTIMAGE", false);
        $this->maAttributes["PUTTABLETAGS"] = new BooleanAttribute("PUTTABLETAGS", false);
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        $this->maParams["IMAGE"] = "DUMMY";
        // Dont call parent; we want to overwrite some NAVtool behavior
        // But we need the parrent mszHTMLForm variable and few other things.....

        if (isset($this->maParams["VISIBLE"]))
            $this->mbVisible = ((strcasecmp($this->maParams["VISIBLE"], "TRUE")==0) ? true : false);

        if (isset($this->maParams["ENABLED"]))
            $this->mbEnabled = ((strcasecmp($this->maParams["ENABLED"], "TRUE")==0) ? true : false);

        if (isset($this->maParams["NAME"]))
            $this->mszName = $this->maParams["NAME"];

        if (isset($this->maParams["FORMINDEX"]))
            $this->mnFormIndex = $this->maParams["FORMINDEX"];

        if (isset($this->maParams["PUTTABLETAGS"]))
            $this->mbPutTableTags = (strtoupper($this->maParams["PUTTABLETAGS"]) == "FALSE") ? false : true;

        $this->mszHTMLForm = "document.forms[".$this->mnFormIndex."]";
    }


    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = parent::GetJavascriptFunctions();

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        $szJsFunctionName = "clickScaleValue";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a Projection Selector dialog
 */
function {$szJsFunctionName}(szScale)
{
    {$this->mszHTMLForm}.NAV_CMD.value = "SCALE_ZOOM";
    {$this->mszHTMLForm}.SCALE_ZOOM.value = szScale;

    if ($bCWCJSAPI)
    {
        goCWCJSAPI.SCALE_ZOOM = szScale;
        goCWCJSAPI.UpdateScaleZoom();
    }
    else
    {
        {$this->mszHTMLForm}.submit();
    }

    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetHTMLHiddenVariables
     *
     * return the NAV_SCALE varaiable.
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = parent::GetHTMLHiddenVariables();

        $szVariable = "SCALE_ZOOM";
        $szValue = "<INPUT TYPE=\"HIDDEN\" NAME=\"$szVariable\" VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * ParseURL
     *
     * Compare NAV_SCALE to SCALE and zoomscale if they are different
     */
    function  ParseURL()
    {
        parent::ParseURL();

        $szCmd = "";
        if ($this->isVarSet( "NAV_CMD" ))
            $szCmd = $this->getVar( "NAV_CMD" );

        if ($szCmd == "SCALE_ZOOM")
        {

            $szCurrentScale = $this->moMapObject->oMap->scale;

            $szNewScale = "";
            if ($this->isVarSet( "SCALE_ZOOM" ))
                $szNewScale = $this->getVar( "SCALE_ZOOM" );

            if ($szNewScale != "")
            {
                $this->moMapNavigator->zoomScale( $szNewScale);
            /**
        Call the reporjectauto function in case the map projection
        is set to AUTO:XXX. If it is not, the function will do
        nothing.
            */
                $this->ReprojectAuto();                       
             
            }
        }

        return true;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        $oApp = GetChameleonApplication();
        
        $szJsOnClick = "";
        
        if (!$this->mbVisible)
            return "<!-- ScaleZoom widget hidden -->";
       
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
              $szSubmit = ";goCWCJSAPI.UpdateNavTools();";
        }
        else
        {
              $szSubmit = $this->mszHTMLForm . ".submit();return false;";
        }

        
        $nCurrentScale = (int)$this->moMapObject->oMap->scale;
        if(isset($this->maParams["INCREASETO"]))
            $nIncreaseTo = $this->maParams["INCREASETO"];
        else
            $nIncreaseTo = 1;
        if(isset($this->maParams["DECREASETO"]))
            $nDecreaseTo = $this->maParams["DECREASETO"];
        else
            $nDecreaseTo = 100000000;

        $nFactor = 1; //if we are within this much, it's a match
        $aScale = array();
        if (isset( $this->maszContents["ZOOMVALUE"]))
        {
            foreach($this->maszContents["ZOOMVALUE"] as $aZoom)
            {
                $nScale = (int)$aZoom["SCALE"];
                if ($nScale != "-1")
                {
                    if (abs($nCurrentScale - $nScale) <= $nFactor)
                        $nCurrentScale = $nScale;
                    array_push( $aScale, $nScale );
                }
            }
            rsort($aScale);
            $nCurrentZoomLevel = 0;
            $nCurrentScaleDiff = 1000000000;
            $bCurrentZoom = isset($this->maParams["CURRENTIMAGE"]);
            $nScales = count($aScale);
            for($i=0;$i<$nScales;$i++)
            {
                if(abs($nCurrentScale - $aScale[$i]) < $nCurrentScaleDiff)
                {
                    $nCurrentScaleDiff = abs($nCurrentScale - $aScale[$i]);
                    if($bCurrentZoom)
                        $nCurrentZoomLevel = $i;
                    if(isset($aScale[$i+1]))
                        $nIncreaseTo = $aScale[$i+1];
                    else
                        $nIncreaseTo = $aScale[$nScales-1];
                    if(isset($aScale[$i-1]))
                        $nDecreaseTo = $aScale[$i-1];
                    else
                        $nDecreaseTo = $aScale[0];
                }
            }
        }

        if (!isset($this->maParams["INCREASEIMAGE"]))
        {
            $szImageIncrease = "";
        }
        else
        {
            $szImageIncrease = $oApp->findFile( $this->maParams["INCREASEIMAGE"] );
            $szImageIncrease = $oApp->fileSystemToURL( $szImageIncrease );
        }
        if (!isset($this->maParams["DECREASEIMAGE"]))
        {
            $szImageDecrease = "";
        }
        else
        {
            $szImageDecrease = $oApp->findFile( $this->maParams["DECREASEIMAGE"] );
            $szImageDecrease = $oApp->fileSystemToURL( $szImageDecrease );
        }
        
        $szDirection = $this->mszDirection;
        if (isset($this->maParams["ORIENTATION"]))
            $szDirection = $this->maParams["ORIENTATION"];

        $szResult = "";
        if ($this->mbPutTableTags)
            $szResult = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n";

        $szResult .= "<tr>\n";

        if ($nDecreaseTo != "-1")
        {
            $szStart = "<a href=\"#\" onClick=\"clickScaleValue($nDecreaseTo);\">";
            $szEnd = "</a>";
        }

        if ($szImageDecrease != "")
            $szResult .= "<td>$szStart<img src=\"$szImageDecrease\" title=\"".trim($this->moMLT->get("1", "Zoom Out to 1:"))."$nDecreaseTo\" alt=\"".trim($this->moMLT->get("1", "Zoom Out to 1:"))."$nDecreaseTo\" border=\"0\">$szEnd</td>\n";
        if (isset( $this->maszContents["ZOOMVALUE"] ))
        {
            $i = 0;
            foreach($this->maszContents["ZOOMVALUE"] as $aZoom)
            {
                if (strcasecmp($szDirection, "VERTICAL") == 0)
                {
                    $szResult .= "</tr>\n<tr>\n";
                }
                if (!isset( $aZoom["SCALE"] ) || !isset( $aZoom["IMAGE"]))
                    continue;
                $szWidth = $szHeight = "";
                $szScale = $aZoom["SCALE"];
                
                $szImage = $oApp->findFile($aZoom["IMAGE"]);
                $szImage = $oApp->fileSystemToURL( $szImage );
                
                if (isset( $aZoom["IMAGEWIDTH"] ))
                    $szWidth = " width=\"".$aZoom["IMAGEWIDTH"]."\"";
                if (isset( $aZoom["IMAGEHEIGHT"] ))
                    $szHeight = " height=\"".$aZoom["IMAGEHEIGHT"]."\"";

                if ($szScale == "-1")
                {
                    $szResult .= "<td><img src=\"$szImage\"$szWidth$szHeight title=\"".trim($this->moMLT->get("3", "Zoom to 1:"))."$szScale\" alt=\"".trim($this->moMLT->get("3", "Zoom to 1:"))."$szScale\" border=\"0\"></td>";
                    $nCurrentZoomLevel++;
                }
                else
                if(isset($this->maParams["CURRENTIMAGE"]) && 
                   $i == $nCurrentZoomLevel)
                {
                    $szResult .= "<td><img src=\"".$this->maParams["CURRENTIMAGE"]."\"$szWidth$szHeight title=\"".trim($this->moMLT->get("3", "Zoom to 1:"))."$szScale\" alt=\"".trim($this->moMLT->get("3", "Zoom to 1:"))."$szScale\" border=\"0\"></td>";
                }
                else
                    $szResult .= "<td><a href=\"#\" onClick=\"clickScaleValue($szScale);\"><img src=\"$szImage\"$szWidth$szHeight title=\"".trim($this->moMLT->get("3", "Zoom to 1:"))."$szScale\" alt=\"".trim($this->moMLT->get("3", "Zoom to 1:"))."$szScale\" border=\"0\"></a></td>";

                $i++;

            }
            if (strcasecmp($szDirection, "VERTICAL") == 0)
                {
                    $szResult .= "</tr>\n<tr>\n";
                }

        }
        $szStart = "<a href=\"#\" onClick=\"clickScaleValue($nIncreaseTo);\">";
        $szEnd = "</a>";
        if ($szImageIncrease != "")
            $szResult .= "<td>$szStart<img src=\"$szImageIncrease\" title=\"".trim($this->moMLT->get("2", "Zoom In to 1:"))."$nIncreaseTo\" alt=\"".trim($this->moMLT->get("2", "Zoom In to 1:"))."$nIncreaseTo\" border=\"0\">$szEnd</td>";
        $szResult .= "</tr>";

        if ($this->mbPutTableTags)
            $szResult .= "</table>\n";

        return $szResult;

    }
}
?>
