<?php
/**
 * Scale Widget class
 *
 * @project     CWC2
 * @revision    $Id: Scale.widget.php,v 1.5 2004/07/08 15:58:59 pspencer Exp $
 * @purpose     Scale Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");

/**
 * Scale
 *
 * @desc Display scale in an input box and process if the page is submitted.
 */
class Scale extends CWCWidget
{
    var $moLabel;
    var $mszSize = "8";
    var $mszClass = "CWCScaleWidgetClass";
    var $mbSubmitOnKeyPress = "true";
    var $mszStyle = "";
    var $oMapNavigator;

    /**
     * Scale
     *
     * Constructor for the Scale
     */
    function Scale( )
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/Scale.dbf";

        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Scale widget displays an HTML INPUT box that the user can view the
current map scale and enter a scale to zoom to.  The Scale widget needs
to be combined with another widget that actually causes the map to refresh,
such as an UpdateMap widget.
EOT;

        $this->moLabel = new CWCLabel($this);
        $this->maAttributes["SIZE"] = new IntegerAttribute( "SIZE", false, 1 );
        $this->maAttributes["WIDGETCLASS"] = new StringAttribute( "WIDGETCLASS", false );
        $this->maAttributes["WIDGETSTYLE"] = new StringAttribute( "WIDGETSTYLE", false );
        $this->maAttributes["SUBMITONKEYPRESS"] = new BooleanAttribute( "SUBMITONKEYPRESS", false );
    }

    /**
     * Initialize default values from tag
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["WIDGETCLASS"]))
            $this->mszClass = strtoupper($this->maParams["WIDGETCLASS"]);
        if (isset($this->maParams["WIDGETSTYLE"]))
            $this->mszStyle = strtoupper($this->maParams["WIDGETSTYLE"]);
        if (isset($this->maParams["SUBMITONKEYPRESS"]))
            $this->mbSubmitOnKeyPress = $this->maParams["SUBMITONKEYPRESS"];

    }

    /**
     * SetMap
     *
     * Set the map session and create a navigation tool.
     *
     * @param oMapSession
     */
    function SetMap($oMapSession)
    {
        $this->moMapObject = $oMapSession;

        $this->moMapNavigator = new MapNavigator( $oMapSession );
    }

    /**
     * ParseURL
     *
     * Compare NAV_SCALE to SCALE and zoomscale if they are different
     */
    function  ParseURL()
    {
        $szUpdate = "";
        if ($this->isVarSet( "UPDATE_MAP" ))
            $szUpdate = $this->getVar( "UPDATE_MAP" );

        if ($szUpdate != "1")
            return true;

        $szNewScale = "";
        if ($this->isVarSet( "SCALE" ))
            $szNewScale = $this->getVar( "SCALE" );

        if ($szNewScale > 0 && is_numeric($szNewScale))
            $this->moMapNavigator->zoomScale( $szNewScale );
        else
            $_SESSION['gErrorManager']->setError(ERR_WARNING, trim($this->moMLT->get("0", "ERROR: Invalid specified scale.")));

        return true;
    }

    /**
     * return an array of javascript functions needed by Scalebar widget
     * @return array of name = function values
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $poMap = $this->moMapObject->oMap;

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if ($bCWCJSAPI)
        {
                        $szJsFunctionName = "ScaleWRegisterForEvent";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to register and even when the map extents chnages (JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(MAP_EXTENT_CHANGED, "ScaleWMapExtentsChanged");
}
EOT;

       $aReturn[$szJsFunctionName] = $szFunction;

              $szJsFunctionName = "ScaleWMapExtentsChanged";
       $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mapextents are changed to update the scalebar images(JSAPI)
 */
function {$szJsFunctionName}()
{
    {$this->mszHTMLForm}.SCALE.value = goCWCJSAPI.oMap.scale;
}
EOT;

    $aReturn[$szJsFunctionName] = $szFunction;

    }
                        $szJsFunctionName = "KeyPressed";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * submits the form on enter
 */
function {$szJsFunctionName}(e)
{
    if (!e) var e = window.event;
    var code = e.keyCode;
    if (code == 13)
    {
        {$this->mszHTMLForm}.UPDATE_MAP.value = "1";
      {$this->mszHTMLForm}.submit();
    return;
    }
}
EOT;
$aReturn[$szJsFunctionName] = $szFunction;


     return $aReturn;
}

    /**
     * return an array of javascript functions needed by Scalebar widget
     * and called when the page is loaded.
     * @return array of name = function values
     */
     function GetJavascriptOnLoadFunctions()
     {
         $aReturn = array();

         $aReturn = parent::GetJavascriptOnLoadFunctions();

         if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
         {
             $szJsFunctionName = "ScaleWRegisterForEvent";
             $szFunction = "$szJsFunctionName();\n";
             $aReturn[$szJsFunctionName] = $szFunction;
         }

         return $aReturn;
     }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- Scale widget hidden -->";

        $this->moMapObject->oMap->setExtent(
                                $this->moMapObject->oMap->extent->minx,
                                $this->moMapObject->oMap->extent->miny,
                                $this->moMapObject->oMap->extent->maxx,
                                $this->moMapObject->oMap->extent->maxy);

        $szScale = $this->moMapObject->oMap->scale;

        // If scale is > than 1 don't round the scale
        if ($szScale > 1)
            $szScale = round($szScale);

        $szSize = $this->mszSize;
        if (isset($this->maParams["SIZE"]))
            $szSize = strtoupper($this->maParams["SIZE"]);

        $szClass = "";
        if ( strlen($this->mszClass) > 0 )
          $szClass = " CLASS=\"$this->mszClass\"";
        $szStyle = "";
        if ( strlen($this->mszStyle) > 0 )
          $szStyle = " STYLE=\"$this->mszStyle\"";

        $szSubmitOnKeyPress = "";
        if ($this->mbSubmitOnKeyPress == "true")
          $szSubmitOnKeyPress = " OnKeyPress=\"KeyPressed(event)\"";
        $szValue = "<INPUT".$szClass.$szStyle.$szSubmitOnKeyPress." NAME=\"SCALE\" TYPE=\"TEXT\" VALUE=\"$szScale\" size=\"$szSize\">";

        //and put a label next to it if necessary
        return $this->moLabel->DrawPublish( $szValue );
    }
}
?>
