<?php
/**
 * Recenter Widget class
 *
 * @project     CWC2
 * @revision    $Id: Recenter.widget.php,v 1.2 2004/04/24 21:59:12 pspencer Exp $
 * @purpose     Recenter Widget class
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../NavTool.php");

/**
 * Recenter
 *
 * @desc  Recenter widget.
 */
class Recenter extends NavTool
{
    var $mszImagePath = "images/tool_recentre.gif";
    var $mszImageSelectedPath = "images/tool_recentre.gif";
    var $mszImageHoverPath = "images/tool_recentre.gif";
    var $mszImageTip = "Recenter";

    /**
     * Recenter
     *
     * Constructor. Set the default values.
     */
    function Recenter()
    {
        // invoke constructor of parent
        parent::NavTool();

        $this->NavTool();
        $this->SetNavCommand("RECENTER");

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Recenter widget allows the user to recenter the map at the clicked location.
EOT;

    }

    /**
     * ParseURL
     *
     * Look for the ZOOM_IN command and if founddo the zooming
     * according to the other NAV paramaters.
     */
    function  ParseURL()
    {
        $bRes = parent::parseURL();

        $szCmd = "";
        if ($this->isVarSet( "NAV_CMD" ))
          $szCmd = trim($this->getVar( "NAV_CMD" ));

        if ($szCmd == "RECENTER" && $this->isVarSet( "NAV_INPUT_COORDINATES" ))
        {
            $oMap =& $this->moMapObject->oMap;

            $szInputCoords = "";
            $szInputCoords = $this->getVar( "NAV_INPUT_COORDINATES" );
            $szInputType = $this->getVar( "NAV_INPUT_TYPE" );

            if(strlen($szInputCoords) <= 0)
            {
                return true;
            }

            if ($szInputType == "POINT")
            {
                $aPixPos = explode(",", $szInputCoords);
                $this->moMapNavigator->recentre($aPixPos[0], $aPixPos[1]);
/* -------------------------------------------------------------------- */
/*      Call the reporjectauto function in case the map projection      */
/*      is set to AUTO:XXX. If it is not, the function will do          */
/*      nothing.                                                        */
/* -------------------------------------------------------------------- */
                $this->ReprojectAuto();                    
            }
            else
            {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                trim($this->moMLT->get("1", "warning: Invalid input type specified in"))." Recenter.php ($szInputType).");
                return true;
            }
        }

        return $bRes;
    }
}
?>
