<?php
/**
 * ROIRectangleTool Widget class
 *
 * @project     CWC2
 * @revision    $Id: ROIRectangleTool.widget.php,v 1.6 2004/05/26 20:44:41 pspencer Exp $
 * @purpose     ROI Rectangle Tool Widget class.  Allows the user to select
 * a rectangular region of interest on the map.  
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
 * ROIRectangleTool
 *
 * @desc A widget to draw a rectangular Region of Interest
 */
class ROIRectangleTool extends CWCWidget
{

    
    /* the button that is the interface for this widget */
    var $moButton;
    
    /**
     * construct a new ROI Rectangle Tool widget
     */
    function ROIRectangleTool()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ROIRectangleTool widget allows the user to draw a rectangular region
of interest on the map interface.
EOT;
        $this->moButton = new CWCButton( $this );
        
        
    }
    
    /**
     * 
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('ROIRectTool'.$this->mnId);

    }

    /**
     * pass URL to button
     */
    function  ParseURL()
    {
        return $this->moButton->ParseURL();
    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
                
        $szCmd = '';
        if ($this->isVarSet('NAV_CMD'))
            $szCmd = $this->getVar('NAV_CMD');
        $szVariable = "NAV_CMD";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;
        
        return $aReturn;
    }
    
    /**
     * GetJavascriptInitFunctions
     *
     * Functions to be called at the end of the load.
     */
    function GetJavascriptInitFunctions()
    {
        $aReturn = $this->moButton->GetJavascriptInitFunctions();

        $szJsFunctionName = "ROIRectToolInit";
        $szFunction = "$szJsFunctionName();\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        $aReturn['InitCWCROIManagerForm'] = 'goCWCROIManager.SetFormObject('.$this->mszHTMLForm.');';
        
        return $aReturn;
    }

    /**
     * javascript include files
     */
    function GetJavascriptIncludeFunctions()
    {
        $aReturn = parent::GetJavascriptIncludeFunctions();
        
        $szVar = "cwc_roi.js";
        $aReturn[$szVar] = '<script src="'.$_SESSION['gszCoreWebPath'].
                            '/widgets/js/cwc_roi.js"></script>';
        
        $szVar = "cwc_dhtml.js";
        $aReturn[$szVar] = '<script src="'.$_SESSION['gszCoreWebPath'].
                            '/widgets/js/cwc_dhtml.js"></script>';
        return $aReturn;
    }

    /**
     * @desc javascript mousemove functions
     */
    function GetJavascriptOnMouseMoveFunctions()
    {
        $aReturn = parent::GetJavascriptOnMouseMoveFunctions();
        
        $aReturn['ROIRectTool'] = 'ROIRectToolMouseMove(e);';

        return $aReturn;
    }

    /**
     * @desc general javascript functions
     */
    function GetJavascriptFunctions()
    {
        $aReturn = parent::GetJavascriptFunctions();

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;
          
        // add JSAPI mode functions  
        if ($bCWCJSAPI)
        {
            $szJsFunctionName = "ROIRectangleToolWRegisterForEvent";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to register events when the layers change (JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(MAP_EXTENT_CHANGED, "ROIRectangleToolWExtentChanged");
    goCWCJSAPI.RegisterEvent(MAP_PROJECTION_CHANGED, "ROIRectangleToolWExtentChanged");
}
EOT;

           $aReturn[$szJsFunctionName] = $szFunction;
           $szJsFunctionName = "ROIRectangleToolWExtentChanged";
           $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the extent is changed (JSAPI)
 */
function {$szJsFunctionName}()
{
    // re-draw the ROI
    goCWCROIManager.SetGeoExtents( goCWCJSAPI.oMap.minx, goCWCJSAPI.oMap.miny, 
                                    goCWCJSAPI.oMap.maxx, goCWCJSAPI.oMap.maxy );
    goCWCROIManager.Redraw();
}
EOT;
            $aReturn[$szJsFunctionName] = $szFunction;

        }
        
        $nId = $this->mnId;
        $szName = 'ROIRectTool'.$nId;
        $szFunction = <<<EOT
function {$szName}()
{
    goCWCROIManager.SetROITool('{$nId}');
}
EOT;
        $aReturn[$szName] = $szFunction;

        $szName = 'ROIRectToolInit';
        $szFunction = <<<EOT
function {$szName}()
{

    ROIRectToolCreateDHTMLLayers();
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROIRectToolCreateDHTMLLayers';
        $szFunction = <<<EOT
function {$szName}()
{
    var content = "";

    content = '<img name="ROIRectImgTop" src="images/a_pixel.gif" border="1">';
    CWCDHTML_CreateLayer(gROIRectBoxTop, gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( gROIRectBoxTop, 20 );
    content = '<img name="ROIRectImgLeft" src="images/a_pixel.gif" border="1">';
    CWCDHTML_CreateLayer(gROIRectBoxLeft, gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( gROIRectBoxLeft, 20 );
    
    content = '<img name="ROIRectImgBottom" src="images/a_pixel.gif" border="1">';
    CWCDHTML_CreateLayer(gROIRectBoxBottom, gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( gROIRectBoxBottom, 20 );
    
    content = '<img name="ROIRectImgRight" src="images/a_pixel.gif" border="1">';
    CWCDHTML_CreateLayer(gROIRectBoxRight, gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( gROIRectBoxRight, 20 );

    content = '<img name="ROIRectImgFill" src="images/a_pixel.gif" border="1">';
    CWCDHTML_CreateLayer(gROIRectBoxFill, gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( gROIRectBoxFill, 20 );

}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szObjectJS = "    var jsObj;\n";

        /**
         * TODO: this does not reconstitute the points associated with the
         * ROI tool because this is complicated ;)  In reality, the points may
         * not be at valid locations.  The only reason to reconstitute the points
         * would be to enable editing, which can't happen
         */
        
        if (isset($_SESSION['ROIRENDERER']))
        {
            $nROI = count($_SESSION['ROIRENDERER']);
            for ($i=0; $i<$nROI; $i++)
            {
                $aROI = $_SESSION['ROIRENDERER'][$i];
                if ($aROI['type'] == 'rectangle')
                {
                    $szObjectJS .= "    goCWCROIManager.SetMode(".
                                   $aROI['mode'] . ");\n";
                    $szObjectJS .= "    jsObj = new CWCRectangleROI();\n";
                    $szObjectJS .= "    jsObj.edgeColor = \"".$aROI['edgecolor']."\";\n";
                    $szObjectJS .= "    jsObj.edgeWidth = ".$aROI['edgewidth'].";\n";
                    $szObjectJS .= "    jsObj.fillLayer = goCWCROIManager.bUseFill;\n";
                    $szObjectJS .= "    jsObj.fillColor = \"".$aROI['fillcolor']."\";\n";
                    $szObjectJS .= "    jsObj.fillOpacity = ".$aROI['fillopacity'].";\n";
                    $szObjectJS .= "    jsObj.leftLayer = gROIRectBoxLeft;\n";
                    $szObjectJS .= "    jsObj.topLayer = gROIRectBoxTop;\n";
                    $szObjectJS .= "    jsObj.rightLayer = gROIRectBoxRight;\n";
                    $szObjectJS .= "    jsObj.bottomLayer = gROIRectBoxBottom;\n";
                    $szObjectJS .= "    jsObj.fillLayer = gROIRectBoxFill;\n";
                    $szObjectJS .= "    goCWCROIManager.Insert( jsObj, $i );\n";
                }
            }
            if (strlen( $szObjectJS ) > 0)
            {
                $szObjectJS .= "    goCWCROIManager.UpdateLayerVisibility();\n";
            }
        }
        
        
        $szName = 'ROIRectToolInitObjects';
        $szFunction = <<<EOT
function {$szName}()
{
{$szObjectJS}
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROIRectToolStartZoomBox';
        $szFunction = <<<EOT
function {$szName}()
{
    goROIRectObj = new CWCRectangleROI();
    goROIRectObj.edgeColor = goCWCROIManager.szEdgeColor;
    goROIRectObj.edgeWidth = goCWCROIManager.nEdgeWidth;
    goROIRectObj.fillLayer = goCWCROIManager.bUseFill;
    goROIRectObj.fillColor = goCWCROIManager.szFillColor;
    goROIRectObj.fillOpacity = goCWCROIManager.nFillOpacity;
    goROIRectObj.leftLayer = gROIRectBoxLeft;
    goROIRectObj.topLayer = gROIRectBoxTop;
    goROIRectObj.rightLayer = gROIRectBoxRight;
    goROIRectObj.bottomLayer = gROIRectBoxBottom;
    goROIRectObj.fillLayer = gROIRectBoxFill;
    
    goROIRectObj.Show();
    
    gROIRectToolx2 = gROIRectToolx1 + 1;
    gROIRectTooly2 = gROIRectTooly1 + 1;
    
    ROIRectToolUpdateZoomBox();
    
    return true;
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROIRectToolUpdateZoomBox';
        $szFunction = <<<EOT
function {$szName}()
{
    var right  = Math.max(gROIRectToolx1, gROIRectToolx2);
    var left   = Math.min(gROIRectToolx1, gROIRectToolx2);
    var bottom = Math.max(gROIRectTooly1, gROIRectTooly2);
    var top    = Math.min(gROIRectTooly1, gROIRectTooly2);
    
    goROIRectObj.Set( left, top, right, bottom )
    //window.status = "goROIRectObj set to " + left + ", " + top + ", " + right + ", " + bottom;
        
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROIRectToolStopZoomBox';
        $szFunction = <<<EOT
function {$szName}()
{
    goCWCROIManager.Add( goROIRectObj );
    goROIRectObj.Hide();
    goROIRectObj = null;
    return true;
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROIRectToolMouseDown';
        $szFunction = <<<EOT
function {$szName}(e)
{
    ROIRectToolGetMousePosition(e);

    if (gROIToolmouseX >=0 && gROIToolmouseY >=0)
    {
        gROIRectToolx1 = gROIToolmouseX;
        gROIRectTooly1 = gROIToolmouseY;
        
        ROIRectToolStartZoomBox();
        gROIRectDragging = true;
    } 
    return false;
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROIRectToolMouseUp';
        $szFunction = <<<EOT
function {$szName}(e)
{
    ROIRectToolGetMousePosition(e);

    if (gROIToolmouseX >=0 && gROIToolmouseY >=0)
    {
        gROIRectToolx2 = gROIToolmouseX;
        gROIRectTooly2 = gROIToolmouseY;
        ROIRectToolStopZoomBox();
        
        gROIRectDragging = false;
    } 
    return false;
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROIRectToolGetMousePosition';
        $szFunction = <<<EOT
function {$szName}(e)
{
    if (CWCIsNav4 || CWCIsNav6) // Netscape
    {                
        gROIToolmouseX = e.pageX;
        gROIToolmouseY = e.pageY;
    } 
    else if (CWCIsIE) // IE
    {            
        gROIToolmouseX = event.clientX + document.body.scrollLeft;
        gROIToolmouseY = event.clientY + document.body.scrollTop;
    } 
    else 
    {                              // Don't know
        gROIToolmouseX = gROIToolmouseY = 0;
    }
    var oImage = CWCDHTML_GetImage('mapimage');
    
    if (oImage == null)
    {
        gROIToolmouseX = -1;
        gROIToolmouseY = -1
        return false;
    }
    var left = CWCDHTML_FindObjectPosX( oImage );
    var top = CWCDHTML_FindObjectPosY( oImage );
    
    var width = oImage.width;
    var height = oImage.height;
    
    // subtract offsets from page left and top
    gROIToolmouseX = gROIToolmouseX - left;
    gROIToolmouseY = gROIToolmouseY - top;
    
    if (gROIToolmouseX < 0 || gROIToolmouseX > width ||
        gROIToolmouseY < 0 || gROIToolmouseY > height)
    {
        gROIToolmouseX = -1;
        gROIToolmouseY = -1
    } 
    return true;
}
EOT;
        $aReturn[$szName] = $szFunction;
        $szName = 'ROIRectToolMouseMove';
        $szFunction = <<<EOT
function {$szName}(e)
{
    ROIRectToolGetMousePosition(e);

    if (gROIToolmouseX >=0 && gROIToolmouseY >=0 &&
        {$this->mszHTMLForm}.NAV_CMD != null &&
        {$this->mszHTMLForm}.NAV_CMD.value == "ROI_TOOL" &&
        {$this->mnId} == goCWCROIManager.GetROITool())
    {
        document.onmousedown = ROIRectToolMouseDown;
        document.onmouseup = ROIRectToolMouseUp;
        if (gROIRectDragging)
        {
            gROIRectToolx2 = gROIToolmouseX;
            gROIRectTooly2 = gROIToolmouseY;
            ROIRectToolUpdateZoomBox();
        }    
    }
    else
    {
    }
    return false;
}
EOT;
        $aReturn[$szName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetJavascriptVariables
     *
     * Return JS global variables and global code.
     */
    function GetJavascriptVariables()
    {
        $aReturn = array();

        $szVariable = "gROIToolmouseX";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIToolmouseY";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectToolx1";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectTooly1";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectToolx2";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectTooly2";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectDragging";
        $szValue = " var $szVariable = false;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "goROIRectObj";
        $szValue = " var $szVariable = null;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectBoxTop";
        $szValue = " var $szVariable = \"gROIRectBoxTop\";\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectBoxLeft";
        $szValue = " var $szVariable = \"gROIRectBoxLeft\";\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectBoxBottom";
        $szValue = " var $szVariable = \"gROIRectBoxBottom\";\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectBoxRight";
        $szValue = " var $szVariable = \"gROIRectBoxRight\";\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIRectBoxFill";
        $szValue = " var $szVariable = \"gROIRectBoxFill\";\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }
    
    /**
     * return an array of javascript functions needed by the Ruler widget
     * and called when the page is loaded. 
     * @return array of name = function values
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = parent::GetJavascriptOnLoadFunctions();

        $aReturn["ROIRectToolInitObjects"] = "    ROIRectToolInitObjects();\n";
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
            $szJsFunctionName = "ROIRectangleToolWRegisterForEvent";
            $szFunction = "$szJsFunctionName();\n";
            $aReturn[$szJsFunctionName] = $szFunction;
        }        

        return $aReturn;
    }
     
    /**
     * draw this widget on the page
     */
    function DrawPublish($szPostEvent = "")
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if (!$this->mbVisible)
            return "<!-- ROIRectTool hidden -->";

        $szReturn = $this->moButton->DrawPublish();

        return $szReturn;
    }
}
?>
