<?php
/**
 * ROIManager Widget class
 *
 * @project     CWC2
 * @revision    $Id: ROIManager.widget.php,v 1.2 2004/05/26 20:44:02 pspencer Exp $
 * @purpose     ROI Manager Widget class.  Allows the user to manage multiple ROIs
 * a rectangular region of interest on the map.  
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once( dirname(__FILE__)."/../Widget.php");

/**
 * ROIManager
 *
 * @desc A widget to manage multiple ROIs
 */
class ROIManager extends CWCWidget
{
    var $mnMode = 1;
    
    /* marquee color is the color that the rectangle is drawn in, default is blue */
    var $mszEdgeColor = "0000FF";
    
    /* marquee width is the width in pixels of the marquee, default is 1 */
    var $mnEdgeWidth = 2;
    
    /* use fill? */
    var $mbFillROI = true;
    
    /* fill color */
    var $mszFillColor = "0000FF";
    
    /* fill opacity */
    var $mnFillOpacity = 25;
    
    /**
     * construct a new ROI Rectangle Tool widget
     */
    function ROIManager()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ROIManager widget allows the user to draw multiple ROIs
EOT;

        $this->maAttributes['MODE'] = new StringAttribute( 'MODE', false );
        $this->maAttributes["EDGECOLOR"] = new HexColorAttribute( "EDGECOLOR", false );
        $this->maAttributes["EDGEWIDTH"] = new IntegerAttribute( "EDGEWIDTH", false, 1 );
        $this->maAttributes["FILLCOLOR"] = new HexColorAttribute( "FILLCOLOR", false );
        $this->maAttributes["FILLOPACITY"] = new IntegerAttribute( "FILLOPACITY", false, 0, 100 );
        $this->maAttributes["FILLROI"] = new BooleanAttribute( "FILLROI", false );
    }
    
    /**
     * 
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        
        if (isset($this->maParams['MODE']))
        {
            if (strcasecmp($this->maParams['MODE'], 'normal') == 0)
            {
                $this->mnMode = 1;
            }
            elseif (strcasecmp($this->maParams['MODE'], 'add') == 0)
            {
                $this->mnMode = 2;
            }
            elseif (strcasecmp($this->maParams['MODE'], 'subtract') == 0)
            {
                $this->mnMode = 3;
            }
        }
        if (isset($this->maParams["EDGECOLOR"]))
            $this->mszEdgeColor = $this->maParams["EDGECOLOR"];
        if (isset($this->maParams["EDGEWIDTH"]))
            $this->mnEdgeWidth = $this->maParams["EDGEWIDTH"];   
        if (isset($this->maParams["FILLCOLOR"]))
            $this->mszFillColor = $this->maParams["FILLCOLOR"];
        if (isset($this->maParams["FILLOPACITY"]))
            $this->mnFillOpacity = $this->maParams["FILLOPACITY"];
        if ($this->mnFillOpacity == 0)
            $this->mbFillROI = false;
        elseif (isset($this->maParams["FILLROI"]))
            $this->mbFillROI = (strcasecmp($this->maParams["FILLROI"], "true") == 0) ? true : false;  
    }
    
    function ParseURL()
    {
        if ($this->isVarSet( 'ROI_MODE' ))
        {
            $this->mnMode = $this->getVar( 'ROI_MODE' );
        }
        
        // return success
        return true;
    }
    
    function GetHTMLHiddenVariables()
    {
        $aReturn = parent::GetHTMLHiddenVariables();
        
        $szVariable = "ROI_MODE";
        $szValue = "<INPUT TYPE=\"HIDDEN\" NAME=\"".$szVariable."\" VALUE=\"".$this->mnMode."\">\n";
        $aReturn[$szVariable] = $szValue;
        
        return $aReturn;
    }
    
    /**
     * GetJavascriptInitFunctions
     *
     * Functions to be called at the end of the load.
     */
    function GetJavascriptInitFunctions()
    {
        $szJsFunctionName = "ROIManagerInit";
        $szFunction = "$szJsFunctionName();\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        $aReturn['InitCWCROIManagerForm'] = 'goCWCROIManager.SetFormObject('.$this->mszHTMLForm.');';
        
        return $aReturn;
    }

    /**
     * javascript include files
     */
    function GetJavascriptIncludeFunctions()
    {
        $aReturn = parent::GetJavascriptIncludeFunctions();
        
        $szVar = "cwc_roi.js";
        $aReturn[$szVar] = '<script src="'.$_SESSION['gszCoreWebPath'].
                            '/widgets/js/cwc_roi.js"></script>';
        
        $szVar = "cwc_dhtml.js";
        $aReturn[$szVar] = '<script src="'.$_SESSION['gszCoreWebPath'].
                            '/widgets/js/cwc_dhtml.js"></script>';
        return $aReturn;
    }

    /**
     * @desc general javascript functions
     */
    function GetJavascriptFunctions()
    {
        $aReturn = parent::GetJavascriptFunctions();

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;
          
        $minX = $this->moMapObject->oMap->extent->minx;
        $maxX = $this->moMapObject->oMap->extent->maxx;
        $minY = $this->moMapObject->oMap->extent->miny;
        $maxY = $this->moMapObject->oMap->extent->maxy;
        
        $width = $this->moMapObject->oMap->width;
        $height = $this->moMapObject->oMap->height;
        
        if ( isset( $_SESSION['gszCoreWebPath'] ) )
            $szTmpCoreWebPath = $_SESSION['gszCoreWebPath'];
        else
            $szTmpCoreWebPath = "";
        
        $szRendererURL = $szTmpCoreWebPath."/widgets/ROIManager/ROIRenderer.php?".SID;
                
        $szName = 'ROIManagerInit';
        $szFunction = <<<EOT
function {$szName}()
{
    var x = CWCDHTML_FindObjectPosX( CWCDHTML_GetImage('mapFrameTL'));
    var y = CWCDHTML_FindObjectPosY( CWCDHTML_GetImage('mapFrameTL'));
    goCWCROIManager.SetPixelExtents( x, y,  x+{$width}, y+{$height})
    goCWCROIManager.SetGeoExtents( {$minX}, {$minY}, {$maxX}, {$maxY});
    goCWCROIManager.SetRendererURL( "{$szRendererURL}" );
    goCWCROIManager.szEdgeColor = "{$this->mszEdgeColor}";
    goCWCROIManager.nEdgeWidth = {$this->mnEdgeWidth};
    goCWCROIManager.szFillColor = "{$this->mszEdgeColor}";
    goCWCROIManager.nFillOpacity = {$this->mnFillOpacity};
    goCWCROIManager.bUseFill = {$this->mbFillROI};
    
    ROIManagerCreateDHTMLLayers();
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        
        $szName = 'ROIManagerCreateDHTMLLayers';
        $szFunction = <<<EOT
function {$szName}()
{
    var szRendererURL = goCWCROIManager.GetRendererURL();
    var x = goCWCROIManager.pixMinX;
    var y = goCWCROIManager.pixMinY;
    var width = goCWCROIManager.pixMaxX - x;
    var height = goCWCROIManager.pixMaxY - y;
    var content = '<img name="ROIRenderer" id="ROIRenderer" src="' + szRendererURL + '&mode=0" border="0" width="' + width + '" height="' + height + '"' + 'onmouseover="MapWCaptureMouse();"onmouseout="MapWReleaseMouse()"' + '>' ;
    CWCDHTML_CreateLayer(gROIRenderer, x, y, width, height, true, content);
    CWCDHTML_HideLayer( gROIRenderer );
    CWCDHTML_SetLayerZOrder( gROIRenderer, 12 );
    if (CWCIsIE)
    {
        CWCDHTML_SetLayerOpacity( gROIRenderer, goCWCROIManager.nFillOpacity );
    }
}
EOT;
        $aReturn[$szName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetJavascriptOnLoadFunctions
     *
     * Return JS code to be run in the onload function
     */
    function GetJavascriptOnloadFunctions()
    {
        $aReturn = array();
      
        return $aReturn;
    }

    
    /**
     * GetJavascriptVariables
     *
     * Return JS global variables and global code.
     */
    function GetJavascriptVariables()
    {
        $aReturn = array();

        $szVariable = "gROIRenderer";
        $szValue = " var $szVariable = \"gROIRenderer\";\n";
        $aReturn[$szVariable] = $szValue;
        
        return $aReturn;
    }
}
?>
