<?php
/**
 * ROICircleTool Widget class
 *
 * @project     CWC2
 * @revision    $Id: ROICircleTool.widget.php,v 1.7 2004/05/26 20:43:55 pspencer Exp $
 * @purpose     ROI Circle Tool Widget class.  Allows the user to select
 * a circular region of interest on the map.  
 * @author      DM Solutions Group (bronsema@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002-2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
 * ROICircleTool
 *
 * @desc A widget to draw a circular Region of Interest
 */
class ROICircleTool extends CWCWidget
{
    /* the button that is the interface for this widget */
    var $moButton;
    var $mnNumPoints = 12;  // default number of points
    
    /**
     * construct a new ROI Circle Tool widget
     */
    function ROICircleTool()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        // set the attributes
        $this->maAttributes["NUMBEROFPOINTS"] = new IntegerAttribute( "NUMBEROFPOINTS", false, 0 );        
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ROICircleTool widget allows the user to draw a circular region
of interest on the map interface.
EOT;
        $this->moButton = new CWCButton( $this );
    }
    
    /**
     * 
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('ROICircleTool'.$this->mnId );
    }
    
    /**
     * pass URL to button
     */
    function  ParseURL()
    {
        return $this->moButton->ParseURL();
    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $szCmd = '';
        if ($this->isVarSet('NAV_CMD'))
            $szCmd = $this->getVar('NAV_CMD');
        $szVariable = "NAV_CMD";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "ROI_TOOL_LOCKED";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"0\">\n";
        $aReturn[$szVariable] = $szValue;
        
        return $aReturn;
    }
    
    /**
     * GetJavascriptInitFunctions
     *
     * Functions to be called at the end of the load.
     */
    function GetJavascriptInitFunctions()
    {
        $aReturn = $this->moButton->GetJavascriptInitFunctions();

        $szJsFunctionName = "ROICircleToolInit";
        $szFunction = "$szJsFunctionName();\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        $aReturn['InitCWCROIManagerForm'] = 'goCWCROIManager.SetFormObject('.$this->mszHTMLForm.');';
        
        return $aReturn;
    }

    /**
     * javascript include files
     */
    function GetJavascriptIncludeFunctions()
    {
        $aReturn = parent::GetJavascriptIncludeFunctions();
        
        $szVar = "cwc_roi.js";
        $aReturn[$szVar] = '<script src="'.$_SESSION['gszCoreWebPath'].
                            '/widgets/js/cwc_roi.js"></script>';
        
        $szVar = "cwc_dhtml.js";
        $aReturn[$szVar] = '<script src="'.$_SESSION['gszCoreWebPath'].
                            '/widgets/js/cwc_dhtml.js"></script>';
        return $aReturn;
    }

    /**
     * @desc javascript mousemove functions
     */
    function GetJavascriptOnMouseMoveFunctions()
    {
        $aReturn = parent::GetJavascriptOnMouseMoveFunctions();
        
        $aReturn['ROICircleTool'] = 'ROICircleToolMouseMove(e);';

        return $aReturn;
    }

    /**
     * @desc general javascript functions
     */
    function GetJavascriptFunctions()
    {
        $aReturn = parent::GetJavascriptFunctions();

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;
          
        // get the chameleon images url
        $szImagesURL = trim(str_replace("\\", '/', $_SESSION['gszCoreWebPath']));
        $szImagesURL = substr( $szImagesURL, -1 ) == '/' ? $szImagesURL.'skins/default/images/' : 
                                                            $szImagesURL.'skins/default/images/';
        // determine the number of points to use
        if ( isset($this->maParams["NUMBEROFPOINTS"] ) )
            $nPoints = intval( $this->maParams["NUMBEROFPOINTS"] );
        else
            $nPoints = $this->mnNumPoints;
            
        // add JSAPI mode functions  
        if ($bCWCJSAPI)
        {
            $szJsFunctionName = "ROICircleToolWRegisterForEvent";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to register events when the layers change (JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(MAP_EXTENT_CHANGED, "ROICircleToolWExtentChanged");
    goCWCJSAPI.RegisterEvent(MAP_PROJECTION_CHANGED, "ROICircleToolWExtentChanged");
}
EOT;

           $aReturn[$szJsFunctionName] = $szFunction;
           $szJsFunctionName = "ROICircleToolWExtentChanged";
           $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the extent is changed (JSAPI)
 */
function {$szJsFunctionName}()
{
    // re-draw the ROI
    goCWCROIManager.SetGeoExtents( goCWCJSAPI.oMap.minx, goCWCJSAPI.oMap.miny, 
                                    goCWCJSAPI.oMap.maxx, goCWCJSAPI.oMap.maxy );
    goCWCROIManager.Redraw();
}
EOT;
            $aReturn[$szJsFunctionName] = $szFunction;

        }            
          
        $nId = $this->mnId;
        $szName = 'ROICircleTool'.$nId;
        $szFunction = <<<EOT
function {$szName}()
{
    goCWCROIManager.SetROITool('{$nId}');
}
EOT;
        $aReturn[$szName] = $szFunction;

        $szName = 'ROICircleToolInit';
        $szFunction = <<<EOT
function {$szName}()
{

    ROICircleToolCreateDHTMLLayers();
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROICircleToolCreateDHTMLLayers';
        $szFunction = <<<EOT
function {$szName}()
{
    var content = "";

    content = '<img name="ROICircleImgCenter" src="{$szImagesURL}ruler_node.gif" width=7 height=7 border="0">';
    CWCDHTML_CreateLayer(gROICircleCenter, 7, 7, 0, 0, false, content);
    //content = '<img name="ROICircleImgCenter" src="{$szImagesURL}a_pixel.gif" width=gMapWiWidth height=gMapWiHeight border="0">';
    //CWCDHTML_CreateLayer(gROICircleCenter, gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,  false, content);
    
    // loop and create circle layers
    for ( var i=1; i<={$nPoints}; i++ )
    {
        eval( 'content = \"<img name=ROICircleLayer' + i + ' src={$szImagesURL}ruler_pix.gif width=6 height=6 border=0>";' );
        eval( 'CWCDHTML_CreateLayer(gROICircleLayer' + i + ' , 6, 6, 0, 0, false, content);' );
        eval( 'CWCDHTML_SetLayerZOrder(gROICircleLayer' + i + ' , 20);' );
    }
}
EOT;
        $aReturn[$szName] = $szFunction;
        
                
        $szObjectJS = "    var jsObj;\n";

        /**
         * TODO: this does not reconstitute the points associated with the
         * ROI tool because this is complicated ;)  In reality, the points may
         * not be at valid locations.  The only reason to reconstitute the points
         * would be to enable editing, which can't happen
         *
         * But ... we do have to re-create the DHTML layer references to fix a bug
         * in the Hide() function of the circle tool ...
         */
        if (isset($_SESSION['ROIRENDERER']))
        {
            $nROI = count($_SESSION['ROIRENDERER']);
            for ($i=0; $i<$nROI; $i++)
            {
                $aROI = $_SESSION['ROIRENDERER'][$i];
                if ($aROI['type'] == 'circle')
                {
                    $szObjectJS .= "    goCWCROIManager.SetMode(".
                                   $aROI['mode'] . ");\n";
                    $szObjectJS .= "    jsObj = new CWCCircleROI(".$nPoints.");\n";
                    $szObjectJS .= "    jsObj.edgeColor = \"".$aROI['edgecolor']."\";\n";
                    $szObjectJS .= "    jsObj.edgeWidth = ".$aROI['edgewidth'].";\n";
                    $szObjectJS .= "    jsObj.fillLayer = goCWCROIManager.bUseFill;\n";
                    $szObjectJS .= "    jsObj.fillColor = \"".$aROI['fillcolor']."\";\n";
                    $szObjectJS .= "    jsObj.fillOpacity = ".$aROI['fillopacity'].";\n";
                    $szObjectJS .= "    // build point layers\n";
                    $szObjectJS .= "    for(var i=1; i<={$nPoints}; i++)\n";
                    $szObjectJS .= "    {\n";
                    $szObjectJS .= "        eval( 'jsObj.Layer' + i + ' = gROICircleLayer' + i + ';');\n";
                    $szObjectJS .= "    }\n";
                    $szObjectJS .= "    jsObj.centerLayer = gROICircleCenter;\n";
                    $szObjectJS .= "    goCWCROIManager.Insert( jsObj, $i );\n";
                }
            }
            if (strlen( $szObjectJS ) > 0)
            {
                $szObjectJS .= "    goCWCROIManager.UpdateLayerVisibility();\n";
            }
        }


        $szName = 'ROICircleToolInitObjects';
        $szFunction = <<<EOT
function {$szName}()
{
{$szObjectJS}
}
EOT;
        $aReturn[$szName] = $szFunction;

        
        $szName = 'ROICircleToolStartZoomBox';
        $szFunction = <<<EOT
function {$szName}()
{
    goROICircleObj = new CWCCircleROI({$nPoints});
    goROICircleObj.centerNodeImageWidth = 7;
    goROICircleObj.nodeImageWidth = 6;
    goROICircleObj.left = gMapWhspc;
    goROICircleObj.top = gMapWvspc;
    goROICircleObj.right = gMapWhspc + gMapWiWidth;
    goROICircleObj.bottom = gMapWvspc + gMapWiHeight;
    goROICircleObj.edgeColor = goCWCROIManager.szEdgeColor;
    goROICircleObj.edgeWidth = goCWCROIManager.nEdgeWidth;
    goROICircleObj.fillLayer = goCWCROIManager.bUseFill;
    goROICircleObj.fillColor = goCWCROIManager.szFillColor;
    goROICircleObj.fillOpacity = goCWCROIManager.nFillOpacity;  
    
    // build point layers
    for(var i=1; i<={$nPoints}; i++)
    {
        eval( 'goROICircleObj.Layer' + i + ' = gROICircleLayer' + i + ';');
    }
    goROICircleObj.centerLayer = gROICircleCenter;
    
    goROICircleObj.Show();
    
    gROICircleToolx2 = gROICircleToolx1 + 1;
    gROICircleTooly2 = gROICircleTooly1 + 1;
    
    ROICircleToolUpdateZoomBox();
    
    return true;
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROICircleToolUpdateZoomBox';
        $szFunction = <<<EOT
function {$szName}()
{
    goROICircleObj.Draw();
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROICircleToolStopZoomBox';
        $szFunction = <<<EOT
function {$szName}()
{
    goCWCROIManager.Add( goROICircleObj );
    goROICircleObj.Hide();
    goROICircleObj = null;
    return true;
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROICircleToolMouseDown';
        $szFunction = <<<EOT
function {$szName}(e)
{
    // skip if not on map
    if ( !MapWinsideMap() )
    {
        gROICircleDragging = false;
        return true;
    }
    
    // skip if locked
    if ( {$this->mszHTMLForm}.ROI_TOOL_LOCKED.value == 1 )
        return true;
        
    ROICircleToolGetMousePosition(e);

    if (gROIToolmouseX >=0 && gROIToolmouseY >=0)
    {
        gROICircleToolx1 = gROIToolmouseX;
        gROICircleTooly1 = gROIToolmouseY;
        
        ROICircleToolStartZoomBox();
        gROICircleDragging = true;
    } 
    return false;
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROICircleToolMouseUp';
        $szFunction = <<<EOT
function {$szName}(e)
{
    // skip if not on map
    // skip if locked
    if ( !gROICircleDragging ||
         {$this->mszHTMLForm}.ROI_TOOL_LOCKED.value == 1  )
        return true;
        
    // lock the tool on a timer
    {$this->mszHTMLForm}.ROI_TOOL_LOCKED.value = 1;
    setTimeout( "ROICircleToolUnlockTool()", 1000 );
        
    ROICircleToolGetMousePosition(e);

    if (gROIToolmouseX >=0 && gROIToolmouseY >=0)
    {
        gROICircleToolx2 = gROIToolmouseX;
        gROICircleTooly2 = gROIToolmouseY;
        ROICircleToolStopZoomBox();
        
        gROICircleDragging = false;
    } 
    return false;
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        $szName = 'ROICircleToolGetMousePosition';
        $szFunction = <<<EOT
function {$szName}(e)
{
    if (CWCIsNav4 || CWCIsNav6) // Netscape
    {                
        gROIToolmouseX = e.pageX;
        gROIToolmouseY = e.pageY;
    } 
    else if (CWCIsIE) // IE
    {            
        gROIToolmouseX = event.clientX + document.body.scrollLeft;
        gROIToolmouseY = event.clientY + document.body.scrollTop;
    } 
    else 
    {                              // Don't know
        gROIToolmouseX = gROIToolmouseY = 0;
    }
    return true;
}
EOT;
        $aReturn[$szName] = $szFunction;
        $szName = 'ROICircleToolMouseMove';
        $szFunction = <<<EOT
function {$szName}(e)
{
    ROICircleToolGetMousePosition(e);
    
    if (gROIToolmouseX >=0 && gROIToolmouseY >=0 &&
        {$this->mszHTMLForm}.NAV_CMD != null &&
        {$this->mszHTMLForm}.NAV_CMD.value == "ROI_TOOL" &&
        {$this->mnId} == goCWCROIManager.GetROITool() )
    {
        document.onmousedown = ROICircleToolMouseDown;
        document.onmouseup = ROICircleToolMouseUp;
        if (gROICircleDragging)
        {
            gROICircleToolx2 = gROIToolmouseX;
            gROICircleTooly2 = gROIToolmouseY;
            ROICircleToolUpdateZoomBox();
        }    
    }
    else
    {
    }
    return false;
}
EOT;
        $aReturn[$szName] = $szFunction;

        $szName = 'ROICircleToolUnlockTool';
        $szFunction = <<<EOT
function {$szName}()
{
    // reset the lock
    {$this->mszHTMLForm}.ROI_TOOL_LOCKED.value = 0;
    return null;
}
EOT;
        $aReturn[$szName] = $szFunction;
        
        return $aReturn;
    }

    /**
     * GetJavascriptVariables
     *
     * Return JS global variables and global code.
     */
    function GetJavascriptVariables()
    {
        $aReturn = array();
        
        $szVariable = "gROIToolmouseX";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROIToolmouseY";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROICircleToolx1";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROICircleTooly1";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROICircleToolx2";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROICircleTooly2";
        $szValue = " var $szVariable = 0;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gROICircleDragging";
        $szValue = " var $szVariable = false;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "goROICircleObj";
        $szValue = " var $szVariable = null;\n";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "gROICircleCenter";
        $szValue = " var $szVariable = \"gROICircleCenter\";\n";
        $aReturn[$szVariable] = $szValue;
        
        // determine the number of points to use
        if ( isset($this->maParams["NUMBEROFPOINTS"] ) )
            $nPoints = intval( $this->maParams["NUMBEROFPOINTS"] );
        else
            $nPoints = $this->mnNumPoints;
        
        for ( $i=1; $i<=$nPoints; $i++ )
        {
            $szVariable = "gROICircleLayer$i";
            $szValue = " var $szVariable = \"gROICircleLayer$i\";\n";
            $aReturn[$szVariable] = $szValue;
        }
        
        return $aReturn;
    }
    
    /**
     * return an array of javascript functions needed by the Ruler widget
     * and called when the page is loaded. 
     * @return array of name = function values
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = parent::GetJavascriptOnLoadFunctions();

        $aReturn["ROICircleToolInitObjects"] = "    ROICircleToolInitObjects();\n";
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
            $szJsFunctionName = "ROICircleToolWRegisterForEvent";
            $szFunction = "$szJsFunctionName();\n";
            $aReturn[$szJsFunctionName] = $szFunction;
        }          

        return $aReturn;
    }
     
    /**
     * draw this widget on the page
     */
    function DrawPublish($szPostEvent = "")
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if (!$this->mbVisible)
            return "<!-- ROICircleTool hidden -->";

        $szReturn = $this->moButton->DrawPublish();

        return $szReturn;
    }
}
?>
