<?php
/**
 * Query Widget class
 *
 * @project     CWC2
 * @revision    $Id: Query.widget.php,v 1.3 2004/04/25 19:46:29 pspencer Exp $
 * @purpose     Query Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../NavTool.php");
include_once( COMMON."wrapper/map_query.php" );
include_once( dirname(__FILE__)."/../Popup.php");

/**
 * a navtool that displays query results at the clicked location
 */
class Query extends NavTool
{
    var $moPopup;
    var $mnRadius = 1;
    var $mnMaxFeatures = "";
    var $mszImagePath = "images/tool_query_off.gif";
    var $mszSelectedImagePath = "images/tool_query_on.gif";
    var $mszHoverImagePath = "images/tool_query_hover.gif";
    var $mszImageTip = "Zoom In";
    var $mbIncludeEmptyResults = false;

    /**
     * construct a new query widget
     */
    function Query()
    {
        // invoke constructor of parent
        parent::NavTool();

        $this->NavTool();
        $this->SetNavCommand("QUERY");
        $this->mnAllowRectangle = 0;
        $this->moPopup = new CWCPopup($this);
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."widgets/Query/QueryResults.phtml";
        $this->maAttributes["RADIUS"] = new IntegerAttribute( "RADIUS", false, 1 );
        $this->maAttributes["MAXFEATURES"] = new IntegerAttribute( "MAXFEATURES", false, 1 );
        $this->maAttributes["INCLUDEEMPTYRESULTS"] = new BooleanAttribute( "INCLUDEEMPTYRESULTS", false );
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Query widget displays a GetFeatureInfo query result for each visible layer
at the point the user clicks.
EOT;

    }

    /**
     * initialize default values for this widget
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["RADIUS"]))
            $this->mnRadius = strtoupper($this->maParams["RADIUS"]);
        if (isset($this->maParams["MAXFEATURES"]))
            $this->mnMaxFeatures = strtoupper($this->maParams["MAXFEATURES"]);
        if (isset($this->maParams["MAXFEATURES"]))
            $this->mnMaxFeatures = strtoupper($this->maParams["MAXFEATURES"]);
        if (isset($this->maParams["INCLUDEEMPTYRESULTS"]))
        {
            $this->mbIncludeEmptyResults = strcasecmp($this->maParams["INCLUDEEMPTYRESULTS"], "true") == 0 ? true : false;
        }
        $this->moPopup->InitDefaults();    }

    /**
     * get javascript mousemove functions
     */
    function GetJavascriptOnMouseMoveFunctions()
    {
        $aReturn = array();
        $szJsFunctionName = "QueryWMouseMove";
        $szFunction = "$szJsFunctionName(e);\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }


    /**
     * get general javascript functions
     */
    function GetJavascriptFunctions()
    {
        $aReturn = parent::GetJavascriptFunctions();
        
        $szSessionName = 'QUERYPOPUPSTYLERESOURCE';

        if (isset($this->maParams['POPUPSTYLERESOURCE']) &&
            $this->maParams['POPUPSTYLERESOURCE'] != "" )
        {
            $_SESSION[$szSessionName] = $this->maParams['POPUPSTYLERESOURCE'];
        }
        elseif (isset($this->maParams['STYLERESOURCE']))
        {
            $_SESSION[$szSessionName] = $this->maParams['STYLERESOURCE'];
        }
        else
        {
            $_SESSION[$szSessionName] = "";
        }

        $szRadius = $this->mnRadius;
        if ($szRadius != "")
            $szRadius = "&RADIUS=".$szRadius;

        $szMaxFeatures = $this->mnMaxFeatures;
        if ($szMaxFeatures != "")
            $szMaxFeatures = "&FEATURE_COUNT=".$szMaxFeatures;

        if ($this->mbIncludeEmptyResults)
            $szIncludeEmpty = "&include_empty=true";
        else
            $szIncludeEmpty = "&include_empty=false";
        
        $this->moPopup->mszParam = $szRadius.$szMaxFeatures.$szIncludeEmpty;

        $szPopupName = $this->moPopup->GetPopupName();
        $szPopupURL = $this->moPopup->GetPopupURL();
        $szPopupOptions = $this->moPopup->GetPopupOptions();

        $szJsFunctionName = "QueryWMouseClick";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mouse moves for the Query widget.
 */
function {$szJsFunctionName}(e)
{
    if ({$this->mszHTMLForm}.NAV_CMD.value != "{$this->mszCmd}")
        return true;

    MapWgetMouse(e);
    if ( !MapWinsideMap() )
        return true;

    szPopupURL = "{$szPopupURL}";
    szPopupName = "{$szPopupName}";
    szPopupOptions = "{$szPopupOptions}";

    nX = {$this->mszHTMLForm}.MAP_CURSOR_POS_X.value;
    nY = {$this->mszHTMLForm}.MAP_CURSOR_POS_Y.value;
    szNav = "NAV_INPUT_COORDINATES=" + nX + "," + nY;
    szPopupURL = szPopupURL + "&" + szNav;

    window.open( szPopupURL, szPopupName, szPopupOptions );
    return true;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "QueryWMouseMove";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mouse moves for the Query widget.
 */
function {$szJsFunctionName}(e)
{

    //make sure that the forms varaibales are initialized.
    //It seems like that in IE, the mouse move may be called before.
    if({$this->mszHTMLForm} == null ||
      {$this->mszHTMLForm}.NAV_CMD == null ||
      {$this->mszHTMLForm}.NAV_CMD.value != "QUERY")
      return true;

    //document.onmousedown = QueryWMouseClick;
    document.onmouseup = QueryWMouseClick;

    var x = (navigator.appName == "Netscape")? e.pageX : event.x+document.body.scrollLeft;
    var y = (navigator.appName == "Netscape")? e.pageY : event.y+document.body.scrollTop;
    if ((navigator.appName == "Netscape") && e.target!=document)
      routeEvent(e);

    return true;

}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;


        return $aReturn;
    }

}
?>
