<?php
/**
 * ProjectionLabel Widget class
 *
 * @project     CWC2
 * @revision    $Id: ProjectionLabel.widget.php,v 1.3 2004/07/08 15:58:58 pspencer Exp $
 * @purpose     ProjectionLabel Widget class
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");

/**
 * ProjectionLabel
 *
 * @desc Displays a label for the current projection
 */
class ProjectionLabel extends CWCWidget
{
    var $moLabel;
    var $mszClass = "CWCProjectionLabelWidgetClass";
    var $mszStyle = "";
    var $mnDefaultTextFieldSize = 50;

    /**
     * construct a new ProjectionLabel widget
     */
    function ProjectionLabel( )
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ProjectionLabel widget displays the name of the current projection
from those defined in a common resource called "projection".
The structure of the common resource is: &ltprojection name="human name"
srs="epsg code"/&gt;.  This structure is shared with the
projection selector widget if used.
EOT;

        $this->moLabel = new CWCLabel($this);
        $this->maAttributes["WIDGETCLASS"] = new StringAttribute( "WIDGETCLASS", false );
        $this->maAttributes["WIDGETSTYLE"] = new StringAttribute( "WIDGETSTYLE", false );
        $this->maAttributes["TEXTFIELDSIZE"] = new IntegerAttribute( "TEXTFIELDSIZE", false, 0 );
    }

    /**
     * initialize default values
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["WIDGETCLASS"]))
            $this->mszClass = strtoupper($this->maParams["WIDGETCLASS"]);
        if (isset($this->maParams["WIDGETSTYLE"]))
            $this->mszStyle = strtoupper($this->maParams["WIDGETSTYLE"]);
        if (isset($this->maParams["TEXTFIELDSIZE"]))
            $this->mnDefaultTextFieldSize = strtoupper($this->maParams["TEXTFIELDSIZE"]);
            
    }
    
    /**
     * return an array of javascript functions needed by ProjectionLabel widget
     * @return array of name = function values
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        
        $poMap = $this->moMapObject->oMap;

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if ($bCWCJSAPI)
        {
            $szJsFunctionName = "ProjectionLabelWRegisterForEvent";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to register and even when the map extents changes (JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(MAP_PROJECTION_CHANGED, "ProjectionLabelWMapProjectionChanged");
}
EOT;
    
       $aReturn[$szJsFunctionName] = $szFunction;

       $szJsFunctionName = "ProjectionLabelWMapProjectionChanged";
       $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the projection is changed to update the projection label(JSAPI)
 */
function {$szJsFunctionName}()
{
    // loop through the array of valid projections and match to current
    for (i=0; i<goCWCJSAPI.oMap.validprojections.length; i++)
    {
        if ( goCWCJSAPI.oMap.validprojections[i] == goCWCJSAPI.oMap.projection )
        {
            // match was found so get the text/name associated with it
            {$this->mszHTMLForm}.txtProjectionLabel.value = goCWCJSAPI.oMap.validprojectionNames[i];
            return;
        }
    }
    
    // if function gets here then error
    {$this->mszHTMLForm}.txtProjectionLabel.value = 'Error: Projection Label not found.';
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;

       }

       return $aReturn;
    }


    /**
     * return an array of javascript functions needed by Extent widget
     * and called when the page is loaded. 
     * @return array of name = function values
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();
        
        $aReturn = parent::GetJavascriptOnLoadFunctions();

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
             $szJsFunctionName = "ProjectionLabelWRegisterForEvent";
             $szFunction = "$szJsFunctionName();\n";
             $aReturn[$szJsFunctionName] = $szFunction;
        }

        return $aReturn;
    }    

    /**
     * draw this widget
     */
    function DrawPublish()
    {

        if (!$this->mbVisible)
            return "<!-- ProjectionLabel is hidden -->";

        $szValue = "";
        $szClass = "";
        $szStyle = "";

        $szMapProj = $this->moMapObject->oMap->getprojection();
        if (strncasecmp($szMapProj, "AUTO", 4) == 0) //assuming AUTO:42002,90001,45,75
        {
            $aProjElem = split(",", $szMapProj);
            $szValue = $aProjElem[0];
        }
        else //assuming init:epsg....
          $szValue = substr($this->moMapObject->oMap->getprojection(), 5 );

        if (isset( $this->maSharedResourceWidgets["projection"]->maszContents["PROJECTION"]))
        {
            foreach( $this->maSharedResourceWidgets["projection"]->maszContents["PROJECTION"] as $aProj )
            {
                if (strcasecmp($aProj["SRS"],$szValue) == 0)
                {
                    $szValue = $aProj["NAME"];
                    break;
                }
            }
        }

        $nSize = $this->mnDefaultTextFieldSize;
        if (isset($this->maParams["TextFieldSize"]))
            $nSize = strtoupper($this->maParams["TextFieldSize"]);            
            
        $szClass = "";
        if ( strlen($this->mszClass) > 0 )
            $szClass = " CLASS=\"$this->mszClass\"";
        $szStyle = "";
        if ( strlen($this->mszStyle) > 0 )
            $szStyle = " STYLE=\"$this->mszStyle\"";

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
            $szContents="<input".$szClass.$szStyle." type=\"text\" name=\"txtProjectionLabel\" value=\"".$szValue."\" size=\"".strlen($szValue)."\" readonly>";
        else
            $szContents="<div".$szClass.$szStyle." name=\"txtProjectionLabel\">".$szValue."</div>";

        return $this->moLabel->DrawPublish( $szContents );



    }
}
?>
