<?php
/**
 * PrintPopup Widget class
 *
 * @project     CWC2
 * @revision    $Id: PrintWidget.widget.php,v 1.7 2004/07/08 17:49:08 pspencer Exp $
 * @purpose     PrintWidget Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * PrintPopup
 *
 * @desc PrintWidget widget class
 */
class PrintWidget extends CWCWidget
{
    var $mszTemplate;      /// [string]

    var $moButton;     /// Button object
    var $moPopup;          /// Popup object


    /**
     * PrintWidget
     *
     * Constctor method for the PrintPopup widget.
     */
    function PrintWidget()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/Print.dbf";

        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The PrintPopup widget displays a popup dialog that allows the user to
create a printable version of the map with some additional cartographic
annotations.
EOT;

        $this->moButton = new CWCButton($this);
        $this->moPopup = new CWCPopup($this);
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/PrintWidget/production.phtml";

        $this->maAttributes["TEMPLATE"] = new StringAttribute( "TEMPLATE", false );
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $szTemplate = $this->GetValue("Template");
        if ($szTemplate != "")
        {
            $this->moButton->SetOnClick("clickPrintPopup");
        }
        else
        {
            $this->moButton->SetOnClick("errorPrintPopup", trim($this->moMLT->get("0", "ERROR: No legend template specified.")));
        }
    }

    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        return $aReturn;
    }
    
    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $szTemplate = "";
        if (isset($this->maParams["TEMPLATE"]))
            $this->maParams["TEMPLATE"];

        if ($szTemplate != "")
        {
            $this->moPopup->mszParam = "&szTemplate=".urlencode($szTemplate);
        }

        $this->moPopup->mszParam .= "&MapWidth=".$this->moMapObject->oMap->width;
        $this->moPopup->mszParam .= "&MapHeight=".$this->moMapObject->oMap->height;

        $szJsFunctionName = "clickPrintPopup";
        $szFunction = "function $szJsFunctionName()\n" .
         "{\n".
          $this->moPopup->DrawPublish()."\n".
        "return;\n" .
        "}\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "errorPrintPopup";
        $szFunction = "function $szJsFunctionName(obj, szError)\n" .
         "{\n".
          "    alert(szError);"."\n".
        "    return;\n" .
        "}\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code to display the link to the legend popup
     */
    function DrawPublish()
    {
        //if a wait image is specified, set it in the session for the popup
        if (!isset($_SESSION['WAITIMAGE']))
        {
            $oApp = GetChameleonApplication();
            if (isset($this->maSharedResourceWidgets["WaitImage"]->maszContents["WAITIMAGE"]))
            {
                foreach($this->maSharedResourceWidgets["WaitImage"]->maszContents["WAITIMAGE"] as $aWaitImage)
                {
                    if (isset($aWaitImage["LANGUAGE"]) && $aWaitImage["LANGUAGE"] == $_SESSION["gszCurrentLanguage"])
                    {
                        if (isset($aWaitImage["WAITIMAGE"]))
                        {
                            $wait = $aWaitImage["WAITIMAGE"];
                            if (strcasecmp( "http://", substr($wait, 0, 7)) == 0 ||
                                strcasecmp( "/", substr($wait, 0, 1)) == 0 ||
                                strcasecmp( ":", substr($wait, 1, 1)) == 0 )
                                $_SESSION["WAITIMAGE"] = $aWaitImage["WAITIMAGE"];
                            else
                                $_SESSION["WAITIMAGE"] = $oApp->findFile($aWaitImage["WAITIMAGE"]);
                                $_SESSION["WAITIMAGE"] = $oApp->fileSystemToURL( $_SESSION['WAITIMAGE'] );
                        }
                        if (isset($aWaitImage["WAITIMAGEWIDTH"]))
                            $_SESSION["WAITIMAGEWIDTH"] = $aWaitImage["WAITIMAGEWIDTH"];
                        if (isset($aWaitImage["WAITIMAGEHEIGHT"]))
                            $_SESSION["WAITIMAGEHEIGHT"] = $aWaitImage["WAITIMAGEHEIGHT"];
                    }
                }
            }
        }


        $szReturn = parent::DrawPublish();

        $szReturn = $this->moButton->DrawPublish();

        return $szReturn;
    }
}
?>
