<?php
/**
 * Popup Class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     Helper class to manage Popup attributes
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * helper class for widgets that want to popup another window through a
 * javascript call
 */
class CWCPopup
{
    var $moParent;
    var $miWidth = 200;
    var $miHeight = 200;
    var $mbToolbar = true;
    var $mbMenubar = true;
    var $mbStatus = true;
    var $mbScrollbars = true;
    var $mbResizable = true;
    var $mszPopupStyleResource = "";

    var $mszLink = "";
    var $mszParam = "";

    /**
     * construct a new popup widget
     */
    function CWCPopup( &$oParent )
    {
        $this->moParent =& $oParent;
        $oParent->maAttributes["POPUPWIDTH"] = new IntegerAttribute( "POPUPWIDTH", true, 0 );
        $oParent->maAttributes["POPUPHEIGHT"] = new IntegerAttribute( "POPUPHEIGHT", true, 0 );
        $oParent->maAttributes["TOOLBAR"] = new BooleanAttribute( "TOOLBAR", false );
        $oParent->maAttributes["MENUBAR"] = new BooleanAttribute( "MENUBAR", false );
        $oParent->maAttributes["STATUS"] = new BooleanAttribute( "STATUS", false );
        $oParent->maAttributes["SCROLLBARS"] = new BooleanAttribute( "SCROLLBARS", false );
        $oParent->maAttributes["RESIZABLE"] = new BooleanAttribute( "RESIZABLE", false );
        $oParent->maAttributes["POPUPSTYLERESOURCE"] = new StringAttribute( "POPUPSTYLERESOURCE", false );
    }

    /**
     * initialize default values
     */
    function InitDefaults()
    {
        $this->SetStyleResource();
    }

    /**
     * construct a URL for the popup
     */
    function GetPopupURL()
    {
        if ((dirname($this->mszLink) == "widgets" ||
            dirname($this->mszLink) == "./widgets") &&
            isset($_SESSION['gszCoreWebPath']))
        {
            $this->mszLink = $_SESSION['gszCoreWebPath']."/widgets/".
                              basename($this->mszLink);
        }

        if (substr($this->mszLink, -1) != "?")
        {
            if (stristr($this->mszLink, "?") === false)
                $this->mszLink .= "?";
            else
                $this->mszLink .= "&";
        }
        return $this->mszLink.SID.$this->mszParam;
    }

    /**
     * get a unique name for this widget to refer to a window by
     */
    function GetPopupName()
    {
        $szName = "popup";
        if (isset($this->moParent->maParams["TYPE"]))
            $szName = $this->moParent->maParams["TYPE"];

        return  $szName."_".
                $this->moParent->mnId."_".session_id();
    }

    /**
     * get the options to apply to the popup window
     */
    function GetPopupOptions()
    {
        // Mandatory values
        if (isset($this->moParent->maParams["POPUPWIDTH"]))
            $this->miWidth = $this->moParent->maParams["POPUPWIDTH"];
        if (isset($this->moParent->maParams["POPUPHEIGHT"]))
            $this->miHeight = $this->moParent->maParams["POPUPHEIGHT"];

        // Optional Values
        if (isset($this->moParent->maParams["POPUPSTYLERESOURCE"]))
            $this->mszPopupStyleResource = $this->moParent->maParams["POPUPSTYLERESOURCE"];
        if (isset($this->moParent->maParams["TOOLBAR"]))
            $this->mbToolbar = $this->moParent->maParams["TOOLBAR"];
        if (isset($this->moParent->maParams["MENUBAR"]))
            $this->mbMenubar = $this->moParent->maParams["MENUBAR"];
        if (isset($this->moParent->maParams["STATUS"]))
            $this->mbStatus = $this->moParent->maParams["STATUS"];
        if (isset($this->moParent->maParams["SCROLLBARS"]))
            $this->mbScrollbars = $this->moParent->maParams["SCROLLBARS"];
        if (isset($this->moParent->maParams["RESIZABLE"]))
            $this->mbResizable = $this->moParent->maParams["RESIZABLE"];

        $szResult = "width=".$this->miWidth.",height=".$this->miHeight.",";

        $szResult .= (($this->mbToolbar == "true") ? "toolbar=yes," : "toolbar=no,");
        $szResult .= (($this->mbMenubar == "true") ? "menubar=yes," : "menubar=no,");
        $szResult .= (($this->mbStatus == "true") ? "status=yes," : "status=no,");
        $szResult .= (($this->mbScrollbars == "true") ? "scrollbars=yes," : "scrollbars=no,");
        $szResult .= (($this->mbResizable == "true") ? "resizable=yes" : "resizable=no");
        return $szResult;
    }

    /**
     * draw the popup javascript call
     */
    function DrawPublish( $szContent = "" )
    {
        $oApp = GetChameleonApplication();
        //pass style resource to the popup
        
        if (isset($this->moParent->maSharedResourceWidgets['PopupCSS']) && !isset($_SESSION['gszCSSFile']))
        {
            $szPopupCSS = $this->moParent->maSharedResourceWidgets['PopupCSS']->getValue("VALUE","popup.css");
            $szPopupCSS = $oApp->findFile( $szPopupCSS );
            $szPopupCSS = $oApp->fileSystemToURL( $szPopupCSS );
            $_SESSION['gszCSSFile'] = $szPopupCSS;
        }
        
        $szResult  = "var wh = window.open('".$this->GetPopupURL().
                     "', '".$this->GetPopupName()."', '".
                     $this->GetPopupOptions()."');".
                     "wh.focus();";

        return $szResult;
    }
    
    function SetStyleResource()
    {
        $szSessionName = strtoupper(get_class( $this->moParent )).'POPUPSTYLERESOURCE';
        if (!isset($_SESSION[$szSessionName]))
        {
            if ( isset( $this->moParent->maParams['POPUPSTYLERESOURCE']) ||
                 isset( $this->moParent->maParams['STYLERESOURCE']) )
            {

                if (isset($this->moParent->maParams['POPUPSTYLERESOURCE']) &&
                    $this->moParent->maParams['POPUPSTYLERESOURCE'] != "" )
                {
                    $_SESSION[$szSessionName] = $this->moParent->maParams['POPUPSTYLERESOURCE'];
                }
                elseif (isset($this->moParent->maParams['STYLERESOURCE']))
                {
                    $_SESSION[$szSessionName] = $this->moParent->maParams['STYLERESOURCE'];
                }
                else
                {
                    $_SESSION[$szSessionName] = "";
                }
            }
        }
        
        if (isset($_SESSION[$szSessionName]) && $_SESSION[$szSessionName] != "")
        {
            if (!isset($_SESSION[$_SESSION[$szSessionName]]))
            {
                $share = $this->moParent->maSharedResourceWidgets[$_SESSION[$szSessionName]]->maszContents;
                $aszStates = array( "normal", "hover", "selected", "disabled" );
                foreach($aszStates as $szState)
                {
                    $aParams = $this->LoadSharedResource( $share, array(), $szState );
                    $_SESSION[$_SESSION[$szSessionName]][$szState] = $aParams; //make a copy in the session.
                }
            }
        }        
    }
    
    /**
     * load a shared resource into an array that contains buttonizer values
     * return the loaded array
     */
    function LoadSharedResource( $share, $aParams = array(), $szState )
    {
        $oApp = GetChameleonApplication();
        //process includes first
        if (isset($share['STATE']))
        {
            foreach( $share["STATE"] as $aszSR )
            {
                if($aszSR["VALUE"] == $szState)
                {
                    $aParams = $this->LoadSharedResource($aszSR["CHILDREN"][0], $aParams, $szState);
                }
            }
        }
        
        if (isset($share["IMAGEWIDTH"][0]["VALUE"]))
            $aParams["width"] = $share["IMAGEWIDTH"][0]["VALUE"];
        
        if (isset($share["IMAGEHEIGHT"][0]["VALUE"]))
            $aParams["height"] = $share["IMAGEHEIGHT"][0]["VALUE"];
        
        if (isset($share["TEXTBUTTONCOLOR"][0]["VALUE"]))
            $aParams["backgroundcolor"] = $share["TEXTBUTTONCOLOR"][0]["VALUE"];
        
        if (isset($share["BACKGROUNDIMAGE"][0]["VALUE"]))
            $aParams["backgroundgraphic"] = $oApp->findFile( $share["BACKGROUNDIMAGE"][0]["VALUE"] );

        if (isset($share["TEXTBUTTONBORDER_TOPLEFT_IMAGE"][0]["VALUE"]))
            $aParams["border_tl_image"] = $oApp->findFile( $share["TEXTBUTTONBORDER_TOPLEFT_IMAGE"][0]["VALUE"] );
        
        if (isset($share["TEXTBUTTONBORDER_TOP_IMAGE"][0]["VALUE"]))
            $aParams["border_t_image"] = $oApp->findFile( $share["TEXTBUTTONBORDER_TOP_IMAGE"][0]["VALUE"] );

        if (isset($share["TEXTBUTTONBORDER_TOPRIGHT_IMAGE"][0]["VALUE"]))
            $aParams["border_tr_image"] = $oApp->findFile( $share["TEXTBUTTONBORDER_TOPRIGHT_IMAGE"][0]["VALUE"] );

        if (isset($share["TEXTBUTTONBORDER_RIGHT_IMAGE"][0]["VALUE"]))
            $aParams["border_r_image"] = $oApp->findFile( $share["TEXTBUTTONBORDER_RIGHT_IMAGE"][0]["VALUE"] );

        if (isset($share["TEXTBUTTONBORDER_TOPLEFT_IMAGE"][0]["VALUE"]))
            $aParams["border_br_image"] = $oApp->findFile( $share["TEXTBUTTONBORDER_BOTTOMRIGHT_IMAGE"][0]["VALUE"] );

        if (isset($share["TEXTBUTTONBORDER_BOTTOM_IMAGE"][0]["VALUE"]))
            $aParams["border_b_image"] = $oApp->findFile( $share["TEXTBUTTONBORDER_BOTTOM_IMAGE"][0]["VALUE"] );

        if (isset($share["TEXTBUTTONBORDER_BOTTOMLEFT_IMAGE"][0]["VALUE"]))
            $aParams["border_bl_image"] =$oApp->findFile(  $share["TEXTBUTTONBORDER_BOTTOMLEFT_IMAGE"][0]["VALUE"] );

        if (isset($share["TEXTBUTTONBORDER_LEFT_IMAGE"][0]["VALUE"]))
            $aParams["border_l_image"] = $oApp->findFile( $share["TEXTBUTTONBORDER_LEFT_IMAGE"][0]["VALUE"] );

        if (isset($share["TEXTBUTTONNUDGE"][0]["VALUE"]))
            $aParams["nudge"] = $share["TEXTBUTTONNUDGE"][0]["VALUE"];
        
        if (isset($share["TEXTBUTTONPADDING"][0]["VALUE"]))
            $aParams["padding"] = $share["TEXTBUTTONPADDING"][0]["VALUE"];
        
        if (isset($share["LABELFONT"][0]["VALUE"]))
            $aParams["labelfont"] = $oApp->findFile( $share["LABELFONT"][0]["VALUE"] );
        
        if (isset($share["LABELFONTSIZE"][0]["VALUE"]))
            $aParams["labelsize"] = $share["LABELFONTSIZE"][0]["VALUE"];
        
        if (isset($share["LABELCOLOR"][0]["VALUE"]))
            $aParams["labelcolor"] = $share["LABELCOLOR"][0]["VALUE"];
        
        if (isset($share["LABELALIGN"][0]["VALUE"]))
            $aParams["labelalign"] = $share["LABELALIGN"][0]["VALUE"];
        
        if (isset($share["LABELANTIALIAS"][0]["VALUE"]))
            $aParams["antialias"] = ($share["LABELANTIALIAS"][0]["VALUE"] == "true" )? true : false;
            
        if (isset($share["IMAGE"]))
            $aParams["graphic"] = $oApp->findFile( $share["IMAGE"][0]['VALUE'] );
            
        if (isset($share["USETEXTBUTTONCACHE"][0]["VALUE"]))
            $aParams['usecache'] = ($share["USETEXTBUTTONCACHE"][0]["VALUE"] == "true" )? true : false;
        
        return $aParams;
    }
}
?>
