<?php
/**
 * Panmap Widget class
 *
 * @project     CWC2
 * @revision    $Id: PanMap.widget.php,v 1.3 2004/05/19 21:18:36 pspencer Exp $
 * @purpose     Pan Map Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../NavTool.php");

/**
 * PanMapWidget
 *
 * @desc PanMap widget.
 */
class PanMap extends NavTool
{
    var $mszImagePath = "images/tool_pan.gif";
    var $mszImageSelectedPath = "images/tool_pan.gif";
    var $mszImageTip = "Pan";

    /**
     * PanMap
     *
     * Constructor. Set the default values.
     */
    function PanMap()
    {
        // invoke constructor of parent
        parent::NavTool();

        $this->NavTool();
        $this->SetNavCommand("PAN_MAP");

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The PanMap widget is a navigation tool that allows the user to drag the
map image to recenter it at a given location.
EOT;
    }


    /**
     * ParseURL
     *
     * Look for the PAN_MAP command and if found do the panning
     * according to the other NAV paramaters.
     */
    function  ParseURL()
    {
        parent::ParseURL();

        $szCmd = "";
        if ($this->isVarSet( "NAV_CMD" ))
            $szCmd = $this->getVar( "NAV_CMD" );

        if ($szCmd == "PAN_MAP" && $this->getVar( "NAV_INPUT_COORDINATES" )!="")
        {
            $poMap = $this->moMapObject->oMap;

            $szInputCoords = $this->getVar( "NAV_INPUT_COORDINATES" );
            $aPixPos = explode(";", $szInputCoords);
            $aPixFirst = explode(",", $aPixPos[0]);
            $aPixLast = explode(",", $aPixPos[1]);

            $nShiftPixX = $aPixLast[0] -  $aPixFirst[0];
            $nShiftPixY = $aPixFirst[1] - $aPixLast[1];

            $dfShiftWidth = $nShiftPixX/$poMap->width;
            $dfShiftHeight = $nShiftPixY/$poMap->height;

            //echo "firstpoint x =" . $aPixFirst[0] . " and last point x = ". $aPixLast[0];
            //echo "firstpoint y =" . $aPixFirst[1] . " and last point y = ". $aPixLast[1];
            //echo " delata pixx=$nShiftPixX and  shift pixel x $dfShiftWidth <br>\n";

            $dfDeltaGeoWidth = $poMap->extent->maxx - $poMap->extent->minx;
            $dfDeltaGeoHeight = $poMap->extent->maxy - $poMap->extent->miny;

            $dfShiftGeoX = $dfShiftWidth * $dfDeltaGeoWidth;
            $dfShiftGeoY = $dfShiftHeight * $dfDeltaGeoHeight;
            $dfShiftGeoX = abs($dfShiftGeoX);
            $dfShiftGeoY = abs($dfShiftGeoY);
            //echo "shift geo x $dfShiftGeoX <br>\n";

            $bInvalid = 0;
            if ($aPixFirst[0] < $aPixLast[0])
            {
                //echo "first x < last x <br>";
                $dfGeoMinX = $poMap->extent->minx - $dfShiftGeoX;
                $dfGeoMaxX = $poMap->extent->maxx - $dfShiftGeoX;
            }
            else if ($aPixFirst[0] > $aPixLast[0])
            {
                //echo "first x > last x <br>";

                $dfGeoMinX = $poMap->extent->minx + $dfShiftGeoX;
                $dfGeoMaxX = $poMap->extent->maxx + $dfShiftGeoX;
            }
            else
              $bInvalid = 1;

            if ($aPixFirst[1] > $aPixLast[1])
            {
                //echo "first y > last y <br>";

                $dfGeoMinY = $poMap->extent->miny - $dfShiftGeoY;
                $dfGeoMaxY = $poMap->extent->maxy - $dfShiftGeoY;
            }
            else if ($aPixFirst[1] < $aPixLast[1])
            {
                //echo "first y < last y <br>";
                $dfGeoMinY = $poMap->extent->miny + $dfShiftGeoY;
                $dfGeoMaxY = $poMap->extent->maxy + $dfShiftGeoY;
            }
            else
              $bInvalid = 1;

            if (!$bInvalid)
            {
                $poMap->setextent($dfGeoMinX, $dfGeoMinY, $dfGeoMaxX, $dfGeoMaxY);
/* -------------------------------------------------------------------- */
/*      Call the reporjectauto function in case the map projection      */
/*      is set to AUTO:XXX. If it is not, the function will do          */
/*      nothing.                                                        */
/* -------------------------------------------------------------------- */
                $this->ReprojectAuto();                    
            }
/* -------------------------------------------------------------------- */
/*      If first and last points are the same, do nothing. The user     */
/*      should alreay have been notfied (alert using js) when this      */
/*      problem occured. So do not send an error message (Bug 2036).    */
/* -------------------------------------------------------------------- */
            //else
            //$_SESSION['gErrorManager']->setError(ERR_WARNING, "When using the PanMap Widget, you should click, hold the mouse down and drag.");
        }
        return true;

    }

    /**
     * GetJavascriptIncludeFunctions
     *
     */
    function GetJavascriptIncludeFunctions()
    {
        $aReturn = array();

        $szJsIncludeName = $_SESSION["gszCoreWebPath"]."/widgets/js/dynlayer.js";
        $szInclude = "<script language=\"JavaScript\" src=\"".$_SESSION["gszCoreWebPath"]."/widgets/js/dynlayer.js\"></script>";
        $aReturn[$szJsIncludeName] = $szInclude;


        $szJsIncludeName = $_SESSION["gszCoreWebPath"]."/widgets/js/drag.js";
        $szInclude = "<script language=\"JavaScript\" src=\"".$_SESSION["gszCoreWebPath"]."/widgets/js/drag.js\"></script>";
        $aReturn[$szJsIncludeName] = $szInclude;

        return $aReturn;
    }

    /**
     * GetJavascriptOnMouseMoveFunctions
     *
     * Returns functions to be called on mouse mouve event.
     */
    function GetJavascriptOnMouseMoveFunctions()
    {
        $aReturn = array();
        $szJsFunctionName = "PanMapWMouseMove";
        $szFunction = "$szJsFunctionName(e);\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }


    /**
     * GetJavascriptOnMouseUpFunctions
     *
     */
    function GetJavascriptOnMouseUpFunctions2()
    {
        $aReturn = array();
        $szJsFunctionName = "PanMapWMouseUp";
        $szFunction = "$szJsFunctionName(e);\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetJavascriptOnMouseDownFunctions
     *
     */
    function GetJavascriptOnMouseDownFunctions2()
    {
        $aReturn = array();
        $szJsFunctionName = "PanMapWMouseDown";
        $szFunction = "$szJsFunctionName(e);\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }


    /**
     * GetJavascriptFunctions
     *
     * Return the JS function associated with the pan.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        $aReturn = parent::GetJavascriptFunctions();

        $poMap = $this->moMapObject->oMap;
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        $szJsFunctionName = "PanMapWInit";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to initialize the pan widget.
 */
function {$szJsFunctionName}(e)
{
    //DynLayerInit();
    maplayer = new DynLayer("MapLayerDiv");
    drag.add(maplayer);
    //alert(maplayer);
    if (is.ie5)
      maplayer.clipInit(0,{$poMap->width}, {$poMap->height},0);

    // for other browsers it's not necessary because the layer in this example
    // is clipped to defaults so I don't have to pass clip values
    else
      maplayer.clipInit();

    //initMouseEvents();

}

EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "PanMapWMouseMove";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mouse moves for the PanMap widget.
 */
function {$szJsFunctionName}(e)
{

    //make sure that the forms varaibales are initialized.
    //It seems like that in IE, the mouse move may be called before.
    if({$this->mszHTMLForm} == null ||
      {$this->mszHTMLForm}.NAV_CMD == null ||
      {$this->mszHTMLForm}.NAV_CMD.value != "PAN_MAP")
      return true;

    if (!MapWinsideMap())
    {
        document.onmousedown = null;
        document.onmouseup = null;
        return true;
    }


    document.onmousedown = PanMapWMouseDown;
    document.onmouseup = PanMapWMouseUp;

    var x = (is.ns)? e.pageX : event.x+document.body.scrollLeft;
    var y = (is.ns)? e.pageY : event.y+document.body.scrollTop;
    if (is.ns && e.target!=document)
      routeEvent(e);

    drag.mouseMove(x,y);
    return true;;

}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;

       $szJsFunctionName = "PanMapWMouseUp";
       $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mouse up for the PanMap widget.
 */
function {$szJsFunctionName}(e)
{
    if({$this->mszHTMLForm}.NAV_CMD.value != "PAN_MAP")
      return true;

    var x = (is.ns)? e.pageX : event.x+document.body.scrollLeft;
    var y = (is.ns)? e.pageY : event.y+document.body.scrollTop;
    if (is.ns && e.target!=document)
      routeEvent(e);
    drag.mouseUp(x,y);
    return true;
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;

$szJsFunctionName = "PanMapWMouseDown";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mouse down for the PanMap widget.
 */
function {$szJsFunctionName}(e)
{
    if({$this->mszHTMLForm}.NAV_CMD.value != "PAN_MAP")
      return true;

    if ((is.ns && e.which!=1) || (is.ie && event.button!=1))
      return true;
    var x = (is.ns)? e.pageX : event.x+document.body.scrollLeft;
    var y = (is.ns)? e.pageY : event.y+document.body.scrollTop;
    if (is.ns && e.target!=document)
      routeEvent(e);
    drag.mouseDown(x,y);
    return false;

}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;

$szErrorMsg = $this->moMLT->get("0", "When using the PanMap Widget, you should click on the map, hold the mouse down and then drag.");

$szJsFunctionName = "PanMapWDragEnd";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the drag ends in PanMap widget.
 */
function {$szJsFunctionName}(x,y)
{
    var nLastPointX = 0;
    var nLastPointY = 0;

    if (x > (gMapWhspc + gMapWiWidth))
      nLastPoinX = gMapWiWidth;
    else if (x < gMapWhspc)
      nLastPointX = 0;
    else
      nLastPointX = gMapWmouseX;

    if (y > (gMapWvspc + gMapWiHeight))
      nLastPointY = gMapWiHeight;
    else if (y < gMapWvspc)
      nLastPointY = 0;
    else
      nLastPointY = gMapWmouseY;

    nFirstPointX = gnPanWFirstPointX;
    nFirstPointY = gnPanWFirstPointY;


    var szCoord = ""+ gnPanWFirstPointX + "," + gnPanWFirstPointY + ";" + nLastPointX + "," + nLastPointY;
    //alert(szCoord);
    {$this->mszHTMLForm}.NAV_INPUT_COORDINATES.value =  szCoord;
    {$this->mszHTMLForm}.NAV_INPUT_TYPE.value = "RECTANGLE";
    if ({$bCWCJSAPI})
    {
        goCWCJSAPI.NAV_INPUT_COORDINATES =  szCoord;
        goCWCJSAPI.NAV_INPUT_TYPE = "RECTANGLE";
    }

    if (gnPanWFirstPointX == nLastPointX && gnPanWFirstPointY == nLastPointY)
    {
        //alert("{$szErrorMsg}");
    }
    else
    {
        if ({$bCWCJSAPI})
          goCWCJSAPI.UpdateNavTools();
        else
        {$this->mszHTMLForm}.submit();
    }
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;


$szJsFunctionName = "PanMapWDragStart";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the drag starts in PanMap widget.
 */
function {$szJsFunctionName}(x,y)
{
    if (gnPanWFirstPointX < 0 && gnPanWFirstPointY < 0)
    {
      gnPanWFirstPointX = gMapWmouseX;
      gnPanWFirstPointY = gMapWmouseY;
    }
    //alert(gnPanWFirstPointX);

}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        if ($bCWCJSAPI)
        {
            $szJsFunctionName = "PanMapWRegisterForEvent";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to register and even when the map extents chnages (JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(MAP_EXTENT_CHANGED, "PanMapWMapExtentsChanged");
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;

 
       $szJsFunctionName = "PanMapWMapExtentsChanged";
       $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mapextents are changed to update the scalebar images(JSAPI)
 */
function {$szJsFunctionName}()
{
    //maplayer = new DynLayer("MapLayerDiv");
    //drag.remove(maplayer);
    //drag.add(maplayer);
    //alert(maplayer);
    if (is.ie5)
      maplayer.clipInit(0,{$poMap->width}, {$poMap->height},0);

    // for other browsers it's not necessary because the layer in this example
    // is clipped to defaults so I don't have to pass clip values
    else
      maplayer.clipInit();

    maplayer.moveTo(gMapWhspc, gMapWvspc);

    maplayer.clipTo(0,gMapWiWidth,gMapWiHeight,0);
    var layerminX = maplayer.x;
    var layerminY = maplayer.y;
        
              
    var layermaxX = layerminX + gMapWiWidth;
    var layermaxY = layerminY + gMapWiHeight;
    var clipval = 0;
             
    if (0)
      {
        var ttt = "minx="+layerminX+" ,minY="+layerminY+", maxx="+layermaxX+", maxy="+layermaxY;
        alert(ttt);
        ttt = "gMapWhspc="+gMapWhspc+" ,gMapWvspc="+gMapWvspc;
        alert(ttt);
      }
    //gttt++;      
    if (layerminX <= gMapWhspc)
      {
        //alert("clip minx");
        clipval = gMapWhspc - layerminX;
        maplayer.clipBy(0,0,0,clipval);
      }
    
    if (layerminY <= gMapWvspc)
      {
        //alert("clip miny");
        clipval = gMapWvspc - layerminY;
        maplayer.clipBy(clipval, 0,0,0);
      }
    
    if (layermaxX >= (gMapWhspc + gMapWiWidth) )
      {
        //alert("clip maxx");
        var clipval = (gMapWhspc + gMapWiWidth) - layermaxX;
        maplayer.clipBy(0,clipval, 0, 0);
      }
    
    if (layermaxY > (gMapWvspc + gMapWiHeight) )
      {
        //alert("clip maxy");
        var clipval = (gMapWvspc + gMapWiHeight) - layermaxY;
        maplayer.clipBy(0,0,clipval, 0);
      }

    //drag.obj.moveTo(gMapWhspc, gMapWvspc);
   

    //MapWshowLayer("MapLayerDiv");
    
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;
       
       }//end of js api       

        return $aReturn;
    }



    /** 
     * GetJavascriptVariables.
     *
     */
    function GetJavascriptVariables()
    {
        $aReturn = array();

        $aReturn = parent::GetJavascriptVariables();

        $szVariable = "gnPanWFirstPointX";
        $szValue = " var $szVariable = -1;\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gnPanWFirstPointY";
        $szValue = " var $szVariable = -1;\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * GetJavascriptOnLoadFunctions
     *
     * Should be redefined for Widgets returning Javascript code.
     *
     * @returns Empty  string.
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();

        $aReturn = parent::GetJavascriptOnLoadFunctions();

        $szJsFunctionName = "PanMapWInit";
        $szFunction = "$szJsFunctionName();\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
            $szJsFunctionName = "PanMapWRegisterForEvent";
            $szFunction = "$szJsFunctionName();\n";
            $aReturn[$szJsFunctionName] = $szFunction;
        }

        return $aReturn;
    }

}
?>
