<?php
/**
 * MapSize Class
 *
 * @project     CWC2
 * @revision    $Id: MapSize.widget.php,v 1.6 2004/07/08 17:49:08 pspencer Exp $
 * @purpose     Display a dialog box to type in a new map size
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * MapSize is an embeddable widget that can be used to modify the
 * current map size (context window)
 */
class MapSize extends CWCWidget
{
    var $moButton;
    var $moPopup;

    /**
     * constructor
     */
    function MapSize()
    {
        $this->mszLanguageresource = str_replace("\\","/",dirname(__FILE__))."/MapSize.dbf";

        // invoke constructor of parent
        parent::CWCWidget();
        $this->moPopup = new CWCPopup($this);
        $this->moButton = new CWCButton($this);

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The MapSize widget displays a widget that allows the user to
specify new dimensions for the map image.  Note that the MapDHTML widget must
have ALLOWRESIZE set to true for this to have any effect.
EOT;

    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        if (isset($this->maParams["EMBEDDED"]) &&
            strcasecmp(trim($this->maParams["EMBEDDED"]), "FALSE") == 0)
            $this->mbEmbedded = false;
        else
            $this->mbEmbedded = true;

        if (!$this->mbEmbedded)
        {
            $this->moButton->SetOnClick("clickMapSizePopup");
            $this->moButton->InitDefaults();
        }
        $this->moPopup = new CWCPopup($this);
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/MapSize/MapSizePopup.phtml";
    }

    /**
     * inspect URL parameters for map size changes
     */
    function ParseURL()
    {    
    
        if (!$this->isVarSet( "SET_MAP_HEIGHT" ) &&
            !$this->isVarSet( "SET_MAP_WIDTH" ))
            return true;
    
        $oMap = $this->moMapObject->oMap;
        

/* ==================================================================== */
/*      only update the width,height id SET_MAP_HEIGHT &&               */
/*      SET_MAP_WIDTH are defined. Other wise the width and height      */
/*      management would pass through the mapdhtml widget. (Note : There is*/
/*      a duplication of code between this widget and the mapdhtml      */
/*      widget that should be removed at one point)                     */
/* ==================================================================== */
         if ($this->isVarSet( "SET_MAP_HEIGHT" ) &&
            $this->getVar( "SET_MAP_HEIGHT" ) != "" &&
            $this->getVar( "SET_MAP_HEIGHT" ) > 0 &&
            $this->isVarSet( "SET_MAP_WIDTH" ) &&
            $this->getVar( "SET_MAP_WIDTH" ) != "" &&
            $this->getVar( "SET_MAP_WIDTH" ) > 0)
          {
              $nHeight = intval($this->getVar( "SET_MAP_HEIGHT" ));

              $nWidth = intval($this->getVar( "SET_MAP_WIDTH" ));

              $this->moMapObject->oMap->set( "width", $nWidth );
              $this->moMapObject->oMap->set( "height", $nHeight );
          }
          
          return true;
    }

    /**
     * GetHTMLHiddenVariables
     *
     * return the map size  variables.
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $szVariable = "SET_MAP_WIDTH";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "SET_MAP_HEIGHT";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }
    
    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }


    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        $szBaseLink = $this->moPopup->mszLink."?";
        if (isset( $this->maszContents["MAPSIZE"] ))
        {
            $szQueryString = "MAPSIZE=";
            $szSep = "";
            foreach( $this->maszContents["MAPSIZE"] as $aMapSize )
            {
                if (isset($aMapSize["LABEL"]) && isset($aMapSize["WIDTH"]) &&
                    isset($aMapSize["HEIGHT"]))
                {
                    if (((int)$aMapSize["WIDTH"] > 0) && ((int)$aMapSize["HEIGHT"] > 0))
                    {
                        $szQueryString .= $szSep.$aMapSize["LABEL"].",".$aMapSize["WIDTH"].",".$aMapSize["HEIGHT"];
                        $szSep = "|";
                    }
                }
                else
                {
                    $_SESSION['gErrorManager']->setError(ERR_WARNING,
                      trim($this->moMLT->get("0", "ERROR: Invalid MAPSIZE tag definition in MapSize Tag")));
                }
            }
            $szBaseLink .= $szQueryString;
        }


        $this->moPopup->mszLink = $szBaseLink;
        $szJsFunctionName = "clickMapSizePopup";
        $szButtonJS = $this->moPopup->DrawPublish();
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a Map Size selection dialog
 */
function {$szJsFunctionName}()
{
    {$szButtonJS}
    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "applyMapSize";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * apply a new map size.
 */
function {$szJsFunctionName}(nWidth, nHeight)
{

    {$this->mszHTMLForm}.SET_MAP_WIDTH.value=nWidth;
    {$this->mszHTMLForm}.SET_MAP_HEIGHT.value=nHeight;
    {$this->mszHTMLForm}.submit();
     return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "cancelMapSize";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * cancel the user changing the map size.
 */
function {$szJsFunctionName}()
{
     obj = {$this->mszHTMLForm}.MAP_SIZE;
     aMapSize = getMapSize();
     szMapSize = aMapSize[0] + "," + aMapSize[1];
     for (i=0; i<obj.options.length; i++ )
     {
        val = obj.options[i].value;
        if (val == szMapSize)
        {
           obj.selectedIndex = i;
            break;
        }
     }
     return;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        $nWidth = $this->moMapObject->oMap->width;
        $nHeight = $this->moMapObject->oMap->height;

        $szJsFunctionName = "getMapSize";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * return the current extents as an array (width,height)
 */
function {$szJsFunctionName}()
{
    return new Array( {$nWidth}, {$nHeight} );
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "changeMapSize";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mapsize value is changed.
 */
function {$szJsFunctionName}(obj)
{
    mapsize=obj.options[obj.selectedIndex].value;
    pos = mapsize.indexOf(",");
    width = mapsize.substring( 0, pos );
    height = mapsize.substring( pos + 1, mapsize.length );
    if (width == "custom" || height == "custom")
        clickMapSizePopup();
    else
    {
        curMapSize = getMapSize();
        if (curMapSize[0] != width || curMapSize[1] != height )
        {
            {$this->mszHTMLForm}.SET_MAP_WIDTH.value = width;
            {$this->mszHTMLForm}.SET_MAP_HEIGHT.value = height;
            {$this->mszHTMLForm}.submit();
        }
    }
    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * Draw the widget
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- MapSize widget hidden -->";

        $nHeight = $this->moMapObject->oMap->height;
        $nWidth = $this->moMapObject->oMap->width;

        if ($this->mbEmbedded)
        {
            $szResult = "<SELECT NAME=\"MAP_SIZE\" onchange=\"changeMapSize(this)\">\n";

            if (isset( $this->maszContents["MAPSIZE"] ))
            {
                $bCustom = true;
                foreach( $this->maszContents["MAPSIZE"] as $aMapSize )
                {
                    if (isset($aMapSize["LABEL"]) && isset($aMapSize["WIDTH"]) &&
                        isset($aMapSize["HEIGHT"]))
                    {
                        $szMapSize = $aMapSize["WIDTH"].",".$aMapSize["HEIGHT"];
                        $szResult .= "<OPTION VALUE=\"".$szMapSize."\"";
                        if ($nHeight == $aMapSize["HEIGHT"] && $nWidth == $aMapSize["WIDTH"])
                        {
                            $szResult .= " SELECTED";
                            $bCustom = false;
                        }
                        $szResult .= ">".$aMapSize["LABEL"]."</OPTION>\n";
                    }
                    else
                    {
                        $_SESSION['gErrorManager']->setError(ERR_WARNING,
                          trim($this->moMLT->get("0", "ERROR: Invalid MAPSIZE tag definition in MapSize Tag")));
                    }
                }
                if ($bCustom)
                {
                    $szResult .= "<OPTION VALUE=\"".$nWidth.",".$nHeight;
                    $szResult .= "\" SELECTED>".$nWidth."x".$nHeight."</OPTION>\n";
                }
            }
            $szResult .= "</SELECT>\n";
        }
        else
        {
            $szResult = $this->moButton->DrawPublish();
        }
        return $szResult;
    }
}
?>
