<?php
/**
 * Base Widget class
 *
 * @project     CWC2
 * @revision    $Id: MapImageWidget.widget.php,v 1.2 2004/04/24 21:58:54 pspencer Exp $
 * @purpose     Base Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");

/**
 * MapImageWidget
 *
 * @desc Map image widget. Provides a single click on the map and
 * updates the NAV_INPUT_COORD parameter.
 */
class MapImageWidget extends CWCWidget
{
    var   $msMapImageName = "DEFAULT_MAP";
    var   $mszDrawMapParams = "";
    var   $mszWaitImage = "";
    var   $mnWaitImageWidth;
    var   $mnWaitImageHeight;
    var   $mbBorder = false;
    var   $mbAllowResize = true;
    var   $mbNavigable = false;
    var   $mbTransparent = false;
    var   $mnWidth = "";
    var   $mnHeight = "";
    var   $mnMinxx = "";
    var   $mnMinxy = "";
    var   $mnMaxxx = "";
    var   $mnMaxxy = "";
    var   $mszImageType = "";

    function MapImageWidget()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = "No description available.  Please set ".
                        "this description in the constructor of this class.";

        $this->maAttributes["WAITIMAGE"] = new StringAttribute( "WAITIMAGE", false);
        $this->maAttributes["WAITIMAGEWIDTH"] = new IntegerAttribute( "WAITIMAGEWIDTH", false, 0 );
        $this->maAttributes["WAITIMAGEHEIGHT"] = new IntegerAttribute( "WAITIMAGEHEIGHT", false, 0 );

        $this->maAttributes["BORDER"] = new BooleanAttribute( "BORDER", false);

        $this->maAttributes["ID"] = new StringAttribute("ID", false);

        $this->maAttributes["SRS"] = new StringAttribute("SRS", false);
        $this->maAttributes["MINX"] = new IntegerAttribute("MINX", false);
        $this->maAttributes["MINY"] = new IntegerAttribute("MINY", false);
        $this->maAttributes["MAXX"] = new IntegerAttribute("MAXX", false);
        $this->maAttributes["MAXY"] = new IntegerAttribute("MAXY", false);

        $this->maAttributes["WIDTH"] = new IntegerAttribute("WIDTH", false);
        $this->maAttributes["HEIGHT"] = new IntegerAttribute("HEIGHT", false);
        $this->maAttributes["ALLOWRESIZE"] = new BooleanAttribute( "ALLOWRESIZE", false);

        $this->maAttributes["NAVIGABLE"] = new BooleanAttribute( "NAVIGABLE", false);

        $this->maAttributes["TRANSPARENT"] = new BooleanAttribute( "TRANSPARENT", false);
        $this->maAttributes["IMAGETYPE"] = new StringAttribute( "IMAGETYPE", false, 
             array("PNG", "PNG24", "JPEG", "GIF", "SWF"));

        $this->mnPriority = PRIORITY_HIGH;
    }

    function InitDefaults()
    {
        //now check the widget attributes to see if it is overridden
        if (isset($this->maParams["WAITIMAGE"]))
        {
            $this->mszWaitImage = $this->maParams["WAITIMAGE"];
        }

        if (isset($this->maParams["WAITIMAGEWIDTH"]))
            $this->mnWaitImageWidth = $this->maParams["WAITIMAGEWIDTH"];
        if (isset($this->maParams["WAITIMAGEHEIGHT"]))
            $this->mnWaitImageHeight = $this->maParams["WAITIMAGEHEIGHT"];

        if (isset($this->maParams["WIDTH"]))
            $this->mnWidth = $this->maParams["WIDTH"];
   
        if (isset($this->maParams["HEIGHT"]))
            $this->mnHeight = $this->maParams["HEIGHT"];

        if (isset($this->maParams["BORDER"]))
          $this->mbBorder = ((strcasecmp($this->maParams["BORDER"],"true")==0)?true:false);

        if (isset($this->maParams["ALLOWRESIZE"]))
        {
            if (strcasecmp( $this->maParams["ALLOWRESIZE"] , "true" ) == 0)
                $this->mbAllowResize = true;
            else
                $this->mbAllowResize = false;
        }

        if (isset($this->maParams["NAVIGABLE"]))
        {
            if (strcasecmp( $this->maParams["NAVIGABLE"] , "true" ) == 0)
                $this->mbNavigable = true;
            else
                $this->mbNavigable = false;
        }

        if (isset($this->maParams["TRANSPARENT"]))
            $this->mbTransparent = ((strtoupper($this->maParams["TRANSPARENT"]) == "TRUE") ? true : false);

        if (isset($this->maParams["IMAGETYPE"]))
            $this->mszImageType = $this->maParams["IMAGETYPE"];

        parent::InitDefaults();
    }

    /**
     * DrawPublish
     *
     * Draw the map and return the HTML.
     */
    function DrawPublish()
    {
        $oMap =& $this->moMapObject->oMap;

        // Get a copy of width and height
        $nOldWidth = $oMap->width+0;
        $nOldHeight = $oMap->height+0;

        // Get a copy of map extents
        $nOldMinX = $oMap->extent->minx+0;
        $nOldMinY = $oMap->extent->miny+0;
        $nOldMaxX = $oMap->extent->maxx+0;
        $nOldMaxY = $oMap->extent->maxy+0;

        $oMap->width = $this->mnWidth;
        $oMap->height = $this->mnHeight;

        $nWidth = $oMap->width;
        $nHeight = $oMap->height;

        // reproject the extent specified in cwc tag to map projection
        if ($oMap->getProjection() != "" && $this->GetValue("srs") != "" &&
            strstr($oMap->getProjection(), $this->GetValue("srs")) === false)
        {
            // Get map rojection as output
            $szTmpMapProj = $oMap->getProjection();

            // Get projection specified in cwc tag
            $projOutObj = ms_newprojectionobj( $szTmpMapProj );

            $projInObj = ms_newprojectionobj("init=".strtolower($this->GetValue("srs")));

            $poRect = ms_newrectobj();
            $poRect->setextent($this->GetValue("minx", $nOldMinX),
                               $this->GetValue("miny", $nOldMinY),
                               $this->GetValue("maxx", $nOldMaxX),
                               $this->GetValue("maxy", $nOldMaxY));
            
            $poRect->project($projInObj, $projOutObj);
        
            $this->mszDrawMapParams .= "&nMinX=".$poRect->minx.
                                       "&nMinY=".$poRect->miny.
                                       "&nMaxX=".$poRect->maxx.
                                       "&nMaxY=".$poRect->maxy;
        }
        else
        {
            $this->mszDrawMapParams .= "&nMinX=".$this->GetValue("minx", $nOldMinX).
                                       "&nMinY=".$this->GetValue("miny", $nOldMinY).
                                       "&nMaxX=".$this->GetValue("maxx", $nOldMaxX).
                                       "&nMaxY=".$this->GetValue("maxy", $nOldMaxY);
        }

        if ($this->mbTransparent != "")
            $this->mszDrawMapParams .= "&bTransparent=".$this->mbTransparent;

        if ($this->mszImageType != "")
            $this->mszDrawMapParams .= "&gszImgType=".$this->mszImageType;

        if($this->GetValue("id", $this->GetValue("name")) != "")
            $this->mszDrawMapParams .= "&gszMapId=".$this->GetValue("id", 
                                                      $this->GetValue("name"));

        $this->mnWidth = $this->GetValue("width", $nOldWidth);
        $this->mnHeight = $this->GetValue("height", $nOldHeight);

        $this->mszDrawMapParams .= "&nWidth=".$this->GetValue("width", $nOldWidth);
        $this->mszDrawMapParams .= "&nHeight=".$this->GetValue("height", $nOldHeight);

        $bNetscape4 = false;
        if (isset($GLOBALS['HTTP_SERVER_VARS']['HTTP_USER_AGENT']))
        {
            if (stristr($GLOBALS['HTTP_SERVER_VARS']['HTTP_USER_AGENT'], "Mozilla/4") && (!(stristr($GLOBALS['HTTP_SERVER_VARS']['HTTP_USER_AGENT'], "compatible"))))
            $bNetscape4 = true;
        }
        else
            $bNetscape4 = true;

        if (!$this->mbNavigable)
            $szImgType = "img";
        else
            $szImgType = "input type=image onclick=\"if (!bPageLoaded) return false;\"";

        $szReturn = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr>";
        if ($this->mbBorder)
        {
            $szReturn .= "<td bgcolor=\"000000\"><img src=\"".$_SESSION['gszCoreWebPath'];
            $szReturn .= "/images/a_pixel.gif\" width=\"1\" height=\"1\" id=\"mapFrameTL\" name=\"mapFrameTL\"></td>";
            $szReturn .= "<td bgcolor=\"000000\"><img src=\"".$_SESSION['gszCoreWebPath'];
            $szReturn .= "/images/a_pixel.gif\" width=\"1\" height=\"1\"></td>";
            $szReturn .= "<td bgcolor=\"000000\"><img src=\"".$_SESSION['gszCoreWebPath'];
            $szReturn .= "/images/a_pixel.gif\" width=\"1\" height=\"1\" id=\"mapFrameTR\" name=\"mapFrameTR\"></td>";
            $szReturn .= "</tr><tr><td bgcolor=\"000000\"><img src=\"".$_SESSION['gszCoreWebPath'];
            $szReturn .= "/images/a_pixel.gif\" width=\"1\" height=\"1\"></td>";
            $szReturn .= "<td><a name=\"mapanchor\" $szImgType><div style=\"width:$nWidth;height:$nHeight;\">";
            if(!$bNetscape4 && $this->mszWaitImage != "")
            {
                $szReturn .= "<ilayer id=\"".$this->msMapImageName."\" width=$nWidth height=$nHeight>";
                $szReturn .= "<layer id=\"".$this->msMapImageName."\" width=$nWidth height=$nHeight>";
                $szReturn .= "<table width=100% height=100% cellspacing=0 cellpading=0 border=0><tr>";
                $szReturn .= "<td align=center valign=center width=100% height=100%><$szImgType SRC=\"".$this->mszWaitImage;
                $szReturn .= "\" NAME=\"".$this->msMapImageName."\" border=\"0\"></td></tr></table></layer></ilayer></div></a></td>";
            }
            else
            {
                $szReturn .= "<$szImgType SRC=\"".WEBCOMMON."/wrapper/drawmap.php?".$this->mszDrawMapParams;
                $szReturn .= "\" NAME=\"".$this->msMapImageName."\" border=\"0\"></div></a></td>";
            }
            $szReturn .= "<td bgcolor=\"000000\"><img src=\"".$_SESSION['gszCoreWebPath'];
            $szReturn .= "/images/a_pixel.gif\" width=\"1\" height=\"1\"></td></tr><tr>";
            $szReturn .= "<td bgcolor=\"000000\"><img src=\"".$_SESSION['gszCoreWebPath'];
            $szReturn .= "/images/a_pixel.gif\" width=\"1\" height=\"1\" id=\"mapFrameBL\" name=\"mapFrameBL\"></td>";
            $szReturn .= "<td bgcolor=\"000000\"><img src=\"".$_SESSION['gszCoreWebPath'];
            $szReturn .= "/images/a_pixel.gif\" width=\"1\" height=\"1\"></td>";
            $szReturn .= "<td bgcolor=\"000000\"><img src=\"".$_SESSION['gszCoreWebPath'];
            $szReturn .= "/images/a_pixel.gif\" width=\"1\" height=\"1\" id=\"mapFrameBR\" name=\"mapFrameBR\"></td>";
        }
        else
        {
            if(!$bNetscape4 && $this->mszWaitImage != "")
            {
                $szReturn .= "<td><a name=\"mapanchor\"><div style=\"width:$nWidth;height:$nHeight;\">";
                $szReturn .= "<ilayer id=\"".$this->msMapImageName."\" width=$nWidth height=$nHeight>";
                $szReturn .= "<layer id=\"".$this->msMapImageName."\" width=$nWidth height=$nHeight>";
                $szReturn .= "<table width=100% height=100% cellspacing=0 cellpading=0 border=0><tr>";
                $szReturn .= "<td align=center valign=center width=100% height=100%><$szImgType SRC=\"".
                    (($bNetscape4 || $this->mszWaitImage == "") ? WEBCOMMON."/wrapper/drawmap.php?".$this->mszDrawMapParams: $this->mszWaitImage);
                $szReturn .= "\" NAME=\"".$this->msMapImageName."\" border=\"0\"></td></tr></table></layer></ilayer></div></a></td>";
            }
            else
            {
                $szReturn .= "<td><a name=\"mapanchor\"><div style=\"width:$nWidth;height:$nHeight;\">";
                $szReturn .= "<$szImgType SRC=\"".WEBCOMMON."/wrapper/drawmap.php?".$this->mszDrawMapParams;
                $szReturn .= "\" NAME=\"".$this->msMapImageName."\" border=\"0\"></div></a></td>";
            }
        }

        $szReturn .= "</tr></table>";

        $oMap->width = $nOldWidth;
        $oMap->height = $nOldHeight;

        return $szReturn;
    }


    /**
     * handle changes coming from the URL.  In this case, we only want
     * to verify that the map size is valid
     */
    function ParseURL()
    {
        if (!$this->mbAllowResize)
        {
            $poMap =& $this->moMapObject->oMap;
        
            $nWidth = $poMap->width;
            $nHeight = $poMap->height;

            if (isset($this->maParams["WIDTH"]))
                $nWidth = $this->maParams["WIDTH"];
            if (isset($this->maParams["HEIGHT"]))
                $nHeight = $this->maParams["HEIGHT"];
            $poMap->set("width", $nWidth);
            $poMap->set("height", $nHeight);
        }
        else
        {
            $poMap =& $this->moMapObject->oMap;

            $nWidth = $poMap->width;
            $nHeight = $poMap->height;

            if (isset($this->maParams["WIDTH"]))
                $nWidth = $this->maParams["WIDTH"];
            if (isset($this->maParams["HEIGHT"]))
                $nHeight = $this->maParams["HEIGHT"];
            
            $poMap->set("width", $nWidth);
            $poMap->set("height", $nHeight);

            if ($this->isVarSet( "MAP_WIDTH" ) &&
                $this->getVar( "MAP_WIDTH" ) != "" &&
                $this->getVar( "MAP_WIDTH" ) > 0 &&
                $this->isVarSet( "MAP_HEIGHT" ) &&
                $this->getVar( "MAP_HEIGHT" ) != "" &&
                $this->getVar( "MAP_HEIGHT" ) > 0)
            {
                $this->moMapObject->oMap->set("width",
                                              $this->getVar( "MAP_WIDTH" ));
                $this->moMapObject->oMap->set("height",
                                              $this->getVar( "MAP_HEIGHT" ));
            }
        }
        if ($this->isVarSet( 'MAP_EXTENTS_MINX' ) &&
            $this->isVarSet( 'MAP_EXTENTS_MINY' ) &&
            $this->isVarSet( 'MAP_EXTENTS_MAXX' ) &&
            $this->isVarSet( 'MAP_EXTENTS_MAXY' ))
        {
            $this->moMapObject->oMap->setExtent(
                                      $this->getVar( 'MAP_EXTENTS_MINX' ),
                                      $this->getVar( 'MAP_EXTENTS_MINY' ),
                                      $this->getVar( 'MAP_EXTENTS_MAXX' ),
                                      $this->getVar( 'MAP_EXTENTS_MAXY' ));
        }

        return parent::ParseURL();
    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = parent::GetHTMLHiddenVariables();

        $szVariable = "NAV_INPUT_TYPE";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"POINT\">";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        srand($this->make_seed());
        $randval = rand();
        $name = $this->msMapImageName;

        if (isset($_SESSION['gszCoreWebPath']))
            $core = $_SESSION['gszCoreWebPath'];
        else
            $core = "";

        $szJsFunctionName = "LoadMap(oLayer, szParam)";
        $szFunction = "function $szJsFunctionName\n{\n".
              "var url='".$core.
              WEBCOMMON."/wrapper/drawmap.php?".SID."&dummy=".$randval.
              "'+szParam;\n".
              "if (navigator.appName == \"Netscape\" && navigator.appVersion[0] <= 4){\n".
              ";\n}else{\n".
              "oDstImg = new Image();\n".
              "oDstImg.src = url;\n".
              "oLayer.src = oDstImg.src;\n}".
              "\n}";

        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetJavascriptVariables
     */
    function getJavascriptVariables()
    {
        $aReturn = parent::getJavascriptVariables();

        $szVarName = "bPageLoaded";
        $aReturn[$szVarName] = "var bPageLoaded = false;\n";

        return $aReturn;
    }

    /**
     * GetJavascriptOnLoadFunctions
     *
     * On load functions.
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();

        $aReturn = parent::GetJavascriptOnLoadFunctions();
        
        $szFunctionName = "bPageLoaded";
        $aReturn[$szFunctionName] = "bPageLoaded = true;\n";

        $this->SetDrawMapURL();

        if ($this->mszWaitImage != "")
        {
            $szJsFunctionName = "if (navigator.appName == \"Netscape\" && navigator.appVersion[0] <= 4) ; else LoadMap(document.images['".$this->msMapImageName."'],'".$this->mszDrawMapParams."')";

            $szFunction = "$szJsFunctionName;\n";
            $aReturn[$szJsFunctionName] = $szFunction;
        }

        return $aReturn;
    }

    function SetDrawMapURL()
    {
        $this->mszDrawMapParams .= "&map_session_mode=".$_SESSION['gnMapSessionMode'];

        $this->mszDrawMapParams .= "&".SID;
    }

    // seed with microseconds
    function make_seed()
    {
        list($usec, $sec) = explode(' ', microtime());
        return (float) $sec + ((float) $usec * 100000);
    }
}
?>
