<?php
/**
 *
 * This function evaluate a simple expression and return true
 * false. If and error is detected in the expression the function
 * return -1.
 * 
 * Expression can contain "==", "!=", "<=", ">=", "<", ">", "&&", 
 * "||", "(" and ")". All string should be beetween double quotes.
 * 
 * Example:
 * 
 *          $szEmployeeName = "Sacha Fournier";
 *          $szExp = "(\"$szEmployeeName\" != Joe && ".
 *                   "\"$szEmployeeName\" != \"Dirt\" || ".
 *                   "($szEmployeeName == \"\" && 1==1))";
 *          $bRet = evaluateExpression("($szEmployeeName != )");
 */

/**
 * Main function to call
 */
function evaluateExpression($szExpression)
{
    // Initialise empty array that will contain all string vars.
    $aszValues = array();

    $szExpression = trim($szExpression);
    if (substr($szExpression, 0,1) != "(" && substr($szExpression, -1) != ")")
        $szExpression = "(".$szExpression.")";

    // Remove strings beetween double quotes
    // and store them in aszValues.
    $nStart = $nEnd = false;
    $i=0;
    do
    {
        $nStart = strpos($szExpression, "\"");
        if ($nStart !== false)
        {
            $nEnd = strpos($szExpression, "\"", $nStart+1);

            if ($nEnd !== false)
            {
                $aszValues["--str".$i."--"] = substr($szExpression, $nStart+1, $nEnd-$nStart-1);
                $szExpression = substr($szExpression, 0, $nStart)."--str$i--".substr($szExpression, $nEnd+1);
                $i++;
            }
        }

    } while ($nStart !== false && $nEnd !== false);

    $nRet = processExpression($szExpression, $aszValues);

    return $nRet;
}

/**
 * This function shouldn't be called by user.
 */
function processExpression(&$szExpression, &$aszValues)
{
    $nStrLen = strlen($szExpression);
    $nPos = 0;
    $nEnd = $nStrLen;
    $nOpen = 0;
    $bFind = false;

    // Process all sub expressions beetween () in
    // correct order.
    $nStart = strpos($szExpression, "(", $nPos);
    $nEnd = strpos($szExpression, ")", $nPos);
    
    if ($nStart === false && $nEnd !== false)
        return -1;

    if ($nStart === false && $nEnd === false)
    {
        $bRet = simpleEval($szExpression, $aszValues);
        return $bRet;
    }
    else
    while (!$bFind)
    {
        $nTmpPos1 = strpos($szExpression, "(", $nPos);
        $nTmpPos2 = strpos($szExpression, ")", $nPos);

        if ($nTmpPos1 !== false && $nTmpPos2 !== false && $nTmpPos1 < $nTmpPos2)
        {
            $nOpen++;
            $nPos = $nTmpPos1 + 1;
        }

        if ($nTmpPos1 !== false && $nTmpPos2 !== false && $nTmpPos1 > $nTmpPos2)
        {
            $nOpen--;
            $nPos = $nTmpPos2 + 1;
        }

        if ($nTmpPos1 === false && $nTmpPos2 !== false)
        {
            $nOpen--;
            $nPos = $nTmpPos2 + 1;
        }

        if ($nTmpPos2 === false && $nTmpPos1 !== false)
        {
            $nOpen++;
            $nPos = $nTmpPos1 + 1;
        }

        if ($nOpen == 0)
        {
           $nEnd = $nPos;

           $szExp = substr($szExpression, $nStart+1, $nEnd-$nStart-2);
           $szExpression = str_replace("(".$szExp.")", processExpression($szExp, $aszValues), $szExpression);

           $nPos = 0;
           $nStrLen = strlen($szExpression);

           $nStart = strpos($szExpression, "(", 0);
           $nEnd = strpos($szExpression, ")", 0);

           if ($nStart === false && $nEnd !== false)
                return -1;

           if ($nStart === false && $nEnd === false)
                return simpleEval($szExpression, $aszValues);
        }

        if ($nPos >= $nStrLen)
        {
            $bFind = true;
        }
    }
}

function simpleEval(&$szExpression, &$aszValues)
{
//    if (trim($szExpression) == "")
//        return false;

    $nRet = 0;

    if (strpos($szExpression, "||") !== false)
    {
        $aszExpression = explode("||", $szExpression);
        $nCnt = count($aszExpression);
        for($i=0;$i<$nCnt;$i++)
        {
            $nRet = (simpleEval(trim($aszExpression[$i]), $aszValues) || $nRet) ? 1 : 0;
            $aszExpression[$i] = $nRet;
        }

        $szExpression = implode("||", $aszExpression);
    }

    if (strpos($szExpression, "&&") !== false)
    {
        $nRet = 1;

        $aszExpression = explode("&&", $szExpression);
        $nCnt = count($aszExpression);
        for($i=0;$i<$nCnt;$i++)
        {
            $nRet = (simpleEval(trim($aszExpression[$i]), $aszValues) && $nRet) ? 1 : 0;
            $szExpression = implode("&&", $aszExpression);
        }
    }

    if (strpos($szExpression, "&&") === false && strpos($szExpression, "||") === false)
    {
        $nRet = myEval($szExpression, $aszValues);

        $szExpression = $nRet;
    }

    return $nRet;
}


function myEval($szExpression, &$aszValues)
{
    $szExpression = trim($szExpression);

    if ($szExpression == "1" || $szExpression == "0")
        return $szExpression;

    if (isset($aszValues[$szExpression]) && strlen($aszValues[$szExpression]) > 0)
        return 1;

    if (strpos($szExpression, "==") !== false)
    {
        $aszOper = explode("==", $szExpression);

        if (count($aszOper) != 2)
            return -1;

        if (isset($aszValues[trim($aszOper[0])]))
            $szVal1 = $aszValues[trim($aszOper[0])];
        else
            $szVal1 = trim($aszOper[0]);
        if (isset($aszValues[trim($aszOper[1])]))
            $szVal2 = $aszValues[trim($aszOper[1])];
        else
            $szVal2 = trim($aszOper[1]);

        if ($szVal1 == $szVal2)
            return 1;
        else
            return 0;
    }
    else
    if (strpos($szExpression, "!="))
    {
        $aszOper = explode("!=", $szExpression);

        if (count($aszOper) != 2)
            return -1;

        if (isset($aszValues[trim($aszOper[0])]))
            $szVal1 = $aszValues[trim($aszOper[0])];
        else
            $szVal1 = trim($aszOper[0]);
        if (isset($aszValues[trim($aszOper[1])]))
            $szVal2 = $aszValues[trim($aszOper[1])];
        else
            $szVal2 = trim($aszOper[1]);

        if ($szVal1 != $szVal2)
            return 1;
        else
            return 0;
    }
    else
    if (strpos($szExpression, ">="))
    {
        $aszOper = explode(">=", $szExpression);

        if (count($aszOper) != 2)
            return -1;

        if (isset($aszValues[trim($aszOper[0])]))
            $szVal1 = $aszValues[trim($aszOper[0])];
        else
            $szVal1 = trim($aszOper[0]);
        if (isset($aszValues[trim($aszOper[1])]))
            $szVal2 = $aszValues[trim($aszOper[1])];
        else
            $szVal2 = trim($aszOper[1]);

        if ($szVal1 >= $szVal2)
            return 1;
        else
            return 0;
    }
    else
    if (strpos($szExpression, "<="))
    {
        $aszOper = explode("<=", $szExpression);

        if (count($aszOper) != 2)
            return -1;

        if (isset($aszValues[trim($aszOper[0])]))
            $szVal1 = $aszValues[trim($aszOper[0])];
        else
            $szVal1 = trim($aszOper[0]);
        if (isset($aszValues[trim($aszOper[1])]))
            $szVal2 = $aszValues[trim($aszOper[1])];
        else
            $szVal2 = trim($aszOper[1]);

        if ($szVal1 <= $szVal2)
            return 1;
        else
            return 0;
    }
    else
    if (strpos($szExpression, ">"))
    {
        $aszOper = explode(">", $szExpression);

        if (count($aszOper) != 2)
            return -1;

        if (isset($aszValues[trim($aszOper[0])]))
            $szVal1 = $aszValues[trim($aszOper[0])];
        else
            $szVal1 = trim($aszOper[0]);
        if (isset($aszValues[trim($aszOper[1])]))
            $szVal2 = $aszValues[trim($aszOper[1])];
        else
            $szVal2 = trim($aszOper[1]);

        if ($szVal1 > $szVal2)
            return 1;
        else
            return 0;
    }
    else
    if (strpos($szExpression, "<"))
    {
        $aszOper = explode("<", $szExpression);

        if (count($aszOper) != 2)
            return -1;

        if (isset($aszValues[trim($aszOper[0])]))
            $szVal1 = $aszValues[trim($aszOper[0])];
        else
            $szVal1 = trim($aszOper[0]);
        if (isset($aszValues[trim($aszOper[1])]))
            $szVal2 = $aszValues[trim($aszOper[1])];
        else
            $szVal2 = trim($aszOper[1]);

        if ($szVal1 < $szVal2)
            return 1;
        else
            return 0;
    }
    else
    {
        if(isset($aszValues[trim($szExpression)]) && strlen($aszValues[trim($szExpression)]) > 0)
            return 1;

        if(isset($aszValues[trim($szExpression)]) && strlen($aszValues[trim($szExpression)]) == 0)
            return 0;

        return 1;
    }   
    return 1;
}
/*
if (evaluateExpression("1||1&&1")) echo "true"; else echo "false";
if (evaluateExpression("1&&1&&1")) echo "true"; else echo "false";
if (evaluateExpression("1&&1||1")) echo "true"; else echo "false";
if (evaluateExpression("1||1||1")) echo "true"; else echo "false";

if (evaluateExpression("1||1&&0")) echo "true"; else echo "false";
if (evaluateExpression("1&&1&&0")) echo "true"; else echo "false";
if (evaluateExpression("1&&1||0")) echo "true"; else echo "false";
if (evaluateExpression("1||1||0")) echo "true"; else echo "false";

if (evaluateExpression("1||0&&1")) echo "true"; else echo "false";
if (evaluateExpression("1&&0&&1")) echo "true"; else echo "false";
if (evaluateExpression("1&&0||1")) echo "true"; else echo "false";
if (evaluateExpression("1||0||1")) echo "true"; else echo "false";

if (evaluateExpression("0||1&&1")) echo "true"; else echo "false";
if (evaluateExpression("0&&1&&1")) echo "true"; else echo "false";
if (evaluateExpression("0&&1||1")) echo "true"; else echo "false";
if (evaluateExpression("0||1||1")) echo "true"; else echo "false";

if (evaluateExpression("1||0&&0")) echo "true"; else echo "false";
if (evaluateExpression("1&&0&&0")) echo "true"; else echo "false";
if (evaluateExpression("1&&0||0")) echo "true"; else echo "false";
if (evaluateExpression("1||0||0")) echo "true"; else echo "false";

if (evaluateExpression("0||0&&1")) echo "true"; else echo "false";
if (evaluateExpression("0&&0&&1")) echo "true"; else echo "false";
if (evaluateExpression("0&&0||1")) echo "true"; else echo "false";
if (evaluateExpression("0||0||1")) echo "true"; else echo "false";

if (evaluateExpression("0||1&&0")) echo "true"; else echo "false";
if (evaluateExpression("0&&1&&0")) echo "true"; else echo "false";
if (evaluateExpression("0&&1||0")) echo "true"; else echo "false";
if (evaluateExpression("0||1||0")) echo "true"; else echo "false";

if (evaluateExpression("0||0&&0")) echo "true"; else echo "false";
if (evaluateExpression("0&&0&&0")) echo "true"; else echo "false";
if (evaluateExpression("0&&0||0")) echo "true"; else echo "false";
if (evaluateExpression("0||0||0")) echo "true"; else echo "false";

echo "\n";
*/
?>
