/**
 * @project     Chameleon
 * @revision    $Id: MapDHTMLWidget.js,v 1.4 2004/05/27 20:12:56 pspencer Exp $
 * @purpose     Javascript and DHTML functions for the MapDHTML widget
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
/*
 * this code originated in the MapDHTMLWidget's GetJavascriptFunction code,
 * and was moved here for a couple of reasons, primarily to accelerate page
 * loading by allowing for caching of all this javascript and secondarily
 * to help in maintenance of the code.
 *
 * TODO: move the zoom box drawing stuff into a utility js file so that all
 * widgets can use it.  Perhaps the ROI code would be a good place to start
 * for that effort.
 */
 
var gMapWvspcIEadjust = 0; //original code was 7;
var gMapWhspcIEadjust = 0; //original code was -2;
var gMapWhspc = 0;
var gMapWvspc = 0;
var gMapWmouseX = 0;
var gMapWmouseY = 0;
var gMapWx1 = 0;
var gMapWy1 = 0;
var gMapWx2 = 0;
var gMapWy2 = 0;
var gMapWfirstx = 0;
var gMapWfirsty = 0;
var gMapWsecondx = 0;
var gMapWsecondy = 0;
var gMapWzleft = 0;
var gMapWzright = 0;
var gMapWztop = 0;
var gMapWzbottom = 0;
var gMapWmapX = 0;
var gMapWmapY = 0;
var gMapWdragging = false;
var gMapWtoplayer = "zBoxTop";
var gMapWleftlayer = "zBoxLeft";
var gMapWbottomlayer = "zBoxBottom";
var gMapWrightlayer = "zBoxRight";

var gMapDHTMLForm = null;
document.ondragstart = CWCOnDragStart;

/**
 * prevent dragging from initializing
 */
function CWCOnDragStart( e )
{
    var target;
    if (CWCIsIE)
    {
        e = event;
        target = event.srcElement;
        e.cancelBubble = true;
        e.returnValue = false;
    }
    else
    {
        target = e.target;
        if (e.cancelable)
            e.cancelBubble = true;
    }
}

/* -------------------------------------------------------------------- */
/*      MapWsetZoomBoxSettings                                          */
/* -------------------------------------------------------------------- */
function MapWsetZoomBoxSettings()
{
    if (CWCIsNav4 || CWCIsNav6)
    {
        document.captureEvents(Event.MOUSEMOVE);
        document.captureEvents(Event.MOUSEDOWN);
        document.captureEvents(Event.MOUSEUP);
        document.captureEvents(Event.RESIZE);
    }
    else if (CWCIsIE)
    {
        gMapWhspc -= gMapWhspcIEadjust;
        gMapWvspc += gMapWvspcIEadjust;
    }
    window.onresize = MapWhandleresize;
}

/* -------------------------------------------------------------------- */
/*      MapWhandleresize                                                */
/* -------------------------------------------------------------------- */
function MapWhandleresize()
{
    if (CWCIsNav4 || CWCIsNav6) 
    {     // Netscape
        location.reload();
    }
    else if (CWCIsIE)
    {
        MapWPositionMapDHTML();
    }
}

function TrackMouseXY(e)
{
    if (navigator.appName == "Microsoft Internet Explorer")
    {
        gnMouseX = event.clientX + document.body.scrollLeft;
        gnMouseY = event.clientY + document.body.scrollTop;
    }
    else
    {
        gnMouseX = e.pageX;
        gnMouseY = e.pageY;
    }
    return true;
}

/* -------------------------------------------------------------------- */
/*      MapWchkMouseUp                                                  */
/* -------------------------------------------------------------------- */
function MapWchkMouseUp(e)
{
  //alert("MapWchkMouseUp : mouse up");
    MapWgetMouse(e);
    TrackMouseXY(e);

    if((window.gMapDHTMLForm != null) && 
       (gMapDHTMLForm.NAV_CMD != null) &&
       (gMapDHTMLForm.NAV_CMD.value == "PAN_MAP" ||
        gMapDHTMLForm.NAV_CMD.value == "RULER" ||
        gMapDHTMLForm.NAV_CMD.value == "QUERY"))
        return true;
    
    if (gMapWdragging) 
    {
        gMapWmouseX = Math.min(Math.max(gMapWmouseX, 0), gMapWiWidth);
        gMapWmouseY = Math.min(Math.max(gMapWmouseY, 0), gMapWiHeight);
        MapWmapTool(e);
    }
}

/* -------------------------------------------------------------------- */
/*      MapWPointNavigation                                             */
/* -------------------------------------------------------------------- */
function MapWPointNavigation()
{
    szCoord = ""+ gMapWmouseX + "," + gMapWmouseY;
    if (window.gMapDHTMLForm != null)
    {
        if (gCWCJSAPI)
        {
            goCWCJSAPI.NAV_INPUT_COORDINATES = szCoord;
            goCWCJSAPI.NAV_INPUT_TYPE = "POINT";

            //the forms variables settings should not be necessary. But It
            //keeps consistancy since some js functions test the values
            //of the form parameters.
            gMapDHTMLForm.NAV_INPUT_COORDINATES.value =  szCoord;
            gMapDHTMLForm.NAV_INPUT_TYPE.value = "POINT";

            goCWCJSAPI.UpdateNavTools();
        }
        else
        {
            gMapDHTMLForm.NAV_INPUT_COORDINATES.value =  szCoord;
            gMapDHTMLForm.NAV_INPUT_TYPE.value = "POINT";
            document.onmousemove = null;
            document.onmouseup = null;
            document.onmousedown = null;
            gMapDHTMLForm.submit();
        }
    }
}

/* -------------------------------------------------------------------- */
/*      MapWmapTool                                                     */
/* -------------------------------------------------------------------- */
function MapWmapTool(e)
{
  //alert("MapWmapTool : mouse down");
    if ( CWCIsNav6)
    {
        if (e.target == "[object HTMLHtmlElement]")
        {
            return;
        }
    }
    MapWgetMouse(e);
    TrackMouseXY(e);
    //    MapWgetImageXY(e);
        
    /* -------------------------------------------------------------------- */
    /*      if in js api update the js class with the mouse click position. */
    /* -------------------------------------------------------------------- */
    if (gCWCJSAPI)
    {
        if (MapWinsideMap())
        {
            goCWCJSAPI.MouseClicked(gMapWmouseX,gMapWmouseY);
        }
    }
    
    if((window.gMapDHTMLForm != null) && 
       (gMapDHTMLForm.NAV_CMD != null) &&
       (gMapDHTMLForm.NAV_CMD.value == "PAN_MAP" ||
        gMapDHTMLForm.NAV_CMD.value == "RULER" ||
        gMapDHTMLForm.NAV_CMD.value == "QUERY" ||
        gMapDHTMLForm.NAV_CMD.value == "MAPTIPS" ||
        gMapDHTMLForm.NAV_CMD.value == "ROI_TOOL" ||
        gMapDHTMLForm.NAV_CMD.value == ""))
        return true;
    if (window.gMapDHTMLForm != null && MapWinsideMap())
    {
        //alert(gMapDHTMLForm.NAV_ALLOW_RECTANGLE.value)
        if (gMapDHTMLForm.NAV_ALLOW_RECTANGLE.value == 0 ||
            gMapDHTMLForm.NAV_ALLOW_RECTANGLE.value == "false")
        {
            //alert(gMapDHTMLForm.NAV_ALLOW_RECTANGLE.value);
            MapWPointNavigation();
            return true;
        }
    }
    if (!gMapWdragging && MapWinsideMap()) {
        MapWstartZoomBox(e);
        return false;
    } 
    else if (gMapWdragging) 
    {
        MapWgetMouse(e);
        MapWstopZoomBox(e);
    }
    return true;
}

/* -------------------------------------------------------------------- */
/*      MapgetImageXY                                                   */
/* -------------------------------------------------------------------- */
function MapWgetImageXY(e)
{
    if (CWCIsNav4 || CWCIsNav6) 
    {                // Netscape
        gMapWmouseX = e.pageX;
        gMapWmouseY = e.pageY;
    } 
    else if (CWCIsIE) 
    {            // IE
        gMapWmouseX = event.clientX + document.body.scrollLeft;
        gMapWmouseY = event.clientY + document.body.scrollTop;
    } 
    else 
    {                              // Don't know
        gMapWmouseX = gMapWmouseY = 0;
    }
    // subtract offsets from page left and top
    gMapWmouseX = gMapWmouseX - gMapWhspc;
    gMapWmouseY = gMapWmouseY - gMapWvspc;
}

/* -------------------------------------------------------------------- */
/*      MapgetMouse                                                     */
/* -------------------------------------------------------------------- */
function MapWgetMouse(e)
{
    if (window.gMapDHTMLForm == null)
        return;
        
    MapWgetImageXY(e);
    
    //make sure that the forms varaibales are initialized.
    //It seems like that in IE, the mouse move may be called before.
    if (gMapDHTMLForm == null ||
        gMapDHTMLForm.MAP_CURSOR_POS_X == null)
        return true;
    
    if (MapWinsideMap())
    {
        gMapDHTMLForm.MAP_CURSOR_POS_X.value = gMapWmouseX;
        gMapDHTMLForm.MAP_CURSOR_POS_Y.value = gMapWmouseY;
        if (gCWCJSAPI)
        {
            goCWCJSAPI.oMap.cursorpos[0] = gMapWmouseX;
            goCWCJSAPI.oMap.cursorpos[1] = gMapWmouseY;
        }
    
    }
    else
    {
        gMapDHTMLForm.MAP_CURSOR_POS_X.value = -1;
        gMapDHTMLForm.MAP_CURSOR_POS_Y.value = -1;
        
        if (gCWCJSAPI)
        {
            goCWCJSAPI.oMap.cursorpos[0] = -1;
            goCWCJSAPI.oMap.cursorpos[1] = -1;
        }
        document.onmousedown = MapWmapTool;
        document.onmouseup = MapWchkMouseUp;
        /*
        if (document.onmousedown == MapWmapTool)
            document.onmousedown = null;
        if (document.onmouseup == MapWchkMouseUp)
            document.onmouseup = null;
        */
        return true;
    }
    
    //CURSOR_TYPE setting original code was here.

    if((gMapDHTMLForm.NAV_CMD != null) &&
    (gMapDHTMLForm.NAV_CMD.value == "" ||
    gMapDHTMLForm.NAV_CMD.value == "PAN_MAP" ||
    gMapDHTMLForm.NAV_CMD.value == "RULER" ||
    gMapDHTMLForm.NAV_CMD.value == "QUERY" ||
    gMapDHTMLForm.NAV_CMD.value == "ROI_TOOL"))
        return true;
    
    document.onmousedown = MapWmapTool;
    document.onmouseup = MapWchkMouseUp;
    if (gMapWdragging) 
    {
        gMapWx2 = gMapWmouseX = Math.min(Math.max(gMapWmouseX, 0), gMapWiWidth);
        gMapWy2 = gMapWmouseY = Math.min(Math.max(gMapWmouseY, 0), gMapWiHeight);
        MapWsetClip();
        return false;
    } 
    else 
    {
        return true;
    }

    return true;
}

/* -------------------------------------------------------------------- */
/*      MapWinsideMap                                                   */
/* -------------------------------------------------------------------- */
function MapWinsideMap()
{
    //alert (gMapWmouseX);
    return ((gMapWmouseX >= 0) && (gMapWmouseX < gMapWiWidth) &&
            (gMapWmouseY >= 0) && (gMapWmouseY < gMapWiHeight));
}

/* -------------------------------------------------------------------- */
/*      MapWstartZoomBox                                                */
/* -------------------------------------------------------------------- */
function MapWstartZoomBox(e)
{
    MapWgetImageXY(e);
    // keep it within the MapImage
    if (!gMapWdragging) 
    {
        // capture values to pass to map server
        gMapWfirstx = gMapWx1 = gMapWmouseX;
        gMapWfirsty =  gMapWy1 =  gMapWmouseY;
        gMapWx2 =  gMapWx1 + 1;
        gMapWy2 =  gMapWy1 + 1;
        
        CWCDHTML_ClipLayer(gMapWtoplayer, gMapWx1, gMapWy1, gMapWx2, gMapWy2);
        CWCDHTML_ClipLayer(gMapWleftlayer, gMapWx1, gMapWy1, gMapWx2, gMapWy2);
        CWCDHTML_ClipLayer(gMapWrightlayer, gMapWx1, gMapWy1, gMapWx2, gMapWy2);
        CWCDHTML_ClipLayer(gMapWbottomlayer, gMapWx1, gMapWy1, gMapWx2, gMapWy2);
        CWCDHTML_ShowLayer(gMapWtoplayer);
        CWCDHTML_ShowLayer(gMapWleftlayer);
        CWCDHTML_ShowLayer(gMapWrightlayer);
        CWCDHTML_ShowLayer(gMapWbottomlayer);
        gMapWdragging = true;
    } 
    else 
    {
        MapWstopZoomBox(e);
    }
    return false;
}

/* -------------------------------------------------------------------- */
/*      MapWstopZoomBox                                                 */
/* -------------------------------------------------------------------- */
function MapWstopZoomBox(e)
{
    gMapWdragging = false;
    gMapWsecondx = gMapWx2;
    gMapWsecondy = gMapWy2;
    //TODO : values for the smallest rectangle availablee
    if (gMapWfirstx == gMapWsecondx && gMapWfirsty == gMapWsecondy)
    {
        var szCoord = ""+ gMapWfirstx + "," + gMapWfirsty;
        if (gCWCJSAPI)
        {
            goCWCJSAPI.NAV_INPUT_COORDINATES = szCoord;
            goCWCJSAPI.NAV_INPUT_TYPE = "POINT";
            //the forms variables settings should not be necessary. But It
            //keeps consistancy since some js functions test the values
            //of the form parameters.
            gMapDHTMLForm.NAV_INPUT_COORDINATES.value = szCoord;
            gMapDHTMLForm.NAV_INPUT_TYPE.value = "POINT";
            goCWCJSAPI.UpdateNavTools();
        }
        else
        {
            gMapDHTMLForm.NAV_INPUT_COORDINATES.value = szCoord;
            gMapDHTMLForm.NAV_INPUT_TYPE.value = "POINT";
            document.onmousemove = null;
            document.onmouseup = null;
            document.onmousedown = null;
            gMapDHTMLForm.submit();
        }
        return true;
    } 
    else 
    {
        // Zoom to box
        var tx1 = Math.min(gMapWfirstx, gMapWsecondx);
        var tx2 = Math.max(gMapWfirstx, gMapWsecondx);
        var ty1 = Math.min(gMapWfirsty, gMapWsecondy);
        var ty2 = Math.max(gMapWfirsty, gMapWsecondy);
        
        var szCoord = ""+ tx1 + "," + ty1 + ";" + tx2 + "," + ty2;

        if (gCWCJSAPI)
        {
            //goCWCJSAPI.NAV_CMD = "ZOOM_IN";
            goCWCJSAPI.NAV_INPUT_COORDINATES = szCoord;
            goCWCJSAPI.NAV_INPUT_TYPE = "RECTANGLE";
            
            //the forms variables settings should not be necessary. But It
            //keeps consistancy since some js functions test the values
            //of the form parameters.
            gMapDHTMLForm.NAV_INPUT_COORDINATES.value = szCoord;
            gMapDHTMLForm.NAV_INPUT_TYPE.value = "RECTANGLE";
            
            CWCDHTML_HideLayer("zBoxTop");
            CWCDHTML_HideLayer("zBoxLeft");
            CWCDHTML_HideLayer("zBoxRight");
            CWCDHTML_HideLayer("zBoxBottom");
            goCWCJSAPI.UpdateNavTools();
        }
        else
        {
            gMapDHTMLForm.NAV_INPUT_COORDINATES.value = szCoord;
            gMapDHTMLForm.NAV_INPUT_TYPE.value = "RECTANGLE";
            document.onmousemove = null;
            document.onmouseup = null;
            document.onmousedown = null;
            gMapDHTMLForm.submit();
        }
        return true;
    }
    return false;
}

/* -------------------------------------------------------------------- */
/*      MapWsetClip                                                     */
/* -------------------------------------------------------------------- */
function MapWsetClip()
{
    gMapWzright  = Math.max(gMapWx1, gMapWx2);
    gMapWzleft   = Math.min(gMapWx1, gMapWx2);
    gMapWzbottom = Math.max(gMapWy1, gMapWy2);
    gMapWztop    = Math.min(gMapWy1, gMapWy2);
    
    if ((gMapWx1 != gMapWx2) && (gMapWy1 != gMapWy2)) 
    {
        var ovBoxSize = gMapDHTMLMarqueeWidth;
        CWCDHTML_ClipLayer(gMapWtoplayer, gMapWzleft, gMapWztop, gMapWzright, gMapWztop + ovBoxSize);
        CWCDHTML_ClipLayer(gMapWleftlayer, gMapWzleft, gMapWztop, gMapWzleft + ovBoxSize, gMapWzbottom);
        CWCDHTML_ClipLayer(gMapWrightlayer, gMapWzright - ovBoxSize, gMapWztop, gMapWzright, gMapWzbottom);
        CWCDHTML_ClipLayer(gMapWbottomlayer, gMapWzleft, gMapWzbottom - ovBoxSize, gMapWzright, gMapWzbottom);
    }
}


function MapWCaptureMouse()
{
    //register a release function
     
    if (window.gMapDHTMLForm != null && gMapDHTMLForm.CURSOR_TYPE != null)
    //gMapDHTMLForm.CURSOR_TYPE.value != "AUTO")
    {
        if (CWCIsIE)
        {
            document.all.MapLayerDiv.style.cursor = 
            gMapDHTMLForm.CURSOR_TYPE.value; //works in IE
        }
        else if (CWCIsNav6)
        {
            document.getElementById("MapLayerDiv").style.cursor = 
            gMapDHTMLForm.CURSOR_TYPE.value;
        }
        
    }
    document.onmousemove = CWC2OnMouseMoveFunction;
    document.ondragstart = CWCOnDragStart;
}

function MapWReleaseMouse(e)
{
    if (!CWCIsIE && e == undefined)
    {
        document.onmousemove = null;
        return;
    }
    MapWgetImageXY(e);
    if (!MapWinsideMap())
    {
        document.onmousemove = null;
    }
}

/* -------------------------------------------------------------------- */
/*      MapWCreateDHTMLLayers                                            */
/* -------------------------------------------------------------------- */
function MapWCreateDHTMLLayers()
{
    var content = "";
    //panning layer
    
    CWCDHTML_CreateLayer("MapLayerBG", gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         true, content);
    CWCDHTML_SetLayerZOrder( "MapLayerBG", 10 );

    CWCDHTML_SetLayerBackgroundColor("MapLayerBG", 'WHITE');
    
    content = "<img id=\"MapLayerDivImg\" name=\"MapLayerDivImg\" src=\""+gAPixel+"\" width=\""+gMapWiWidth+"\" height=\""+gMapWiHeight+"\" border=\"0\" onload=\"MapWHideActivityLayer();\"  onmouseover=\"MapWCaptureMouse(arguments[0]);\" onmouseout=\"MapWReleaseMouse(arguments[0]);\">";
    CWCDHTML_CreateLayer("MapLayerDiv", gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                          true, content);
    CWCDHTML_SetLayerZOrder( "MapLayerDiv", 11 );
        
    content = '<img id="zImgTop" name="zImgTop" src="'+gMapDHTMLVerticalMarquee+'" border="1">';
    CWCDHTML_CreateLayer("zBoxTop", gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( "zBoxTop", 20 );
    CWCDHTML_SetLayerBackgroundColor("zBoxTop", gMapDHTMLMarqueeColor);
    
    content = '<img id="zImgLeft" name="zImgLeft" src="'+gMapDHTMLHorizontalMarquee+'" border="1">';
    CWCDHTML_CreateLayer("zBoxLeft", gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( "zBoxLeft", 20 );
    CWCDHTML_SetLayerBackgroundColor("zBoxLeft", gMapDHTMLMarqueeColor);
    
    content = '<img id="zImgBottom" name="zImgBottom" src="'+gMapDHTMLVerticalMarquee+'" border="1">';
    CWCDHTML_CreateLayer("zBoxBottom", gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( "zBoxBottom", 20 );
    CWCDHTML_SetLayerBackgroundColor("zBoxBottom", gMapDHTMLMarqueeColor);
    
    content = '<img id="zImgRight" name="zImgRight" src="'+gMapDHTMLHorizontalMarquee+'" border="1">';
    CWCDHTML_CreateLayer("zBoxRight", gMapWhspc, gMapWvspc, gMapWiWidth, gMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( "zBoxRight", 20 );
    CWCDHTML_SetLayerBackgroundColor("zBoxRight", gMapDHTMLMarqueeColor);
    
    content = '<img id="ActivityImg" name="ActivityImg" src="' + gMapDHTMLWaitImage + '" width="' + 
              gMapDHTMLWaitImageWidth + '" height="' + gMapDHTMLWaitImageHeight + '" border="0">';
    CWCDHTML_CreateLayer("ActivityLayer", gMapWhspc + gMapWiWidth/2 - gMapDHTMLWaitImageWidth/2, 
                         gMapWvspc + gMapWiHeight/2 - gMapDHTMLWaitImageHeight/2, gMapDHTMLWaitImageWidth, 
                         gMapDHTMLWaitImageHeight, true, content);

    CWCDHTML_SetLayerZOrder( "ActivityLayer", 30 );
}

function MapWComputeMapPosition()
{
    if (document.layers) //Netscape 4.x
    {
        gMapWhspc = document.images['mapFrameTL'].x;
        gMapWvspc = document.images['mapFrameTL'].y;
    }
    else
    {
        gMapWhspc = CWCDHTML_FindObjectPosX( document.getElementById('mapFrameTL'));
        gMapWvspc = CWCDHTML_FindObjectPosY( document. getElementById('mapFrameTL'));
    }
    
    gMapWhspc+=1;
    gMapWvspc+=1;

}

/* -------------------------------------------------------------------- */
/*       Initilalization function called from on load.                  */
/* -------------------------------------------------------------------- */
function MapWidgetInitVariables()
{
    MapWComputeMapPosition();

    
    MapWsetZoomBoxSettings();
    MapWCreateDHTMLLayers();
}

/**
 * MapWMapExtentsChanged
 * called to initialize the JS API widget
 */
function MapWMapExtentsChanged()
{
    var sImgName = "MapLayerDivImg";
    var url = gMapDHTMLURL;
    var d = new Date();
    var unique = d.getTime() + '' + Math.floor(1000 * Math.random());
    url = url + "&UniqId="+unique;
    if (navigator.appName == "Netscape" && navigator.appVersion[0] <= 4)
    {
        document.layers["MapLayerDiv"].document.images[0].src=url; //for netscape4
    }
    else
    {
        document.images["MapLayerDivImg"].src = url;  //for IE and Netscape6 works
    }
}

/**
 * MapWRegisterForEvent
 * called to create a dynamic layer
 */
function MapWRegisterForEvent()
{
    goCWCJSAPI.RegisterEvent(MAP_EXTENT_CHANGED, "MapWMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(LAYER_STATUS_CHANGED, "MapWMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(LAYER_ORDER_CHANGED, "MapWMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(LAYER_STYLE_CHANGED, "MapWMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(MAP_NEW_LAYER_ADDED, "MapWMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(MAP_NEW_ELEMENT_ADDED, "MapWMapExtentsChanged");

    //set the js map object to allow resizing or not.
    goCWCJSAPI.oMap.bAllowResize = gMapDHTMLAllowResize;
}
        
/**
 * MapLayerDivImgOnLoad
 * called to initialize the map image after the page has loaded
 */
function MapLayerDivImgOnLoad()
{
    var sImgName = "MapLayerDivImg";
    var url = gMapDHTMLURL;
    var d = new Date();
    var unique = d.getTime() + '' + Math.floor(1000 * Math.random());
    url = url + "&UniqId="+unique;

    if (navigator.appName == "Netscape" && navigator.appVersion[0] <= 4)
    {
        document.layers["MapLayerDiv"].document.images[0].src=url; //for netscape4
    }
    else
    {
        document.images["MapLayerDivImg"].src = url;  //for IE and Netscape6 works
    }
}

/**
 * MapWHideActivityLayer
 * called to initialize the map image after the page has loaded
 */
function MapWHideActivityLayer()
{
    var szImage = null;
    if (navigator.appName == "Netscape" && navigator.appVersion[0] <= 4)
    {
       szImage = document.layers["MapLayerDiv"].document.images[0].src;
    }
    else
    {
        szImage = document.images["MapLayerDivImg"].src;  //for IE and Netscape6 works
    }
    if (szImage != null && szImage.indexOf( 'a_pixel' ) == -1)
    {
        CWCDHTML_HideLayer('ActivityLayer');
        CWCDHTML_ShowLayer('MapLayerDiv');
    }
    
}

/**
 * MapWPositionMapDHTML
 * called to position the map image after the page has loaded (inside the onload).
 * Ita also position the background image layer and the zoom layers.
 */
function MapWPositionMapDHTML()
{
  MapWComputeMapPosition();

  if (CWCIsIE)
    {
        //map
        document.all.MapLayerDiv.style.left = gMapWhspc;
        document.all.MapLayerDiv.style.top = gMapWvspc;
        //map background
        document.all.MapLayerBG.style.left = gMapWhspc;
        document.all.MapLayerBG.style.top = gMapWvspc;
        //zoom layers
        document.all.zBoxTop.style.left = gMapWhspc;
        document.all.zBoxTop.style.top = gMapWvspc;
        document.all.zBoxLeft.style.left = gMapWhspc;
        document.all.zBoxLeft.style.top = gMapWvspc;
        document.all.zBoxRight.style.left = gMapWhspc;
        document.all.zBoxRight.style.top = gMapWvspc;
        document.all.zBoxBottom.style.left = gMapWhspc;
        document.all.zBoxBottom.style.top = gMapWvspc;

      }
  else if (CWCIsNav6)
      {
        document.getElementById("MapLayerDiv").style.left = gMapWhspc;
        document.getElementById("MapLayerDiv").style.top = gMapWvspc;

        document.getElementById("MapLayerBG").style.left = gMapWhspc;
        document.getElementById("MapLayerBG").style.top = gMapWvspc;

        document.getElementById("zBoxLeft").style.left = gMapWhspc;
        document.getElementById("zBoxLeft").style.top = gMapWvspc;

        document.getElementById("zBoxRight").style.left = gMapWhspc;
        document.getElementById("zBoxRight").style.top = gMapWvspc;

        document.getElementById("zBoxTop").style.left = gMapWhspc;
        document.getElementById("zBoxTop").style.top = gMapWvspc;

        document.getElementById("zBoxBottom").style.left = gMapWhspc;
        document.getElementById("zBoxBottom").style.top = gMapWvspc;

      }

}