<?php
/**
* LegendTemplateLM Widget class
*
* @project     CWC2
* @revision    $Id:
* @purpose     Legend Template Widget class  ESPECIALY CODED FOR LAYERMANAGER widget
* @author      DM Solutions Group (sfournier@dmsolutions.ca)
* @copyright
* <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
* DEALINGS IN THE SOFTWARE.
*/

include_once(dirname(__FILE__)."/../LegendTemplate/LegendTemplate.widget.php");

/**
* LegendTemplateLM
*
* @desc LegendTemplate widget class
*/
class LegendTemplateLM extends LegendTemplate
{
    var $moTmpMapObject;
    
    /**
    * LegendTemplateLM
    *
    * Constctor method for the LegendPopup widget.
    */
    function LegendTemplateLM()
    {
        // invoke constructor of parent
        parent::LegendTemplate();
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Legend widget allows the user display a legend based on a legend template.
The Legend can either be embedded in the same page or displayed in a separate window.
This widget was coded especialy for LayerManager widget. It use a different MapObject.
EOT;
    }
    
    function parseURL()
    {
        // create a new map session object
        $oNewMapSession = new MapSession_RW;
        
        // set the temp directory for the map session
        $oNewMapSession->setTempDir( $_SESSION['gszTmpPath'] );
        
        if (!$this->isVarSet("LAYERMANAGER2_CURRENT_STATE"))
        {
            $oNewMapSession->restoreState( $_SESSION["gszCurrentState"],
            $_SESSION['gszMapName'],
            dirname($_SESSION['gszMapName'] ) );
        }
        else
        {
            $oNewMapSession->restoreState( $this->getVar("LAYERMANAGER2_CURRENT_STATE"),
            $_SESSION['gszMapName'],
            dirname($_SESSION['gszMapName'] ) );
            
            // restore projection, extent and mapsize
            $oNewMapSession->oMap->setProjection($this->moMapObject->oMap->getProjection(),
            true);
            $oNewMapSession->oMap->setextent($this->moMapObject->oMap->extent->minx,
            $this->moMapObject->oMap->extent->miny,
            $this->moMapObject->oMap->extent->maxx,
            $this->moMapObject->oMap->extent->maxy);
            $oNewMapSession->oMap->set("width", $this->moMapObject->oMap->width);
            $oNewMapSession->oMap->set("height", $this->moMapObject->oMap->height);
        }
        
        // Make sure the imageurl and imagepath are set to chameleon configuration
        $oNewMapSession->oMap->web->set("imageurl", $_SESSION['gszTmpWebPath']);
        $oNewMapSession->oMap->web->set("imagepath", $_SESSION['gszTmpImgPath']);
        $oNewMapSession->oMap->selectOutputFormat($_SESSION['gszImgType']);
        
        $oTmpMapObj = $this->moMapObject;
        $this->moMapObject = $oNewMapSession;
        parent::parseURL();
        $this->moMapObject = $oTmpMapObj;
        $this->moTmpMapObject = $oNewMapSession;
    }
    
    function GetJavascriptFunctions()
    {
        $oTmpMapObj = $this->moMapObject;
        $this->moMapObject = $this->moTmpMapObject;
        $aReturn = parent::GetJavascriptFunctions();
        $this->moMapObject = $oTmpMapObj;
        
        $szLayer = $this->getVar('LAYERMANAGER_LAYER');
        $szJsFunctionName = "SelectSelectedLayer";
        if ($this->isVarSet('LAYERMANAGER_LAYER'))
        {
            $szFunction = <<<EOT
function {$szJsFunctionName}()
{
  var i;
  var bFind = false;

  if({$this->mszHTMLForm}['LAYERMANAGER_LAYER'][0] == null)
  {
    {$this->mszHTMLForm}['LAYERMANAGER_LAYER'].checked = true;
  }
  else
  {
    for(var i=0;i<{$this->mszHTMLForm}['LAYERMANAGER_LAYER'].length;i++)
    {
      if ({$this->mszHTMLForm}['LAYERMANAGER_LAYER'][i].value == '{$szLayer}')
      {
        bFind = true;
        {$this->mszHTMLForm}['LAYERMANAGER_LAYER'][i].checked = true;
      }
    }

    // just in case.
    if (!bFind)
      {$this->mszHTMLForm}['LAYERMANAGER_LAYER'][0].checked = true;
  }
}
EOT;
}
else
{
    $szFunction = <<<EOT
function {$szJsFunctionName}()
{
    {$this->mszHTMLForm}['LAYERMANAGER_LAYER'][0].checked = true;
}
EOT;
}

$aReturn[$szJsFunctionName] = $szFunction;

return $aReturn;
    }
    
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = parent::GetJavascriptOnLoadFunctions();
        
        $aReturn['SelectSelectedLayer'] = "SelectSelectedLayer();";
        
        return $aReturn;
    }
    
    function drawPublish()
    {
        $oTmpMapObj = $this->moMapObject;
        $this->moMapObject = $this->moTmpMapObject;
        $aReturn = parent::drawPublish();
        $this->moMapObject = $oTmpMapObj;
        
        return $aReturn;
    }
}
?>
