<?php
/**
 * LegendTemplate Widget class
 *
 * @project     CWC2
 * @revision    $Id: LegendTemplate.widget.php,v 1.6 2004/07/08 20:53:40 jlacroix Exp $
 * @purpose     Legend Template Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * LegendTemplate
 *
 * @desc LegendTemplate widget class
 */
class LegendTemplate extends CWCWidget
{
    var $mszTemplate;      // [string]

    var $moButton;         // Button object
    var $moPopup;          // Popup object
    var $moInfoPopup;      // Popup object for Info dialog


    /**
     * LegendTemplate
     *
     * Constctor method for the LegendPopup widget.
     */
    function LegendTemplate()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/LegendPopup.dbf";

        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Legend widget allows the user display a legend based on a legend template.
The Legend can either be embedded in the same page or displayed in a separate window.
EOT;
        $this->maAttributes["TEMPLATE"] = new StringAttribute( "TEMPLATE", true );

    }



    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        if (isset($this->maParams["EMBEDDED"]) &&
            strcasecmp(trim($this->maParams["EMBEDDED"]), "FALSE") == 0)
        {
            $this->moButton = new CWCButton($this);
            $this->moButton->InitDefaults();
            $this->moButton->SetOnClick("LegendTemplatePopup");
            $this->moPopup = new CWCPopup($this);
            $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."widgets/LegendTemplate/LegendTemplatePopup.phtml";
        }
        else
        {
            $this->moInfoPopup = new CWCPopup($this);
            $this->moInfoPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/LegendTemplate/LegendInfo.phtml?layerName='+layername+'";
        }
        
        if (isset($this->maParams["TEMPLATE"]))
        {
            $this->mszTemplate = trim($this->maParams["TEMPLATE"]);
            //TEMPLATE is relative to the application template, not the map file :)
            if (strcmp(substr($this->mszTemplate, 0, 1), "/") ||
                strcmp(substr($this->mszTemplate, 1, 1), ":") ||
                strcmp(substr($this->mszTemplate, 0, 1), "\\") )
            {
                $oChameleon = GetChameleonApplication();
                $szTemplatePath = dirname($oChameleon->mszTemplateName);
                $this->mszTemplate = realpath($szTemplatePath."/".$this->mszTemplate);
            }
            if (strtoupper(substr($this->mszTemplate, 0, 7)) == "HTTP://")
            {
                $aszFile = file($this->mszTemplate);
                $szTmpName = tempnam($_SESSION['gszTmpPath'], "legendtemplate").".html";
                $fh = fopen($szTmpName, "w");

                $nbLine = count($aszFile);

                for($i=0; $i<$nbLine; $i++)
                {
                    fwrite($fh, $aszFile[$i]);
                }
                fclose($fh);

                $this->mszTemplate = $szTmpName;
            }
        }
    }

    function GetJavascriptInitFunctions()
    {
        if (isset($this->maParams["EMBEDDED"]) &&
            strcasecmp(trim($this->maParams["EMBEDDED"]), "FALSE") == 0)
        {
            return $this->moButton->GetJavascriptInitFunctions();
        }
        else
            return array();
    }

    function GetJavascriptVariables()
    {
        $aResult = array();
        
        if (isset($this->maParams["EMBEDDED"]) &&
            strcasecmp(trim($this->maParams["EMBEDDED"]), "FALSE") == 0)
        {
            $aResult = $this->moButton->GetJavascriptVariables();
        }
        
        
    }

    function GetJavascriptIncludeFunctions()
    {
        if (isset($this->maParams["EMBEDDED"]) &&
            strcasecmp(trim($this->maParams["EMBEDDED"]), "FALSE") == 0)
        {
            return $this->moButton->GetJavascriptIncludeFunctions();
        }
        else
            return array();
    }

    /**
     * GetJavascriptFunctions.
     *
     */
    function GetJavascriptFunctions()
    {
        $poMap = $this->moMapObject->oMap;

        $aReturn = array();

        $aReturn = parent::GetJavascriptFunctions();

        $url_sid = SID;
        if (isset($_SESSION['gszCoreWebPath']))
        {
            $szWidgetPath = $_SESSION['gszCoreWebPath'] . "/widgets/LegendTemplate/";
        }
        else
        {
            $szWidgetPath = "widgets/LegendTemplate/";
        }
        
        
        $szLayers = "aLayers = new Array();\n";
        $oMap = $this->moMapObject->oMap;
        for( $i=0; $i< $oMap->numlayers; $i++)
        {
            $oLayer = $oMap->getLayer( $i );
            $oLayer->setmetadata( "layer_index", $i );
            $szLayers .= 'aLayers['.$i.'] = "'.$oLayer->name.'";'."\n";
        }
        
        $szJsFunctionName = "LegendTemplateGetLayerName";
        $szFunction = <<<EOT
function {$szJsFunctionName}( index )
{
{$szLayers}
return aLayers[index];
}
        
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;
        
        if (!isset($this->maParams["EMBEDDED"]) ||
            strcasecmp(trim($this->maParams["EMBEDDED"]), "TRUE") == 0)
        {
            $szJsFunctionName = "LegendTemplateLayerInfo";
            $szButtonJS = $this->moInfoPopup->DrawPublish();
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to popup infos on the layer into a separate window
 */
function {$szJsFunctionName}(layername)
{
    {$szButtonJS}
    return false;
}
EOT;

            $aReturn[$szJsFunctionName] = $szFunction;
        }

        if (isset($this->maParams["EMBEDDED"]) &&
            strcasecmp(trim($this->maParams["EMBEDDED"]), "FALSE") == 0)
        {
            $szJsFunctionName = "LegendTemplatePopup";
            
            $szFunction = "function $szJsFunctionName()\n" .
              "{\n".
              $this->moPopup->DrawPublish()."\n".
              "return;\n" .
              "}\n";
            $aReturn[$szJsFunctionName] = $szFunction;
        }

/////////////////////////////

        // add javascript API functions
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if ($bCWCJSAPI)
        {
            $szJsFunctionName = "LegendTemplateWRegisterForEvent";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to register events when the layers change (JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(LAYER_STATUS_CHANGED, "LegendTemplateWLayersChanged");
    goCWCJSAPI.RegisterEvent(LAYER_ORDER_CHANGED, "LegendTemplateWLayersChanged");
    goCWCJSAPI.RegisterEvent(MAP_NEW_LAYER_ADDED, "LegendTemplateWLayersChanged");
}
EOT;

           $aReturn[$szJsFunctionName] = $szFunction;
           $szJsFunctionName = "LegendTemplateWLayersChanged";
           $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the layers are changed(JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.ProcessLegendTemplate();
}
EOT;
            $aReturn[$szJsFunctionName] = $szFunction;

        }

/////////////////////////////////////

        return $aReturn;
    }

    /**
     * return an array of javascript functions needed by Legend widget
     * and called when the page is loaded.
     * @return array of name = function values
     */
    function GetJavascriptOnLoadFunctions()
    {
        if (isset($this->maParams["EMBEDDED"]) &&
            strcasecmp(trim($this->maParams["EMBEDDED"]), "FALSE") == 0)
        {
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        }
        else
            $aReturn = parent::GetJavascriptOnLoadFunctions();

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
            $szJsFunctionName = "LegendTemplateWRegisterForEvent";
            $szFunction = "$szJsFunctionName();\n";
            $aReturn[$szJsFunctionName] = $szFunction;
        }

        return $aReturn;
    }

    /**
     * ParseURL
     *
     * Look for layers name in the url and set the status on/off.
     */
    function ParseURL()
    {
        // parse layer stuff
        $oMap = $this->moMapObject->oMap;

        if (!isset($this->maParams["EMBEDDED"]) ||
                (isset($this->maParams["EMBEDDED"]) &&
                 strcasecmp(trim($this->maParams["EMBEDDED"]), "TRUE") == 0))
        {
            if ($this->isVarSet("LEGENDTEMPLATE_LAYERS"))
            {
                $aLayers = explode( ",", $this->getVar("LEGENDTEMPLATE_LAYERS") );
            }
            else
            {
                $aLayers = array();
            }

            if ($this->isVarSet("LEGENDTEMPLATE_RESET") && $this->getVar("LEGENDTEMPLATE_RESET") != "")
            {
            }
            elseif ($this->isVarSet("legendlayername") || count($aLayers) > 0 )
            {
                if ($this->isVarSet("legendlayername"))
                    $aLegendLayers = $this->getVar("legendlayername");
                else
                    $aLegendLayers = array();
                $nLayers = count($aLegendLayers);

                for ($i=0; $i<$oMap->numlayers; $i++)
                {
                    $oLayer = @$oMap->getlayer($i);
                    if ($oLayer->status == MS_DELETE)
                        continue;
                    if (in_array($oLayer->name, $aLayers ))
                    {
                        if (in_array($oLayer->name, $aLegendLayers))
                            $oLayer->set("status", MS_ON);
                        else
                            $oLayer->set("status", MS_OFF);
                    }
                }
            }
            elseif ($this->isVarSet("legendgroupname") || count($aLayers) > 0 )
            {
                if ($this->isVarSet("legendgroupname"))
                    $aLegendGroups = $this->getVar("legendgroupname");
                else
                    $aLegendGroups = array();
                $nLegendGroups = count($aLegendGroups);
                $aAllGroups = $oMap->getAllGroupNames();
                for ($i=0; $i<$oMap->numlayers; $i++)
                {
                    $oLayer = @$oMap->getlayer($i);
                    if (in_array($oLayer->name, $aLayers ))
                    {
                        $oLayer->set("status", MS_OFF);
                    }
                }

                for ($i=0; $i<$nLegendGroups; $i++)
                {
                    if (in_array($aLegendGroups[$i], $aAllGroups))
                    {
                        $aLayerInGroup =
                          $oMap->getLayersIndexByGroup($aLegendGroups[$i]);
                        $nLayerInGroup = count($aLayerInGroup);
                        for ($j=0; $j<$nLayerInGroup; $j++)
                        {
                            $oLayer = @$oMap->getlayer($aLayerInGroup[$j]);
                            if ($oLayer->status == MS_DELETE)
                                continue;
                            if (in_array($oLayer->name, $aLayers ))
                            {
                                $oLayer->set("status", MS_ON);
                            }
                        }
                    }
                }
            }
        }
        
        // return success
        return true;
    }
    
    function GetHTMLHiddenVariables()
    {
        if (isset($this->maParams["EMBEDDED"]) &&
            strcasecmp(trim($this->maParams["EMBEDDED"]), "FALSE") == 0)
        {
            $aReturn = $this->moButton->GetHTMLHiddenVariables();
        }
        else
        {
            $aReturn = array();
        }

        $szVariable = "LEGENDTEMPLATE_RESET";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        //record layer names so that new layers don't get turned off by mistake
        $szLayerNames = "";
        $szSep = "";
        $oMap = $this->moMapObject->oMap;
        for ($i=0; $i<$oMap->numlayers; $i++)
        {
            $oLayer = $oMap->getlayer($i);
            // Don't include layers that will be deleted.
            if( $oLayer->status != MS_DELETE )
            {
                $szLayerNames .= $szSep . $oLayer->name;
                $szSep = ",";
            }
        }

        $szVariable = "LEGENDTEMPLATE_LAYERS";
        $szValue = " <INPUT TYPE=\"HIDDEN\" NAME=\"$szVariable\" VALUE=\"$szLayerNames\">\n";
        $aReturn[$szVariable] = $szValue;
        
        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code that displays the legend based on the
     * legend template or a link to display the legend in a popup
     * windows if the paramater EMBEDDED is false.
     */
    function DrawPublish()
    {
        $poMap = $this->moMapObject->oMap;
        $poMap->legend->set("template",$this->mszTemplate);
        if (!$this->mbVisible)
            return "<!-- LegendTemplateWidget is hidden -->";


        if ($this->mszTemplate != "")
        {
/* *************************************************** */
/* If specified template is a remote file then copy it */
/* localy before using it.                             */
/* *************************************************** */
/* ==================================================================== */
/*      Patch to be able to order layers in reverse order that they     */
/*      appear in the map file. This should be remove as soon as the    */
/*      legend html mapserver code will support the ascending and       */
/*      descending order tag.                                           */
/* ==================================================================== */
            $nLayers = $poMap->numlayers;
            for ($i=0; $i<$nLayers; $i++)
            {
                $poLayer = $poMap->getlayer($i);
                $poLayer->setMetaData("LEGEND_ORDER", $i);
            }
            if (!isset($this->maParams["EMBEDDED"]) ||
                (isset($this->maParams["EMBEDDED"]) &&
                 strcasecmp(trim($this->maParams["EMBEDDED"]), "TRUE") == 0))
            {
                $szLegendTemp = $poMap->processLegendTemplate( array());
                //$szReturn "<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"2\" >";

                // add div tags if in javascript API mode
                if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
                    $szReturn = "<div name=\"legendTemplateDiv\" id=\"legendTemplateDiv\"><table>".$szLegendTemp."</table></div>";
                else
                    $szReturn = $szLegendTemp;
                //echo "</TABLE>";

                return $szReturn;
            }
            else //not embedded
            {
                $szReturn = $this->moButton->DrawPublish();

                return $szReturn;
            }
        }
        else // no template : fall back on mapserver legend ??
        {
            $_SESSION['gErrorManager']->setError(ERR_WARNING, trim($this->moMLT->get("1", "No Template found for Legend widget.")));
        }
    }

}
?>
