<?php
/**
 * Legend Widget class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     LegendPopup Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * Legend
 *
 * @desc Legend widget class
 */
class Legend extends CWCWidget
{
    var $mszTemplate;      /// [string]

    var $moButton;     /// Button object
    var $moPopup;          /// Popup object
    var $mnPopVal; //remember if a window is popped up


    /**
     * Legend
     *
     * Constctor method for the Legend widget.
     */
    function Legend()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/LegendPopup.dbf";

        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The LegendPopup widget allows the user to popup a legend for the current
context in a separate window.
EOT;

        $this->moButton = new CWCButton($this);
        $this->moPopup = new CWCPopup($this);
        $this->moPopup->mszLink = "widgets/Legend/LegendPopup.phtml";

    }

    function InitDefaults()
    {
        parent::InitDefaults();
        $this->moButton->InitDefaults();
        $this->mnPopVal = 0;
        
        $szTemplate = "";
        if (isset($this->maParams["TEMPLATE"]))
            $szTemplate = $this->maParams["TEMPLATE"];
            
        if ($szTemplate != "")
        {
            $this->moButton->SetOnClick("clickLegendPopup");
        }
        else
        {
            $this->moButton->SetOnClick('alert', trim($this->oMLT->get('1', 'ERROR: No legend template specified.')) );
        }
    }
    
    function ParseURL()
    {
        // add the hidden form variable
        if ( $this->isVarSet('leg_wid_popup_open') && 
             $this->getVar('leg_wid_popup_open') == 1 )
            $this->mnPopVal = 1;
        else 
            $this->mnPopup = 0;

        return true;
    }
    
    /**
     * GetHTMLHiddenVariables
     *
     * Returnrs an empty  string. Should be redefined for Widgets 
     * returning hidden variables
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $aReturn["LEG_WID_POPUP_OPEN"] =  "<input type=\"hidden\" name=\"leg_wid_popup_open\" value=\"".$this->mnPopVal."\">";

        return $aReturn;
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $szTemplate = "";
        if (isset($this->maParams["TEMPLATE"]))
            $szTemplate = $this->maParams["TEMPLATE"];
        if ($szTemplate != "")
        {
            $this->moPopup->mszParam = "&szTemplate=".urlencode($szTemplate);
        }

        $szJsFunctionName = "clickLegendPopup";
        $szFunction = "function $szJsFunctionName()\n" .
         "{\n".
          $this->moPopup->DrawPublish()."\n".
        "return;\n" .
        "}\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        // add javascript API functions
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if ($bCWCJSAPI)
        {
            $szJsFunctionName = "LegendWRegisterForEvent";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to register events when the layers change (JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(LAYER_STATUS_CHANGED, "LegendWLayersChanged");
    goCWCJSAPI.RegisterEvent(LAYER_ORDER_CHANGED, "LegendWLayersChanged");
    goCWCJSAPI.RegisterEvent(MAP_NEW_LAYER_ADDED, "LegendWLayersChanged");
    
    
}
EOT;
    
       $aReturn[$szJsFunctionName] = $szFunction;
       $szJsFunctionName = "LegendWLayersChanged";
       $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the layers are changed(JSAPI)
 */
function {$szJsFunctionName}()
{
    UpdatePopup();
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;
       $szJsFunctionName = "UpdatePopup";
       $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * update popup if open(JSAPI)
 */
function {$szJsFunctionName}()
{
    // only update if the window is open
    if ( {$this->mszHTMLForm}.leg_wid_popup_open != null && 
             {$this->mszHTMLForm}.leg_wid_popup_open.value == 1 )
    {
        clickLegendPopup();
    }
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;       

       }        
        
        // return the array of functions
        return $aReturn;
    }
    
    /**
     * return an array of javascript functions needed by Legend widget
     * and called when the page is loaded. 
     * @return array of name = function values
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();
        
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
            $szJsFunctionName = "LegendWRegisterForEvent";
            $szFunction = "$szJsFunctionName();\n";
            $aReturn[$szJsFunctionName] = $szFunction;
            $szJsFunctionName = "UpdatePopup";
            $szFunction = "$szJsFunctionName();\n";
            $aReturn[$szJsFunctionName] = $szFunction;            
        }
        

        return $aReturn;
    }            
    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }        
    /**
     * DrawPublish
     *
     * Return the HTML code to display the link to the legend popup
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- LegendWidget is hidden -->";
           
        $szReturn = parent::DrawPublish();

        $szReturn = $this->moButton->DrawPublish();
        

        return $szReturn;
    }
}
?>
