<?php
/**
* LayerManagerAction Widget class
*
* @project     CWC2
* @revision    $Id:
* @purpose     LayerManagerAction Widget class
* @author      DM Solutions Group (sacha@dmsolutions.ca)
* @copyright
* <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
* DEALINGS IN THE SOFTWARE.
*/
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
* LayerOrderUp
*
* @desc Display a clickable image that will update the map
*/
class LayerManagerAction extends CWCWidget
{
    var $mszAction;
    var $moButton;
    var $mszCurrentState = "";
    
    /**
    * LayerManagerAction
    *
    * Constructor for the LayerManagerAction
    */
    function LayerManagerAction()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        $this->moParent =& $oParent;
        $this->mnPriority = PRIORITY_HIGH;
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
See alse the UpdateMap Widget
The LayerManagerAction widget will possibly cause the layerorder to be changed
See visibility checkbox handling
EOT;
        $this->maAttributes["ACTION"] = new StringAttribute( "ACTION", true, array("UP", "DOWN", "DELETE", "APPLY") );
        
        $this->moButton = new CWCButton($this);
    }
    
    /**
    * Get LayerManager action
    */
    function InitDefaults()
    {
        parent::InitDefaults();
        $this->moButton->InitDefaults();
        
        $this->mszAction = $this->maParams['ACTION'];
        
        $this->moButton->SetOnClick( "clickLayerManagerAction", $this->mszAction );
    }
    
    /**
    * GetHTMLHiddenVariables
    *
    * Return HTML hidden variables.
    */
    function GetHTMLHiddenVariables()
    {
        $aReturn = array_merge($this->moButton->GetHTMLHiddenVariables(), parent::GetHTMLHiddenVariables());
        
        $szVariable = "LAYERMANAGER_ACTION";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
        $aReturn[$szVariable] = $szValue;
        
        if ($this->mszCurrentState != "")
        {
            $szVariable = "LAYERMANAGER2_CURRENT_STATE";
            $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$this->mszCurrentState."\">";
            $aReturn[$szVariable] = $szValue;
        }
        
        return $aReturn;
    }
    
    /**
    * GetJavascriptFunctions
    *
    * Return the Javacriptfunctions needed by the widget.
    */
    function GetJavascriptFunctions()
    {
        $aReturn = $this->moButton->GetJavascriptFunctions();;
        
        $szJsFunctionName = "clickLayerManagerAction";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the user clicks the LayerOrderUp icon
 */
function {$szJsFunctionName}(obj, szAction)
{
    {$this->mszHTMLForm}['LAYERMANAGER_ACTION'].value = szAction;
    {$this->mszHTMLForm}.submit();

    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;
        
        $szJsFunctionName = "LayerManagerApplyChanges";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the user clicks Apply
 */
function {$szJsFunctionName}()
{
    opener.LayerManager2CallBack(0, this);

    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;
        
        return $aReturn;
}

/**
* GetJavascriptOnLoadFunctions
*
* On load functions.
*/
function GetJavascriptOnLoadFunctions()
{
    $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
    
    if ($this->isVarSet('LAYERMANAGER_ACTION') &&
    $this->getVar('LAYERMANAGER_ACTION') == "APPLY" &&
    $this->mszAction == "APPLY")
    $aReturn['LayerManagerApplyChanges'] = "LayerManagerApplyChanges();\n";
    
    return $aReturn;
}


/**
* GetJavascriptInitFunctions
*
* On init functions.
*/
function GetJavascriptInitFunctions()
{
    $aReturn = $this->moButton->GetJavascriptInitFunctions();
    
    return $aReturn;
}

/**
* GetJavascriptIncludeFunctions()
*
* On init functions.
*/
function GetJavascriptIncludeFunctions()
{
    $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
    
    return $aReturn;
}

/**
* DrawPublish
*
* Return the HTML code using the name in the map file and the
* parameters of the CWC tag.
*/
function DrawPublish()
{
    if (!$this->mbVisible)
    return "<!-- LayerManagerAction widget hidden -->";
    
    return $this->moButton->DrawPublish();
}
/**
* ParseURL
*
* Look for selected layers and move them Up or Down or Delete.
*/
function  ParseURL()
{
    $this->moButton->ParseURL();
    if ($this->isVarSet("LAYERMANAGER_ACTION") &&
    $this->getVar("LAYERMANAGER_ACTION") == $this->mszAction)
    {
        // create a new map session object
        $oNewMapSession = new MapSession_RW;
        
        // set the temp directory for the map session
        $oNewMapSession->setTempDir( $_SESSION['gszTmpPath'] );
        
        if (!$this->isVarSet("LAYERMANAGER2_CURRENT_STATE") ||
        $this->getVar("LAYERMANAGER2_CURRENT_STATE") == "")
        {
            $oNewMapSession->restoreState( $_SESSION["gszCurrentState"],
            $_SESSION['gszMapName'],
            dirname($_SESSION['gszMapName'] ) );
        }
        else
        {
            $oNewMapSession->restoreState( $this->getVar("LAYERMANAGER2_CURRENT_STATE"),
            $_SESSION['gszMapName'],
            dirname($_SESSION['gszMapName'] ) );
            
            // restore projection, extent and mapsize
            $oNewMapSession->oMap->setProjection($this->moMapObject->oMap->getProjection(),
            true);
            $oNewMapSession->oMap->setextent($this->moMapObject->oMap->extent->minx,
            $this->moMapObject->oMap->extent->miny,
            $this->moMapObject->oMap->extent->maxx,
            $this->moMapObject->oMap->extent->maxy);
            $oNewMapSession->oMap->set("width", $this->moMapObject->oMap->width);
            $oNewMapSession->oMap->set("height", $this->moMapObject->oMap->height);
        }
        
        // Make sure the imageurl and imagepath are set to chameleon configuration
        $oNewMapSession->oMap->web->set("imageurl", $_SESSION['gszTmpWebPath']);
        $oNewMapSession->oMap->web->set("imagepath", $_SESSION['gszTmpImgPath']);
        $oNewMapSession->oMap->selectOutputFormat($_SESSION['gszImgType']);
        
        $oMap =& $oNewMapSession->oMap;
        
        //Get the Layer selected by radio button
        $szSelectedLayer = $this->getVar('LAYERMANAGER_LAYER');
        
        // Get the Layer(s) sleected by checkbox.
        $aszSelectedVisibleLayers = ($this->isVarSet('LAYERMANAGER_LAYERS')) ?
        $this->getVar('LAYERMANAGER_LAYERS') : array();
        
        // check for visibility.
        for($i=0; $i < $oMap->numlayers; $i++)
        {
            $oLayer = $oMap->getLayer($i);
            
            if (in_array($oLayer->name, $aszSelectedVisibleLayers))
            $oLayer->set('status', MS_ON);
            else
            $oLayer->set('status', MS_OFF);
        }
        
        for($i=0; $i < $oMap->numlayers; $i++)
        {
            $oLayer = $oMap->getLayer($i);
            
            if ($oLayer->name == $szSelectedLayer)
            {
                if ($this->mszAction == "DOWN")
                $oMap->moveLayerUp($i); //lower in mapfile is higher in the layerlist
                else
                if ($this->mszAction == "UP")
                $oMap->moveLayerDown($i); //Higher in mapfile is lower in the layerlist
                else
                if ($this->mszAction == "DELETE")
                $oLayer->set('status', MS_DELETE); // Delete layer from mapfile
                
                // Stop looping throught layers.
                break;
            }
        }
        
        $aszLayerNames = $oMap->getAllLayerNames();
        
        if ($this->mszAction == "APPLY")
        {
            // check for visibility.
            for($i=0; $i < $this->moMapObject->oMap->numlayers; $i++)
            {
                $oLayer = $this->moMapObject->oMap->getLayer($i);
                
                if (in_array($oLayer->name, $aszLayerNames))
                {
                    if (in_array($oLayer->name, $aszSelectedVisibleLayers))
                    $oLayer->set('status', MS_ON);
                    else
                    $oLayer->set('status', MS_OFF);
                }
                else
                {
                    $oLayer->set('status', MS_DELETE);
                }
            }
            
            $anLayers = $oNewMapSession->oMap->getLayersDrawingOrder();
            $anOrder = array();
            for($i=0; $i < $oNewMapSession->oMap->numlayers; $i++)
            for($j=0; $j < $this->moMapObject->oMap->numlayers; $j++)
            {
                $oLayer1 = $this->moMapObject->oMap->getLayer($j);
                $oLayer2 = $oNewMapSession->oMap->getLayer($i);
                
                if ($oLayer1->name == $oLayer2->name)
                $anOrder[$i] = $j;
            }
            
            $this->moMapObject->oMap->setLayersDrawingOrder($anOrder);
        }
        
        $this->mszCurrentState = urlencode($oNewMapSession->saveState());
        
        $this->setVar("LAYERMANAGER2_CURRENT_STATE", $this->mszCurrentState);
    }
    
    return true;
}
}
?>
