<?php
/**
 * Label Class
 *
 * @project     CWC2
 * @revision    $Id: Label.php,v 1.19 2003/10/27 20:46:18 sfournier Exp $
 * @purpose     Helper class to manage label attributes
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * a utility class for displaying a label next to some contents.  The label
 * can be styled by adding values to the widget's tag.
 */
class CWCLabel
{
    var $moParent;
    var $mnPosition = 8;
    var $mszVAlign = "";
    var $mszHAlign = "";
    var $mszLabel = "";
    var $mszClass = "CWCLabelClass";
    var $mszStyle = "";

    /**
     * construct a new label widget
     */
    function CWCLabel( &$oParent )
    {
        $this->moParent =& $oParent;
        $oParent->maAttributes["LABEL"] = new StringAttribute( "LABEL", false );
        $oParent->maAttributes["LABELPOSITION"] = new IntegerAttribute( "LABELPOSITION", false, 0, 8 );
        $oParent->maAttributes["LABELHALIGN"] = new StringAttribute( "LABELHALIGN",
                                          false, array( "LEFT", "CENTER", "RIGHT" ) );
        $oParent->maAttributes["LABELVALIGN"] = new StringAttribute( "LABELVALIGN", false,
                                          array( "TOP", "MIDDLE", "BOTTOM" ));
        $oParent->maAttributes["LABELCLASS"] = new StringAttribute( "LABELCLASS", false );
        $oParent->maAttributes["LABELSTYLE"] = new StringAttribute( "LABELSTYLE", false );
    }

    /**
     * initialize default values
     */
    function InitDefaults()
    {
    }

    /**
     * draw the label with some contents
     */
    function DrawPublish( $szContent = "" )
    {
        $szLabel = "";
        $szClass = $this->mszClass;
        $szStyle = $this->mszStyle;
        $nPos = 8; //$this->mnPosition;
        $hAlign = $this->mszHAlign;
        $vAlign = $this->mszVAlign;

        if ( isset( $this->moParent->maParams["LABEL"] ) )
            $szLabel = $this->moParent->maParams["LABEL"];

        // this decodes any HTML characters (&lt;, &gt; for instance) that
        // are in the label, which allows us to embed HTML in a label.
        $trans = array_flip( get_html_translation_table(HTML_SPECIALCHARS) );
        $szLabel = strtr( $szLabel, $trans );

        if (trim($szLabel) == "")
            return $szContent;

        if ( isset( $this->moParent->maParams["LABELCLASS"] ) )
            $szClass = $this->moParent->maParams["LABELCLASS"];
        if ( isset( $this->moParent->maParams["LABELSTYLE"] ) )
            $szStyle = $this->moParent->maParams["LABELSTYLE"];

        if (strlen($szClass) > 0)
            $szClass = " CLASS=\"$szClass\"";
        if (strlen($szStyle) > 0)
            $szStyle = " STYLE=\"$szStyle\"";

        //put together the result
        $szLabel = "<SPAN$szClass$szStyle>$szLabel</SPAN>";

        //position content in a table if necessary
        if ($szContent != "")
        {
            $cell1 = $cell2 = $cell3 = $cell4 = "";
            $valign1 = $valign2 = $valign3 = $valign4 = "";
            $halign1 = $halign2 = $halign3 = $halign4 = "";

            if ( isset( $this->moParent->maParams["LABELPOSITION"] ) )
                $nPos = intval($this->moParent->maParams["LABELPOSITION"]);

            if ( isset( $this->moParent->maParams["LABELHALIGN"] ) )
                $hAlign = " HALIGN=\"".$this->moParent->maParams["LABELHALIGN"]."\"";

            if ( isset( $this->moParent->maParams["LABELVALIGN"] ) )
                $vAlign = " VALIGN=\"".$this->moParent->maParams["LABELVALIGN"]."\"";

            switch( $nPos )
            {
              case 1:
                $cell1 = $szLabel;
                $valign1 = $vAlign;
                $halign1 = $hAlign;
                $cell4 = $szContent;
                break;
              case 2:
                $cell1 = $szLabel;
                $valign1 = $vAlign;
                $halign1 = $hAlign;
                $cell3 = $szContent;
                break;
              case 3:
                $cell2 = $szLabel;
                $valign2 = $vAlign;
                $halign2 = $hAlign;
                $cell3 = $szContent;
                break;
              case 4:
                $cell2 = $szLabel;
                $valign2 = $vAlign;
                $halign2 = $hAlign;
                $cell1 = $szContent;
                break;
              case 5:
                $cell4 = $szLabel;
                $valign4 = $vAlign;
                $halign4 = $hAlign;
                $cell1 = $szContent;
                break;
              case 6:
                $cell3 = $szLabel;
                $valign3 = $vAlign;
                $halign3 = $hAlign;
                $cell1 = $szContent;
                break;
              case 7:
                $cell3 = $szLabel;
                $valign3 = $vAlign;
                $halign3 = $hAlign;
                $cell2 = $szContent;
                break;
              case 8:
                $cell1 = $szLabel;
                $valign1 = $vAlign;
                $halign1 = $hAlign;
                $cell2 = $szContent;
                break;
            }

            $szResult = '<table border="0" cellspacing="0" cellpadding="1">'."\n";
            $szResult .= '  <tr>'."\n";
            if ($cell1 != "")
            {
                $szResult .= '    <td'.$valign1.$halign1.'>'.$cell1.'</td>'."\n";
            }
            if ($cell2 != "")
            {
                $szResult .= '    <td'.$valign2.$halign2.'>'.$cell2.'</td>'."\n";
            }
            $szResult .= '  </tr>'."\n";
            if ($cell3 != "" || $cell4 != "")
            {
                $szResult .= '  <tr>'."\n";
                $szResult .= '    <td'.$valign3.$halign3.'>'.$cell3.'</td>'."\n";
                $szResult .= '    <td'.$valign4.$halign4.'>'.$cell4.'</td>'."\n";
                $szResult .= '  </tr>'."\n";
            }
            $szResult .= '</table>'."\n";
        }
        else
        {
            $szResult = $szLabel;
        }

        return $szResult;
    }
}
