<?php
/**
* KeyMapDHTMLMode Widget class
*
* @project     CWC2
* @revision    $Id:
* @purpose     KeyMapDHTML Mode setter class.  Allows the user to set the
*              the current mode of the KeyMapDHTML
*
* @author      DM Solutions Group (sfournier@dmsolutions.ca)
* @copyright
* <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
* DEALINGS IN THE SOFTWARE.
*/

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
* KeyMapDHTMLMode
*
* @desc A widget to remove the last KeyMapDHTML mode added to the new one.
*/
class KeyMapDHTMLMode extends CWCWidget
{
    /* the button that is the interface for this widget */
    var $moButton;
    
    /* the mode to set the manager to */
    var $mszCmd = "ZOOM";
    
    /**
    * construct a new KeyMapDHTML Removal Tool widget
    */
    function KeyMapDHTMLMode()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The KeyMapDHTMLMode widget allows the user to set the current mode
of the KeyMapDHTML.
EOT;
        $this->moButton = new CWCButton( $this );
        $this->maAttributes['MODE'] = new StringAttribute( 'MODE', false );
    }
    
    /**
    * initialize the widget.
    */
    function InitDefaults()
    {
        parent::InitDefaults();
        
        $this->moButton->InitDefaults();
        
        if (isset($this->maParams['MODE']))
        {
            if (strcasecmp($this->maParams['MODE'], 'zoom') == 0)
            {
                $this->mszCmd = "ZOOM";
            }
            elseif (strcasecmp($this->maParams['MODE'], 'recenter') == 0)
            {
                $this->mszCmd = "RECENTER";
            }
        }
        $this->moButton->SetOnClick('CWCKeyMapDHTMLModeSet', $this->mszCmd);
    }
    
    function ParseURL()
    {
        return $this->moButton->ParseURL();
    }
    
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        
        $szName = 'CWCKeyMapDHTMLModeSet';
        $szFunction = <<<EOT
function {$szName}( oButton, xValues )
{
  {$this->mszHTMLForm}.KEYMAP_DHTML_MODE.value = xValues;
  {$this->mszHTMLForm}.KEYMAP_NAV_ALLOW_RECTANGLE.value=1;
}    
EOT;
        $aReturn[$szName] = $szFunction;
        
        return $aReturn;
    }

    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else
            return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else
            return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
    
        return $aReturn;
    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
    
        $szMode = "ZOOM";
        if ($this->isVarSet("KEYMAP_DHTML_MODE"))
            $szMode = $this->getVar("KEYMAP_DHTML_MODE");
    
        $szVariable = "KEYMAP_DHTML_MODE";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szMode\">";
        $aReturn[$szVariable] = $szValue;
    
        $szVariable = "KEYMAP_NAV_ALLOW_RECTANGLE";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"1\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
    * draw this widg5et on the page
    */
    function DrawPublish()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
            $bCWCJSAPI = 1;
        else
            $bCWCJSAPI = 0;
    
        if (!$this->mbVisible)
            return "<!-- KeyMapDHTMLMode hidden -->";
        
        $szReturn = $this->moButton->DrawPublish();
    
        return $szReturn;
    }
}
?>
