<?php
/**
 * JavaScript TreeView Widget class
 *
 * @project     CWC2
 * @revision    $Id: JSTreeView.widget.php,v 1.4 2004/07/08 15:58:57 pspencer Exp $
 * @purpose     JS TreeView Widget class
 * @author      DM Solutions Group (zjames@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");

if (!defined( "WEBCOMMON" ))
{
    define ("WEBCOMMON", $_SESSION['gszCoreWebPath']."/common/" );
}

/**
 * creates a javascript treeview from a js enabled shared resource
 */
class JSTreeView extends CWCWidget
{
    /* is the treeview going to be valid (i.e. does it have data to display) */
    var $mbJSEnabled = false;

    /* the js shared resource to use */
    var $mszJSSharedResource = "";

    /* the onclick event for nodes, just the name of the javascript function */
    var $mszNodeOnClick = "";

    /* the field to get optional data to pass to the onclick function */
    var $mszNodeDataField = "";

    /* the field to get the branch label from */
    var $mszNodeLabelField = "";

    /* the field to get the branch closed icon from */
    var $mszNodeIconField = "";

    /* the field to get the branch opened icon from */
    var $mszNodeIconOpenField = "";

    /* the CSS class to use for tree text */
    var $mszNodeClass = "treeItem";

    /* the onclick event for leaves, just the name of the javascript function */
    var $mszLeafOnClick = "void";

    /* the field to display in the tree */
    var $mszLeafLabelField = "";

    /* the field to get the name of the image from */
    var $mszLeafIconField = "";

    /* the field to get optional data to pass to the onclick function */
    var $mszLeafDataField = "";

    /* the CSS class to use for links */
    var $mszLinkClass = "treeLink";

    /* the CSS style to use for selected links */
    var $mszNodeSelectedStyle = "border-width:1px;border-color:#b2c4c4;font-weight:bold:background-color:#e3f0f0";

    /* the CSS style to use for unselected links */
    var $mszNodeNormalStyle = "border-width:1px;border-color:#ffffff;font-weight:normal:background-color:#ffffff";

    /**
     * construct a new tree view widget
     */
    function JSTreeView()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Javascript TreeView displays a client side tree view of the data in a 
Shared Resource Widget that has the JSEnabled attribute set to true.
EOT;

        $this->maAttributes["JSSHAREDRESOURCE"] = new StringAttribute( "JSSHAREDRESOURCE", true );
        $this->maAttributes["NODEONCLICK"] = new StringAttribute( "NODEONCLICK", false );
        $this->maAttributes["NODEDATAFIELD"] = new StringAttribute( "NODEDATAFIELD", false );
        $this->maAttributes["NODELABELFIELD"] = new StringAttribute( "NODELABELFIELD", false );
        $this->maAttributes["NODEICONFIELD"] = new StringAttribute( "NODEICONFIELD", false );        
        $this->maAttributes["NODEICONOPENFIELD"] = new StringAttribute( "NODEICONOPENFIELD", false );
        $this->maAttributes["NODEICONOPENFIELD"] = new StringAttribute( "NODEICONOPENFIELD", false );
        $this->maAttributes["NODECLASS"] = new StringAttribute( "NODECLASS", false );
        $this->maAttributes["NODESELECTEDSTYLE"] = new StringAttribute( "LEAFHIGHLIGHTSTYLE", false );
        $this->maAttributes["NODENORMALSTYLE"] = new StringAttribute( "LEAFHIGHLIGHTSTYLE", false );
        $this->maAttributes["LEAFONCLICK"] = new StringAttribute( "LEAFONCLICK", false );
        $this->maAttributes["LEAFLABELFIELD"] = new StringAttribute( "LEAFLABELFIELD", false );
        $this->maAttributes["LEAFICONFIELD"] = new StringAttribute( "LEAFLABELFIELD", false );
        $this->maAttributes["LEAFDATAFIELD"] = new StringAttribute( "LEAFDATAFIELD", false );
        $this->maAttributes["LINKCLASS"] = new StringAttribute( "LINKCLASS", false );
    }

    /**
     * initialize default values
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["JSSHAREDRESOURCE"]))
        {
            $this->mszJSSharedResource = $this->maParams["JSSHAREDRESOURCE"];
        }

        if (isset($this->maParams["NODEONCLICK"]))
        {
            $this->mszNodeOnClick = $this->maParams["NODEONCLICK"];
        }

        if (isset($this->maParams["NODEDATAFIELD"]))
        {
            $this->mszNodeDataField = $this->maParams["NODEDATAFIELD"];
        }
        
        if (isset($this->maParams["NODELABELFIELD"]))
        {
            $this->mszNodeLabelField = $this->maParams["NODELABELFIELD"];
        }

        if (isset($this->maParams["NODEICONFIELD"]))
        {
            $this->mszNodeIconField = $this->maParams["NODEICONFIELD"];
        }

        if (isset($this->maParams["NODEICONOPENFIELD"]))
        {
            $this->mszNodeIconOpenField = $this->maParams["NODEICONOPENFIELD"];
            if (strlen($this->mszNodeIconField) == 0)
            {
                $this->mszNodeIconField = $this->mszNodeIconOpenField;
            }
        }
        else if (strlen($this->mszNodeIconField) > 0)
        {
            $this->mszNodeIconOpenField = $this->mszNodeIconField;
        }
        
        if (isset($this->maParams["NODECLASS"]))
        {
            $this->mszNodeClass = $this->maParams["NODECLASS"];
        }
        if (isset($this->maParams["LINKCLASS"]))
        {
            $this->mszLinkClass = $this->maParams["LINKCLASS"];
        }
        if (isset($this->maParams["NODESELECTEDSTYLE"]))
        {
            $this->mszNodeSelectedStyle = $this->maParams["NODESELECTEDSTYLE"];
        }
        if (isset($this->maParams["NODENORMALSTYLE"]))
        {
            $this->mszNodeNormalStyle = $this->maParams["NODENORMALSTYLE"];
        }
        
        if (isset($this->maParams["LEAFONCLICK"]))
        {
            $this->mszLeafOnClick = $this->maParams["LEAFONCLICK"];
        }
        if (isset($this->maParams["LEAFLABELFIELD"]))
        {
            $this->mszLeafLabelField = $this->maParams["LEAFLABELFIELD"];
        }

        if (isset($this->maParams["LEAFICONFIELD"]))
        {
            $this->mszLeafIconField = $this->maParams["LEAFICONFIELD"];
        }
        
        if (isset($this->maParams["LEAFDATAFIELD"]))
        {
            $this->mszLeafDataField = $this->maParams["LEAFDATAFIELD"];
        }
        
        
        return true;
    }

    /**
     * we aren't actually expecting anything from the URL, but we can check to see if the
     * sharedresource is valid now
     */
    function ParseURL()
    {
        $this->mbJSEnabled = 0;
            
        if (isset($this->maSharedResourceWidgets[$this->mszJSSharedResource]))
        {
            $oSR = $this->maSharedResourceWidgets[$this->mszJSSharedResource];
            if (isset($oSR->maParams["ENABLEJS"]))
            {
                $this->mbJSEnabled = (strcasecmp($oSR->maParams["ENABLEJS"],
                                                 "true") == 0) ? true : false;
            }
        }
        else
        {
            //ERROR:
            //echo "SharedResource ".$this->mszJSSharedResource." not found<BR>";
        }
            
        if (!$this->mbJSEnabled)
        {
            //ERROR:
            //echo "error, JSSHAREDRESOURCE ".$this->mszJSSharedResource." is not JS enabled<BR>";
        }

        return true;
    }

    /**
     * return javascript functions
     */
    function GetJavascriptFunctions()
    {
        $aReturn = parent::GetJavascriptFunctions();
        
        //check if there is a js resource to make tree from
        if (!$this->mbJSEnabled)
        {
            return $aReturn;
        }
        /* the problem here is that in the treeview code, the name of the
         * tree is hard coded instead of passed in.  This could be fixed
         * but will make our copy unmaintainable through upgrading
         */
        $szTreeName = "foldersTree"; //"goJSTreeView".$this->mnId;

        $bNodeIcon = (strlen(trim($this->mszNodeIconField)) > 0) ? "true" : "false";
        $bNodeIconOpen = (strlen(trim($this->mszNodeIconOpenField)) > 0) ? "true" : "false";
        $bLeafIcon = (strlen(trim($this->mszLeafIconField)) > 0) ? "true" : "false";
        
        $bLeafLink = (strlen(trim($this->mszLeafOnClick)) > 0 ) ? "true" : "false";
        $bNodeLink = (strlen(trim($this->mszNodeOnClick)) > 0 ) ? "true" : "false";
        
        $szJsFunctionName = "JSTreeViewInit_".$this->mnId;
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to set up the tree.
 */
function {$szJsFunctionName}()
{
    //server entry is first child of shared resource
    var sr = false;
    if (goJSSR.GetValue( "{$this->mszJSSharedResource}" ).maoChildren.length > 0)
        sr = goJSSR.GetValue( "{$this->mszJSSharedResource}" ).maoChildren[0];

    var _icon = "";

    var szNodeOpen = "<span class=\"{$this->mszNodeClass}\">";
    var szNodeClose = "</span>";

   
    if (sr != false)
    { 
        if ({$bNodeLink})
        {
            _js = "javascript:{$this->mszNodeOnClick}(";
            if ( '{$this->mszNodeDataField}' != "")
            {
                _js = _js + "\\"" + sr.GetValue( "{$this->mszNodeDataField}" ) + "\\"";
            }
            _js = _js + ");";
            {$szTreeName} = gFld( szNodeOpen + sr.GetValue("{$this->mszNodeLabelField}" ) + szNodeClose, _js);
        }
        else
        {
            {$szTreeName} = gFld( szNodeOpen + sr.GetValue("{$this->mszNodeLabelField}" ) + szNodeClose);
        }
    
        if ({$bNodeIconOpen})
        {
            _icon = sr.GetValue( '{$this->mszNodeIconOpenField}' );
            if (_icon.length > 0)
            {
                JSTreeViewImage.src = _icon;
                {$szTreeName}.iconSrc = _icon;
            }
        }
        if ({$bNodeIcon})
        {
            _icon = sr.GetValue( '{$this->mszNodeIconField}');
            if (_icon.length > 0)
            {
                JSTreeViewImage.src = _icon;
                {$szTreeName}.iconSrcClosed = _icon;
            }
        }

        JSTreeView_AddRecursive( sr, {$szTreeName} );
    }

    return true;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction; 

        $szJSOpen = "javascript:".$this->mszLeafOnClick."(" ;
        $szJSClose = ");";
        
        if ($this->mszLeafDataField != "")
        {
            $szJSOpen .= "\\\\\\\\\'";
            $szJSClose = "\\\\\\\\\'" . $szJSClose; 
        }
        
        $szJsFunctionName = "JSTreeView_AddRecursive";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * add children recursively from a JS SharedResource
 */
function {$szJsFunctionName}( sr, obj )
{
    var _item, _child, i, _js, _icon, szLink;
    var szNodeOpen = "";
    var szNodeClose = "";

    for (i=0; i<sr.maoChildren.length; i++)
    {
        _child = sr.maoChildren[i];

        if (_child.maoChildren.length > 0)
        {
            if ({$bNodeLink})
            {
                _js = "javascript:{$this->mszNodeOnClick}(";
                if ( '{$this->mszNodeDataField}' != "")
                {
                    _js = _js + "\\"" + _child.GetValue( "{$this->mszNodeDataField}" ) + "\\"";
                }
                _js = _js + ");";
                _item = gFld( szNodeOpen + _child.GetValue("{$this->mszNodeLabelField}" ) + szNodeClose, _js);
            }
            else
            {
                _item = gFld( szNodeOpen + _child.GetValue("{$this->mszNodeLabelField}" ) + szNodeClose);
            }
            if ({$bNodeIconOpen})
            {
                _icon = _child.GetValue( '{$this->mszNodeIconOpenField}' );
                if (_icon.length > 0)
                {
                    JSTreeViewImage.src = _icon;
                    _item.iconSrc = _icon;
                }
            }   
            if ({$bNodeIcon})
            {
                _icon = _child.GetValue('{$this->mszNodeIconField}');
                if (_icon.length > 0)
                {
                    JSTreeViewImage.src = _icon;
                    _item.iconSrcClosed = _icon;
                    if (_item.iconSrc.length == 0)
                    {
                        _item.iconSrc = _icon;
                    }
                }
                else if (_item.iconSrc.length != 0)
                {
                    _item.iconSrcClosed = _item.iconSrc;
                }
            }
            JSTreeView_AddRecursive( _child, _item );
        }
        else
        {
            if ({$bLeafLink})
            {
                _js = "{$szJSOpen}";
                if ("{$this->mszLeafDataField}" != "")
                {
                    _js = _js + _child.GetValue( "{$this->mszLeafDataField}");
                }
                _js = _js + "{$szJSClose}";
            
                _item = gLnk("S", szNodeOpen + _child.GetValue("{$this->mszLeafLabelField}") + szNodeClose, _js);
            }
            else
            {
                _item = gLnk("S", szNodeOpen + _child.GetValue("{$this->mszLeafLabelField}") + szNodeClose );           
            }
            if ({$bLeafIcon})
            {
                _icon = _child.GetValue( '{$this->mszLeafIconField}' );
                if (_icon.length > 0)
                {
                    JSTreeViewImage.src = _icon;
                    _item.iconSrc = _icon;
                }
            }
        }

        obj.addChild( _item );
    }
    return true;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;        
    
        return $aReturn;
    }       

    function GetJavascriptVariables()
    {
        $aReturn = parent::GetJavascriptVariables();

        $szVar = "foldersTree"; //"goJSTreeView".$this->mnId;
        $aReturn[$szVar] = "var $szVar = '';\n";
        $szVar = "HIGHLIGHT"; 
        $aReturn[$szVar] = "var $szVar = 1;\n";
        $szVar = "ICONPATH"; 
        $aReturn[$szVar] = "var $szVar = \"".$_SESSION['gszCoreWebPath']."/skins/default/images/\";\n";
        $szVar = "USETEXTLINKS"; 
        $aReturn[$szVar] = "var $szVar = 1;\n";
        $szVar = "USEFRAMES"; 
        $aReturn[$szVar] = "var $szVar = 0;\n";
        $szVar = "STARTALLOPEN"; 
        $aReturn[$szVar] = "var $szVar = 0;\n";
        $szVar = "PRESERVESTATE"; 
        $aReturn[$szVar] = "var $szVar = 0;\n";
        $szVar = "JSTreeViewImage"; 
        $aReturn[$szVar] = "var $szVar = new Image();\n";
        $szVar = "NODECLASS";
        $aReturn[$szVar] = "var $szVar = \"".$this->mszNodeClass."\";\n";
        $szVar = "LINKCLASS";
        $aReturn[$szVar] = "var $szVar = \"".$this->mszLinkClass."\";\n";
        $szVar = "NODESELECTEDSTYLE";
        $aReturn[$szVar] = "var $szVar = \"".$this->mszNodeSelectedStyle."\";\n";
        $szVar = "NODENORMALSTYLE";
        $aReturn[$szVar] = "var $szVar = \"".$this->mszNodeNormalStyle."\";\n";
        

        return $aReturn;
    }

    /**
     * javascript include files
     */
    function GetJavascriptIncludeFunctions()
    {
        $aReturn = parent::GetJavascriptIncludeFunctions();
        if ($this->mbJSEnabled)
        {
            $szJsIncludeName = $_SESSION["gszCoreWebPath"]."/widgets/js/cwc_sr.js";
            $szInclude = "<script language=\"JavaScript\" src=\"".$_SESSION["gszCoreWebPath"]."/widgets/js/cwc_sr.js\"></script>";
            $aReturn[$szJsIncludeName] = $szInclude;

            //load the treeview javascript - see http://treeview.net
            $szJsIncludeName = WEBCOMMON."/jtree/ua.js";
            $szInclude = "<script language=\"JavaScript\" src=\"".WEBCOMMON."/jtree/ua.js\"></script>";
            $aReturn[$szJsIncludeName] = $szInclude;

            $szJsIncludeName = WEBCOMMON."/jtree/ftiens4.js";
            $szInclude = "<script language=\"JavaScript\" src=\"".WEBCOMMON."/jtree/ftiens4.js\"></script>";
            $aReturn[$szJsIncludeName] = $szInclude;
        }
        return $aReturn;
    }

    /**
     * draw the TreeView widget
     */
    function DrawPublish()
    {
        $szReturn = "";
        if ($this->mbJSEnabled)
        {
            $szReturn .= "<script>JSTreeViewInit_".$this->mnId."();initializeDocument();</script>";
        }
        if (!$this->mbVisible)
            return "<!-- JSTreeView is hidden -->";

        
        return $szReturn;
    }
}
?>
