<?php
/**
 * JSList Widget class
 *
 * @project     GeoInnovations 2002 - MapLab enhancements
 * @revision    $Id: JSList.widget.php,v 1.4 2004/05/28 15:53:40 pspencer Exp $ 
 * @purpose     JSList creates a list box from the contents of a javascript
 *              shared resource
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");

/**
 * JSList Widget
 *
 * @desc a widget that creates a list box from a javascript shared resource.
 *
 * A JSList tag can have OPTION sub tags as follows:
 * <option label="a label" value="an optional value" selected="true|false"/>
 *
 * label is seen by the user
 * value is optional, the value is label by default unless provided
 * selected is boolean true or false to make the option the default selected
 * option. 
 */
class JSList extends CWCWidget
{
     /* the name of the shared resource to populate the list with */
     var $mszJSSharedResource = "";

     /* the property (in the JSSR) to use as Labels */
     var $mszLabelField = "";

     /* the property (in the JSSR) to use as Values. */
     var $mszValueField = "";
    
     /* a javascript function to call when the selection changes */
     var $mszJSCallback = "";

     /* the css class to apply to the select box */
     var $mszClass = "";

     /* the css style to apply to the select box */
     var $mszStyle = "";

     /* the name by which this will be referred to in the form */
     var $mszName = "";
    
    /**
     * JSList
     *
     * Constructor method for the JSList widget.
     */
    function JSList()
    {         
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The JSList widget creates a SELECT input and populates it with values from a 
SharedResource.
EOT;

        $this->maAttributes["JSSHAREDRESOURCE"] = new StringAttribute( "JSSHAREDRESOURCE", true );
    $this->maAttributes["LABELFIELD"] = new StringAttribute( "LABELFIELD", false );
        $this->maAttributes["VALUEFIELD"] = new StringAttribute( "VALUEFIELD", false );
    $this->maAttributes["ONCHANGE"] = new StringAttribute( "ONCHANGE", false );
        $this->maAttributes["WIDGETCLASS"] = new StringAttribute( "WIDGETCLASS", false );
        $this->maAttributes["WIDGETSTYLE"] = new StringAttribute( "WIDGETSTYLE", false );
    }

    /**
     * initialize respectable defaults
     */
    function InitDefaults()
    {
        parent::InitDefaults();

        if(isset($this->maParams["JSSHAREDRESOURCE"]))
            $this->mszJSSharedResource = $this->maParams["JSSHAREDRESOURCE"];
        if(isset($this->maParams["LABELFIELD"]))
            $this->mszLabelField = $this->maParams["LABELFIELD"];
        if(isset($this->maParams["VALUEFIELD"]))
            $this->mszValueField = $this->maParams["VALUEFIELD"];
        if(isset($this->maParams["ONCHANGE"]))
            $this->mszOnChange = $this->maParams["ONCHANGE"];
        if (isset($this->maParams["WIDGETCLASS"]))
            $this->mszClass = strtoupper($this->maParams["WIDGETCLASS"]);
        if (isset($this->maParams["WIDGETSTYLE"]))
            $this->mszStyle = strtoupper($this->maParams["WIDGETSTYLE"]);
        $this->mszName = "JSList_".$this->mnId;
    }

    /**
     * take action from the previous page
     */
    function ParseURL()
    {   
        //action to take: look for a previous value and reselect it

        return true;
    }

    /**
     * return javascript functions to be used by the list

     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $szName = "initJSList_".$this->mnId;
        $szFunction = <<<EOT
/**
 * initialize a JSList instance
 */
function {$szName}()
{
    var sr;
    var i;
    var selected = {$this->mszHTMLForm}.{$this->mszJSSharedResource}.value;
    sr = goJSSR.GetValue( "{$this->mszJSSharedResource}" );
    var nIdx = {$this->mszHTMLForm}.{$this->mszName}.selectedIndex;
    for (i=0; i<sr.maoChildren.length; i++)
    {
        var opt = new Option();
        opt.value = sr.maoChildren[i].GetValue( '{$this->mszValueField}' );
        opt.text = sr.maoChildren[i].GetValue( '{$this->mszLabelField}' );

        if (opt.value == selected)
        {
            opt.selected = true;
            nIdx = {$this->mszHTMLForm}.{$this->mszName}.options.length;
        }
        {$this->mszHTMLForm}.{$this->mszName}.options.add(opt);
    }
    {$this->mszHTMLForm}.{$this->mszName}.selectedIndex = nIdx;
}

EOT;
        
        $aReturn[$szName] = $szFunction;

        return $aReturn;
    }

    function GetJavascriptInitFunctions()
    {
        $aReturn = array();
     
        $szName = "initJSList_".$this->mnId;
        $aReturn[$szName] = $szName."();";

        return $aReturn;
    }

    /**
     * render widget as HTML
     */
    function DrawPublish()
    {
     if (!$this->mbVisible)
     {
          return "";
     }
     
     $szResult = '<select name="'.$this->mszName.'"';

     if (strlen(trim($this->mszOnChange)) > 0)
     {
             $szResult .= ' onChange="'.$this->mszOnChange.
                 '(this, this.options[this.selectedIndex])" ';
     }

        $szClass = "";
        if ( strlen($this->mszClass) > 0 )
        {
            $szClass = " CLASS=\"$this->mszClass\"";
        }

        $szStyle = "";
        if ( strlen($this->mszStyle) > 0 )
        {
            $szStyle = " STYLE=\"$this->mszStyle\"";
        }


        $szResult .= $szClass.$szStyle.">";
             
        if (isset($this->maszContents["OPTION"]))
        {
            $szResult .= "\n";
            foreach($this->maszContents["OPTION"] as $aOption)
            {
                if (isset($aOption["LABEL"]))
                {
                    $szResult .= "<OPTION";
                    if (isset($aOption["VALUE"]))
                    {
                        $szResult .= ' value="'.$aOption["VALUE"].'"';
                    }
                    if (isset($aOption["SELECTED"]) && strcasecmp($aOption["SELECTED"], "true") == 0)
                    {
                        $szResult .= " SELECTED";
                    }
                    $szResult .= ">".$aOption["LABEL"]."</OPTION>\n";
                }
            }
        }
        $szResult .= "</select>\n"; 

        return $szResult;
    }   
}

?>