<?php
/**
* HelpWidget Widget class
*
* @project     CWC2
* @revision    $Id:
* @purpose     HelpWidget Popup Widget class
* @author      DM Solutions Group (sfournier@dmsolutions.ca)
* @copyright
* <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
* DEALINGS IN THE SOFTWARE.
*/
include_once(dirname(__FILE__)."/../Widget.php");

/**
* HelpWidget
*
* @desc HelpWidget widget class
*/
class HelpWidget extends CWCWidget
{
    var $mszTemplate;      // [string]
    
    /**
    * HelpWidgetWidget
    *
    * Constctor method for the HelpWidget widget.
    */
    function HelpWidget()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
Display help content.
EOT;
    }
    
    /**
    * DrawPublish
    *
    * Return the HTML code to display the link to the legend popup
    */
    function DrawPublish()
    {
        $aszWidget = array();
        $szReturn = "";
        
        $szLang = $_SESSION["gszCurrentLanguage"];
        
        if (isset($this->maParams["WIDGET"]))
        {
            $bFind = false;
            foreach ($this->moApp->moUI->moWidgetManger->maszWidgetDirectories as $szDir)
            {
                if (file_exists(str_replace("\\","/", $szDir."/".$this->maParams["WIDGET"]."/".$this->maParams["WIDGET"].".help.xml")))
                {
                    $bFind = true;
                    break;
                }
            }
                
            if (!$bFind)
            {   
                $szReturn .= "<p class=\"CWCHelpText\">No description available</p>";
            }
            else
            {
                $aFile = file(str_replace("\\","/", $szDir."/".$this->maParams["WIDGET"]."/".$this->maParams["WIDGET"].".help.xml"));
                $bStart=false;
                $bEnd=false;
                
                $oXML = new XMLObject(implode("", $aFile));
                $oWidgetDoc = $oXML->getNextChild('widgetdoc');
                
                // Get language
                $oLang = $oWidgetDoc->getNextChild('language');
                $oDefaultLang = $oLang;
                while($oLang != "")
                {
                    if (isset($oLang->_attributes['name']) &&
                    strtolower($oLang->_attributes['name']) == strtolower($szLang))
                    break;
                    
                    $oLang = $oWidgetDoc->getNextChild('language');
                }
                
                if ($oLang == "")
                {
                    echo "Language $szLang not found in widget documentation. Using default one.";
                    $oLang = $oDefaultLang;
                }
                
                echo "<h3><a name=\"".$oWidgetDoc->_attributes['name']."\"></a>".$oWidgetDoc->_attributes['name']."</h3>\n";
                echo "<dl><dt class=\"WidgetSectionHeading\">Description:</dt>\n";
                $oDesc = $oLang->getNextChild('description');
                echo "<dd>".trim($oDesc->value)."</dd>";
                echo "<dt class=\"WidgetSectionHeading\">Tag:</dt>";
                echo "<dd><p class=\"TagPreview\">Tag example here</p></dd>";
                echo "<dt class=\"WidgetSectionHeading\">Attributes:</dt>";
                echo "<dd>The <em>".$oWidgetDoc->_attributes['name']."</em> tag has attributes from the ";
                $oInclude = $oWidgetDoc->getNextChild('includes');
                while ($oInclude != "")
                {
                    echo "<a href=\"#".$oInclude->_attributes['target']."attributes\">".
                    ucfirst($oInclude->_attributes['target'])." Attributes</a> ";
                    $oInclude = $oWidgetDoc->getNextChild('includes');
                }
                echo " groups";
                $oAttributes = $oLang->getNextChild('attributes');
                $oAttribute = $oAttributes->getNextChild('attribute');
                if ($oAttribute != "")
                echo " plus the following attributes:</dd>\n";
                else
                echo ".</dd>\n";
                echo "<dd><dl>";
                while ($oAttribute != "")
                {
                    $oDescription = $oAttribute->getNextChild('description');
                    echo "<dt class=WidgetAttribute>".$oAttribute->_attributes['type']." ".$oAttribute->_attributes['name'];
                    echo ((isset($oAttribute->_attributes['required']) && strtolower($oAttribute->_attributes['required'])=="true") ?
                    " (required)" : "");
                    echo "</dt><dd>".$oDescription->value."</dd>\n";
                    
                    $oPossValues = $oAttribute->getNextChild('possvalues');
                    if ($oPossValues != "")
                    {
                        $oPossValue = $oPossValues->getNextChild('possvalue');
                        while ($oPossValue != "")
                        {
                            echo "<dd>".$oPossValue->_attributes['value']."</dd>";
                            $oPossValue = $oPossValues->getNextChild('possvalue');
                        }
                    }
                    $oAttribute = $oAttributes->getNextChild('attribute');
                }
                echo "</dl></dd>\n";
                echo "<dt class=\"WidgetSectionHeading\">Form Elements:</dt>\n";
                echo "<dd><dl>\n";
                $oFormElements = $oLang->getNextChild('formelements');
                if ($oFormElements != "")
                {
                    $oFormElement = $oFormElements->getNextChild('formelement');
                    while ($oFormElement != "")
                    {
                        $oDescription = $oFormElement->getNextChild('description');
                        echo "<dt class=Property>".$oFormElement->_attributes['name'].
                        "</dt><dd>".$oDescription->value."</dd>\n";
                        
                        $oFormElement = $oFormElements->getNextChild('formelement');
                    }
                }
                echo "</dl></dd>\n";
                
                echo "<dt class=\"WidgetSectionHeading\">Javascript Functions:</dt>\n";
                echo "<dd><dl>\n";
                $oJSFunctions = $oLang->getNextChild('jsfunctions');
                if ($oJSFunctions != "")
                {
                    $oJSFunction = $oJSFunctions->getNextChild('jsfunction');
                    while ($oJSFunction != "")
                    {
                        $oDescription = $oJSFunction->getNextChild('description');
                        echo "<dt class=MethodDeclaration>".$oJSFunction->_attributes['name'].
                        "</dt><dd>".$oDescription->value."</dd>\n";
                        
                        $oParameter = $oJSFunction->getNextChild('parameter');
                        while ($oParameter != "")
                        {
                            echo "<dd>".$oParameter->_attributes['type']." ".$oParameter->_attributes['name']." ".$oParameter->value."</dd>";
                            $oParameter = $oJSFunction->getNextChild('parameter');
                        }
                        $oJSFunction = $oJSFunctions->getNextChild('jsfunction');
                    }
                }
                echo "</dl></dd>\n";
                
                
                echo "<dt class=\"WidgetSectionHeading\">Javascript Variables:</dt>\n";
                echo "<dd><dl>";
                $oJSVariables = $oLang->getNextChild('jsvariables');
                if ($oJSVariables != "")
                {
                    $oJSVariable = $oJSVariables->getNextChild('jsvariable');
                    while ($oJSVariable != "")
                    {
                        $oDescription = $oJSVariable->getNextChild('description');
                        echo "<dt class=Property>".$oJSVariable->_attributes['name'].
                        "</dt><dd>".$oDescription->value."</dd>\n";
                        
                        $oJSVariable = $oJSVariables->getNextChild('jsvariable');
                    }
                }
                echo "</dl></dd>";
                
                
                echo "<dt class=\"WidgetSectionHeading\">Events:</dt>\n";
                echo "<dd><dl>\n";
                $oEvents = $oLang->getNextChild('events');
                if ($oEvents !="")
                {
                    $oEvent = $oEvents->getNextChild('event');
                    while ($oEvent != "")
                    {
                        $oDescription = $oEvent->getNextChild('description');
                        echo "<dt class=MethodDeclaration>".$oEvent->_attributes['name'].
                        "</dt><dd>".$oDescription->value."</dd>\n";
                        
                        $oParameter = $oEvent->getNextChild('parameter');
                        while ($oParameter != "")
                        {
                            echo "<dd>".$oParameter->_attributes['type']." ".$oParameter->_attributes['name']." ".$oParameter->value."</dd>";
                            $oParameter = $oEvent->getNextChild('parameter');
                        }
                        $oEvent = $oEvents->getNextChild('event');
                    }
                }
                echo "</dl></dd>\n";
                echo "</dl>";
            }
        }
        
        return $szReturn;
    }
}
?>
