<?php

define( "GPS_STARTED", 1);
define( "GPS_STOPPED", 2);

/* -------------------------------------------------------------------- */
/*      Parse Get query                                                 */
/* -------------------------------------------------------------------- */

if (sizeof($_POST) > 0)
{
  $HTTP_FORM_VARS = $_POST;
}
else if (sizeof($_GET) > 0)
{
  $HTTP_FORM_VARS = $_GET;
}
else
$HTTP_FORM_VARS = array();

$nVarCnt = count($HTTP_FORM_VARS);
$aszVarKeys = array_keys($HTTP_FORM_VARS);

//foreach($HTTP_FORM_VARS as $szKey => $szValue)
//{
//    echo $szKey . "=" .  $szValue . "<br>\n";
//}

//default interface values
$GLOBALS['CURRENTTAB'] = "configlayer";
$GLOBALS['RefreshMapDelay'] = 10;
$GLOBALS['LatLongCoordinates'] ="";
//variable indicating if we need to refresh the map.
//set to 1 in function UpdatePoints if all crierias are met. 
$GLOBALS['RefreshMap'] = -1; 

/* -------------------------------------------------------------------- */
/*      Extract GPS setting.                                            */
/* -------------------------------------------------------------------- */
foreach($HTTP_FORM_VARS as $szKey => $szValue)
{     
    if (strcasecmp($szKey, "Baud") == 0)
      $GLOBALS['dfBaud'] =  $szValue;
    else if (strcasecmp($szKey, "Port") == 0)
      $GLOBALS['sPort'] =  $szValue;
    else if (strcasecmp($szKey, "DataBits") == 0)
      $GLOBALS['nDataBits'] =  $szValue;
    else if (strcasecmp($szKey, "Parity") == 0)
      $GLOBALS['sParity'] =  $szValue;
    else if (strcasecmp($szKey, "StopBits") == 0)
      $GLOBALS['dfStopBits'] =  $szValue;
    else if (strcasecmp($szKey, "GPSURL") == 0)
       $GLOBALS['sGPSURL'] =  urldecode($szValue);
    else if (strcasecmp($szKey, "GPSBINARY") == 0)
      $GLOBALS['sGPSBINARY'] =  urldecode($szValue);
    else if (strcasecmp($szKey, "GPSBINARYSTATUS") == 0)
      $GLOBALS['GPSBINARYSTATUS'] =  $szValue;

    else if (strcasecmp($szKey, "startstopgpstext") == 0)
       $GLOBALS['StartStopGPSMessage'] =  $szValue;
    else if (strcasecmp($szKey, "GPSSTATUS") == 0)
       $GLOBALS['GPSSTATUS'] =  $szValue;
    else if (strcasecmp($szKey, "CURRENTTAB") == 0)
      $GLOBALS['CURRENTTAB'] =  $szValue;
    else if (strcasecmp($szKey, "PlotPointTypeAll") == 0)
      $GLOBALS['PlotPointType'] =  $szValue;
    else if (strcasecmp($szKey, "PlotPointTypeOne") == 0)
      $GLOBALS['PlotPointType'] =  $szValue;
    else if (strcasecmp($szKey, "RefreshMapDelay") == 0)
       $GLOBALS['RefreshMapDelay'] = $szValue;
    else if (strcasecmp($szKey, "NextUpdateMapTime") == 0)
       $GLOBALS['NextUpdateMapTime'] = $szValue;
    else if (strcasecmp($szKey, "DEBUG") == 0)
      $GLOBALS['DEBUG'] = $szValue;
    else if (strcasecmp($szKey, "ConfigChanged") == 0)
      $GLOBALS['ConfigChanged'] = $szValue;
     else if (strcasecmp($szKey, "ReadPointsDelay") == 0)
      $GLOBALS['ReadPointsDelay'] = $szValue;
    else if (strcasecmp($szKey, "AveragePoints") == 0)
      $GLOBALS['AveragePoints'] = 1;
    
    else if (strcasecmp($szKey, "SymbolName") == 0)
      $GLOBALS['SymbolName'] = $szValue;
    else if (strcasecmp($szKey, "SymbolSize") == 0)
      $GLOBALS['SymbolSize'] = $szValue;
    else if (strcasecmp($szKey, "ColorRed") == 0)
      $GLOBALS['ColorRed'] = $szValue;
     else if (strcasecmp($szKey, "ColorGreen") == 0)
      $GLOBALS['ColorGreen'] = $szValue;
     else if (strcasecmp($szKey, "ColorBlue") == 0)
      $GLOBALS['ColorBlue'] = $szValue;
    else if (strcasecmp($szKey, "OutlineColorRed") == 0)
      $GLOBALS['OutlineColorRed'] = $szValue;
     else if (strcasecmp($szKey, "OutlineColorGreen") == 0)
      $GLOBALS['OutlineColorGreen'] = $szValue;
     else if (strcasecmp($szKey, "OutlineColorBlue") == 0)
      $GLOBALS['OutlineColorBlue'] = $szValue;
      
    
    

}                
    
if (isset($HTTP_FORM_VARS['StartGPS']))
{
    StartGPS();
}

if (isset($HTTP_FORM_VARS['StopGPS']))
{
    StopGPS();
}

if (GetGPSStatus() == GPS_STARTED)
{
    GetLastLatLong();
}

if (isset($GLOBALS['NextUpdateMapTime']))
{
    UpdatePoints();
}

/************************************************************************/
/*                                 StartGPS                             */
/*                                                                      */
/*      Call the GPSURL with the start command. Update the message field.*/
/************************************************************************/
function StartGPS()
{
  /*
    if (GetGPSBinaryStatus(0) == 0 && GetGPSBinary() != "")
    {
        $sBinary = GetGPSBinary();
        //$sBinary = "psexec /C c:\\projects\\gpsutil\\gpsutil.exe";
        $sBinary = "start c:\\projects\\gpsutil\\gpsutil.exe";
        echo $GLOBALS['sGPSBINARY'] . "<br>\n";
        echo passthru($sBinary);

        $GLOBALS['GPSBINARYSTATUS'] = 1;
         echo "StartGPS BinaryStatus : " . $GLOBALS['GPSBINARYSTATUS'] . "<br>\n";
    }
  */

  //echo "config changed = " . $GLOBALS['ConfigChanged'];
  if (1)//$GLOBALS['ConfigChanged'] == 1 || 
        //GetGPSStatus() != GPS_STARTED)
    {
        $szURL =  $GLOBALS['sGPSURL'] . "command=setconfig";
        $szURL .= "&port=". $GLOBALS['sPort'];
        $szURL .= "&baud=". $GLOBALS['dfBaud'] ;
        $szURL .= "&databits=".$GLOBALS['nDataBits'];
        $szURL .= "&parity=".$GLOBALS['sParity'];
        $szURL .= "&stopbits=".$GLOBALS['dfStopBits'];
        if (GetAveragePoints() && $GLOBALS['RefreshMapDelay']>0)
        {
            $nAverage =  intval($GLOBALS['RefreshMapDelay'] / 2);
            if ($nAverage < 2)
              $nAverage = 2;
            $szURL .= "&averagepoints=$nAverage";
        }


        //$szURL .= "&timebetweenreadings=".$GLOBALS['ReadPointsDelay'];
        //echo $szURL;
         @$fp = fopen($szURL, "r");
         if ($fp)
         {
             $result = fgets($fp);
             $GLOBALS['StartStopGPSMessage'] = $result;
             fclose($fp);
         }
    }
        
    $szURL =  $GLOBALS['sGPSURL'] . "command=startgps";
    @$fp = fopen($szURL, "r");  
    if ($fp)
    {
        $result = fgets($fp);
        $GLOBALS['StartStopGPSMessage'] = $result;
        if (stristr($result, "SUCCESS"))
          $GLOBALS['GPSSTATUS'] = GPS_STARTED;
    }
    else
    {
        $GLOBALS['StartStopGPSMessage'] = "could not connnect to " . $szURL;
    }
}


function StopGPS()
{
    $szURL =  $GLOBALS['sGPSURL'] . "command=stopgps";
    @$fp = fopen($szURL, "r");  
    if ($fp)
    {
        $result = fgets($fp);
        $GLOBALS['StartStopGPSMessage'] = $result;
        if (stristr($result, "SUCCESS"))
          $GLOBALS['GPSSTATUS'] = GPS_STOPPED;
    }
    else
    {
        $GLOBALS['StartStopGPSMessage'] = "could not connnect to " . $szURL;
    }
}

function GetGPSStatus()
{
    if (isset($GLOBALS['GPSSTATUS']))
      return $GLOBALS['GPSSTATUS'];

    return 0;
}


function GetGPSBinaryStatus($n)
{
    if ($n == 1)
      echo "GetGPSBinaryStatus called from phtml : " . $GLOBALS['GPSBINARYSTATUS'] . "<br>\n";  
    else
      echo "GetGPSBinaryStatus called from php : " . $GLOBALS['GPSBINARYSTATUS'] . "<br>\n";

    if (isset($GLOBALS['GPSBINARYSTATUS']))
      return $GLOBALS['GPSBINARYSTATUS'];
    else
      return 0;
}
function GetStartStopGPSMessage()
{
    if(isset($GLOBALS['StartStopGPSMessage']))
      return $GLOBALS['StartStopGPSMessage'];
    else
      return "";
}

function GetLastLatLong()
{
    $szURL =  $GLOBALS['sGPSURL'] . "command=getlatlongmessages&nummessage=1";
    $fp = fopen($szURL, "r");  
    if ($fp)
    {
        $result = fgets($fp);
        //echo $result . "<br>\n";
        if (stristr($result, "Lat")) //make sure that we have a valid response
        {
            //echo $result . "<br>\n";
            $aLatLong = split(",", $result);
            if (count($aLatLong) >=2)
            {
                for ($i=0; $i<2; $i++)
                {
                    $aNameValue = split("=", $aLatLong[$i]);
                    if (count($aNameValue) == 2)
                    {
                        if (strncasecmp($aNameValue[0], "Lat", 3) == 0)
                        {
                            $GLOBALS['dfLatestLat'] = $aNameValue[1];
                        }
                        else if (strncasecmp($aNameValue[0], "Lon", 3) == 0)
                        {
                            $GLOBALS['dfLatestLon'] = $aNameValue[1];
                        }
                    }
                }
            }
            return 1;
        }
    }
}



function IsGPSStarted()
{
    if (GetGPSStatus() == GPS_STARTED)
      return 1;

    return 0;
}


function GetLatestLatitude()
{
    if (isset($GLOBALS['dfLatestLat']))
      return $GLOBALS['dfLatestLat'];
    return 0;
}				

function GetLatestLongitude()
{
    if (isset($GLOBALS['dfLatestLon']))
      return $GLOBALS['dfLatestLon'];
    return 0;
}				


function GetReadPointsDelay()
{
    if (isset($GLOBALS['ReadPointsDelay']))
      return $GLOBALS['ReadPointsDelay'];

    return 5;
}

function GetRefreshMapDelay()
{
    if ($GLOBALS['RefreshMapDelay'] <= 0)
      $GLOBALS['RefreshMapDelay'] = 20;
    return $GLOBALS['RefreshMapDelay'];
}

function GetNextUpdateMapTime()
{
    if (isset($GLOBALS['NextUpdateMapTime']))
      return $GLOBALS['NextUpdateMapTime'];

    return -1;
}

function GetLatLongCoordinates()
{
    return $GLOBALS['LatLongCoordinates'];
}
function UpdatePoints()
{
    $nTime = time();
    
    if(isset($GLOBALS['NextUpdateMapTime']) &&
       $GLOBALS['NextUpdateMapTime'] > 0 &&
       isset($GLOBALS['PlotPointType']) &&
       $GLOBALS['PlotPointType'] > 0)
    {
        //echo "UpdatePoints() time=: " . $nTime;
        //echo "NextUpdateMapTime = " . $GLOBALS['NextUpdateMapTime'];
        if ($GLOBALS['NextUpdateMapTime'] <= $nTime)
        {
            
            $GLOBALS['RefreshMap'] = 1;
              
            $szURL =  $GLOBALS['sGPSURL'] . "command=getlatlongmessages&time=".$GLOBALS['NextUpdateMapTime'];

            // echo $szURL;

            if ($GLOBALS['PlotPointType'] == 2)
              $szURL .="&nummessage=1";

            //set the next update time
            $GLOBALS['NextUpdateMapTime'] = $nTime + $GLOBALS['RefreshMapDelay'];
            
            $fp = fopen($szURL, "r");  
            if ($fp)
            {
                while (!feof($fp))
                  $contents .= fread($fp, 8192);
                
                if (stristr($contents, "Lat"))
                    $GLOBALS['LatLongCoordinates'] = $contents;
                //echo $contents;
                fclose($fp);
            }
        }	
    }
}

function GetRawMessages($nMessages=20)
{
    
    $contents = "";
    if (GetGPSStatus() == GPS_STARTED && !GPSDebugMode())
    {
        $szURL =  $GLOBALS['sGPSURL'] . "command=getrawmessages";
        $fp = fopen($szURL, "r");  
        if ($fp)
        {
            while (!feof($fp))
              $contents .= fread($fp, 8192);

            fclose($fp);
        }
    }
    return $contents;
}

function GPSDebugMode()
{
  if (isset($GLOBALS['DEBUG']))
    return $GLOBALS['DEBUG'];
  return 0;
}


/************************************************************************/
/*              Utility functions to get curren gps settings.           */
/************************************************************************/

function GetGPSURL()
{
  return $GLOBALS['sGPSURL'];
}


function GetGPSBinary()
{
    if (isset($GLOBALS['sGPSBINARY']))
      return $GLOBALS['sGPSBINARY'];

    return "";
}



function GetCurrentBaud()
{
  return $GLOBALS['dfBaud'];
}


function GetCurrentPort()
{
  return $GLOBALS['sPort'];
}

function GetCurrentDataBits()
{
  return $GLOBALS['nDataBits'];
}


function GetCurrentParity()
{
  return $GLOBALS['sParity'];
}

function GetCurrentStopBits()
{
  return $GLOBALS['dfStopBits'];
}


function GetAveragePoints()
{
  if (isset($GLOBALS['AveragePoints']))
    return $GLOBALS['AveragePoints'];

  return 0;
}


function GetCurrentInterfaceTab()
{
    return $GLOBALS['CURRENTTAB'];
}


function GetPlotPointType()
{
    if (isset($GLOBALS['PlotPointType']))
      return $GLOBALS['PlotPointType'];

    return 0;
}

function  GetSymbolName()
{
    if (isset($GLOBALS['SymbolName']))
      return $GLOBALS['SymbolName'];

    return 'star';
}


function  GetSymbolSize()
{
    if (isset($GLOBALS['SymbolSize']))
      return $GLOBALS['SymbolSize'];

    return 8;
}

function GetMapSymbolColor()
{       
    $szColor="";
    if (isset($GLOBALS['ColorRed']))
      $szColor = $szColor . $GLOBALS['ColorRed'] . ",";
    else
      $szColor = $szColor . "0" . ",";
    if (isset($GLOBALS['ColorGreen']))
      $szColor = $szColor . $GLOBALS['ColorGreen'] . ",";
    else
      $szColor = $szColor . "0" . ",";
    if (isset($GLOBALS['ColorBlue']))
      $szColor = $szColor . $GLOBALS['ColorBlue'];
    else
      $szColor = $szColor . "0";
    
    
  return $szColor;
}

function GetMapSymbolOutlineColor()
{
    $szOutlineColor="";
    if (isset($GLOBALS['OutlineColorRed']))
      $szOutlineColor = $szOutlineColor . $GLOBALS['OutlineColorRed'] . ",";
    else
      $szOutlineColor = $szOutlineColor . "0" . ",";
    if (isset($GLOBALS['OutlineColorGreen']))
      $szOutlineColor = $szOutlineColor . $GLOBALS['OutlineColorGreen'] . ",";
    else
      $szOutlineColor = $szOutlineColor . "0" . ",";
    if (isset($GLOBALS['OutlineColorBlue']))
      $szOutlineColor = $szOutlineColor . $GLOBALS['OutlineColorBlue'];
    else
      $szOutlineColor = $szOutlineColor . "0";
    
    
  return $szOutlineColor;
 
}


function GetColor($szColor)
{
    if ($szColor == 'red')
    {
        if (isset($GLOBALS['ColorRed']))
          return $GLOBALS['ColorRed'];
        else
          return 0;
    }
    else if ($szColor == 'green')
    {
        if (isset($GLOBALS['ColorGreen']))
          return $GLOBALS['ColorGreen'];
        else
          return 0;
    }
    else if ($szColor == 'blue')
    {
        if (isset($GLOBALS['ColorBlue']))
          return $GLOBALS['ColorBlue'];
        else
          return 0;
    }
}


function GetOutlineColor($szOutlineColor)
{
    if ($szOutlineColor == 'red')
    {
        if (isset($GLOBALS['OutlineColorRed']))
          return $GLOBALS['OutlineColorRed'];
        else
          return 0;
    }
    else if ($szOutlineColor == 'green')
    {
        if (isset($GLOBALS['OutlineColorGreen']))
          return $GLOBALS['OutlineColorGreen'];
        else
          return 0;
    }
    else if ($szOutlineColor == 'blue')
    {
        if (isset($GLOBALS['OutlineColorBlue']))
          return $GLOBALS['OutlineColorBlue'];
        else
          return 0;
    }
}
