<?php
/**
 * ExtractWFSData Widget Class
 *
 * @project     Chameleon
 * @revision    $Id: ExtractWFSData.widget.php,v 1.7 2004/07/08 17:49:07 pspencer Exp $
 * @purpose     Widget to extract WFS data given an AOI.
 * @author      DM Solutions Group (dev@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * ExtractWFSData
 *
 * @desc Display a widget that pops up a projection selection widget.
 */
class ExtractWFSData extends CWCWidget
{
    var $moButton;
    var $moPopup;

    /**
     * ExtractWFSData
     *
     * Constuctor method for the ExtractWFSData
     */
    function ExtractWFSData()
    {
        parent::CWCWidget();

        $this->moButton = new CWCButton( $this );
        $this->moPopup = new CWCPopup( $this );
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath'].
                                    "/widgets/ExtractWFSData/ExtractWFSData.phtml";

        // add outputformats attribute support
        $this->maAttributes["OUTPUTFORMATS"] = new
                                        StringAttribute( "OUTPUTFORMATS", true );

        // add compressformats attribute support
        $this->maAttributes["COMPRESSFORMATS"] = new
                                        StringAttribute( "COMPRESSFORMATS", true );

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Extract WFS Data widget allows the user to extract data based on the current
selected layer and ROI.  Currently the following formats are supported:
GML
Shape
EOT;

    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('clickExtractWFSData');
    }

    /**
     * SetMap
     *
     * Set the map session and create a navigation tool.
     */
    function SetMap($oMapSession)
    {
        $this->moMapObject = $oMapSession;
    }


    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }

    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }

    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    /**
     * GetHTMLHiddenVariables
     */
    function GetHTMLHiddenVariables()
    {
        // initialize return array
        $aReturn = $this->moButton->GetHTMLHiddenVariables();

        // return array of hidden variables
        return $aReturn;
    }

    /**
     * ParseURL
     *
     */
    function  ParseURL()
    {
        // return success
        return true;
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        // get outputformat
        if ( isset( $this->maParams["OUTPUTFORMATS"] ) )
            $szTmpOutputFormat = $this->maParams["OUTPUTFORMATS"];
        else
            $szTmpOutputFormat = "";

        // get compressformat
        if ( isset( $this->maParams["COMPRESSFORMATS"] ) )
            $szTmpCompressFormat = $this->maParams["COMPRESSFORMATS"];
        else
            $szTmpCompressFormat = "";


        $aReturn = $this->moButton->GetJavascriptFunctions();//array();
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/ExtractWFSData/ExtractWFSData.phtml?outputformats=".
                               $szTmpOutputFormat."&compressformats=".$szTmpCompressFormat.
                               "&chkCompress=1".
                               "&selectedlayers=' + szSelectedLayers + ' ";
        $szJsFunctionName = "clickExtractWFSData";
        $szButtonJS = $this->moPopup->DrawPublish();
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a extract wfs data dialog
 */
function {$szJsFunctionName}()
{
    var szSelectedLayers = "";
    // set the var
    if ( {$this->mszHTMLForm}.SELECTED_LAYERS )
    {
        szSelectedLayers = {$this->mszHTMLForm}.SELECTED_LAYERS.value;
    }
    //alert( szSelectedLayers );
    {$szButtonJS}
    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        // return the array of functions
        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- ExtractWFSData popup widget hidden -->";

        $szResult = $this->moButton->DrawPublish();
        return $szResult;
    }
}
?>
