<?php
/**
 * Extent Widget class
 *
 * @project     CWC2
 * @revision    $Id: Extent.widget.php,v 1.3 2004/07/08 15:58:57 pspencer Exp $
 * @purpose     Extent Widget class
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");

/**
 * a widget to display one of the map extents
 */
class Extent extends CWCWidget
{
    var $moLabel;
    var $mszClass = "CWCExtentWidgetClass";
    var $mszStyle = "";
    var $mszExtent = "";
    var $mnDefaultTextFieldSize = 20;

    /**
     * construct a new Extent widget
     */
    function Extent( )
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Extent widget displays one of the extents of the map in text on the
output page.
EOT;

        $this->moLabel = new CWCLabel($this);
        $this->maAttributes["EXTENT"] = new StringAttribute( "EXTENT", true,
                                    array( "MINX", "MINY", "MAXX", "MAXY" ) );
        $this->maAttributes["WIDGETCLASS"] = new StringAttribute( "WIDGETCLASS", false );
        $this->maAttributes["WIDGETSTYLE"] = new StringAttribute( "WIDGETSTYLE", false );
        $this->maAttributes["TEXTFIELDSIZE"] = new IntegerAttribute( "TEXTFIELDSIZE", false, 0 );
    }

    /**
     * Initialize default values from tag
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        
        if (isset($this->maParams["WIDGETCLASS"]))
            $this->mszClass = strtoupper($this->maParams["WIDGETCLASS"]);
        if (isset($this->maParams["WIDGETSTYLE"]))
            $this->mszStyle = strtoupper($this->maParams["WIDGETSTYLE"]);
        if (isset($this->maParams["EXTENT"]))
            $this->mszExtent = strtoupper($this->maParams["EXTENT"]);
        if (isset($this->maParams["TEXTFIELDSIZE"]))
            $this->mnDefaultTextFieldSize = strtoupper($this->maParams["TEXTFIELDSIZE"]);
    }

    /**
     * return an array of javascript functions needed by Extent widget
     * @return array of name = function values
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $poMap = $this->moMapObject->oMap;

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if ($bCWCJSAPI)
        {
            $szJsFunctionName = "ExtentWRegisterForEvent";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to register and even when the map extents changes (JSAPI)
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(MAP_EXTENT_CHANGED, "ExtentWMapExtentsChanged");
}
EOT;

       $aReturn[$szJsFunctionName] = $szFunction;

       $szJsFunctionName = "ExtentWMapExtentsChanged";
       $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the mapextents are changed to update the extent(JSAPI)
 */
function {$szJsFunctionName}()
{
  // update the extent labels
    {$this->mszHTMLForm}.Extent_MINX.value = goCWCJSAPI.oMap.minx;
    {$this->mszHTMLForm}.Extent_MINY.value = goCWCJSAPI.oMap.miny;
    {$this->mszHTMLForm}.Extent_MAXX.value = goCWCJSAPI.oMap.maxx;
    {$this->mszHTMLForm}.Extent_MAXY.value = goCWCJSAPI.oMap.maxy;
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;

       }

       return $aReturn;
    }


    /**
     * return an array of javascript functions needed by Extent widget
     * and called when the page is loaded.
     * @return array of name = function values
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();

        $aReturn = parent::GetJavascriptOnLoadFunctions();

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
             $szJsFunctionName = "ExtentWRegisterForEvent";
             $szFunction = "$szJsFunctionName();\n";
             $aReturn[$szJsFunctionName] = $szFunction;
        }

        return $aReturn;
    }

    /**
     * draw the extent in published state
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- ExtentWidget hidden -->";

        $szValue = "";
        $szClass = "";
        $szStyle = "";

        if (strlen($this->mszExtent) == 0)
            return "<!-- EXTENT WIDGET MISSING EXTENT ATTRIBUTE -->\n";

        //get the requested extent value
        $szEval =  "\$szValue = \$this->moMapObject->oMap->extent->";
        $szEval .= strtolower($this->mszExtent).";";
        eval( $szEval );

        $nPixSize = $this->moMapObject->oMap->width;
        $nGeoSize = $this->moMapObject->oMap->extent->minx -
                     $this->moMapObject->oMap->extent->maxx;

        $nPixelSize = abs($nPixSize / $nGeoSize);

        if ($nPixelSize > 1)
            $nNbDecimal = abs(log($nPixelSize))/log(10)+1;
        else
            $nNbDecimal = 0;

        $nMinX = number_format($szValue, $nNbDecimal, ".", "");

        // show the extent as a textbox made to look like a label
        if (!$this->mbVisible)
            return "<!-- Extent widget hidden -->";

        $nSize = $this->mnDefaultTextFieldSize;
        if (isset($this->maParams["TextFieldSize"]))
            $nSize = strtoupper($this->maParams["TextFieldSize"]);

        $szClass = "";
        if ( strlen($this->mszClass) > 0 )
            $szClass = " CLASS=\"$this->mszClass\"";
        $szStyle = "";
        if ( strlen($this->mszStyle) > 0 )
            $szStyle = " STYLE=\"$this->mszStyle\"";
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
            $szContents="<input".$szClass.$szStyle." type=\"text\" name=\"Extent_".$this->mszExtent."\" value=\"".$nMinX."\"  size=\"$nSize\" readonly>";
        else
            $szContents="<span".$szClass.$szStyle." name=\"txtExtentLabel".$this->mnId."\">".$nMinX."</span>";
        return $this->moLabel->DrawPublish( $szContents );

    }
}
?>
