<?php
/**
 * @project     GeoDan
 * @revision    $Id: ExpressionBuilder.php,v 1.9 2004/07/06 06:08:48 bartvde Exp $
 * @purpose     This contains the supporting php code.
 * @author      William A. Bronsema, C.E.T. (dev@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 **/

//set the language resource file
$szLanguageResource = str_replace("\\","/",dirname(__FILE__))."/ExpressionBuilder.dbf";


// set the flag to setup the mapsession
if ( !defined("LOAD_MAPSESSION") )
    define("LOAD_MAPSESSION", 1);

// include the session handling file (currently only required for MLT)
include_once(dirname(__FILE__)."/../session.inc.php");
include_once(dirname(__FILE__)."/../CWC2ButtonCache.php");

// include the layer attribute handling functions
include( dirname(__FILE__)."/../LayerAttributes.php" );

// get the form vars
$_FORM = array_merge( $_GET, $_POST );

/* ============================================================================
 * Define the default properties for the "LIKE" operator
 * ========================================================================= */
define( "LIKE_WILDCARD", urldecode( $_FORM["wildcard"] ) );
define( "LIKE_SINGLECHAR", urldecode( $_FORM["singlechar"] ) );
define( "LIKE_ESCAPECHAR", urldecode( $_FORM["escape"] ) );

/* ============================================================================
 * Determine the layer specific info
 * ========================================================================= */
// init vars
$nCount = 0;
$nSelectedLayer = "";
$szSelectedLayerName = "";
$szSelectedLayerConnType = "";
$aszAttributes = array();
$szErrorNotice = "";
$szWFSConnection = "";
$nLayerCount = $oMapSession->oMap->numlayers;
$szWFSTypeName = '';

/* ============================================================================
 * Get selected WFS layer
 * ========================================================================= */
// check if selected layer list has been passes through URL
$aszLayers = array();
if ( isset( $_FORM["selectedlayers"] ) &&
                              strlen( trim( $_FORM["selectedlayers"] ) ) > 0 )
{
    // put layers into array
    $aszLayers = explode( ',', $_FORM["selectedlayers"] );
    $nTmpCount = count( $aszLayers );
    for( $i=0; $i<$nTmpCount; $i++ )
        $aszLayers[$i] = trim( $aszLayers[$i] );

}

// check for layers from the url
if ( count( $aszLayers ) > 0 )
{
    //convert WMS_TITLE to WMS_NAME ... this should make sure WMS_NAME is
    //set first but I didn't have time to do that properly ... it is safe
    //when working with map files coming from Contexts but possibly not
    //when working with hand-crafted map files
    for( $i=0; $i<count($aszLayers); $i++ )
    {
        for ($j=0; $j<$nLayerCount; $j++)
        {
            $oLayer = $oMapSession->oMap->getLayer($j);
            if ($oLayer->connectiontype == MS_WMS)
            {
                if ($aszLayers[$i] == $oLayer->getMetadata( "WMS_TITLE" ))
                {
                    $aszLayers[$i] = $oLayer->getMetadata( "WMS_NAME" );
                }
            }
        }
    }
}
else
{
    // get list from metadata
    for ( $i=0; $i<$nLayerCount; $i++ )
    {
        // get layer
        $oLayer = $oMapSession->oMap->getLayer( $i );

        // check metadata
        if ( $oLayer->getmetadata("selected") == 1 )
        {
            // add to the list of layers
            array_push( $aszLayers, $oLayer->name );
        }
    }
}

// check for an empty first one
if ( $aszLayers[0] == '' )
    array_shift( $aszLayers );

// update the active layer count
$nCount = count( $aszLayers );

// only process the first WMS or WFS layer
for ( $i=0; $i<$nCount; $i++ )
{
    // get layer by name
    $oLayer = $oMapSession->oMap->getLayerbyName( $aszLayers[$i] );
    if ($oLayer == null)
    {
        //desperate attempt to find layer ...
        for ($j=0; $j<$oMapSession->oMap->numlayers; $j++)
        {
            $oLayer = $oMapSession->oMap->getLayer( $j );
            if ($oLayer->getMetaData( "WMS_NAME" ) == $aszLayers[$i] ||
                $oLayer->getMetaData( "WMS_TITLE" ) == $aszLayers[$i] )
            {
                break;
            }
        }
    }
    // only process WMS and WFS layers
    if ( $oLayer->connectiontype == MS_WFS ||
         $oLayer->connectiontype == MS_WMS )
    {
        // record layer index
        $nSelectedLayer = $oLayer->index;

        // store the layer name to use
        $szSelectedLayerName = $oLayer->name;

        // store the connection type
        $szSelectedLayerConnType = $oLayer->connectiontype;

        // process according to layer type
        switch( $oLayer->connectiontype )
        {
            case MS_WFS:
                // record the connection string
                $szWFSConnection = $oLayer->connection;
                break;
            case MS_WMS:
                // get WFS the connection string
                $szSelectedLayerName = $oLayer->getMetadata( "WMS_NAME" );
                //echo $szSelectedLayerName."<BR>";
                $aszWFSInfo = getWFSConnection( $oLayer->connection,
                                                      $szSelectedLayerName );

				// function can return false instead of array!
                if ($aszWFSInfo != false)
                {
                  $szWFSConnection = $aszWFSInfo['wfs'];
                  //echo $szWFSConnection."<BR>";
                  // loop and build typename
                  foreach( $aszWFSInfo['typename'] as $szTypeName )
                  {
                    $szWFSTypeName .= $szTypeName.',';
                  }

                  // remove trailing ','
                  if ( substr( $szWFSTypeName, -1, 1 ) == ',' )
                  {
                    $szWFSTypeName = substr( $szWFSTypeName, 0, -1 );
                  }

                  // check for false (meaning no associated WFS)
                  if ( $szWFSConnection === false )
                  {
                      // give error
                      $szErrorNotice = $oMLT->get("30", 'An invalid WMS layer was '.
                          'selected.  A WMS layer must have a WFS associated with '.
                          'it in order to be filtered.' );

                      // reset
                      $szWFSConnection = '';
                      $nSelectedLayer = '';
                      $szSelectedLayerName = '';
                  }
                }
                else
                {
                  // give error
                  $szErrorNotice = $oMLT->get("30", 'An invalid WMS layer was '.
                      'selected.  A WMS layer must have a WFS associated with '.
                      'it in order to be filtered.' );


                  // reset
                  $szWFSConnection = '';
                  $nSelectedLayer = '';
                  $szSelectedLayerName = '';
                }
                break;
        }

        // save expressions if necessary
        if ( isset( $_FORM['txtSaveExpressions'] ) &&
                                        $_FORM['txtSaveExpressions'] == 1 )
        {
            // store these as current layer's metadata expression
            $oLayer = $oMapSession->oMap->getLayer( $nSelectedLayer );
            $oLayer->setMetadata( 'cham_x_build_expressions',
                                                  $_FORM['txtExpressions'] );
        }

        // get expressions from metadata
        $_FORM['txtExpressions'] =
                        $oLayer->getMetadata( 'cham_x_build_expressions' );

        // one layer has been processed so exit loop
        break;
    }

// for loop
}

/* ============================================================================
 * Create javascript necessary to load saved expressions
 * ========================================================================= */
if ( isset( $_FORM['txtExpressions'] ) && strlen( $_FORM['txtExpressions'] ) > 0 )
{
    $szJavascriptExpressions =
                         buildJavascriptExpressions( $_FORM['txtExpressions'] );
}

/* ============================================================================
 * Process attribute info
 * ========================================================================= */
if ( strlen( trim( $szWFSConnection ) ) > 0 )
{
    // check the the WFS online resource contains the necessary params
    //echo "fixing WFS url $szWFSConnection for layer $szSelectedLayerName<BR>";
    $szWFSConnection = fixWFSURL( $szWFSConnection, $szWFSTypeName );

    // get the attribute types
    $aszAttributes = getAttributeTypes( $szWFSConnection.
                            'request=describefeaturetype', $szSelectedLayerName );

    // build list of attrtibutes
    $szAttributeOptions = '';
    $szLayerType = '';
    foreach( $aszAttributes as $key=>$value )
    {
        // skip layer type
        if ( $key == 'LayerType' )
        {
            $szLayerType = $value;
            continue;
        }

        // assemble string
        $szTmpAttribute = $key." (".$value.")";

        // create new option list item
        $szAttributeOptions .= "<option value=\"".$key."\">".
            $szTmpAttribute."</option>\n";
    }
}
else
{
    // set error message
    $szErrorNotice = $oMLT->get("20", "Invalid layer or none selected.  ".
        "Please ensure that the selected layer is a WFS or WMS layer." );
}

/* ============================================================================
 * Build style select
 * ========================================================================= */
if ( isset($_FORM['styles']  ) && strlen( $_FORM['styles'] ) > 0 )
{
    // get title
    $szTmpTitle = $oMLT->get("28", "Select SLD");

    // loop and build list of drop down options
    $aszStyles = explode( '|', $_FORM['styles'] );
    $nSLDCount = count( $aszStyles );
    $szStyleOptions = '';
    for ( $i=0; $i<$nSLDCount; $i++ )
    {
        // separate the name from the sld file
        // [0] = name
        // [1] = sld url
        // [2] = namedlayer
        // [3] = layer type
        $aszSplit = explode( '@', $aszStyles[$i] );
        if (!isset($szLayerType) || strcasecmp($szLayerType, 'MS_LAYER_'.$aszSplit[3] ) == 0)
        {
            $szStyleOptions .= '<option value="'.$aszStyles[$i].'">'.$aszSplit[0].
                                                                            '</option>';
        }
    }

    // set
    $szStyleForm = <<<EOT
  <tr>
    <td colspan="2" class="layoutTable">
      <table class="titleArea" width="100%" border="0" cellpadding="4" cellspacing="0">
        <tr>
          <td><span class="title">{$szTmpTitle}</span></td>
        </tr>
      </table>
      <table class="contentArea" width="100%" border="0" cellpadding="4" cellspacing="0">
        <tr>
          <td><select name="selSLD" class="inputList">
                {$szStyleOptions}
              </select></td>
        </tr>
      </table>
    </td>
  </tr>
EOT;

/* ============================================================================
 * Build layer type HTML
 * ========================================================================= */
    if ( !isset( $szLayerType ) || strlen( $szLayerType ) <= 0 )
    {
        $szLayerTypeHTML = '<td valign="middle" rowspan="2"><p class="helpArea">'.
            $oMLT->get('33', 'Unable to determine layer data type.  Please specify the underlying data type for this layer.').
            '</p></td>'.
            '</tr>'.
            '<tr>'.
            '<td valign="top"><span class="label">'.
            $oMLT->get("31", "Type").
            ': </span><select name="selLayerType" class="inputList">'.
            '<option value="MS_LAYER_POINT">Point</option>'.
            '<option value="MS_LAYER_LINE">Line</option>'.
            '<option value="MS_LAYER_POLYGON">Polygon</option></select></td>';
    }
    else
    {
        if ( !isset( $szLayerType ) ) $szLayerType = '';
        $szLayerTypeHTML = '<input type="hidden" name="selLayerType" value="'.
                                                                $szLayerType.'">';
    }
}

function buildJavascriptExpressions( $szExpressionsString )
{

    // explode individual expressions
    $aszExpressions = explode( '|@|', $szExpressionsString );

    // init vars
    $szJavascriptExpressions = "";

    // process each expression
    foreach( $aszExpressions as $szExpression )
    {
        // skip if empty
        if ( strlen( trim( $szExpression ) ) <= 0 )
            continue;

        // break apart
        $aszExpComponents = explode( '|', $szExpression );

        // create javascript to add expressions
        $szJavascriptExpressions .= 'addExpression( "'.
                                        $aszExpComponents[0].'", "'.
                                        $aszExpComponents[1].'", "'.
                                        $aszExpComponents[2].'", "'.
                                        $aszExpComponents[4].'", "'.
                                        $aszExpComponents[5].'", "'.
                                        $aszExpComponents[2].'", "'.
                                        $aszExpComponents[3].'", "'.
                                        $aszExpComponents[4].'", "'.
                                        $aszExpComponents[5].'" );';
    }

    // return
    return $szJavascriptExpressions;
}

?>
