<?
include_once(COMMON."/xml_utils/XMLObject.php" );

class ThemeParser
{
    var $maVals = array();

    var $maGlobals = array();
    var $maThemes = array();
    var $maThemeIndex = array();
    var $maLayers = array();
    var $mnThemes = 0;
    
    function ThemeParser( $szThemeFile )
    {
/* ==================================================================== */
/*      Used implode(file instead of file_get_contents which is only    */
/*      defined if php >= 4.3.0.                                        */
/* ==================================================================== */
        $szXML = implode('',file($szThemeFile));//file_get_contents( $szThemeFile );
        $this->Parse( $szXML );
    }

    function Parse( $szXML )
    {

        $oXML = new XMLObject( $szXML );

        $oThemes = $oXML->getNextChild( "themes" );

        $oGlobal = $oThemes->getNextChild( "global" );

        $this->maGlobals["gThemeBold"] = "false";
        $this->maGlobals["gThemeFont"] = "";
        $this->maGlobals["gThemeFontSize"] = "";
        $this->maGlobals["gThemeIcon"] = "";
        $this->maGlobals["gThemeExtendAbstract"] = "false";
        $this->maGlobals["gThemeExtendContext"] = "false";
        $this->maGlobals["gThemeExtraLayers"] = -1;

        $this->maGlobals["gGroupBold"] = "false";
        $this->maGlobals["gGroupFont"] = "";
        $this->maGlobals["gGroupFontSize"] = "";
        $this->maGlobals["gGroupIcon"] = "";
        $this->maGlobals["gGroupExtendAbstract"] = "false";
        $this->maGlobals["gGroupVisible"] = "true";

        if ($oGlobal != "")
        {
            $ogTheme = $oGlobal->getNextChild( "themeParams" );
            $this->maGlobals["gThemeBold"] = (isset($ogTheme->bold)) ? $ogTheme->bold : $this->maGlobals["gThemeBold"];
            $this->maGlobals["gThemeFont"] = (isset($ogTheme->font)) ? $ogTheme->font : $this->maGlobals["gThemeFont"];
            $this->maGlobals["gThemeFontSize"] = (isset($ogTheme->fontsize)) ? $ogTheme->fontsize : $this->maGlobals["gThemeFontSize"];
            $this->maGlobals["gThemeIcon"] = (isset($ogTheme->icon)) ? $ogTheme->icon : $this->maGlobals["gThemeIcon"];
            $this->maGlobals["gThemeExtendAbstract"] = (isset($ogTheme->extendabstract)) ? $ogTheme->extendabstract : $this->maGlobals["gThemeExtendAbstract"];
            $this->maGlobals["gThemeExtendContext"] = (isset($ogTheme->extendcontext)) ? $ogTheme->extendcontext : $this->maGlobals["gThemeExtendContext"];

            $ogGroup = $oGlobal->getNextChild( "groupParams" );
            $this->maGlobals["gGroupBold"] = (isset($ogGroup->bold)) ? $ogGroup->bold : $this->maGlobals["gGroupBold"];
            $this->maGlobals["gGroupFont"] = (isset($ogGroup->font)) ? $ogGroup->font : $this->maGlobals["gGroupFont"];
            $this->maGlobals["gGroupFontSize"] = (isset($ogGroup->fontsize)) ? $ogGroup->fontsize : $this->maGlobals["gGroupFontSize"];
            $this->maGlobals["gGroupIcon"] = (isset($ogGroup->icon)) ? $ogGroup->icon : $this->maGlobals["gGroupIcon"];
            $this->maGlobals["gGroupExtendAbstract"] = (isset($ogGroup->extendabstract)) ? $ogGroup->extendabstract : $this->maGlobals["gGroupExtendAbstract"];
            $this->maGlobals["gGroupVisible"] = (isset($ogGroup->visible)) ? $ogGroup->visible : $this->maGlobals["gGroupVisible"];
        }

        $this->maVals = array();

        while( ($oTheme = $oThemes->getNextChild( "" )) != "" )
        {
            if ($oTheme->_type == "theme")
            {
                if (!isset($this->maVals["theme"]))
                    $this->maVals["theme"] = array();

                $aTheme = array();

                $aTheme["theme_type"] = isset($oTheme->type) ? $oTheme->type : "checkbox";
                $aTheme["theme_abstract"] = isset($oTheme->abstract) ? $oTheme->abstract : "";
                $aTheme["theme_name"] = isset($oTheme->name) ? $oTheme->name : "theme";
                $aTheme["theme_bold"] = isset($oTheme->bold) ? $oTheme->bold : $this->maGlobals["gThemeBold"];
                $aTheme["theme_font"] = isset($oTheme->font) ? $oTheme->font : $this->maGlobals["gThemeFont"];
                $aTheme["theme_fontsize"] = isset($oTheme->fontsize) ? $oTheme->fontsize : $this->maGlobals["gThemeFontSize"];
                $aTheme["theme_icon"] = isset($oTheme->icon) ? $oTheme->icon : $this->maGlobals["gThemeIcon"];
                $aTheme["theme_extendabstract"] = isset($oTheme->extendabstract) ? $oTheme->extendabstract : $this->maGlobals["gThemeExtendAbstract"];
                $aTheme["theme_extralayers"] = isset($oTheme->extralayers) ? $oTheme->extralayers : "false";
                $aTheme["theme_numlayers"] = "0";
                //calculated values
                $aTheme["theme_id"] = count( $this->maVals["theme"] );
                $aTheme["theme_input"] = "";
                $aTheme["theme_url"] = "";

                if ($aTheme["theme_extralayers"] == "true")
                 {
                 $this->maGlobals["gThemeExtraLayers"] = $aTheme["theme_id"];
                }
                array_push( $this->maVals["theme"], $aTheme );

                $this->maThemes[ $aTheme["theme_name"] ] = array();
                array_push( $this->maThemeIndex, $aTheme["theme_name"] );

                while ( ($oGroup = $oTheme->getNextChild("")) != "" )
                {
                    if ($oGroup->_type == "group")
                    {
                        if (!isset($this->maVals["group"]))
                            $this->maVals["group"] = array();

                        $aGroup = array();

                        $aGroup["group_abstract"] = isset($oGroup->abstract) ? $oGroup->abstract : "";
                        $aGroup["group_name"] = isset($oGroup->name) ? $oGroup->name : "group";
                        $aGroup["group_bold"] = isset($oGroup->bold) ? $oGroup->bold : $this->maGlobals["gGroupBold"];
                        $aGroup["group_font"] = isset($oGroup->font) ? $oGroup->font : $this->maGlobals["gGroupFont"];
                        $aGroup["group_fontsize"] = isset($oGroup->fontsize) ? $oGroup->fontsize : $this->maGlobals["gGroupFontSize"];
                        $aGroup["group_icon"] = isset($oGroup->icon) ? $oGroup->icon : $this->maGlobals["gGroupIcon"];
                        $aGroup["group_extendabstract"] = isset($oGroup->extendabstract) ? $oGroup->extendabstract : $this->maGlobals["gGroupExtendAbstract"];
                        $aGroup["group_visible"] = isset($oGroup->visible) ? $oGroup->visible : $this->maGlobals["gGroupVisible"];

                        //calculated values
                        $aGroup["group_id"] = count( $this->maVals["group"] );
                        $aGroup["group_theme_id"] = $aTheme["theme_id"];
                        $aGroup["group_input"] = "";
                        $aGroup["group_url"] = "";

                        array_push( $this->maVals["group"], $aGroup );

                        $this->maThemes[ $aTheme["theme_name"] ][ $aGroup["group_name"] ] = array();

                        while ( ($oLayer = $oGroup->getNextChild("")) != "" )
                        {
                            if ($oLayer->_type == "layer" && isset( $oLayer->name ))
                            {
                                $this->maThemes[ $aTheme["theme_name"] ][ $aGroup["group_name"] ][] = $oLayer->name;
                                $this->maLayers[ $oLayer->name ] = array();
                                $this->maLayers[ $oLayer->name ]['theme'] = $aTheme["theme_name"];
                                $this->maLayers[ $oLayer->name ]['group'] = $aGroup["group_name"];

                            }
                        }
                    }
                }
            }
        }
        $this->mnThemes = count($this->maThemes);
    }

/* ==================================================================== */
/*      ProcessExtraLayers adds layers in the context but not in the    */
/*      themefile to the legend. If there is a theme with               */
/*      extralayers=true, they are added there, otherwise each layer    */
/*      gets its own theme.                                             */
/* ==================================================================== */
    function ProcessExtraLayers($oMap)
    {
        
        $nLayers = $oMap->numlayers;
        
        for( $i=0; $i<$oMap->numlayers;$i++)
        {
            $oLayer = $oMap->getlayer($i);
            $aName = explode(":", $oLayer->name);

            $szLayerName = $aName[1];

            //find layers not in themefile.
            if (!isset($this->maLayers[$szLayerName]))
            {
                //get extra layers theme id
                $nExtraLayersTheme = $this->maGlobals["gThemeExtraLayers"];
                
                //if extra layers is set, we add this layer to that theme as a
                //group with a single layer.
                //otherwise, add a theme and a group for the layer
                if ($nExtraLayersTheme > -1)
                {
                    $aGroup = array();
    
                    $aGroup["group_abstract"] = isset($oGroup->abstract) ? $oGroup->abstract : "";
                    $aGroup["group_name"] = $szLayerName;
                    $aGroup["group_bold"] = $this->maGlobals["gGroupBold"];
                    $aGroup["group_font"] = $this->maGlobals["gGroupFont"];
                    $aGroup["group_fontsize"] = $this->maGlobals["gGroupFontSize"];
                    $aGroup["group_icon"] = $this->maGlobals["gGroupIcon"];
                    $aGroup["group_extendabstract"] = $this->maGlobals["gGroupExtendAbstract"];
                    $aGroup["group_visible"] = $this->maGlobals["gGroupVisible"];
                    $aGroup['group_numlayers'] = "1";
   
                    //calculated values
                    $aGroup["group_id"] = count( $this->maVals["group"] );
                    $aGroup["group_theme_id"] = $nExtraLayersTheme;
                    $aGroup["group_input"] = "";
                    $aGroup["group_url"] = "";
    
                    $szThemeName = $this->GetTheme($nExtraLayersTheme);
                    
                    $this->maThemes[ "$szThemeName" ][ $aGroup["group_name"] ] = array();

                    $this->maThemes[ "$szThemeName" ][ $aGroup["group_name"] ][] = $szLayerName;
                    $this->maLayers[ $szLayerName ] = array();
                    $this->maLayers[ $szLayerName ]['theme'] = $nExtraLayersTheme;
                    $this->maLayers[ $szLayerName ]['group'] = $aGroup["group_name"];
                    array_push( $this->maVals["group"], $aGroup );

                }
                else
                {
                    $aTheme = array();
                    $aTheme["theme_type"] = "checkbox";
                    $aTheme["theme_abstract"] = "";
                    $aTheme["theme_name"] = $szLayerName;
                    $aTheme["theme_bold"] = $this->maGlobals["gThemeBold"];
                    $aTheme["theme_font"] = $this->maGlobals["gThemeFont"];
                    $aTheme["theme_fontsize"] = $this->maGlobals["gThemeFontSize"];
                    $aTheme["theme_icon"] = $this->maGlobals["gThemeIcon"];
                    $aTheme["theme_extendabstract"] = $this->maGlobals["gThemeExtendAbstract"];
                    $aTheme["theme_extralayers"] = "false";
                    $aTheme['theme_numlayers'] = "1";                    
                    
                    //calculated values
                    $aTheme["theme_id"] = count( $this->maVals["theme"] );
                    $aTheme["theme_input"] = "";
                    $aTheme["theme_url"] = "";
                                       
                    array_push( $this->maVals["theme"], $aTheme );

                    $this->maThemes[ $aTheme["theme_name"] ] = array();
                    array_push( $this->maThemeIndex, $aTheme["theme_name"] );
                    
                    $aGroup = array();
    
                    $aGroup["group_abstract"] = isset($oGroup->abstract) ? $oGroup->abstract : "";
                    $aGroup["group_name"] = $szLayerName;
                    $aGroup["group_bold"] = $this->maGlobals["gGroupBold"];
                    $aGroup["group_font"] = $this->maGlobals["gGroupFont"];
                    $aGroup["group_fontsize"] = $this->maGlobals["gGroupFontSize"];
                    $aGroup["group_icon"] = $this->maGlobals["gGroupIcon"];
                    $aGroup["group_extendabstract"] = $this->maGlobals["gGroupExtendAbstract"];
                    $aGroup["group_visible"] = "false";
                    $aGroup['group_numlayers'] = "1";
                    
                    //calculated values
                    $aGroup["group_id"] = count( $this->maVals["group"] );
                    $aGroup["group_theme_id"] = $aTheme["theme_id"];
                    $aGroup["group_input"] = "";
                    $aGroup["group_url"] = "";
    
                    $this->maThemes[ $aTheme["theme_name"] ][ $aGroup["group_name"] ][] = $szLayerName;
                    $this->maLayers[ $szLayerName ] = array();
                    $this->maLayers[ $szLayerName ]['theme'] = $aTheme["theme_name"];
                    $this->maLayers[ $szLayerName ]['group'] = $aGroup["group_name"];
                    
                    array_push( $this->maVals["group"], $aGroup );
               
                }
              
            }
        }
    }

    function GetNumberOfThemes()
    {
        return $this->mnThemes;
    }

    function GetTheme($i)
    {
        if ($i>=0 && $i<$this->mnThemes)
        {
            return $this->maThemeIndex[$i];
        }
    }

    function GetThemeIndex( $szTheme )
    {
        return array_search( $szTheme, $this->maThemeIndex );
    }

    function GetThemeAttribute( $szTheme, $szAttribute )
    {
        $idx = $this->GetThemeIndex( $szTheme );
        if( isset( $this->maVals["theme"][$idx][$szAttribute] ) )
            return $this->maVals["theme"][$idx][$szAttribute];
        else
            return "";
    }

    function GetGroupIndex( $szTheme, $szGroup )
    {
        $theme_id = $this->GetThemeIndex( $szTheme );

        foreach( $this->maVals["group"] as $idx => $aGroup )
        {
            if ($aGroup["group_theme_id"] == $theme_id && $aGroup["group_name"] == $szGroup )
                return $idx;
        }
    }

    function GetGroupAttribute( $szTheme, $szGroup, $szAttribute )
    {
        $idx = $this->GetGroupIndex( $szTheme, $szGroup );
        if( isset( $this->maVals["group"][$idx][$szAttribute] ) )
            return $this->maVals["group"][$idx][$szAttribute];
        else
            return "";
    }

    function GetNumGroups($szTheme)
    {
        if (isset($this->maThemes[trim($szTheme)]))
        {
            $idx = $this->GetThemeIndex( $szTheme );
            if ($this->maVals["theme"][$idx]["theme_type"] == "radio")
                $result = 1;
            else
                $result = count($this->maThemes[trim($szTheme)]);
            return $result;
        }

        return 0;
    }

    function GetGroups( $szTheme )
    {
        if (isset($this->maThemes[trim($szTheme)]))
            return $this->maThemes[trim($szTheme)];
        else
            return array();
    }
}

?>
