<?php
/**
 * ClearWFSFilter Widget Class
 *
 * @project     Chameleon
 * @revision    $Id: ClearWFSFilter.widget.php,v 1.5 2004/07/08 17:49:07 pspencer Exp $
 * @purpose     Clear the active layer's WFS filter if found.
 * @author      DM Solutions Group (dev@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
 * ClearWFSFilter
 *
 * @desc Display a widget that clears the active layer's WFS filter.
 */
class ClearWFSFilter extends CWCWidget
{
    var $moButton;

    /**
     * ExpressionBuilder
     *
     * Constctor method for the ExpressionBuilder
     */
    function ClearWFSFilter()
    {
        // set the language file
        $this->mszLanguageResource = dirname(__FILE__)."/ClearWFSFilter.dbf";
        
        parent::CWCWidget();

        $this->moButton = new CWCButton( $this );

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ClearWFSFilter widget clears the WFS filter from the active layer and deletes
the temporary annotation layer.
EOT;

    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('clickClearWFSFilter');
    }

    /**
     * SetMap
     *
     * Set the map session and create a navigation tool.
     */
    function SetMap($oMapSession)
    {
        $this->moMapObject = $oMapSession;
    }


    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }

    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

        function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }

    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    /**
     * GetHTMLHiddenVariables
     */
    function GetHTMLHiddenVariables()
    {
        // initialize return array
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        // set default value for the filter check
        $szFilterSet = ( isset( $_SESSION['expr_build_filter_set'] ) && 
                        $_SESSION['expr_build_filter_set'] == '1' ) ? '1' : '0';       
        
        // setup the variables
        $szVariable = "WFS_CLEAR_FILTER";
        $szValue = " <INPUT TYPE=hidden NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;
        $szVariable = "WFS_CLEAR_FILTER_ISSET";
        $szValue = ' <INPUT TYPE=hidden NAME='.$szVariable.' VALUE="'.$szFilterSet."\">\n";
        $aReturn[$szVariable] = $szValue;

        // return array of hidden variables
        return $aReturn;
    }

    /**
     * ParseURL
     *
     */
    function  ParseURL()
    {
        $this->moButton->ParseURL();
        
        // process the clear WFS filter request
        if ( $this->isVarSet("WFS_CLEAR_FILTER") &&
             $this->getVar("WFS_CLEAR_FILTER") == 1 )
        {
            // get the layer object
            $nCount = $this->moMapObject->oMap->numlayers;
            for ( $i=0; $i<$nCount; $i++ )
            {
                // get next layer
                $oLayer = $this->moMapObject->oMap->getlayer( $i );

                // if metadata is set then clear
                if ( $oLayer->getmetadata("selected") == 1 &&
                     strlen( trim( $oLayer->getmetadata("wfs_filter" ) ) ) > 0 )
                    $oLayer->removeMetaData( "wfs_filter" );
                    
                // delete annotation layer
                if ( $oLayer->name == 'ExpressionBuilderAnnotation' )
                    $oLayer->set( 'status', MS_DELETE );
            }
        }

        // return success
        return true;
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        $aReturn = $this->moButton->GetJavascriptFunctions();//array();

        // Add code to clear filter
        $szJsFunctionName = "clickClearWFSFilter";
        $szNoFilterMessage = $this->moMLT->get( "1", "There is no filter to clear." );
        $szWarningMessage = $this->moMLT->get( "0", "You are about to clear the WFS ".
            "filter.  Do you wish to continue?" );
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * Clear the WFS filter
 */
function {$szJsFunctionName}()
{
    // give message if there is nothing to delete
    if ( {$this->mszHTMLForm}.WFS_CLEAR_FILTER_ISSET.value == 1 )
    {
    
        // warn the user that they are about to clear the filter
        if ( confirm( "{$szWarningMessage}" ) )
        {
            // set the hidden form vars
            {$this->mszHTMLForm}.WFS_CLEAR_FILTER.value = 1;
        
            // submit the form
            {$this->mszHTMLForm}.submit();
        }
    }
    else
    {
        alert('{$szNoFilterMessage}');
    }
            
    // return
    return;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        // return the array of functions
        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- clickClearWFSFilter widget hidden -->";

        $szResult = $this->moButton->DrawPublish();
        return $szResult;
    }
}


?>
